/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeException
extends RubyException {
    private final Throwable cause;
    public static final String CLASS_NAME = "NativeException";
    private final Ruby runtime;

    public NativeException(Ruby ruby, RubyClass rubyClass, Throwable throwable) {
        super(ruby, rubyClass, throwable.getClass().getName() + ": " + throwable.getMessage());
        this.runtime = ruby;
        this.cause = throwable;
    }

    public static RubyClass createClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = ruby.defineClass(CLASS_NAME, rubyClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = ruby.callbackFactory(NativeException.class);
        rubyClass2.defineMethod("cause", callbackFactory.getMethod("cause"));
        return rubyClass2;
    }

    public IRubyObject cause(Block block) {
        return Java.wrap(this.getRuntime(), (IRubyObject)JavaObject.wrap(this.getRuntime(), this.cause));
    }

    public IRubyObject backtrace() {
        IRubyObject iRubyObject = super.backtrace();
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        RubyArray rubyArray = (RubyArray)iRubyObject.dup();
        StackTraceElement[] stackTraceElementArray = this.cause.getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            String string2 = null;
            if (stackTraceElement.getFileName() == null) {
                string2 = string + ":" + stackTraceElement.getLineNumber() + ":in `" + stackTraceElement.getMethodName() + "'";
            } else {
                int n = string.lastIndexOf(".");
                String string3 = null;
                string3 = n == -1 ? "" : string.substring(0, n) + "/";
                string2 = string3.replace(".", "/") + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ":in `" + stackTraceElement.getMethodName() + "'";
            }
            RubyString rubyString = this.runtime.newString(string2);
            rubyArray.unshift(rubyString);
        }
        return rubyArray;
    }

    public void printBacktrace(PrintStream printStream) {
        super.printBacktrace(printStream);
        printStream.println("Complete Java stackTrace");
        this.cause.printStackTrace(printStream);
    }
}

