/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends HighlighterBase {
    private static final String COLORS_INACTIVE = "cc-highlighting-inactive";
    private static final String COLORS_MACRO = "cc-highlighting-macros-user";
    private static final String COLORS_SYSMACRO = "cc-highlighting-macros-system";
    private static final String COLORS_FIELDS = "cc-highlighting-class-fields";
    private AttributeSet inactiveColors;
    private AttributeSet macroColors;
    private AttributeSet sysMacroColors;
    private AttributeSet fieldsColors;
    private AttributeSet functionsColors;
    private final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null});

    public SemanticHighlighter(Document document) {
        super(document);
    }

    @Override
    protected void initFontColors(FontColorSettings fontColorSettings) {
        this.inactiveColors = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorSettings.getTokenFontColors(COLORS_INACTIVE), this.cleanUp});
        this.macroColors = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorSettings.getTokenFontColors(COLORS_MACRO), this.cleanUp});
        this.sysMacroColors = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorSettings.getTokenFontColors(COLORS_SYSMACRO), this.cleanUp});
        if (SemanticHighlightingOptions.SEMANTIC_ADVANCED) {
            this.fieldsColors = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorSettings.getTokenFontColors(COLORS_FIELDS), this.cleanUp});
            this.functionsColors = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Bold, Boolean.TRUE});
        }
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(SemanticHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(SemanticHighlighter.class, offsetsBag);
        }
        return offsetsBag;
    }

    private void update() {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            OffsetsBag offsetsBag = new OffsetsBag((Document)baseDocument);
            offsetsBag.clear();
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
            if (csmFile != null && csmFile.isParsed()) {
                for (CsmOffsetable object : SemanticHighlighter.getInactiveCodeBlocks(csmFile)) {
                    offsetsBag.addHighlight(object.getStartOffset(), object.getEndOffset(), this.inactiveColors);
                }
                if (SemanticHighlightingOptions.getEnableMacros()) {
                    boolean bl = SemanticHighlightingOptions.getDifferSystemMacros();
                    for (CsmReference csmReference : SemanticHighlighter.getMacroBlocks(csmFile)) {
                        CsmMacro csmMacro = (CsmMacro)csmReference.getReferencedObject();
                        offsetsBag.addHighlight(csmReference.getStartOffset(), csmReference.getEndOffset(), !bl || csmMacro == null || !csmMacro.isSystem() ? this.macroColors : this.sysMacroColors);
                    }
                }
                if (SemanticHighlightingOptions.getEnableClassFields()) {
                    for (CsmOffsetable csmOffsetable : SemanticHighlighter.getFieldsBlocks(csmFile)) {
                        offsetsBag.addHighlight(csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset(), this.fieldsColors);
                    }
                }
                if (SemanticHighlightingOptions.getEnableFunctionNames()) {
                    for (CsmReference csmReference : SemanticHighlighter.getFunctionNames(csmFile)) {
                        offsetsBag.addHighlight(csmReference.getStartOffset(), csmReference.getEndOffset(), this.functionsColors);
                    }
                }
            }
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).setHighlights(offsetsBag);
        }
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile);
    }

    static List<CsmReference> getMacroBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
    }

    static List<? extends CsmOffsetable> getFieldsBlocks(CsmFile csmFile) {
        return SemanticHighlighter.getBlocksFromReferences(csmFile, new Validator(){

            public boolean validate(CsmReference csmReference) {
                CsmObject csmObject = csmReference.getReferencedObject();
                return csmObject != null && CsmKindUtilities.isField((CsmObject)csmObject);
            }
        });
    }

    static List<CsmReference> getFunctionNames(final CsmFile csmFile) {
        return SemanticHighlighter.getBlocksFromReferences(csmFile, new Validator(){

            public boolean validate(CsmReference csmReference) {
                CsmFunctionDefinition csmFunctionDefinition;
                CsmObject csmObject = csmReference.getReferencedObject();
                if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                    CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmObject;
                    if (csmOffsetableDeclaration.getContainingFile().equals(csmFile) && csmOffsetableDeclaration.getStartOffset() <= csmReference.getStartOffset() && csmOffsetableDeclaration.getEndOffset() >= csmReference.getEndOffset()) {
                        return true;
                    }
                    CsmFunctionDefinition csmFunctionDefinition2 = ((CsmFunction)csmObject).getDefinition();
                    if (csmFunctionDefinition2 != null && csmFile.equals(csmFunctionDefinition2.getContainingFile()) && csmFunctionDefinition2.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition2.getBody().getStartOffset()) {
                        return true;
                    }
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && csmFile.equals((csmFunctionDefinition = (CsmFunctionDefinition)csmObject).getContainingFile()) && csmFunctionDefinition.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition.getBody().getStartOffset()) {
                    return true;
                }
                return false;
            }
        });
    }

    private static List<CsmReference> getBlocksFromReferences(CsmFile csmFile, final Validator validator) {
        final ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReference csmReference) {
                if (validator.validate(csmReference)) {
                    arrayList.add(csmReference);
                }
            }
        });
        return arrayList;
    }

    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        BaseDocument baseDocument;
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT) {
            try {
                this.update();
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP && (baseDocument = this.getDocument()) != null) {
            SemanticHighlighter.getHighlightsBag((Document)baseDocument).clear();
        }
    }

    public boolean isValid() {
        return true;
    }

    private static interface Validator {
        public boolean validate(CsmReference var1);
    }
}

