/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.lang.ref.WeakReference;
import java.util.EventListener;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public abstract class HighlighterBase
implements CsmFileTaskFactory.PhaseRunner,
LookupListener {
    private final String mime;
    private final OffsetsBag bag;
    private final WeakReference<BaseDocument> weakDoc;

    public HighlighterBase(Document document) {
        this.bag = new OffsetsBag(document);
        this.mime = (String)document.getProperty("mimeType");
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)this.mime));
        Lookup.Result result = lookup.lookup(new Lookup.Template(FontColorSettings.class));
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), null));
        result.allInstances();
        this.weakDoc = document instanceof BaseDocument ? new WeakReference<BaseDocument>((BaseDocument)document) : null;
        this.updateFontColors();
    }

    protected BaseDocument getDocument() {
        return this.weakDoc != null ? (BaseDocument)this.weakDoc.get() : null;
    }

    public OffsetsBag getHighlightsBag() {
        return this.bag;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.updateFontColors();
        this.run(CsmFileTaskFactory.PhaseRunner.Phase.INIT);
    }

    public void updateFontColors() {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)this.mime));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        this.initFontColors(fontColorSettings);
    }

    protected abstract void initFontColors(FontColorSettings var1);

    protected boolean isCancelled() {
        return Thread.interrupted();
    }
}

