/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorIncludesModel
implements ListModel {
    private List<String> names = new ArrayList<String>();
    private List<List<CsmInclude>> includeList = new ArrayList<List<CsmInclude>>();
    private int errorFiles;
    private int errorIncludes;

    public ErrorIncludesModel(List<CsmInclude> list) {
        this.errorIncludes = list.size();
        TreeMap<String, ArrayList<CsmInclude>> treeMap = new TreeMap<String, ArrayList<CsmInclude>>();
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        for (CsmInclude object : list) {
            hashSet.add(object.getContainingFile());
            String string = object.isSystem() ? "<" + object.getIncludeName() + ">" : "\"" + object.getIncludeName() + "\"";
            ArrayList<CsmInclude> arrayList = (ArrayList<CsmInclude>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<CsmInclude>();
                treeMap.put(string, arrayList);
            }
            arrayList.add(object);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            this.names.add((String)entry.getKey());
            this.includeList.add((List<CsmInclude>)entry.getValue());
        }
        this.errorFiles = hashSet.size();
    }

    public int getFailedIncludesSize() {
        return this.errorIncludes;
    }

    public int getFailedFilesSize() {
        return this.errorFiles;
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    public Object getElementAt(int n) {
        return this.names.get(n);
    }

    public List<CsmInclude> getElementList(int n) {
        return this.includeList.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }
}

