/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.highlight.error.HighlightProvider;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.EditorAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class HighlightProviderTaskFactory
extends EditorAwareCsmFileTaskFactory {
    protected CsmFileTaskFactory.PhaseRunner createTask(FileObject fileObject) {
        CsmFileTaskFactory.PhaseRunner phaseRunner = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            final CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)dataObject, (boolean)false);
            final StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument != null && csmFile != null) {
                phaseRunner = new CsmFileTaskFactory.PhaseRunner(){

                    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
                        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT) {
                            HighlightProvider.getInstance().update(csmFile, styledDocument);
                        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
                            HighlightProvider.getInstance().clear(styledDocument);
                        }
                    }

                    public boolean isValid() {
                        return true;
                    }
                };
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        return phaseRunner != null ? phaseRunner : HighlightProviderTaskFactory.lazyRunner();
    }
}

