/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HighlightProvider {
    public static final boolean TRACE_ANNOTATIONS = Boolean.getBoolean("cnd.highlight.trace.annotations");
    private static final HighlightProvider instance = new HighlightProvider();

    public static HighlightProvider getInstance() {
        return instance;
    }

    private HighlightProvider() {
    }

    void update(CsmFile csmFile, Document document) {
        assert (document != null || csmFile == null);
        if (document instanceof BaseDocument) {
            this.addAnnotations((BaseDocument)document, csmFile);
        }
    }

    void clear(Document document) {
        assert (document != null);
        if (document instanceof BaseDocument) {
            this.removeAnnotations(document);
        }
    }

    private void addAnnotations(BaseDocument baseDocument, CsmFile csmFile) {
        this.removeAnnotations((Document)baseDocument);
        try {
            ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
            for (CsmInclude csmInclude : csmFile.getIncludes()) {
                if (csmInclude.getIncludeFile() != null) continue;
                PositionBounds positionBounds = CsmUtilities.createPositionBounds((CsmOffsetable)csmInclude);
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)NbBundle.getMessage(HighlightProvider.class, (String)"HighlightProvider_IncludeMissed", (Object)HighlightProvider.getIncludeText(csmInclude)), (Document)baseDocument, (Position)positionBounds.getBegin().getPosition(), (Position)positionBounds.getEnd().getPosition()));
            }
            HintsController.setErrors((Document)baseDocument, (String)HighlightProvider.class.getName(), arrayList);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void removeAnnotations(Document document) {
        HintsController.setErrors((Document)document, (String)HighlightProvider.class.getName(), Collections.emptyList());
    }

    private static String getIncludeText(CsmInclude csmInclude) {
        if (csmInclude.isSystem()) {
            return "<" + csmInclude.getIncludeName() + ">";
        }
        return "\"" + csmInclude.getIncludeName() + "\"";
    }
}

