/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.highlight.error.BrokenProjectService;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BadgeProvider {
    private static BadgeProvider myInstance = new BadgeProvider();
    private Storage storage = new Storage();
    private Object listLock = new Object();

    private BadgeProvider() {
    }

    public static BadgeProvider getInstance() {
        return myInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateProject(CsmProject csmProject) {
        boolean bl = false;
        Object object = this.listLock;
        synchronized (object) {
            boolean bl2 = this.storage.contains(csmProject);
            block3: for (CsmFile csmFile : csmProject.getAllFiles()) {
                for (CsmInclude csmInclude : csmFile.getIncludes()) {
                    if (csmInclude.getIncludeFile() != null) continue;
                    if (this.storage.contains(csmFile)) continue block3;
                    this.storage.add(csmFile);
                    bl = true;
                    continue block3;
                }
                if (!this.storage.contains(csmFile)) continue;
                this.storage.remove(csmFile);
                bl = true;
            }
            boolean bl3 = this.storage.contains(csmProject);
            if (bl2 == bl3) {
                bl = false;
            }
        }
        if (bl) {
            this.fireBadgeChanged(csmProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFile(CsmFile csmFile) {
        boolean bl = false;
        CsmProject csmProject = csmFile.getProject();
        Object object = this.listLock;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = this.storage.contains(csmProject);
            boolean bl4 = false;
            for (CsmInclude csmInclude : csmFile.getIncludes()) {
                if (csmInclude.getIncludeFile() != null) continue;
                if (!this.storage.contains(csmFile)) {
                    this.storage.add(csmFile);
                    bl = true;
                }
                bl4 = true;
                break;
            }
            if (!bl4 && this.storage.contains(csmFile)) {
                this.storage.remove(csmFile);
                bl = true;
            }
            if (bl3 == (bl2 = this.storage.contains(csmProject))) {
                bl = false;
            }
        }
        if (bl) {
            this.fireBadgeChanged(csmProject);
        }
    }

    private void fireBadgeChanged(CsmFile csmFile) {
        new BrokenProjectService().stateChanged(null);
    }

    private void fireBadgeChanged(CsmProject csmProject) {
        new BrokenProjectService().stateChanged(null);
    }

    private void fireBadgeChanged() {
        new BrokenProjectService().stateChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileRemoved(CsmFile csmFile) {
        boolean bl = false;
        CsmProject csmProject = csmFile.getProject();
        Object object = this.listLock;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = this.storage.contains(csmProject);
            if (this.storage.contains(csmFile)) {
                this.storage.remove(csmFile);
                bl = true;
            }
            if (bl3 == (bl2 = this.storage.contains(csmProject))) {
                bl = false;
            }
        }
        if (bl) {
            this.fireBadgeChanged(csmProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProjects() {
        boolean bl = false;
        Object object = this.listLock;
        synchronized (object) {
            bl = !this.storage.isEmpty();
            this.storage.clear();
        }
        if (bl) {
            this.fireBadgeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(CsmProject csmProject) {
        boolean bl = false;
        Object object = this.listLock;
        synchronized (object) {
            bl = this.storage.contains(csmProject);
            this.storage.remove(csmProject);
        }
        if (bl) {
            this.fireBadgeChanged(csmProject);
        }
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(BadgeProvider.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBroken(NativeProject nativeProject) {
        Object object = this.listLock;
        synchronized (object) {
            return this.storage.contains(nativeProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsmUID<CsmFile>> getFailedFiles(NativeProject nativeProject) {
        Object object = this.listLock;
        synchronized (object) {
            return new HashSet<CsmUID<CsmFile>>(this.storage.getFiles(nativeProject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFailedFiles(NativeProject nativeProject) {
        Object object = this.listLock;
        synchronized (object) {
            return this.storage.contains(nativeProject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Storage {
        private Map<CsmProject, Set<CsmUID<CsmFile>>> wrongFiles = new HashMap<CsmProject, Set<CsmUID<CsmFile>>>();
        private Map<CsmProject, NativeProject> nativeProjects = new HashMap<CsmProject, NativeProject>();

        private Storage() {
        }

        public Set<CsmUID<CsmFile>> getFiles(CsmProject csmProject) {
            return this.wrongFiles.get(csmProject);
        }

        public Set<CsmUID<CsmFile>> getFiles(NativeProject nativeProject) {
            for (Map.Entry<CsmProject, NativeProject> entry : this.nativeProjects.entrySet()) {
                if (nativeProject != entry.getValue()) continue;
                return this.getFiles(entry.getKey());
            }
            return Collections.emptySet();
        }

        public boolean isEmpty() {
            return this.nativeProjects.size() == 0;
        }

        public void clear() {
            this.wrongFiles.clear();
            this.nativeProjects.clear();
        }

        public void remove(CsmProject csmProject) {
            this.wrongFiles.remove(csmProject);
            this.nativeProjects.remove(csmProject);
        }

        public void remove(CsmFile csmFile) {
            Set<CsmUID<CsmFile>> set;
            CsmProject csmProject = csmFile.getProject();
            if (csmProject != null && (set = this.getFiles(csmProject)) != null && set.size() > 0) {
                set.remove(csmFile.getUID());
            }
        }

        public void add(CsmFile csmFile) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject != null) {
                Object object;
                Set<CsmUID<CsmFile>> set = this.getFiles(csmProject);
                if (set == null && (object = csmProject.getPlatformProject()) instanceof NativeProject) {
                    set = new HashSet<CsmUID<CsmFile>>();
                    this.wrongFiles.put(csmProject, set);
                    this.nativeProjects.put(csmProject, (NativeProject)object);
                }
                if (set != null) {
                    set.add((CsmUID<CsmFile>)csmFile.getUID());
                }
            }
        }

        public boolean contains(CsmProject csmProject) {
            Set<CsmUID<CsmFile>> set = this.getFiles(csmProject);
            return set != null && set.size() > 0;
        }

        public boolean contains(NativeProject nativeProject) {
            Set<CsmUID<CsmFile>> set = this.getFiles(nativeProject);
            return set != null && set.size() > 0;
        }

        public boolean contains(CsmFile csmFile) {
            Set<CsmUID<CsmFile>> set;
            CsmProject csmProject = csmFile.getProject();
            if (csmProject != null && (set = this.getFiles(csmProject)) != null) {
                return set.contains(csmFile.getUID());
            }
            return false;
        }
    }
}

