/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.core.InvokeOperationActionProvider;
import org.netbeans.modules.websvc.core.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsInvokeOperation;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class JaxWsInvokeOperationProvider
implements InvokeOperationActionProvider {
    public InvokeOperationCookie getInvokeOperationCookie(FileObject fileObject, Node node) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ProjectInfo projectInfo = new ProjectInfo(project);
        int n = projectInfo.getProjectType();
        if (this.isJaxWsService(node)) {
            if (n == 0 && !this.isJAXRPCProject(project) && !this.isJAXWSProject(project) || n == 0 && this.isJAXWSProject(project) && this.isJaxWsLibraryOnClasspath(fileObject) || Util.isJavaEE5orHigher((Project)project) && (n == 1 || n == 3 || n == 2) || projectInfo.isJwsdpSupported()) {
                return new JaxWsInvokeOperation();
            }
            if (JaxWsUtils.isEjbJavaEE5orHigher(projectInfo)) {
                return new JaxWsInvokeOperation();
            }
            if (n == 1 && !Util.isJavaEE5orHigher((Project)project) && this.isJaxWsLibraryOnRuntimeClasspath(fileObject)) {
                return new JaxWsInvokeOperation();
            }
        }
        return null;
    }

    private boolean isJaxWsLibraryOnRuntimeClasspath(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null && classPath.findResource("javax/xml/rpc/Service.class") == null;
    }

    private boolean isJAXRPCProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject fileObject = null;
        if (sourceGroupArray.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")) != null) {
            fileObject = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
        }
        return fileObject != null;
    }

    private boolean isJAXWSProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject fileObject = null;
        if (sourceGroupArray.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")) != null) {
            fileObject = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        }
        return fileObject != null;
    }

    private boolean isJaxWsLibraryOnClasspath(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        if (classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null) {
            return true;
        }
        classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null;
    }

    private boolean isJaxWsService(Node node) {
        if (node != null) {
            return node.getLookup().lookup(WsdlOperation.class) != null;
        }
        return false;
    }
}

