/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.AddOperationCookie;
import org.netbeans.modules.websvc.core.AddWsOperationHelper;
import org.netbeans.modules.websvc.core._RetoucheUtil;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsAddOperation
implements AddOperationCookie {
    private FileObject implClassFo;
    private Service service;

    public JaxWsAddOperation(FileObject fileObject) {
        this.implClassFo = fileObject;
        this.service = this.getService();
    }

    public void addOperation(final FileObject fileObject) {
        final AddWsOperationHelper addWsOperationHelper = new AddWsOperationHelper(NbBundle.getMessage(AddWsOperationHelper.class, (String)"LBL_OperationAction"));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    String string = _RetoucheUtil.getMainClassName(fileObject);
                    if (string != null) {
                        addWsOperationHelper.addMethod(fileObject, string);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public boolean isEnabledInEditor(FileObject fileObject) {
        return this.isJaxWsImplementationClass() && !this.isFromWSDL();
    }

    private boolean isJaxWsImplementationClass() {
        return this.service != null;
    }

    private Service getService() {
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.implClassFo);
        if (jAXWSSupport != null) {
            List list = jAXWSSupport.getServices();
            for (int i = 0; i < list.size(); ++i) {
                String string;
                Service service = (Service)list.get(i);
                if (service.getWsdlUrl() != null || !(string = service.getImplementationClass()).equals(this.getPackageName(this.implClassFo))) continue;
                return service;
            }
        }
        return null;
    }

    private boolean isFromWSDL() {
        if (this.service != null) {
            return this.service.getWsdlUrl() != null;
        }
        return false;
    }

    private String getPackageName(FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources != null && (sourceGroupArray = sources.getSourceGroups("java")) != null) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject2 = sourceGroup.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject).replace('/', '.');
                return string.endsWith(".java") ? string.substring(0, string.length() - 5) : string;
            }
        }
        return null;
    }
}

