/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.undo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.undo.CompoundUndoManager;
import org.openide.awt.UndoRedo;

public class QuietUndoManager
extends CompoundUndoManager {
    private static final long serialVersionUID = 1L;
    private AbstractDocument document;
    private Model model;
    private List<Model> otherModels = new ArrayList<Model>();

    public QuietUndoManager(UndoRedo.Manager manager) {
        super(manager);
    }

    private void finish(UndoableEditListener[] undoableEditListenerArray) {
        if (this.model != null) {
            this.model.addUndoableEditListener((UndoableEditListener)((Object)this));
        }
        if (undoableEditListenerArray != null && undoableEditListenerArray.length > 0) {
            for (UndoableEditListener undoableEditListener : undoableEditListenerArray) {
                this.document.addUndoableEditListener(undoableEditListener);
            }
        }
    }

    private UndoableEditListener[] prepare() {
        if (this.model != null) {
            this.model.removeUndoableEditListener((UndoableEditListener)((Object)this));
        }
        if (this.document == null) {
            return null;
        }
        UndoableEditListener[] undoableEditListenerArray = this.document.getUndoableEditListeners();
        if (undoableEditListenerArray != null && undoableEditListenerArray.length > 0) {
            for (UndoableEditListener undoableEditListener : undoableEditListenerArray) {
                this.document.removeUndoableEditListener(undoableEditListener);
            }
        }
        return undoableEditListenerArray;
    }

    public void setDocument(AbstractDocument abstractDocument) {
        this.document = abstractDocument;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    private void syncModel() {
        if (this.model != null) {
            try {
                this.model.sync();
                for (Model model : this.otherModels) {
                    model.sync();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void redo() throws CannotRedoException {
        UndoableEditListener[] undoableEditListenerArray = this.prepare();
        super.redo();
        this.syncModel();
        this.finish(undoableEditListenerArray);
    }

    public void undo() throws CannotUndoException {
        UndoableEditListener[] undoableEditListenerArray = this.prepare();
        super.undo();
        this.syncModel();
        this.finish(undoableEditListenerArray);
    }

    public void addWrapperModel(Model model) {
        if (!this.otherModels.contains(model)) {
            this.otherModels.add(model);
        }
    }

    public void removeWrapperModel(Model model) {
        this.otherModels.remove(model);
    }
}

