/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.customizer;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.netbeans.modules.xml.xam.ui.customizer.FolderNode;
import org.netbeans.modules.xml.xam.ui.customizer.WaitNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NamespaceChildren
extends Children.Keys {
    private HashMap<String, List<FileObject>> nsFilesMap;
    private FileObject[] rootFolders;
    private ExternalReferenceDecorator decorator;

    public NamespaceChildren(FileObject[] fileObjectArray, ExternalReferenceDecorator externalReferenceDecorator) {
        this.rootFolders = fileObjectArray;
        this.decorator = externalReferenceDecorator;
        this.nsFilesMap = new HashMap();
    }

    protected Node[] createNodes(Object object) {
        List<FileObject> list;
        if (object == WaitNode.WAIT_KEY) {
            return WaitNode.createNode();
        }
        if (object instanceof String && (list = this.nsFilesMap.get(object)) != null && !list.isEmpty()) {
            Object object22;
            Node[] nodeArray = new Node[list.size()];
            int n = 0;
            for (Object object22 : list) {
                try {
                    Node node = DataObject.find((FileObject)object22).getNodeDelegate();
                    nodeArray[n++] = this.decorator.createExternalReferenceNode(node);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
            Children.Array array = new Children.Array();
            array.add(nodeArray);
            object22 = new NamespaceNode((Children)array, (String)object, this.decorator);
            return new Node[]{object22};
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(WaitNode.getKeys());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (FileObject fileObject : NamespaceChildren.this.rootFolders) {
                    Map map = Utilities.getFiles2NSMappingInProj((File)FileUtil.toFile((FileObject)fileObject), (Utilities.DocumentTypesEnum)NamespaceChildren.this.decorator.getDocumentType());
                    for (Map.Entry entry : map.entrySet()) {
                        String string = (String)entry.getValue();
                        ArrayList arrayList = (ArrayList)NamespaceChildren.this.nsFilesMap.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(entry.getKey());
                        NamespaceChildren.this.nsFilesMap.put(string, arrayList);
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        NamespaceChildren.this.setKeys(NamespaceChildren.this.nsFilesMap.keySet());
                    }
                });
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private static class NamespaceNode
    extends FolderNode
    implements ExternalReferenceNode {
        private ExternalReferenceDecorator decorator;

        NamespaceNode(Children children, String string, ExternalReferenceDecorator externalReferenceDecorator) {
            super(children);
            this.decorator = externalReferenceDecorator;
            this.setName(string);
            if ("NO_NAME_SPACE".equals(string)) {
                this.setDisplayName(NbBundle.getMessage(NamespaceNode.class, (String)"LBL_NoTargetNamespace"));
            }
        }

        public String getHtmlDisplayName() {
            String string = this.getDisplayName();
            if (this.decorator != null) {
                string = this.decorator.getHtmlDisplayName(string, this);
            }
            return string;
        }

        public Model getModel() {
            return null;
        }

        public String getNamespace() {
            return this.getName();
        }

        public boolean hasModel() {
            return false;
        }
    }
}

