/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.netbeans.modules.xml.xam.ui.customizer.FolderNode;
import org.netbeans.modules.xml.xam.ui.customizer.NamespaceChildren;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalReferenceCustomizer<T extends Component>
extends AbstractReferenceCustomizer<T>
implements DocumentListener,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private transient boolean prefixGenerated;
    private transient FileObject sourceFO;
    private transient FileObject referencedFO;
    private transient DefaultProjectCatalogSupport catalogSupport;
    public JLabel locationLabel;
    public JPanel locationPanel;
    public JLabel messageLabel;
    public JLabel namespaceLabel;
    public JTextField namespaceTextField;
    public JLabel prefixLabel;
    public JTextField prefixTextField;

    public ExternalReferenceCustomizer(T t, Model model) {
        super(t);
        this.initComponents();
        this.sourceFO = (FileObject)t.getModel().getModelSource().getLookup().lookup(FileObject.class);
        this.catalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)this.sourceFO);
        this.init(t, model);
        this.initializeUI();
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setPopupAllowed(false);
        beanTreeView.setDefaultActionAllowed(false);
        beanTreeView.setSelectionMode(1);
        beanTreeView.setRootVisible(false);
        beanTreeView.getAccessibleContext().setAccessibleName(this.locationLabel.getToolTipText());
        beanTreeView.getAccessibleContext().setAccessibleDescription(this.locationLabel.getToolTipText());
        this.locationPanel.add((java.awt.Component)beanTreeView, "Center");
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.explorerManager.setRootContext(this.createRootNode());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("apply", true, false);
    }

    @Override
    public void applyChanges() throws IOException {
        if (this.mustNamespaceDiffer() && this.isPrefixChanged()) {
            this.prefixTextField.setEditable(false);
        }
        if (this.isLocationChanged() && this.referencedFO != null && this.catalogSupport.needsCatalogEntry(this.sourceFO, this.referencedFO)) {
            try {
                this.catalogSupport.createCatalogEntry(this.sourceFO, this.referencedFO);
            }
            catch (IOException iOException) {
            }
            catch (CatalogModelException catalogModelException) {
                // empty catch block
            }
        }
    }

    protected String getEditedLocation() {
        if (this.referencedFO == null) {
            return this.getReferenceLocation();
        }
        try {
            return this.catalogSupport.getReferenceURI(this.sourceFO, this.referencedFO).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected String getEditedNamespace() {
        return this.namespaceTextField.getText().trim();
    }

    protected String getEditedPrefix() {
        return this.prefixTextField.getText().trim();
    }

    protected abstract String getReferenceLocation();

    protected abstract String getNamespace();

    protected abstract String getPrefix();

    protected abstract String generatePrefix();

    protected boolean isLocationChanged() {
        String string = this.getReferenceLocation();
        String string2 = this.getEditedLocation();
        if (string == null) {
            return string2 != null;
        }
        return !string.equals(string2);
    }

    protected boolean isNamespaceChanged() {
        if (!this.mustNamespaceDiffer()) {
            return false;
        }
        String string = this.getNamespace();
        String string2 = this.getEditedNamespace();
        if (string == null) {
            return string2.length() > 0;
        }
        return !string.equals(string2);
    }

    protected boolean isPrefixChanged() {
        if (!this.mustNamespaceDiffer()) {
            return false;
        }
        if (this.prefixGenerated) {
            return false;
        }
        String string = this.getPrefix();
        String string2 = this.getEditedPrefix();
        if (string == null) {
            return string2.length() > 0;
        }
        return !string.equals(string2);
    }

    protected void init(T t, Model model) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.prefixGenerated = false;
        this.validateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.prefixGenerated = false;
        this.validateInput();
    }

    @Override
    protected void initializeUI() {
        if (this.mustNamespaceDiffer()) {
            this.namespaceTextField.setText(this.getNamespace());
            this.prefixTextField.getDocument().removeDocumentListener(this);
            String string = this.getPrefix();
            if (string != null) {
                this.prefixTextField.setText(string);
                this.prefixTextField.setEditable(false);
                this.prefixGenerated = false;
            } else {
                string = this.generatePrefix();
                this.prefixGenerated = true;
                this.prefixTextField.setText(string);
                this.prefixTextField.getDocument().addDocumentListener(this);
            }
        } else {
            this.namespaceLabel.setVisible(false);
            this.namespaceTextField.setVisible(false);
            this.prefixLabel.setVisible(false);
            this.prefixTextField.setVisible(false);
        }
    }

    @Override
    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        return new ExternalReferenceDataNode(node, this.getNodeDecorator());
    }

    private void validateInput() {
        boolean bl = this.isLocationChanged();
        boolean bl2 = this.isNamespaceChanged();
        boolean bl3 = this.isPrefixChanged();
        if (!(bl || bl2 || bl3)) {
            this.setSaveEnabled(false);
            this.setResetEnabled(false);
        } else {
            this.setResetEnabled(true);
            String string = null;
            if (this.mustNamespaceDiffer()) {
                if (bl && this.getEditedLocation() == null) {
                    string = NbBundle.getMessage(ExternalReferenceCustomizer.class, (String)"LBL_ExternalReferenceCustomizer_InvalidLocation");
                }
                Map<String, String> map = this.getPrefixes(this.getModelComponent().getModel());
                String string2 = this.getEditedPrefix();
                if (bl3 && (string2.length() == 0 || map.containsKey(string2))) {
                    string = NbBundle.getMessage(ExternalReferenceCustomizer.class, (String)"LBL_ExternalReferenceCustomizer_InvalidPrefix");
                }
            }
            this.prefixTextField.setEditable(bl);
            if (string != null) {
                this.showMessage(string);
            }
            this.setSaveEnabled(string == null);
        }
    }

    @Override
    protected void showMessage(String string) {
        if (string == null) {
            this.messageLabel.setText(" ");
            this.messageLabel.setIcon(null);
        } else {
            this.messageLabel.setText(string);
            this.messageLabel.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/xam/ui/resources/error.gif")));
        }
    }

    @Override
    protected Node createRootNode() {
        Object object;
        Object object22;
        Set set = null;
        if (this.catalogSupport.supportsCrossProject()) {
            set = this.catalogSupport.getProjectReferences();
        }
        ExternalReferenceDecorator externalReferenceDecorator = this.getNodeDecorator();
        Node[] nodeArray = new Node[1 + (set == null ? 0 : set.size())];
        Project project = FileOwnerQuery.getOwner((FileObject)this.sourceFO);
        LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
        nodeArray[0] = externalReferenceDecorator.createExternalReferenceNode(logicalViewProvider.createLogicalView());
        int n = 1;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        arrayList.add(project.getProjectDirectory());
        if (set != null) {
            for (Object object22 : set) {
                object = (Project)object22;
                logicalViewProvider = (LogicalViewProvider)object.getLookup().lookup(LogicalViewProvider.class);
                nodeArray[n++] = externalReferenceDecorator.createExternalReferenceNode(logicalViewProvider.createLogicalView());
                arrayList.add(object.getProjectDirectory());
            }
        }
        FileObject[] fileObjectArray = arrayList.toArray(new FileObject[arrayList.size()]);
        object22 = new Children.Array();
        object22.add(nodeArray);
        object = new FolderNode((Children)object22);
        object.setDisplayName(NbBundle.getMessage(ExternalReferenceCustomizer.class, (String)"LBL_ExternalReferenceCustomizer_Category_By_File"));
        NamespaceChildren namespaceChildren = new NamespaceChildren(fileObjectArray, externalReferenceDecorator);
        FolderNode folderNode = new FolderNode((Children)namespaceChildren);
        folderNode.setDisplayName(NbBundle.getMessage(ExternalReferenceCustomizer.class, (String)"LBL_ExternalReferenceCustomizer_Category_By_Namespace"));
        Children.Array array = new Children.Array();
        array.add(new Node[]{object, folderNode});
        return new AbstractNode((Children)array);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            ExternalReferenceNode externalReferenceNode;
            Model model;
            this.showMessage(null);
            this.setSaveEnabled(false);
            String string = null;
            this.referencedFO = null;
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length > 0 && nodeArray[0] instanceof ExternalReferenceNode && (model = (externalReferenceNode = (ExternalReferenceNode)nodeArray[0]).getModel()) != null) {
                String string2;
                string = this.getTargetNamespace(model);
                if (model != this.getModelComponent().getModel()) {
                    this.referencedFO = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
                }
                if ((string2 = this.getNodeDecorator().validate(externalReferenceNode)) != null) {
                    this.showMessage(string2);
                } else {
                    this.validateInput();
                }
            }
            this.namespaceTextField.setText(string);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationPanel = new JPanel();
        this.namespaceLabel = new JLabel();
        this.namespaceTextField = new JTextField();
        this.prefixLabel = new JLabel();
        this.prefixTextField = new JTextField();
        this.messageLabel = new JLabel();
        this.locationLabel.setLabelFor(this.locationPanel);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("LBL_ExternalReferenceCustomizer_Location"));
        this.locationLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("TIP_ExternalReferenceCustomizer_Location"));
        this.locationPanel.setLayout(new BorderLayout());
        this.locationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("LBL_ExternalReferenceCustomizer_Namespace"));
        this.namespaceLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("TIP_ExternalReferenceCustomizer_Namespace"));
        this.namespaceTextField.setEditable(false);
        this.prefixLabel.setLabelFor(this.prefixTextField);
        Mnemonics.setLocalizedText((JLabel)this.prefixLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("LBL_ExternalReferenceCustomizer_Prefix"));
        this.prefixLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("TIP_ExternalReferenceCustomizer_Prefix"));
        this.prefixTextField.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/xml/xam/ui/customizer/Bundle").getString("TIP_ExternalReferenceCustomizer_Prefix"));
        this.messageLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.messageLabel, -1, 382, Short.MAX_VALUE).add((java.awt.Component)this.locationPanel, -1, 382, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.namespaceLabel).add((java.awt.Component)this.prefixLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.prefixTextField, -1, 297, Short.MAX_VALUE).add((java.awt.Component)this.namespaceTextField, -1, 297, Short.MAX_VALUE))).add((java.awt.Component)this.locationLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((java.awt.Component)this.locationLabel).addPreferredGap(0).add((java.awt.Component)this.locationPanel, -1, 330, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((java.awt.Component)this.namespaceLabel).add((java.awt.Component)this.namespaceTextField, -2, -1, -2)).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.prefixLabel).add((java.awt.Component)this.prefixTextField, -2, -1, -2)).addPreferredGap(0).add((java.awt.Component)this.messageLabel).addContainerGap()));
    }
}

