/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.editors.api.utils;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.utils.HtmlNameManager;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactorUtil {
    public static final int MAX_SIMPLE_NAME_LENGTH = 50;
    public static final String ENTITY_SEPARATOR = ".";

    private RefactorUtil() {
    }

    public static String getName(Component component) {
        NodeType nodeType;
        String string = null;
        if (component instanceof Named) {
            string = ((Named)component).getName();
        } else if (component instanceof BooleanExpr) {
            string = ((BooleanExpr)component).getContent();
            String string2 = string = string == null ? null : string.trim();
            if (string != null && string.length() > 50) {
                string = string.substring(0, 50);
            }
        } else if (component instanceof BpelEntity && (nodeType = Util.getBasicNodeType((Component)((BpelEntity)component))) != null && !NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
            string = nodeType.getDisplayName();
        }
        if (string == null && component instanceof DocumentComponent) {
            string = Util.getTagName((DocumentComponent)component);
        }
        return string == null ? "" : string;
    }

    public static String getHtmlName(Component component) {
        HtmlNameManager[] htmlNameManagerArray;
        String string = null;
        NodeType nodeType = RefactorUtil.getBpelNodeType(component);
        for (HtmlNameManager htmlNameManager : htmlNameManagerArray = HtmlNameManager.HTML_NAME_MANAGERS) {
            if (!htmlNameManager.accept(nodeType, component)) continue;
            string = htmlNameManager.getHtmlName(nodeType, component);
        }
        string = string == null ? "" : string;
        return RefactorUtil.removeHtmlHeader(string);
    }

    public static Icon getIcon(Component component) {
        NodeType nodeType;
        Node node = RefactorUtil.getNode(component);
        if (node != null) {
            return new ImageIcon(node.getIcon(1));
        }
        Icon icon = null;
        if (component instanceof BpelEntity && (nodeType = Util.getBasicNodeType((Component)((BpelEntity)component))) != null && !NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
            icon = nodeType.getIcon();
        }
        icon = icon != null ? icon : NodeType.DEFAULT_BPEL_ENTITY_NODE.getIcon();
        return icon;
    }

    public static String getToolTip(Component component) {
        String string = RefactorUtil.getType(component);
        if (string != null) {
            return "<html>" + string + " <b>" + RefactorUtil.getName(component) + "</b></html>";
        }
        return RefactorUtil.getName(component);
    }

    public static String getType(Component component) {
        String string = null;
        string = component instanceof BpelEntity ? ((BpelEntity)component).getElementType().getName() : (component instanceof SchemaComponent ? ((SchemaComponent)component).getComponentType().getName() : component.getClass().getName());
        int n = string.lastIndexOf(ENTITY_SEPARATOR);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static Node getNode(Component component) {
        if (component instanceof SchemaComponent) {
            SchemaComponent schemaComponent = (SchemaComponent)component;
            CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaComponent.getModel(), Lookups.singleton((Object)schemaComponent));
            return categorizedSchemaNodeFactory.createNode(schemaComponent);
        }
        if (component instanceof WSDLComponent) {
            return NodesFactory.getInstance().create(component);
        }
        return null;
    }

    private static String removeHtmlHeader(String string) {
        if (string == null) {
            return string;
        }
        String string2 = "<html>";
        String string3 = "</html>";
        if (string.matches(string2 + ".*" + string3)) {
            string = string.substring(string2.length() - 1, string.length() - string3.length() + 1);
        }
        return string;
    }

    private static NodeType getBpelNodeType(Component component) {
        if (!(component instanceof BpelEntity)) {
            return null;
        }
        return Util.getBasicNodeType((Component)((BpelEntity)component));
    }

    public static String getUsageContextPath(String string, BpelEntity bpelEntity, Class<? extends BpelEntity> clazz) {
        String string2 = RefactorUtil.getUsageContextPath(bpelEntity, clazz);
        if (string2 != null) {
            string = string == null ? "" : ENTITY_SEPARATOR + string;
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String getUsageContextPath(BpelEntity bpelEntity, Class<? extends BpelEntity> clazz) {
        assert (bpelEntity != null);
        StringBuffer stringBuffer = new StringBuffer(RefactorUtil.getName((Component)bpelEntity));
        BpelEntity bpelEntity2 = bpelEntity;
        while ((bpelEntity2 = bpelEntity2.getParent()) != null) {
            String string;
            if (bpelEntity2.getElementType() == clazz || (string = RefactorUtil.getName((Component)bpelEntity2)) == null || string.length() <= 0) continue;
            stringBuffer.insert(0, ENTITY_SEPARATOR).insert(0, string);
        }
        return stringBuffer.toString();
    }
}

