/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.datasource;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CurrentProject {
    private static CurrentProject _instance = null;
    private Project project = null;
    protected ProjectsChangedListener changedProjectsListener = new ProjectsChangedListener();

    private CurrentProject() {
        DataObject dataObject = (DataObject)Utilities.actionsGlobalContext().lookup(DataObject.class);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this.changedProjectsListener, (Object)OpenProjects.getDefault()));
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
    }

    public static CurrentProject getInstance() {
        if (_instance == null) {
            _instance = new CurrentProject();
        }
        return _instance;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getOpenedProject() {
        Lookup lookup;
        DataObject dataObject;
        if (TopComponent.getRegistry().getActivated() != null && (dataObject = (DataObject)(lookup = TopComponent.getRegistry().getActivated().getLookup()).lookup(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        if (this.project == null) {
            this.project = OpenProjects.getDefault().getMainProject();
        }
        return this.project;
    }

    public Project getCurrentProject(DesignBean[] designBeanArray) {
        DesignContext designContext = designBeanArray[0].getDesignContext();
        FacesModel facesModel = ((LiveUnit)designContext).getModel();
        this.project = facesModel.getProject();
        return this.project;
    }

    public class ProjectsChangedListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                List<Project> list = Arrays.asList((Project[])propertyChangeEvent.getOldValue());
                List<Project> list2 = Arrays.asList((Project[])propertyChangeEvent.getNewValue());
                LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>(list);
                linkedHashSet.removeAll(list2);
                for (Project project : linkedHashSet) {
                    if (_instance.project != project) continue;
                    _instance.project = null;
                    OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }
}

