/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.swingapp.templates.AppProjectGenerator;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.netbeans.modules.swingapp.templates.ConfigureProjectVisualPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewAppWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private WizardDescriptor wizard;
    private int panelIndex;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private WizardDescriptor.InstantiatingIterator appShellIterator;
    private EventListenerList listenerList;
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    void setAppShellIterator(WizardDescriptor.InstantiatingIterator instantiatingIterator) {
        if (this.appShellIterator != null) {
            this.appShellIterator.removeChangeListener((ChangeListener)this);
            this.appShellIterator.uninitialize(this.wizard);
        }
        this.appShellIterator = instantiatingIterator;
        if (this.appShellIterator != null) {
            this.appShellIterator.initialize(this.wizard);
            this.appShellIterator.addChangeListener((ChangeListener)this);
        }
        if (this.panelIndex >= this.panels.length) {
            this.panelIndex = this.panels.length - 1;
        }
        this.initSteps();
        this.updateSteps();
        this.fireStateChanged();
    }

    WizardDescriptor.InstantiatingIterator getAppShellIterator() {
        return this.appShellIterator;
    }

    private void updateSteps() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        jComponent.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
        jComponent.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, this.panelIndex);
    }

    private void initSteps() {
        Object object;
        String[] stringArray = new String[]{NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name")};
        if (this.appShellIterator != null && (object = ((JComponent)this.appShellIterator.current().getComponent()).getClientProperty(WIZARD_PANEL_CONTENT_DATA)) instanceof String[]) {
            String[] stringArray2;
            for (String string : stringArray2 = (String[])object) {
                if (string != stringArray[0]) continue;
                this.steps = stringArray2;
                return;
            }
            this.steps = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, this.steps, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, this.steps, stringArray.length, stringArray2.length);
            return;
        }
        this.steps = stringArray;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.panelIndex = 0;
        this.panels = new WizardDescriptor.Panel[]{new ConfigureProjectPanel(this)};
        this.initSteps();
        this.updateSteps();
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.panelIndex < this.panels.length ? this.panels[this.panelIndex] : this.appShellIterator.current();
    }

    public boolean hasNext() {
        if (this.panelIndex + 1 < this.panels.length) {
            return true;
        }
        if (this.appShellIterator != null) {
            return this.panelIndex + 1 == this.panels.length ? true : this.appShellIterator.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
        if (this.panelIndex > this.panels.length) {
            this.appShellIterator.nextPanel();
        }
        this.updateSteps();
    }

    public void previousPanel() {
        --this.panelIndex;
        if (this.panelIndex >= this.panels.length) {
            this.appShellIterator.previousPanel();
        }
        this.updateSteps();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    public Set instantiate() throws IOException {
        File file = (File)this.wizard.getProperty("projdir");
        if (file == null) {
            return null;
        }
        file = FileUtil.normalizeFile((File)file);
        FileObject fileObject = (FileObject)this.wizard.getProperty("appshell");
        String[] stringArray = NewAppWizardIterator.getTemplateNames(fileObject);
        String string = file.getName();
        String string2 = (String)this.wizard.getProperty("appname");
        String[] stringArray2 = NewAppWizardIterator.getSubstituteNames(string, string2);
        FileObject fileObject2 = AppProjectGenerator.createProjectFromTemplate(fileObject, file, stringArray, stringArray2);
        ProjectChooser.setProjectsFolder((File)file.getParentFile());
        FileObject fileObject3 = AppProjectGenerator.getGeneratedFile(fileObject2, "src/applicationpackage/ShellApp.java", stringArray, stringArray2);
        FileObject fileObject4 = AppProjectGenerator.getGeneratedFile(fileObject2, "src/applicationpackage/ShellView.java", stringArray, stringArray2);
        this.wizard.putProperty("mainForm", (Object)fileObject4);
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        Set set = null;
        if (this.appShellIterator != null) {
            set = this.appShellIterator.instantiate();
        }
        linkedHashSet.add(fileObject2);
        if (fileObject3 != null) {
            linkedHashSet.add(fileObject3);
        }
        if (set != null) {
            linkedHashSet.addAll(set);
        }
        NewAppWizardIterator.collectForms(fileObject2.getFileObject("src"), linkedHashSet);
        if (fileObject4 != null) {
            linkedHashSet.remove(fileObject4);
            linkedHashSet.add(fileObject4);
        }
        return linkedHashSet;
    }

    private static void collectForms(FileObject fileObject, Set<FileObject> set) {
        if (fileObject == null || !fileObject.isFolder()) {
            return;
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.isFolder()) {
                NewAppWizardIterator.collectForms(fileObject2, set);
            }
            if (!fileObject2.getExt().equalsIgnoreCase("java") || !fileObject2.existsExt("form")) continue;
            try {
                fileObject2.setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
                set.add(fileObject2);
            }
            catch (IOException iOException) {
                Logger.getLogger(NewAppWizardIterator.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    private static String[] getTemplateNames(FileObject fileObject) {
        return new String[]{fileObject.getName(), "applicationpackage", "ShellApp", "ShellView", "ShellAboutBox", "UTF-\\u0038"};
    }

    private static String[] getSubstituteNames(String string, String string2) {
        String string3;
        int n = string2.lastIndexOf(46);
        String string4 = string2.substring(0, n);
        if (!(string2 = string2.substring(n + 1)).endsWith(string3 = "Application") && !string2.endsWith(string3 = "App")) {
            string3 = null;
        }
        String string5 = string3 != null ? string2.substring(0, string2.length() - string3.length()) : string2;
        return new String[]{string, string4, string2, string5 + "View", string5 + "AboutBox", FileEncodingQuery.getDefaultEncoding().name()};
    }
}

