/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceService;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourcePanelImpl;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceServiceImpl
implements ResourceService {
    public void prepareNew(FileObject fileObject) {
        try {
            ResourceUtils.createResourcesFolder(fileObject);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public ResourceValue get(String string, Class clazz, String string2, FileObject fileObject) {
        DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(fileObject, true);
        designResourceMap.setLocalization(string2);
        return designResourceMap.getResourceValue(string, clazz);
    }

    public Collection<String> findKeys(String string, FileObject fileObject) {
        return ResourceUtils.getDesignResourceMap(fileObject, true).collectKeys(string, true);
    }

    public ResourceValue create(String string, Class clazz, Object object, String string2, FileObject fileObject) {
        return new ResourceValueImpl(string, clazz, object, null, string2, clazz == String.class, 2, fileObject);
    }

    public ResourceValue changeKey(ResourceValue resourceValue, String string) {
        ResourceValueImpl resourceValueImpl = (ResourceValueImpl)resourceValue;
        if (!"#auto".equals(resourceValue.getKey())) {
            resourceValueImpl = new ResourceValueImpl(resourceValueImpl);
        }
        resourceValueImpl.setKey(string);
        return resourceValueImpl;
    }

    public ResourceValue changeValue(ResourceValue resourceValue, Object object, String string) {
        ResourceValueImpl resourceValueImpl = (ResourceValueImpl)resourceValue;
        return new ResourceValueImpl(resourceValueImpl.getKey(), resourceValueImpl.getValueType(), object, null, string, resourceValueImpl.isInternationalized(), resourceValueImpl.getStorageLevel(), resourceValueImpl.getSourceFile());
    }

    public ResourceValue switchLocale(ResourceValue resourceValue, String string) {
        if (resourceValue instanceof ResourceValueImpl) {
            ResourceValueImpl resourceValueImpl = (ResourceValueImpl)resourceValue;
            DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(resourceValueImpl.getSourceFile(), true);
            designResourceMap.setLocalization(string);
            return designResourceMap.getResourceValue(resourceValueImpl.getKey(), resourceValueImpl.getValueType());
        }
        if (resourceValue instanceof ProxyAction) {
            ProxyAction proxyAction = (ProxyAction)resourceValue;
            DesignResourceMap designResourceMap = proxyAction.getResourceMap();
            designResourceMap.setLocalization(string);
            proxyAction = new ProxyAction(proxyAction);
            proxyAction.loadFromResourceMap();
            return proxyAction;
        }
        return resourceValue;
    }

    public String[][] getAvailableLocales(FileObject fileObject) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, MultiDataObject.Entry> hashMap = new HashMap<String, MultiDataObject.Entry>();
        for (MultiDataObject.Entry stringArray2 : ResourceUtils.getDesignResourceMap(fileObject, true).collectLocaleEntries()) {
            String i = Util.getLocaleSuffix((MultiDataObject.Entry)stringArray2);
            if (hashSet.contains(i)) continue;
            hashSet.add(i);
            hashMap.put(i, stringArray2);
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = Util.getLocaleLabel((MultiDataObject.Entry)((MultiDataObject.Entry)hashMap.get(objectArray[i])));
        }
        return new String[][]{objectArray, stringArray};
    }

    public Component getCreateLocaleComponent(final PropertyEditor propertyEditor, FileObject fileObject) {
        DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(fileObject, true);
        String string = designResourceMap.getBundleNames().get(0);
        PropertiesDataObject propertiesDataObject = designResourceMap.getRepresentativeDataObject();
        if (propertiesDataObject == null) {
            try {
                propertiesDataObject = ResourceUtils.createPropertiesDataObject(fileObject, string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                return null;
            }
        }
        final PropertiesDataObject propertiesDataObject2 = propertiesDataObject;
        final Dialog[] dialogArray = new Dialog[1];
        final LocalePanel localePanel = new LocalePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)localePanel, NbBundle.getBundle(PropertiesDataObject.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    String string = localePanel.getLocale().toString();
                    Util.createLocaleFile((PropertiesDataObject)propertiesDataObject2, (String)string, (boolean)false);
                    propertyEditor.setValue("_" + string);
                }
                dialogArray[0].setVisible(false);
                dialogArray[0].dispose();
            }
        });
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialogArray[0];
    }

    public void update(ResourceValue resourceValue, ResourceValue resourceValue2, FileObject fileObject, String string) throws IOException {
        if (resourceValue != null && resourceValue.getKey() == null || resourceValue2 != null && resourceValue2.getKey() == null) {
            return;
        }
        ResourceValueImpl resourceValueImpl = (ResourceValueImpl)resourceValue;
        ResourceValueImpl resourceValueImpl2 = (ResourceValueImpl)resourceValue2;
        if (!(resourceValueImpl == null || resourceValueImpl2 != null && resourceValueImpl.getKey().equals(resourceValueImpl2.getKey()) && resourceValueImpl.getStorageLevel() == resourceValueImpl2.getStorageLevel())) {
            ResourceUtils.getDesignResourceMap(resourceValueImpl.getSourceFile(), true).removeResourceValue(resourceValueImpl);
        }
        if (resourceValueImpl2 != null) {
            DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(resourceValueImpl2.getSourceFile(), true);
            designResourceMap.setLocalization(string);
            designResourceMap.addResourceValue(resourceValueImpl2);
        }
    }

    public void autoSave(FileObject fileObject) {
        DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(fileObject, false);
        if (designResourceMap != null) {
            designResourceMap.save();
        }
    }

    public void close(FileObject fileObject) {
        DesignResourceMap designResourceMap = ResourceUtils.unregisterDesignResourceMap(fileObject);
        if (designResourceMap != null) {
            designResourceMap.revertChanges();
        }
        AppFrameworkSupport.fileClosed(fileObject);
    }

    public boolean projectWantsUseResources(FileObject fileObject) {
        return AppFrameworkSupport.isFrameworkEnabledProject(fileObject);
    }

    public boolean projectUsesResources(FileObject fileObject) {
        return AppFrameworkSupport.isFrameworkLibAvailable(fileObject);
    }

    public boolean isExcludedProperty(Class clazz, String string) {
        return Component.class.isAssignableFrom(clazz) && "name".equals(string);
    }

    public String getInjectionCode(Object object, String string, FileObject fileObject) {
        Component component;
        if (object instanceof Component && (component = (Component)object).getParent() == null) {
            return ResourceUtils.getResourceMapCode(fileObject) + "*/\n\\0" + ".injectComponents(" + string + ");";
        }
        return null;
    }

    public ResourcePanel createResourcePanel(Class clazz, FileObject fileObject) {
        return new ResourcePanelImpl(ResourceUtils.getDesignResourceMap(fileObject, true), clazz);
    }

    public List<URL> getResourceFiles(FileObject fileObject) {
        PropertiesDataObject propertiesDataObject = ResourceUtils.getPropertiesDataObject(fileObject);
        if (propertiesDataObject != null) {
            try {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                arrayList.add(propertiesDataObject.getPrimaryEntry().getFile().getURL());
                for (MultiDataObject.Entry entry : propertiesDataObject.secondaryEntries()) {
                    arrayList.add(entry.getFile().getURL());
                }
                return arrayList;
            }
            catch (IOException iOException) {
                Logger.getLogger(ResourceServiceImpl.class.getName()).log(Level.INFO, null, iOException);
            }
        }
        return Collections.emptyList();
    }
}

