/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSImportNode;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSetting;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.StyleSheetCache;
import org.apache.batik.css.engine.sac.CSSClassCondition;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSConditionalSelector;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.AbstractValue;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSSEngine {
    public static final boolean RULE_FILTERING = System.getProperty("rave.nocssfiltering") == null;
    public static final boolean DEBUG_FILTERING = false;
    protected List fontFaces = new LinkedList();
    CSSEngineUserAgent userAgent = null;
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List<WeakReference<CSSStyleSheetNode>> styleSheetNodes;
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    private int expandingShorthandProperty = -1;
    protected List unknownPropertyNames;
    protected List unknownPropertyValues;
    private ArrayList transientStyleSheetNodes;
    public static int styleLookupCount = 0;
    public static final StyleSheet PARSING_SHEET = new StyleSheet();
    private Comparator ruleComparator = new Comparator(){

        public int compare(Object object1, Object object2) {
            Rule rule1 = (Rule)object1;
            Rule rule2 = (Rule)object2;
            return rule1.getPosition() - rule2.getPosition();
        }
    };
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public List getFontFaces() {
        return this.fontFaces;
    }

    public static CSSStylableElement getParentCSSStylableElement(Element elt) {
        if (elt instanceof StyleElementLink && ((StyleElementLink)((Object)elt)).getStyleParent() != null) {
            return ((StyleElementLink)((Object)elt)).getStyleParent();
        }
        Element e = CSSEngine.getParentElement(elt);
        while (e != null) {
            if (e instanceof CSSStylableElement) {
                return (CSSStylableElement)e;
            }
            e = CSSEngine.getParentElement(e);
        }
        return null;
    }

    public static Element getParentElement(Element elt) {
        for (Node n = elt.getParentNode(); n != null; n = n.getParentNode()) {
            if ((n = CSSEngine.getLogicalParentNode(n)).getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Node getLogicalParentNode(Node parent) {
        Node node = parent;
        if (node != null) {
            if (node instanceof CSSImportedElementRoot) {
                return ((CSSImportedElementRoot)node).getCSSParentElement();
            }
            return node;
        }
        return null;
    }

    public static CSSImportedElementRoot getImportedChild(Node node) {
        if (node instanceof CSSImportNode) {
            CSSImportNode inode = (CSSImportNode)node;
            CSSImportedElementRoot r = inode.getCSSImportedElementRoot();
            return r;
        }
        return null;
    }

    protected CSSEngine(Document doc, URL uri, ExtendedParser p, ValueManager[] vm, ShorthandManager[] sm, String[] pe, String sns, String sln, String cns, String cln, boolean hints, String hintsNS, CSSContext ctx) {
        this.document = doc;
        this.documentURI = uri;
        this.parser = p;
        this.pseudoElementNames = pe;
        this.styleNamespaceURI = sns;
        this.styleLocalName = sln;
        this.classNamespaceURI = cns;
        this.classLocalName = cln;
        this.cssContext = ctx;
        this.cssConditionFactory = new CSSConditionFactory(cns, cln, null, "id");
        this.valueManagers = vm;
        this.shorthandManagers = sm;
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            et.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            et.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            et.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            et.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            et.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            this.ALL_PROPERTIES[i] = i;
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            EventTarget et = (EventTarget)((Object)this.document);
            et.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            et.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            et.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            et.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            et.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            CSSImportedElementRoot c;
            if (n.getNodeType() == 1) {
                this.disposeStyleMaps(n);
            }
            if ((c = CSSEngine.getImportedChild(n)) == null) continue;
            this.disposeStyleMaps(c);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String name) {
        return this.indexes.get(name);
    }

    public int getShorthandIndex(String name) {
        return this.shorthandIndexes.get(name);
    }

    public String getPropertyName(int idx) {
        return this.valueManagers[idx].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet ss) {
        this.userAgentStyleSheet = ss;
    }

    public void setUserStyleSheet(StyleSheet ss) {
        this.userStyleSheet = ss;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public void setMedia(String str) {
        try {
            this.media = this.parser.parseMedia(str);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = Messages.formatMessage("media.error", new Object[]{str, m});
            throw new DOMException(12, s);
        }
    }

    public void setAlternateStyleSheet(String str) {
        this.alternateStyleSheet = str;
    }

    public void importCascadedStyleMaps(Element src, CSSEngine srceng, Element dest) {
        if (src instanceof CSSStylableElement) {
            CSSStylableElement csrc = (CSSStylableElement)src;
            CSSStylableElement cdest = (CSSStylableElement)dest;
            StyleMap sm = srceng.getCascadedStyleMap(csrc, null);
            sm.setFixedCascadedStyle(true);
            cdest.setComputedStyleMap(null, sm);
            if (this.pseudoElementNames != null) {
                for (String pe : this.pseudoElementNames) {
                    sm = srceng.getCascadedStyleMap(csrc, pe);
                    cdest.setComputedStyleMap(pe, sm);
                }
            }
        }
        Node dn = dest.getFirstChild();
        Node sn = src.getFirstChild();
        while (dn != null) {
            if (sn.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)sn, srceng, (Element)dn);
            }
            dn = dn.getNextSibling();
            sn = sn.getNextSibling();
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            if (this.element == null) {
                try {
                    return new URL("http", "localhost", 80, "dummy");
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else {
                this.cssBaseURI = this.element.getCSSBase();
            }
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement elt, String pseudo) {
        ArrayList rules;
        int props = this.getNumberOfProperties();
        StyleMap result = new StyleMap(props);
        if (this.userAgentStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userAgentStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)0);
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)8192);
        }
        this.element = elt;
        try {
            String style;
            int i;
            ArrayList rules2;
            this.applyNonCSSPresentationalHints(elt, result);
            List<WeakReference<CSSStyleSheetNode>> snodes = this.getStyleSheetNodes();
            int slen = snodes.size();
            if (slen > 0) {
                rules2 = new ArrayList();
                for (i = 0; i < slen; ++i) {
                    StyleSheet ss;
                    CSSStyleSheetNode ssn;
                    WeakReference<CSSStyleSheetNode> ssnWRef = snodes.get(i);
                    CSSStyleSheetNode cSSStyleSheetNode = ssn = ssnWRef == null ? null : (CSSStyleSheetNode)ssnWRef.get();
                    if (ssn == null || (ss = ssn.getCSSStyleSheet()) == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                    this.addMatchingRules(rules2, ss, elt, pseudo);
                }
                this.addRules(elt, pseudo, result, rules2, (short)24576);
            }
            if (this.transientStyleSheetNodes != null) {
                rules2 = new ArrayList(this.transientStyleSheetNodes.size());
                for (i = 0; i < this.transientStyleSheetNodes.size(); ++i) {
                    CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.transientStyleSheetNodes.get(i);
                    StyleSheet ss = ssn.getCSSStyleSheet();
                    if (ss == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                    this.addMatchingRules(rules2, ss, elt, pseudo);
                }
                this.addRules(elt, pseudo, result, rules2, (short)24576);
            }
            if (this.styleLocalName != null && (style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = result;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.styleDeclarationDocumentHandler.location = elt;
                    this.styleDeclarationDocumentHandler.lineno = -1;
                    this.parser.parseStyleDeclaration(style);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = "";
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, style, m});
                    DOMException de = new DOMException(12, s);
                    de.initCause(e);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return result;
    }

    protected void displayError(DOMException e, Object location, int lineno, int column) {
    }

    protected void displayMissingStyleSheet(String uri) {
    }

    public String getExpandingShorthandProperty() {
        if (this.expandingShorthandProperty == -1) {
            return null;
        }
        return this.shorthandManagers[this.expandingShorthandProperty].getPropertyName();
    }

    protected void setAttributeValue(Element elt, String name, String value) {
        if (value != null) {
            elt.setAttribute(name, value);
        } else {
            elt.removeAttribute(name);
        }
    }

    protected void applyNonCSSPresentationalHints(CSSStylableElement elt, StyleMap map) {
    }

    protected void applyNonCSSPresentationalHint(CSSStylableElement elt, StyleMap map, int idx, String value) {
        try {
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            ValueManager vm = this.valueManagers[idx];
            try {
                Value v = vm.createValue(lu, this);
                if (v instanceof AbstractValue) {
                    AbstractValue av = (AbstractValue)v;
                    av.setLocation(elt);
                    av.setLineNumber(-1);
                }
                this.putAuthorProperty(map, idx, v, false, (short)16384);
            }
            catch (DOMException e) {
                this.displayError(e, elt, 0, 0);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, "?", value, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    protected void applyNonCSSPresentationalHint(CSSStylableElement elt, StyleMap map, int idx, Value v) {
        ValueManager vm = this.valueManagers[idx];
        try {
            this.putAuthorProperty(map, idx, v, false, (short)16384);
        }
        catch (DOMException e) {
            this.displayError(e, elt, 0, 0);
        }
    }

    public boolean isDefaultValue(CSSStylableElement elt, String pseudo, int propidx) {
        Value value;
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        if ((value = sm.getValue(propidx)) != null) {
            return false;
        }
        ValueManager vm = this.valueManagers[propidx];
        CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
        return value == null && (!vm.isInheritedProperty() || p == null);
    }

    public boolean isInheritedValue(CSSStylableElement elt, int propidx) {
        Value v = this.getComputedStyle(elt, null, propidx);
        StyleMap sm = elt.getComputedStyleMap(null);
        return sm.isInherited(propidx);
    }

    public Collection getStyleClasses() {
        int i;
        List<WeakReference<CSSStyleSheetNode>> snodes;
        int slen;
        TreeSet styleClasses = new TreeSet();
        if (this.userStyleSheet != null) {
            ArrayList rules = new ArrayList();
            this.addStyleClasses(styleClasses, this.userStyleSheet);
        }
        if ((slen = (snodes = this.getStyleSheetNodes()).size()) > 0) {
            for (i = 0; i < slen; ++i) {
                StyleSheet ss;
                CSSStyleSheetNode ssn;
                WeakReference<CSSStyleSheetNode> ssnWRef = snodes.get(i);
                CSSStyleSheetNode cSSStyleSheetNode = ssn = ssnWRef == null ? null : (CSSStyleSheetNode)ssnWRef.get();
                if (ssn == null || (ss = ssn.getCSSStyleSheet()) == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                this.addStyleClasses(styleClasses, ss);
            }
        }
        if (this.transientStyleSheetNodes != null) {
            for (i = 0; i < this.transientStyleSheetNodes.size(); ++i) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.transientStyleSheetNodes.get(i);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                this.addStyleClasses(styleClasses, ss);
            }
        }
        return styleClasses;
    }

    private void addStyleClasses(Collection styleClasses, StyleSheet ss) {
        int len = ss.getSize();
        block4: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        CSSConditionalSelector cs;
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        if (!(s instanceof CSSConditionalSelector) || !((cs = (CSSConditionalSelector)s).getCondition() instanceof CSSClassCondition)) continue;
                        CSSClassCondition ck = (CSSClassCondition)cs.getCondition();
                        styleClasses.add(ck.getValue());
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) continue block4;
                    this.addStyleClasses(styleClasses, mr);
                }
            }
        }
    }

    public String getMatchingRules(Element elt, boolean includeAgentRules) {
        String style;
        List<WeakReference<CSSStyleSheetNode>> snodes;
        int slen;
        Rule rule;
        Iterator it;
        ArrayList rules;
        String pseudo = "";
        StringBuffer sb = new StringBuffer(2000);
        if (includeAgentRules && this.userAgentStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userAgentStyleSheet, elt, pseudo);
            it = rules.iterator();
            if (it.hasNext()) {
                sb.append("Default User Agent Styles:\n");
            }
            while (it.hasNext()) {
                rule = (Rule)it.next();
                sb.append(rule.toString(this));
                sb.append("\n");
            }
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, elt, pseudo);
            it = rules.iterator();
            if (it.hasNext()) {
                sb.append("Default User Styles:\n");
            }
            while (it.hasNext()) {
                rule = (Rule)it.next();
                sb.append(rule.toString(this));
                sb.append("\n");
            }
        }
        if ((slen = (snodes = this.getStyleSheetNodes()).size()) > 0) {
            for (int i = 0; i < slen; ++i) {
                StyleSheet ss;
                CSSStyleSheetNode ssn;
                WeakReference<CSSStyleSheetNode> ssnWRef = snodes.get(i);
                CSSStyleSheetNode cSSStyleSheetNode = ssn = ssnWRef == null ? null : (CSSStyleSheetNode)ssnWRef.get();
                if (ssn == null || (ss = ssn.getCSSStyleSheet()) == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                ArrayList rules2 = new ArrayList();
                this.addMatchingRules(rules2, ss, elt, pseudo);
                Iterator it2 = rules2.iterator();
                if (it2.hasNext()) {
                    sb.append(ss.getTitle() + ":\n");
                }
                while (it2.hasNext()) {
                    Rule rule2 = (Rule)it2.next();
                    sb.append(rule2.toString(this));
                    sb.append("\n");
                }
            }
        }
        if (this.transientStyleSheetNodes != null) {
            for (int i = 0; i < this.transientStyleSheetNodes.size(); ++i) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.transientStyleSheetNodes.get(i);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                ArrayList rules3 = new ArrayList();
                this.addMatchingRules(rules3, ss, elt, pseudo);
                Iterator it3 = rules3.iterator();
                if (it3.hasNext()) {
                    sb.append(ss.getTitle() + ":\n");
                }
                while (it3.hasNext()) {
                    Rule rule3 = (Rule)it3.next();
                    sb.append(rule3.toString(this));
                    sb.append("\n");
                }
            }
        }
        if ((style = elt.getAttribute(this.styleLocalName)).length() > 0) {
            sb.append("style=\"" + style + "\"\n");
        }
        return sb.toString();
    }

    public String getUpdatedLocalStyleValues(CSSStylableElement elt, StyleSetting[] stylesToSet, StyleSetting[] stylesToRemove) throws Exception {
        String style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName);
        StringBuffer styleBuffer = new StringBuffer(200);
        if (style.length() > 0) {
            styleBuffer.append(style);
        }
        if (stylesToSet != null) {
            for (int i = 0; i < stylesToSet.length; ++i) {
                StyleSetting setting = stylesToSet[i];
                if (styleBuffer.length() > 0) {
                    styleBuffer.append("; ");
                }
                styleBuffer.append(this.getPropertyName(setting.getIndex()));
                styleBuffer.append(":");
                styleBuffer.append(setting.getValue());
            }
        }
        style = styleBuffer.toString();
        CSSStylableElement old = this.element;
        try {
            int props = this.getNumberOfProperties();
            StyleMap result = new StyleMap(props);
            this.element = elt;
            this.unknownPropertyNames = new ArrayList();
            this.unknownPropertyValues = new ArrayList();
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.styleDeclarationDocumentHandler.styleMap = result;
            this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
            this.styleDeclarationDocumentHandler.location = elt;
            this.styleDeclarationDocumentHandler.lineno = -1;
            this.parser.parseStyleDeclaration(style);
            this.styleDeclarationDocumentHandler.styleMap = null;
            if (stylesToRemove != null) {
                StyleMap sm = elt.getComputedStyleMap(null);
                for (int i = 0; i < stylesToRemove.length; ++i) {
                    StyleSetting setting = stylesToRemove[i];
                    result.putValue(setting.getIndex(), null);
                    if (sm == null) continue;
                    sm.putValue(setting.getIndex(), null);
                }
            }
            String s = this.toMinimalStyleString(result);
            if (this.unknownPropertyNames.size() > 0) {
                StringBuffer sb = new StringBuffer(s.length() + this.unknownPropertyNames.size() * 30);
                sb.append(s);
                int n = this.unknownPropertyNames.size();
                for (int i = 0; i < n; ++i) {
                    if (sb.length() > 0) {
                        sb.append(';');
                        sb.append(' ');
                    }
                    sb.append(this.unknownPropertyNames.get(i).toString());
                    sb.append(':');
                    sb.append(' ');
                    sb.append(this.unknownPropertyValues.get(i).toString());
                }
                s = sb.toString();
            }
            if (s.length() == 0) {
                s = null;
            }
            String sb = s;
            return sb;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, style, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            throw de;
        }
        finally {
            this.unknownPropertyNames = null;
            this.unknownPropertyValues = null;
            this.element = old;
        }
    }

    private void appendCss(StringBuffer sb, LexicalUnit value) {
        while (value != null) {
            switch (value.getLexicalUnitType()) {
                case 0: {
                    sb.append(",");
                    break;
                }
                case 1: {
                    sb.append("+");
                    break;
                }
                case 2: {
                    sb.append("-");
                    break;
                }
                case 3: {
                    sb.append("*");
                    break;
                }
                case 4: {
                    sb.append("/");
                    break;
                }
                case 5: {
                    sb.append("%");
                    break;
                }
                case 6: {
                    sb.append("^");
                    break;
                }
                case 7: {
                    sb.append("<");
                    break;
                }
                case 8: {
                    sb.append(">");
                    break;
                }
                case 9: {
                    sb.append("<=");
                    break;
                }
                case 10: {
                    sb.append(">=");
                    break;
                }
                case 11: {
                    sb.append("~");
                    break;
                }
                case 12: {
                    sb.append("inherit");
                    break;
                }
                case 13: {
                    sb.append(Integer.toString(value.getIntegerValue()));
                    break;
                }
                case 14: {
                    sb.append(Float.toString(value.getFloatValue()));
                    break;
                }
                case 15: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 16: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 17: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 18: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 19: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 20: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 21: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 22: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 23: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 24: {
                    sb.append("uri(" + value.getStringValue() + ")");
                    break;
                }
                case 28: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 29: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 30: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 31: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 32: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 33: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 34: {
                    sb.append(Float.toString(value.getFloatValue()) + value.getDimensionUnitText());
                    break;
                }
                case 35: {
                    sb.append(value.getStringValue());
                    break;
                }
                case 36: {
                    sb.append("\"" + value.getStringValue() + "\"");
                    break;
                }
                case 37: {
                    sb.append(value.getStringValue());
                    break;
                }
                case 42: {
                    sb.append(Float.toString(value.getFloatValue()));
                    break;
                }
                case 39: {
                    break;
                }
                case 40: {
                    sb.append("(");
                    this.appendCss(sb, value.getSubValues());
                    sb.append(")");
                    break;
                }
                case 27: {
                    sb.append("rgb");
                    sb.append("(");
                    this.appendCss(sb, value.getParameters());
                    sb.append(")");
                    break;
                }
                case 25: {
                    sb.append("counter");
                    sb.append("(");
                    this.appendCss(sb, value.getParameters());
                    sb.append(")");
                    break;
                }
                case 26: {
                    sb.append("counters");
                    sb.append("(");
                    this.appendCss(sb, value.getParameters());
                    sb.append(")");
                    break;
                }
                case 38: {
                    sb.append("rect");
                    sb.append("(");
                    this.appendCss(sb, value.getParameters());
                    sb.append(")");
                    break;
                }
                case 41: {
                    sb.append(value.getFunctionName());
                    sb.append("(");
                    this.appendCss(sb, value.getParameters());
                    sb.append(")");
                }
            }
            if ((value = value.getNextLexicalUnit()) == null) continue;
            sb.append(' ');
        }
    }

    public void addTransientStyleSheetNode(CSSStyleSheetNode elt) {
        if (this.transientStyleSheetNodes == null) {
            this.transientStyleSheetNodes = new ArrayList();
        }
        this.transientStyleSheetNodes.add(elt);
    }

    public void clearTransientStyleSheetNodes() {
        this.transientStyleSheetNodes = null;
    }

    protected void warnCircularReference(URL uri, Object location) {
        System.err.println("Circular reference: " + uri);
    }

    public Value getComputedStyle(CSSStylableElement elt, String pseudo, int propidx) {
        ++styleLookupCount;
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        Value value = sm.getValue(propidx);
        if (!sm.isComputed(propidx)) {
            Value result = value;
            ValueManager vm = this.valueManagers[propidx];
            CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
            if (!(value != null || vm.isInheritedProperty() && p != null)) {
                result = vm.getDefaultValue();
            } else if (value != null && value == InheritValue.INSTANCE && p != null) {
                result = null;
            }
            if (result == null) {
                result = this.getComputedStyle(p, null, propidx);
                sm.putParentRelative(propidx, true);
                sm.putInherited(propidx, true);
            } else {
                result = vm.computeValue(elt, pseudo, this, propidx, sm, result);
            }
            if (value == null) {
                sm.putValue(propidx, result);
                sm.putNullCascaded(propidx, true);
            } else if (value == InheritValue.INSTANCE) {
                sm.putValue(propidx, result);
                sm.putInherited(propidx, true);
            } else if (result != value) {
                ComputedValue cv = new ComputedValue(value);
                cv.setComputedValue(result);
                sm.putValue(propidx, cv);
                result = cv;
            }
            sm.putComputed(propidx, true);
            value = result;
        }
        return value;
    }

    public List<WeakReference<CSSStyleSheetNode>> getStyleSheetNodes() {
        boolean discardOldCache = false;
        if (this.styleSheetNodes != null) {
            for (WeakReference<CSSStyleSheetNode> styleSheetNodeWRef : this.styleSheetNodes) {
                Element ssElement;
                CSSStyleSheetNode ssnode;
                CSSStyleSheetNode cSSStyleSheetNode = ssnode = styleSheetNodeWRef == null ? null : (CSSStyleSheetNode)styleSheetNodeWRef.get();
                if (ssnode == null) {
                    discardOldCache = true;
                    break;
                }
                if (!(ssnode instanceof Element) || (ssElement = (Element)((Object)ssnode)).getParentNode() != null) continue;
                discardOldCache = true;
                break;
            }
        }
        if (discardOldCache) {
            this.styleSheetNodes = null;
        }
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList<WeakReference<CSSStyleSheetNode>>();
            if (this.document == null) {
                return this.styleSheetNodes;
            }
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes();
            int len = this.styleSheetNodes.size();
            for (int i = 0; i < len; ++i) {
                WeakReference<CSSStyleSheetNode> ssnWRef = this.styleSheetNodes.get(i);
                CSSStyleSheetNode ssn = ssnWRef == null ? null : (CSSStyleSheetNode)ssnWRef.get();
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss == null) continue;
                this.findSelectorAttributes(this.selectorAttributes, ss);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes() {
        this.findStyleSheetNodes(this.document);
    }

    protected String toMinimalStyleString(StyleMap map) {
        return map.toStyleString(this);
    }

    protected void findStyleSheetNodes(Node n) {
        if (n instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(new WeakReference<CSSStyleSheetNode>((CSSStyleSheetNode)((Object)n)));
        }
        for (Node nd = n.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            this.findStyleSheetNodes(nd);
        }
    }

    protected void findSelectorAttributes(Set attrs, StyleSheet ss) {
        int len = ss.getSize();
        block4: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        s.fillAttributeSet(attrs);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) continue block4;
                    this.findSelectorAttributes(attrs, mr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement elt, final MainPropertyReceiver dst, String pname, String value, boolean important) {
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                public void property(String pname, LexicalUnit lu, boolean important) {
                    int idx = CSSEngine.this.getPropertyIndex(pname);
                    if (idx != -1) {
                        ValueManager vm = CSSEngine.this.valueManagers[idx];
                        Value v = vm.createValue(lu, CSSEngine.this);
                        dst.setMainProperty(pname, v, important);
                        return;
                    }
                    idx = CSSEngine.this.getShorthandIndex(pname);
                    if (idx == -1) {
                        return;
                    }
                    CSSEngine.this.expandingShorthandProperty = idx;
                    CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                    CSSEngine.this.expandingShorthandProperty = -1;
                }
            };
            ph.property(pname, lu, important);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, pname, value, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement elt, String prop, String value) {
        int idx = this.getPropertyIndex(prop);
        if (idx == -1) {
            return null;
        }
        ValueManager vm = this.valueManagers[idx];
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue(value);
            Value value2 = vm.createValue(lu, this);
            return value2;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, prop, value, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return vm.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement elt, String value) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = elt;
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.styleDeclarationBuilder.location = elt;
            this.styleDeclarationBuilder.lineno = -1;
            this.parser.parseStyleDeclaration(value);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheet parseStyleSheet(URL uri, String media, Object location) throws DOMException {
        StyleSheetCache cache = StyleSheetCache.getInstance();
        StyleSheet ss = cache.get(uri);
        if (ss == PARSING_SHEET) {
            this.warnCircularReference(uri, location);
            return new StyleSheet();
        }
        if (ss != null) {
            return ss;
        }
        StyleSheet parsedSheet = null;
        ss = new StyleSheet();
        try {
            cache.put(uri, PARSING_SHEET);
            try {
                ss.setMedia(this.parser.parseMedia(media));
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m == null) {
                    m = "";
                }
                String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
                DOMException de = new DOMException(12, s);
                de.initCause(e);
                if (this.userAgent == null) {
                    throw de;
                }
                this.userAgent.displayError(de);
                StyleSheet styleSheet = ss;
                cache.put(uri, parsedSheet);
                return styleSheet;
            }
        }
        catch (Throwable throwable) {
            cache.put(uri, parsedSheet);
            throw throwable;
        }
        this.parseStyleSheet(ss, uri, location);
        parsedSheet = ss;
        cache.put(uri, parsedSheet);
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheet parseStyleSheet(InputSource is, URL uri, String media, Object location) throws DOMException {
        StyleSheetCache cache = StyleSheetCache.getInstance();
        StyleSheet ss = cache.get(uri);
        if (ss == PARSING_SHEET) {
            this.warnCircularReference(uri, location);
            return new StyleSheet();
        }
        if (ss != null) {
            return ss;
        }
        StyleSheet parsedSheet = null;
        ss = new StyleSheet();
        cache.put(uri, PARSING_SHEET);
        try {
            ss.setMedia(this.parser.parseMedia(media));
            this.parseStyleSheet(ss, is, uri, location);
            parsedSheet = ss;
            cache.put(uri, parsedSheet);
        }
        catch (Exception e) {
            try {
                String m = e.getMessage();
                if (m == null) {
                    m = "";
                }
                String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
                DOMException de = new DOMException(12, s);
                de.initCause(e);
                if (this.userAgent == null) {
                    throw de;
                }
                this.userAgent.displayError(de);
                cache.put(uri, parsedSheet);
            }
            catch (Throwable throwable) {
                cache.put(uri, parsedSheet);
                throw throwable;
            }
        }
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, URL uri, Object location) throws DOMException {
        if (uri == null) {
            String s = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return;
        }
        try {
            this.parseStyleSheet(ss, new InputSource(uri.toString()), uri, location);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof CSSException && ((CSSException)e).getException() instanceof IOException) {
                this.displayMissingStyleSheet(uri.toString());
                return;
            }
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = Messages.formatMessage("syntax.error.at", new Object[]{uri.toString(), m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    public StyleSheet parseStyleSheet(String rules, URL uri, String media, Object location) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, rules, uri, location);
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, String rules, URL uri, Object location) throws DOMException {
        try {
            this.parseStyleSheet(ss, new InputSource(new StringReader(rules)), uri, location);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String s = "";
            s = uri == null ? Messages.formatMessage("stylesheet.syntax.error", new Object[]{"None", rules, m}) : Messages.formatMessage("stylesheet.syntax.error", new Object[]{uri.toString(), rules, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(StyleSheet ss, InputSource is, URL uri, Object location) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = uri;
            this.styleSheetDocumentHandler.styleSheet = ss;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.styleSheetDocumentHandler.location = location;
            this.styleSheetDocumentHandler.lineno = 0;
            this.parser.parseStyleSheet(is);
            int len = ss.getSize();
            for (int i = 0; i < len; ++i) {
                Rule r = ss.getRule(i);
                if (r.getType() != 2) {
                    break;
                }
                ImportRule ir = (ImportRule)r;
                StyleSheetCache cache = StyleSheetCache.getInstance();
                StyleSheet sheet = cache.get(ir.getURI());
                if (sheet == PARSING_SHEET) {
                    this.warnCircularReference(ir.getURI(), location);
                    continue;
                }
                this.parseStyleSheet(ir, ir.getURI(), (Object)ir.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap dest, int idx, Value sval, boolean imp, short origin) {
        boolean cond;
        Value dval = dest.getValue(idx);
        short dorg = dest.getOrigin(idx);
        boolean dimp = dest.isImportant(idx);
        boolean bl = cond = dval == null;
        if (!cond) {
            switch (dorg) {
                case 8192: {
                    cond = !dimp;
                    break;
                }
                case 24576: {
                    cond = !dimp || imp;
                    break;
                }
                default: {
                    cond = true;
                }
            }
        }
        if (cond) {
            dest.putValue(idx, sval);
            dest.putImportant(idx, imp);
            dest.putOrigin(idx, origin);
        }
    }

    private void addCandidateRules(List rules, Map map, String key, Element elt, String pseudo) {
        ExtendedSelector[] rs = (ExtendedSelector[])map.get(key);
        if (rs != null) {
            for (int i = 0; i < rs.length; ++i) {
                ExtendedSelector s = rs[i];
                if (!s.match(elt, pseudo)) continue;
                Rule r = s.getRule();
                assert (r.getType() == 0);
                rules.add(r);
            }
        }
    }

    protected void addMatchingRules(List rules, StyleSheet ss, Element elt, String pseudo) {
        if (RULE_FILTERING) {
            Rule[] rs;
            String id;
            HashMap idMap;
            String styleClass;
            HashMap classMap;
            ArrayList<StyleRule> newRules = new ArrayList<StyleRule>(ss.getSize());
            HashMap tagMap = ss.getTagMap();
            if (tagMap != null) {
                String tagName = elt.getTagName();
                this.addCandidateRules(newRules, tagMap, tagName, elt, pseudo);
            }
            if ((classMap = ss.getClassMap()) != null && (styleClass = elt.getAttribute("class")).length() != 0) {
                if (styleClass.indexOf(32) == -1) {
                    this.addCandidateRules(newRules, classMap, styleClass, elt, pseudo);
                } else {
                    int begin = 0;
                    int length = styleClass.length();
                    while (begin < length) {
                        int end;
                        while (begin < length && Character.isSpace(styleClass.charAt(begin))) {
                            ++begin;
                        }
                        for (end = begin + 1; end < length && !Character.isSpace(styleClass.charAt(end)); ++end) {
                        }
                        if (begin < length && end > begin) {
                            this.addCandidateRules(newRules, classMap, styleClass.substring(begin, end), elt, pseudo);
                        }
                        begin = end + 1;
                    }
                }
            }
            if ((idMap = ss.getIdMap()) != null && (id = elt.getAttribute("id")).length() > 0) {
                this.addCandidateRules(newRules, idMap, id, elt, pseudo);
            }
            if ((rs = ss.getRemainingRules()) != null) {
                block11: for (int i = 0; i < rs.length; ++i) {
                    Rule r = rs[i];
                    switch (r.getType()) {
                        case 0: {
                            StyleRule style = (StyleRule)r;
                            SelectorList selectorList = style.getSelectorList();
                            int slen = selectorList.getLength();
                            for (int j = 0; j < slen; ++j) {
                                ExtendedSelector s = (ExtendedSelector)selectorList.item(j);
                                if (!s.match(elt, pseudo)) continue;
                                newRules.add(style);
                            }
                            continue block11;
                        }
                        case 1: 
                        case 2: {
                            MediaRule mr = (MediaRule)r;
                            if (!this.mediaMatch(mr.getMediaList())) continue block11;
                            this.addMatchingRules(newRules, mr, elt, pseudo);
                        }
                    }
                }
                int size = newRules.size();
                if (size > 0) {
                    if (size > 1) {
                        Collections.sort(newRules, this.ruleComparator);
                    }
                    Object prev = null;
                    for (Object e : newRules) {
                        if (e == prev) continue;
                        rules.add(e);
                        prev = e;
                    }
                }
                return;
            }
        }
        int len = ss.getSize();
        block14: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        ExtendedSelector s = (ExtendedSelector)sl.item(j);
                        if (!s.match(elt, pseudo)) continue;
                        rules.add(style);
                    }
                    continue block14;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMediaList())) continue block14;
                    this.addMatchingRules(rules, mr, elt, pseudo);
                }
            }
        }
    }

    protected void addRules(Element elt, String pseudo, StyleMap sm, List rules, short origin) {
        this.sortRules(rules, elt, pseudo);
        int rlen = rules.size();
        if (origin == 24576) {
            for (int r = 0; r < rlen; ++r) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    this.putAuthorProperty(sm, sd.getIndex(i), sd.getValue(i), sd.getPriority(i), origin);
                }
            }
        } else {
            for (int r = 0; r < rlen; ++r) {
                StyleRule sr = (StyleRule)rules.get(r);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    int idx = sd.getIndex(i);
                    sm.putValue(idx, sd.getValue(i));
                    sm.putImportant(idx, sd.getPriority(i));
                    sm.putOrigin(idx, origin);
                }
            }
        }
    }

    protected void sortRules(List rules, Element elt, String pseudo) {
        int len = rules.size();
        for (int i = 0; i < len - 1; ++i) {
            int idx = i;
            int min = Integer.MAX_VALUE;
            for (int j = i; j < len; ++j) {
                StyleRule r = (StyleRule)rules.get(j);
                SelectorList sl = r.getSelectorList();
                int spec = 0;
                int slen = sl.getLength();
                for (int k = 0; k < slen; ++k) {
                    int sp;
                    ExtendedSelector s = (ExtendedSelector)sl.item(k);
                    if (!s.match(elt, pseudo) || (sp = s.getSpecificity()) <= spec) continue;
                    spec = sp;
                }
                if (spec >= min) continue;
                min = spec;
                idx = j;
            }
            if (i == idx) continue;
            Object tmp = rules.get(i);
            rules.set(i, rules.get(idx));
            rules.set(idx, tmp);
        }
    }

    protected boolean mediaMatch(SACMediaList ml) {
        if (this.media == null || ml == null || this.media.getLength() == 0 || ml.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < ml.getLength(); ++i) {
            if (ml.item(i).equalsIgnoreCase("all")) {
                return true;
            }
            for (int j = 0; j < this.media.getLength(); ++j) {
                if (!this.media.item(j).equalsIgnoreCase("all") && !ml.item(i).equalsIgnoreCase(this.media.item(j))) continue;
                return true;
            }
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener l) {
        this.listeners.add(l);
    }

    public void removeCSSEngineListener(CSSEngineListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertiesChangedEvent(Element target, int[] props) {
        CSSEngineListener[] ll = this.listeners.toArray(LISTENER_ARRAY);
        int len = ll.length;
        if (len > 0) {
            CSSEngineEvent evt = new CSSEngineEvent(this, target, props);
            for (int i = 0; i < len; ++i) {
                ll[i].propertiesChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement elt, StyleMap style, MutationEvent evt) {
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                String decl = evt.getNewValue();
                if (decl.length() > 0) {
                    this.element = elt;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = style;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.styleDeclarationUpdateHandler.location = elt;
                        this.styleDeclarationUpdateHandler.lineno = -1;
                        this.parser.parseStyleDeclaration(decl);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m == null) {
                            m = "";
                        }
                        String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, decl, m});
                        DOMException de = new DOMException(12, s);
                        de.initCause(e);
                        if (this.userAgent == null) {
                            throw de;
                        }
                        this.userAgent.displayError(de);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                boolean removed = false;
                if (evt.getPrevValue() != null && evt.getPrevValue().length() > 0) {
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        if (!style.isComputed(i) || style.getOrigin(i) != Short.MIN_VALUE || updated[i]) continue;
                        removed = true;
                        updated[i] = true;
                    }
                }
                if (removed) {
                    this.invalidateProperties(elt, null, updated, true);
                    break;
                }
                int count = 0;
                boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
                boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
                boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (updated[i]) {
                        ++count;
                        continue;
                    }
                    if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
                    updated[i] = true;
                    CSSEngine.clearComputedValue(style, i);
                    ++count;
                }
                if (count <= 0) break;
                int[] props = new int[count];
                count = 0;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.invalidateProperties(elt, props, null, true);
                break;
            }
            default: {
                throw new InternalError("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap style, int n) {
        if (style.isNullCascaded(n)) {
            style.putValue(n, null);
        } else {
            Value v = style.getValue(n);
            if (v instanceof ComputedValue) {
                ComputedValue cv = (ComputedValue)v;
                v = cv.getCascadedValue();
                style.putValue(n, v);
            }
        }
        style.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] properties, boolean[] updated, boolean recascade) {
        int i;
        int i2;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style == null) {
            return;
        }
        boolean[] diffs = new boolean[this.getNumberOfProperties()];
        if (updated != null) {
            for (i2 = 0; i2 < updated.length; ++i2) {
                diffs[i2] = updated[i2];
            }
        }
        if (properties != null) {
            for (i2 = 0; i2 < properties.length; ++i2) {
                diffs[properties[i2]] = true;
            }
        }
        int count = 0;
        if (!recascade) {
            for (int i3 = 0; i3 < diffs.length; ++i3) {
                if (!diffs[i3]) continue;
                ++count;
            }
        } else {
            StyleMap newStyle = this.getCascadedStyleMap(elt, null);
            elt.setComputedStyleMap(null, newStyle);
            for (i = 0; i < diffs.length; ++i) {
                if (diffs[i]) {
                    ++count;
                    continue;
                }
                Value nv = newStyle.getValue(i);
                Value ov = null;
                if (!style.isNullCascaded(i) && (ov = style.getValue(i)) instanceof ComputedValue) {
                    ov = ((ComputedValue)ov).getCascadedValue();
                }
                if (nv == ov) continue;
                if (nv != null && ov != null) {
                    if (nv.equals(ov)) continue;
                    String ovCssText = ov.getCssText();
                    String nvCssText = nv.getCssText();
                    if (nvCssText == ovCssText || nvCssText != null && nvCssText.equals(ovCssText)) continue;
                }
                ++count;
                diffs[i] = true;
            }
        }
        int[] props = null;
        if (count != 0) {
            props = new int[count];
            count = 0;
            for (i = 0; i < diffs.length; ++i) {
                if (!diffs[i]) continue;
                props[count++] = i;
            }
        }
        this.propagateChanges(elt, props, recascade);
    }

    protected void propagateChanges(Node node, int[] props, boolean recascade) {
        CSSImportedElementRoot ier;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            int i;
            int i2;
            boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
            for (i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
                updated[i2] = false;
            }
            if (props != null) {
                for (i2 = props.length - 1; i2 >= 0; --i2) {
                    int idx = props[i2];
                    updated[idx] = true;
                }
            }
            boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
            boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
            boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
            int count = 0;
            for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                if (updated[i]) {
                    ++count;
                    continue;
                }
                if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
                updated[i] = true;
                CSSEngine.clearComputedValue(style, i);
                ++count;
            }
            if (count == 0) {
                props = null;
            } else {
                props = new int[count];
                count = 0;
                for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.firePropertiesChangedEvent(elt, props);
            }
        }
        int[] inherited = props;
        if (props != null) {
            int i;
            int count = 0;
            for (i = 0; i < props.length; ++i) {
                ValueManager vm = this.valueManagers[props[i]];
                if (vm.isInheritedProperty()) {
                    ++count;
                    continue;
                }
                props[i] = -1;
            }
            if (count == 0) {
                inherited = null;
            } else {
                inherited = new int[count];
                count = 0;
                for (i = 0; i < props.length; ++i) {
                    if (props[i] == -1) continue;
                    inherited[count++] = props[i];
                }
            }
        }
        if ((ier = CSSEngine.getImportedChild(node)) != null) {
            Node c = ier.getFirstChild();
            this.invalidateProperties(c, inherited, null, ier.getIsLocal());
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.invalidateProperties(n, inherited, null, recascade);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement elt, StyleMap style, String property, MutationEvent evt) {
        int idx = this.getPropertyIndex(property);
        if (style.isImportant(idx)) {
            return;
        }
        switch (style.getOrigin(idx)) {
            case -32768: 
            case 24576: {
                return;
            }
        }
        switch (evt.getAttrChange()) {
            case 1: 
            case 2: {
                this.element = elt;
                try {
                    LexicalUnit lu = this.parser.parsePropertyValue(evt.getNewValue());
                    ValueManager vm = this.valueManagers[idx];
                    Value v = vm.createValue(lu, this);
                    style.putMask(idx, (short)0);
                    style.putValue(idx, v);
                    style.putOrigin(idx, (short)16384);
                    break;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = "";
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, property, evt.getNewValue(), m});
                    DOMException de = new DOMException(12, s);
                    de.initCause(e);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] invalid = new int[]{idx};
                this.invalidateProperties(elt, invalid, null, true);
                return;
            }
        }
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        updated[idx] = true;
        boolean fs = idx == this.fontSizeIndex;
        boolean lh = idx == this.lineHeightIndex;
        boolean cl = idx == this.colorIndex;
        int count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (updated[i]) {
                ++count;
                continue;
            }
            if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i)) && (!cl || !style.isColorRelative(i))) continue;
            updated[i] = true;
            CSSEngine.clearComputedValue(style, i);
            ++count;
        }
        int[] props = new int[count];
        count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!updated[i]) continue;
            props[count++] = i;
        }
        this.invalidateProperties(elt, props, null, true);
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (!(et instanceof CSSStylableElement)) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            if (mevt.getNewValue().equals(mevt.getPrevValue())) {
                return;
            }
            Node attr = mevt.getRelatedNode();
            String attrNS = attr.getNamespaceURI();
            String name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
            CSSStylableElement elt = (CSSStylableElement)((Object)et);
            try {
                StyleMap style = elt.getComputedStyleMap(null);
                if (style != null) {
                    if ((attrNS == null && CSSEngine.this.styleNamespaceURI == null || attrNS != null && attrNS.equals(CSSEngine.this.styleNamespaceURI)) && name.equals(CSSEngine.this.styleLocalName)) {
                        CSSEngine.this.inlineStyleAttributeUpdated(elt, style, mevt);
                        return;
                    }
                    if (CSSEngine.this.nonCSSPresentationalHints != null && (attrNS == null && CSSEngine.this.nonCSSPresentationalHintsNamespaceURI == null || attrNS != null && attrNS.equals(CSSEngine.this.nonCSSPresentationalHintsNamespaceURI)) && CSSEngine.this.nonCSSPresentationalHints.contains(name)) {
                        CSSEngine.this.nonCSSPresentationalHintUpdated(elt, style, name, mevt);
                        return;
                    }
                }
                if (CSSEngine.this.selectorAttributes != null && CSSEngine.this.selectorAttributes.contains(name)) {
                    CSSEngine.this.invalidateProperties(elt, null, null, true);
                    for (Node n = elt.getNextSibling(); n != null; n = n.getNextSibling()) {
                        CSSEngine.this.invalidateProperties(n, null, null, true);
                    }
                }
            }
            catch (DOMException e) {
                CSSEngine.this.displayError(e, elt, CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            Node n = (Node)((Object)evt.getTarget());
            if (n.getParentNode() instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            }
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event evt) {
            if (CSSEngine.this.styleSheetRemoved) {
                CSSEngine.this.styleSheetRemoved = false;
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
            } else if (CSSEngine.this.removedStylableElementSibling != null) {
                for (Node n = CSSEngine.this.removedStylableElementSibling; n != null; n = n.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(n, null, null, true);
                }
                CSSEngine.this.removedStylableElementSibling = null;
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetRemoved = true;
            } else if (et instanceof CSSStylableElement) {
                CSSEngine.this.removedStylableElementSibling = ((Node)((Object)et)).getNextSibling();
            }
            CSSEngine.this.disposeStyleMaps((Node)((Object)et));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            EventTarget et = evt.getTarget();
            if (et instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateProperties(CSSEngine.this.document.getDocumentElement(), null, null, true);
                return;
            }
            if (et instanceof CSSStylableElement) {
                for (Node n = ((Node)((Object)evt.getTarget())).getNextSibling(); n != null; n = n.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(n, null, null, true);
                }
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;
        Object location;
        int lineno;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                try {
                    CSSEngine.this.expandingShorthandProperty = i;
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                    CSSEngine.this.expandingShorthandProperty = -1;
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            } else {
                if (this.styleMap.isImportant(i)) {
                    return;
                }
                this.updatedProperties[i] = true;
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                if (v instanceof AbstractValue) {
                    AbstractValue av = (AbstractValue)v;
                    av.setLocation(this.location);
                    av.setLineNumber(this.lineno + CSSEngine.this.parser.getLine() - 1);
                }
                this.styleMap.putMask(i, (short)0);
                this.styleMap.putValue(i, v);
                this.styleMap.putOrigin(i, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            throw new InternalError();
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        Object location;
        int lineno;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            ImportRule ir = new ImportRule();
            ir.setRelativeUri(uri);
            ir.setMediaList(media);
            ir.setParent(this.styleSheet);
            try {
                URL base = CSSEngine.this.getCSSBaseURI();
                URL url = base == null ? new URL(uri) : new URL(base, uri);
                ir.setURI(url);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.styleSheet.append(ir);
        }

        public void startMedia(SACMediaList media) throws CSSException {
            MediaRule mr = new MediaRule();
            mr.setMediaList(media);
            mr.setParent(this.styleSheet);
            this.styleSheet.append(mr);
            this.styleSheet = mr;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            try {
                StyleMap sm = new StyleMap(CSSEngine.this.getNumberOfProperties());
                int len = this.styleDeclaration.size();
                for (int i = 0; i < len; ++i) {
                    int idx = this.styleDeclaration.getIndex(i);
                    sm.putValue(idx, this.styleDeclaration.getValue(i));
                    sm.putImportant(idx, this.styleDeclaration.getPriority(i));
                    sm.putOrigin(idx, (short)24576);
                }
                this.styleDeclaration = null;
                int pidx = CSSEngine.this.getPropertyIndex("font-family");
                Value fontFamily = sm.getValue(pidx);
                if (fontFamily == null) {
                    return;
                }
                URL base = CSSEngine.this.getCSSBaseURI();
                ParsedURL purl = null;
                if (base != null) {
                    purl = new ParsedURL(base);
                }
                CSSEngine.this.fontFaces.add(new FontFaceRule(sm, purl));
            }
            catch (DOMException e) {
                CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectors);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                try {
                    CSSEngine.this.expandingShorthandProperty = i;
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                    CSSEngine.this.expandingShorthandProperty = -1;
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            } else {
                try {
                    Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                    if (v instanceof AbstractValue) {
                        AbstractValue av = (AbstractValue)v;
                        av.setLocation(this.location);
                        av.setLineNumber(this.lineno + CSSEngine.this.parser.getLine() - 1);
                    }
                    this.styleDeclaration.append(v, i, important);
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;
        Object location;
        int lineno;

        protected StyleDeclarationBuilder() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    if (CSSEngine.this.unknownPropertyNames != null) {
                        CSSEngine.this.unknownPropertyNames.add(name);
                        StringBuffer sb = new StringBuffer(50);
                        CSSEngine.this.appendCss(sb, value);
                        CSSEngine.this.unknownPropertyValues.add(sb.toString());
                    }
                    return;
                }
                try {
                    CSSEngine.this.expandingShorthandProperty = i;
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                    CSSEngine.this.expandingShorthandProperty = -1;
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            } else {
                try {
                    Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                    if (v instanceof AbstractValue) {
                        AbstractValue av = (AbstractValue)v;
                        av.setLocation(this.location);
                        av.setLineNumber(this.lineno + CSSEngine.this.parser.getLine() - 1);
                    }
                    this.styleDeclaration.append(v, i, important);
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        Object location;
        int lineno;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    if (CSSEngine.this.unknownPropertyNames != null) {
                        CSSEngine.this.unknownPropertyNames.add(name);
                        StringBuffer sb = new StringBuffer(50);
                        CSSEngine.this.appendCss(sb, value);
                        CSSEngine.this.unknownPropertyValues.add(sb.toString());
                    }
                    return;
                }
                try {
                    CSSEngine.this.expandingShorthandProperty = i;
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                    CSSEngine.this.expandingShorthandProperty = -1;
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            } else {
                try {
                    Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                    if (v instanceof AbstractValue) {
                        AbstractValue av = (AbstractValue)v;
                        av.setLocation(this.location);
                        av.setLineNumber(this.lineno + CSSEngine.this.parser.getLine() - 1);
                    }
                    CSSEngine.this.putAuthorProperty(this.styleMap, i, v, important, (short)Short.MIN_VALUE);
                }
                catch (DOMException e) {
                    CSSEngine.this.displayError(e, this.location, this.lineno + CSSEngine.this.parser.getLine() - 1, CSSEngine.this.parser.getColumn());
                }
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }

    public static interface StyleElementLink {
        public CSSStylableElement getStyleParent();

        public void setStyleParent(CSSStylableElement var1);
    }
}

