/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.ImportPaletteFolderAction;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.text.CloneableEditor;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SVGPaletteFactory {
    public static final String SVGXML_PALETTE_FOLDER = "SVGXMLPalette";
    public static final String SVG_PALETTE_THUMBNAIL_FOLDER = "SVGPalette/ThumbnailImages";
    private static PaletteController palette = null;

    public static synchronized PaletteController getPalette() throws IOException {
        if (palette == null) {
            palette = PaletteFactory.createPalette((String)SVGXML_PALETTE_FOLDER, (PaletteActions)new SVGPaletteActions(), null, null);
        }
        return palette;
    }

    private static class SVGPaletteActions
    extends PaletteActions {
        private SVGPaletteActions() {
        }

        public Action getPreferredAction(final Lookup lookup) {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                        SVGDataObject sVGDataObject;
                        if (!topComponent.isVisible() || (sVGDataObject = (SVGDataObject)((Object)topComponent.getLookup().lookup(SVGDataObject.class))) == null || sVGDataObject.getSceneManager().isReadOnly()) continue;
                        try {
                            MultiViewElement multiViewElement = sVGDataObject.getActiveElement();
                            assert (multiViewElement != null);
                            JComponent jComponent = multiViewElement.getVisualRepresentation();
                            if (jComponent instanceof CloneableEditor) {
                                ActiveEditorDrop activeEditorDrop = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
                                JEditorPane jEditorPane = ((CloneableEditor)jComponent).getEditorPane();
                                if (activeEditorDrop != null && jEditorPane != null) {
                                    activeEditorDrop.handleTransfer((JTextComponent)jEditorPane);
                                } else {
                                    SceneManager.log(Level.SEVERE, "Paletter drop failed - could not obtain context.");
                                }
                            } else if (jComponent instanceof SVGViewTopComponent) {
                                DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
                                assert (dataObject != null);
                                ((SVGViewTopComponent)((Object)jComponent)).dropDataObject(dataObject);
                            }
                        }
                        catch (Exception exception) {
                            SceneManager.error("Palette drop failed.", exception);
                        }
                        return;
                    }
                }
            };
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            return null;
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            return null;
        }

        public Action[] getImportActions() {
            return null;
        }

        public Action[] getCustomPaletteActions() {
            return new Action[]{SystemAction.get(ImportPaletteFolderAction.class)};
        }
    }
}

