/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.util.Utilities;

public final class ScaleActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor SCALE_MOUSE_CURSOR = new ActionMouseCursor(Toolkit.getDefaultToolkit().createCustomCursor(Utilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/resize_cursor.png"), new Point(8, 8), "rotateCursor"), 2);

    public ScaleActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToScaleAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new ScaleAction(this, sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        if (!bl && this.getObjectToScaleAt(mouseEvent) != null) {
            return SCALE_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent mouseEvent) {
        SVGObject sVGObject;
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0 && (sVGObject = sVGObjectArray[0]).getOutline().isAtScaleHandlePoint(mouseEvent.getX(), mouseEvent.getY())) {
            return sVGObject;
        }
        return null;
    }

    private static class ScaleAction
    extends AbstractComposerAction {
        private final SVGObject m_scaled;
        private final int m_x;
        private final int m_y;

        public ScaleAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, MouseEvent mouseEvent) {
            super(composerActionFactory);
            this.m_scaled = sVGObject;
            this.m_x = mouseEvent.getX();
            this.m_y = mouseEvent.getY();
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(this.calculateScale(mouseEvent.getX(), mouseEvent.getY()));
                rectangle.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : SCALE_MOUSE_CURSOR;
        }

        protected float calculateScale(int n, int n2) {
            float[] fArray = this.m_scaled.getOutline().getScalePivotPoint();
            float f = fArray[0] - (float)this.m_x;
            float f2 = fArray[1] - (float)this.m_y;
            float f3 = f * f + f2 * f2;
            f = fArray[0] - (float)n;
            f2 = fArray[1] - (float)n2;
            float f4 = f * f + f2 * f2;
            return f4 / f3;
        }
    }
}

