/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapper;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapperFactory;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.InputControlManager;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.CursorPositionActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.DeleteActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.HighlightActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveBackwardActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveFocusActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveForwardActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveToBottomActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveToTopActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.RotateActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectAction;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.SkewActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateActionFactory;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGStatusBar;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.w3c.dom.svg.SVGLocatableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SceneManager {
    public static final int EVENT_ANIM_STARTED = 2533;
    public static final int EVENT_ANIM_STOPPED = 2534;
    public static final int EVENT_IMAGE_DISPLAYED = 2535;
    public static final String OPERATION_TOKEN = "operation";
    private static final Logger LOGGER;
    private static final String LOGGER_NAME = "mobility.svg";
    private static final boolean LOG_TIME;
    private static final boolean LOG_THREAD;
    private static int s_instanceCounter;
    private transient SVGDataObject m_dObj = null;
    private transient int m_instanceID;
    private transient InstanceContent m_lookupContent;
    private transient Lookup m_lookup;
    private transient PerseusController m_perseusController;
    private transient ScreenManager m_screenMgr;
    private transient InputControlManager m_inputControlMgr;
    private transient List<ComposerActionFactory> m_actionFactories;
    private transient Stack<ComposerAction> m_activeActions;
    private transient List<Action> m_registeredActions;
    public transient SelectActionFactory m_selectActionFactory;
    private transient List<SelectionListener> m_selectionListeners;
    private transient SVGImage m_svgImage;
    private transient SVGLocatableElement m_popupElement = null;
    private transient String m_selectedId = null;
    private transient String m_selectedTag = null;
    private float m_animationDuration = 30.0f;
    private final List<String> m_busyStates = new ArrayList<String>(4);
    private boolean m_busyCursorOn = false;
    private boolean m_isReadOnly = true;
    float m_zoomRatio = 1.0f;

    public static boolean isEnabled(Level level) {
        return LOGGER.isLoggable(level);
    }

    public static void log(Level level, String string, Throwable throwable) {
        LOGGER.log(level, SceneManager.decorate(level, string), throwable);
    }

    public static void log(Level level, String string) {
        LOGGER.log(level, SceneManager.decorate(level, string));
    }

    public static void error(String string, Throwable throwable) {
        SceneManager.log(Level.SEVERE, string, throwable);
        NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception(throwable);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
    }

    private static String decorate(Level level, String string) {
        if (LOGGER.isLoggable(level) && (LOG_THREAD || LOG_TIME)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (LOG_TIME) {
                stringBuilder.append(System.currentTimeMillis());
                stringBuilder.append(' ');
            }
            if (LOG_THREAD) {
                stringBuilder.append('[');
                stringBuilder.append(Thread.currentThread().toString());
                stringBuilder.append("] ");
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        return string;
    }

    public static AWTEvent createEvent(Object object, int n) {
        return new AWTEvent(object, n){};
    }

    public SceneManager() {
        this.m_activeActions = new Stack();
    }

    public void initialize(SVGDataObject sVGDataObject) {
        assert (this.m_dObj == null) : "Scene manager cannot be initialized twice";
        this.m_dObj = sVGDataObject;
        this.m_instanceID = s_instanceCounter++;
        this.m_lookupContent = new InstanceContent();
        this.m_lookup = new AbstractLookup((AbstractLookup.Content)this.m_lookupContent);
        this.m_actionFactories = new ArrayList<ComposerActionFactory>();
        this.m_selectionListeners = new ArrayList<SelectionListener>();
        this.m_activeActions.clear();
        this.m_selectActionFactory = new SelectActionFactory(this);
        this.addSelectionListener(this.m_selectActionFactory);
        this.m_actionFactories.add(new HighlightActionFactory(this));
        this.m_actionFactories.add(this.m_selectActionFactory);
        this.m_actionFactories.add(new TranslateActionFactory(this));
        this.m_actionFactories.add(new SkewActionFactory(this));
        this.m_actionFactories.add(new ScaleActionFactory(this));
        this.m_actionFactories.add(new RotateActionFactory(this));
        this.m_actionFactories.add(new DeleteActionFactory(this));
        this.m_actionFactories.add(new MoveToTopActionFactory(this));
        this.m_actionFactories.add(new MoveToBottomActionFactory(this));
        this.m_actionFactories.add(new MoveForwardActionFactory(this));
        this.m_actionFactories.add(new MoveBackwardActionFactory(this));
        this.m_actionFactories.add(new CursorPositionActionFactory(this));
        this.m_actionFactories.add(new MoveFocusActionFactory(this));
        this.m_screenMgr = new ScreenManager(this);
        this.updateStatusBar();
        this.m_registeredActions = new ArrayList<Action>();
        for (ComposerActionFactory composerActionFactory : this.m_actionFactories) {
            Action[] actionArray = composerActionFactory.getMenuActions();
            if (actionArray == null) continue;
            for (Action action : actionArray) {
                this.m_registeredActions.add(action);
            }
        }
    }

    public String toString() {
        return "SceneManager-" + this.m_instanceID + "-" + (this.m_dObj != null ? this.m_dObj.getPrimaryFile().toString() : "null");
    }

    public synchronized void setImage(SVGImage sVGImage) {
        if (this.m_svgImage != null) {
            this.resetImage();
        }
        this.m_lookupContent.add((Object)sVGImage);
        this.m_svgImage = sVGImage;
        this.m_perseusController = new PerseusController(this);
        this.m_inputControlMgr = new InputControlManager(this);
        this.m_perseusController.initialize();
        this.m_screenMgr.initialize();
        this.m_inputControlMgr.initialize();
        this.m_screenMgr.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetImage() {
        if (this.m_svgImage != null) {
            this.m_lookupContent.remove((Object)this.m_svgImage);
            this.m_svgImage = null;
        }
        this.m_popupElement = null;
        this.m_perseusController = null;
        this.m_screenMgr.reset();
        this.m_inputControlMgr = null;
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            this.m_activeActions.clear();
        }
    }

    public synchronized boolean isImageLoaded() {
        return this.m_svgImage != null;
    }

    public void saveSelection() {
        if (this.m_selectedId == null) {
            SVGObject[] sVGObjectArray = this.getSelected();
            if (sVGObjectArray != null && sVGObjectArray.length > 0 && sVGObjectArray[0] != null) {
                SVGLocatableElement sVGLocatableElement = sVGObjectArray[0].getSVGElement();
                this.m_selectedId = sVGLocatableElement.getId();
                this.m_selectedTag = sVGLocatableElement.getLocalName();
            } else {
                this.m_selectedId = null;
                this.m_selectedTag = null;
            }
        }
    }

    public void restoreSelection() {
        if (this.m_selectedId != null) {
            SVGObject sVGObject = this.m_perseusController.getObjectById(this.m_selectedId);
            if (sVGObject != null && (this.m_selectedTag == null || this.m_selectedTag.equals(sVGObject.getSVGElement().getLocalName()))) {
                this.setSelection(this.m_selectedId, false);
            }
            this.m_selectedId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusyState(String string, boolean bl) {
        List<String> list = this.m_busyStates;
        synchronized (list) {
            boolean bl2;
            if (this.m_busyStates.contains(string)) {
                if (!bl) {
                    this.m_busyStates.remove(string);
                }
            } else if (bl) {
                this.m_busyStates.add(string);
            }
            boolean bl3 = bl2 = !this.m_busyStates.isEmpty();
            if (this.m_busyCursorOn != bl2) {
                JComponent jComponent;
                if (this.m_screenMgr != null && (jComponent = this.m_screenMgr.getComponent()) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Cursor cursor = bl2 ? Utilities.createProgressCursor((Component)jComponent) : null;
                            jComponent.setCursor(cursor);
                        }
                    });
                }
                this.m_busyCursorOn = bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        List<String> list = this.m_busyStates;
        synchronized (list) {
            return !this.m_busyStates.isEmpty();
        }
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.m_isReadOnly);
        objectOutputStream.writeFloat(this.m_zoomRatio);
    }

    public void deserialize(ObjectInputStream objectInputStream) throws IOException {
        this.m_isReadOnly = objectInputStream.readBoolean();
        this.m_zoomRatio = objectInputStream.readFloat();
    }

    Action getAction(String string) {
        for (Action action : this.m_registeredActions) {
            String string2 = action instanceof AbstractSVGAction ? ((AbstractSVGAction)action).getActionID() : action.getClass().getName();
            if (string2 == null || !string2.equals(string)) continue;
            return action;
        }
        SceneManager.log(Level.SEVERE, "Unknown action id " + string);
        return null;
    }

    public void registerPopupActions(Action[] lookup, TopComponent topComponent, Lookup lookup2) {
        for (Action action : lookup) {
            this.m_registeredActions.add(action);
        }
        Lookup lookup3 = Lookups.forPath((String)"Editors/text/svg+xml/Popup");
        Collection collection = lookup3.lookupAll(ActionWrapperFactory.class);
        Action[] actionArray = new Action[collection.size()];
        int n = 0;
        for (ActionWrapperFactory actionWrapperFactory : collection) {
            ActionWrapper actionWrapper = actionWrapperFactory.createWrapper(this);
            if (actionWrapper == null) continue;
            Action action = actionWrapper.getAction();
            actionArray[n++] = action;
            if (!(action instanceof AbstractSVGAction)) continue;
            ((AbstractSVGAction)action).registerAction(topComponent);
        }
        this.m_screenMgr.registerPopupMenu(actionArray, lookup2);
    }

    public Action[] getToolbarActions(String ... stringArray) {
        Action[] actionArray = new Action[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            actionArray[i] = this.getAction(stringArray[i]);
        }
        return actionArray;
    }

    public void updateActionState() {
        for (ComposerActionFactory composerActionFactory : this.m_actionFactories) {
            composerActionFactory.updateActionState();
        }
    }

    public SVGDataObject getDataObject() {
        return this.m_dObj;
    }

    public Lookup getLoookup() {
        return this.m_lookup;
    }

    public PerseusController getPerseusController() {
        return this.m_perseusController;
    }

    public ScreenManager getScreenManager() {
        return this.m_screenMgr;
    }

    public SVGImage getSVGImage() {
        return this.m_svgImage;
    }

    public JComponent getComposerGUI() {
        return this.m_screenMgr.getComponent();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.m_selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.m_selectionListeners.remove(selectionListener);
    }

    public float getAnimationDuration() {
        return this.m_animationDuration;
    }

    public void updateAnimationDuration(float f) {
        if (f > this.m_animationDuration) {
            this.m_animationDuration = f;
        }
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        if (this.m_isReadOnly != bl) {
            this.m_isReadOnly = bl;
            this.updateStatusBar();
            if (!this.m_isReadOnly) {
                this.m_perseusController.stopAnimator();
            }
            SVGObject[] sVGObjectArray = this.getSelected();
            this.notifySelectionChanged(sVGObjectArray, sVGObjectArray);
            this.m_screenMgr.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(String string, boolean bl) {
        if (bl) {
            this.m_selectedId = string;
        } else {
            Object object;
            SVGObject[] sVGObjectArray = this.getSelected();
            SelectAction selectAction = this.m_selectActionFactory.getActiveAction();
            if (selectAction != null) {
                selectAction.actionCompleted();
            }
            if (string != null) {
                object = this.m_perseusController.getObjectById(string);
                if (object != null) {
                    Object object2 = this.m_activeActions;
                    synchronized (object2) {
                        this.m_activeActions.push(this.m_selectActionFactory.startAction((SVGObject)object));
                    }
                    object2 = this.m_selectActionFactory.getMouseCursor(null, false);
                    this.m_screenMgr.setCursor(object2 != null ? ((ActionMouseCursor)object2).getCursor() : null);
                } else {
                    return;
                }
            }
            if (!SVGObject.areSame(object = this.getSelected(), sVGObjectArray)) {
                this.selectionChanged((SVGObject[])object, sVGObjectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAction(ComposerAction composerAction) {
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            this.m_activeActions.add(composerAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        if (SceneManager.isEnabled(Level.FINEST)) {
            SceneManager.log(Level.FINEST, "Processing event: " + aWTEvent);
        }
        if (!this.isBusy()) {
            ActionMouseCursor actionMouseCursor;
            Object object;
            int n;
            boolean bl = aWTEvent.getSource() != this.m_screenMgr.getAnimatorView();
            SVGObject[] sVGObjectArray = this.getSelected();
            boolean bl2 = false;
            ActionMouseCursor actionMouseCursor2 = null;
            Object object2 = this.m_activeActions;
            synchronized (object2) {
                for (n = this.m_activeActions.size() - 1; n >= 0; --n) {
                    object = (ComposerAction)this.m_activeActions.get(n);
                    actionMouseCursor = object.getMouseCursor(bl);
                    if (actionMouseCursor2 == null && actionMouseCursor != null) {
                        actionMouseCursor2 = actionMouseCursor;
                    }
                    if (object.consumeEvent(aWTEvent, bl)) {
                        bl2 = true;
                        break;
                    }
                    if (!object.isCompleted()) continue;
                    this.m_activeActions.remove(n);
                }
            }
            object2 = null;
            if (!bl2) {
                for (n = this.m_actionFactories.size() - 1; n >= 0; --n) {
                    object2 = this.m_actionFactories.get(n).startAction(aWTEvent, bl);
                    if (object2 == null) continue;
                    object = this.m_activeActions;
                    synchronized (object) {
                        this.m_activeActions.push((ComposerAction)object2);
                        break;
                    }
                }
            }
            if (aWTEvent instanceof MouseEvent && actionMouseCursor2 == null) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                for (int i = this.m_actionFactories.size() - 1; i >= 0; --i) {
                    actionMouseCursor = this.m_actionFactories.get(i).getMouseCursor(mouseEvent, bl);
                    if (actionMouseCursor == null || actionMouseCursor2 != null && actionMouseCursor2.getPriority() >= actionMouseCursor.getPriority()) continue;
                    actionMouseCursor2 = actionMouseCursor;
                }
            }
            this.m_screenMgr.setCursor(actionMouseCursor2 != null ? actionMouseCursor2.getCursor() : null);
            SVGObject[] sVGObjectArray2 = this.getSelected();
            if (!SVGObject.areSame(sVGObjectArray2, sVGObjectArray)) {
                this.selectionChanged(sVGObjectArray2, sVGObjectArray);
            }
        }
    }

    public SVGObject[] getSelected() {
        SVGObject sVGObject = null;
        SelectAction selectAction = this.m_selectActionFactory.getActiveAction();
        if (selectAction != null) {
            sVGObject = selectAction.getSelected();
        }
        if (sVGObject != null) {
            return new SVGObject[]{sVGObject};
        }
        return null;
    }

    public Stack<ComposerAction> getActiveActions() {
        return this.m_activeActions;
    }

    public boolean containsAction(Class clazz) {
        return this.findAction(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComposerAction findAction(Class clazz) {
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            for (int i = this.m_activeActions.size() - 1; i >= 0; --i) {
                ComposerAction composerAction = (ComposerAction)this.m_activeActions.get(i);
                if (!clazz.isInstance(composerAction)) continue;
                return composerAction;
            }
            return null;
        }
    }

    public void deleteObject(SVGObject sVGObject) {
        SVGObject[] sVGObjectArray = this.getSelected();
        sVGObject.delete();
        SVGObject[] sVGObjectArray2 = this.getSelected();
        if (!SVGObject.areSame(sVGObjectArray2, sVGObjectArray)) {
            this.selectionChanged(sVGObjectArray2, sVGObjectArray);
        }
    }

    void popupAt(int n, int n2) {
        SVGLocatableElement sVGLocatableElement = this.m_perseusController.findElementAt(n, n2);
        if (this.m_popupElement != null) {
            this.m_lookupContent.remove((Object)this.m_popupElement);
        }
        this.m_popupElement = sVGLocatableElement;
        if (this.m_popupElement != null) {
            this.m_lookupContent.add((Object)this.m_popupElement);
        }
        this.m_screenMgr.repaint();
    }

    protected void selectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2) {
        int n;
        if (sVGObjectArray2 != null) {
            for (n = 0; n < sVGObjectArray2.length; ++n) {
                this.m_lookupContent.remove((Object)sVGObjectArray2[n]);
            }
        }
        if (sVGObjectArray != null && sVGObjectArray.length > 0) {
            for (n = 0; n < sVGObjectArray.length; ++n) {
                this.m_lookupContent.add((Object)sVGObjectArray[n]);
            }
        }
        this.notifySelectionChanged(sVGObjectArray, sVGObjectArray2);
    }

    protected void notifySelectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2) {
        for (SelectionListener selectionListener : this.m_selectionListeners) {
            selectionListener.selectionChanged(sVGObjectArray, sVGObjectArray2, this.m_isReadOnly);
        }
    }

    private void updateStatusBar() {
        this.m_screenMgr.getStatusBar().setText(1, this.m_isReadOnly ? SVGStatusBar.LOCKED : SVGStatusBar.UNLOCKED);
    }

    static {
        s_instanceCounter = 0;
        LOGGER = Logger.getLogger(LOGGER_NAME);
        if (LOGGER.getLevel() == null) {
            LOGGER.setLevel(Level.WARNING);
        }
        Logger.getLogger("global").log(Level.INFO, "mobility.svg.level=" + LOGGER.getLevel());
        String string = "mobility.svg.logTime";
        LOG_TIME = Boolean.valueOf(System.getProperty(string));
        LOGGER.info(string + '=' + LOG_TIME);
        string = "mobility.svg.logThread";
        LOG_THREAD = Boolean.valueOf(System.getProperty(string));
        LOGGER.info(string + '=' + LOG_THREAD);
    }

    public static interface SelectionListener {
        public void selectionChanged(SVGObject[] var1, SVGObject[] var2, boolean var3);
    }
}

