/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Transform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.modules.mobility.svgcore.composer.GraphicUtils;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.w3c.dom.svg.SVGRect;

public final class SVGObjectOutline {
    private static final int ROUND_CORNER_SIZE = 3;
    private static final int DIAMOND_CORNER_SIZE = 3;
    public static final int SELECTOR_OVERLAP = 5;
    private static final float HANDLE_DIST = 30.0f;
    public static final Color SELECTOR_BODY = Color.RED;
    private static final Color SELECTOR_OUTLINE = Color.WHITE;
    private static final Color COLOR_HIGHLIGHT = new Color(0, 0, 0, 64);
    private static final int ROTATE_CORNER_INDEX = 1;
    private static final int SKEW_CORNER_INDEX = 3;
    private final SVGObject m_svgObject;
    private final float[][] m_coords = new float[4][2];
    private short m_tickerCopy;

    public SVGObjectOutline(SVGObject sVGObject) {
        assert (sVGObject != null) : "The SVGObject reference cannot be null";
        this.m_svgObject = sVGObject;
        this.setDirty();
    }

    public float[][] getCoords() {
        this.checkObject();
        return this.m_coords;
    }

    public void setDirty() {
        this.m_tickerCopy = (short)-1;
    }

    public static void drawOutline(Graphics graphics, int n, int n2, float[][] fArray) {
        for (int i = 0; i < 4; ++i) {
            int n3 = (i + 1) % 4;
            graphics.drawLine(Math.round(fArray[i][0]) + n, Math.round(fArray[i][1]) + n2, Math.round(fArray[n3][0]) + n, Math.round(fArray[n3][1]) + n2);
        }
    }

    public void draw(Graphics graphics, int n, int n2, Color color, boolean bl) {
        this.checkObject();
        graphics.setColor(color);
        SVGObjectOutline.drawOutline(graphics, n, n2, this.m_coords);
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                if (i == 1) {
                    GraphicUtils.drawRoundSelectorCorner(graphics, SELECTOR_OUTLINE, SELECTOR_BODY, (int)this.m_coords[i][0] + n, (int)this.m_coords[i][1] + n2, 3);
                    continue;
                }
                if (i == 3) {
                    GraphicUtils.drawDiamondSelectorCorner(graphics, SELECTOR_OUTLINE, SELECTOR_BODY, (int)this.m_coords[i][0] + n, (int)this.m_coords[i][1] + n2, 3);
                    continue;
                }
                SVGObjectOutline.drawRectSelectorCorner(graphics, (int)this.m_coords[i][0] + n, (int)this.m_coords[i][1] + n2);
            }
        }
    }

    public void highlight(Graphics graphics, int n, int n2, Color color) {
        this.checkObject();
        graphics.setColor(color);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Math.round((float)n + this.m_coords[i][0]);
            nArray2[i] = Math.round((float)n2 + this.m_coords[i][1]);
        }
        graphics.fillPolygon(nArray, nArray2, 4);
    }

    public void highlight(Graphics graphics, int n, int n2) {
        this.highlight(graphics, n, n2, COLOR_HIGHLIGHT);
    }

    public static Rectangle getShapeBoundingBox(float[][] fArray) {
        float f;
        float f2;
        float f3 = f2 = fArray[0][0];
        float f4 = f = fArray[0][1];
        for (int i = 1; i < fArray.length; ++i) {
            float f5 = fArray[i][0];
            float f6 = fArray[i][1];
            if (f5 < f3) {
                f3 = f5;
            } else if (f5 > f2) {
                f2 = f5;
            }
            if (f6 < f4) {
                f4 = f6;
                continue;
            }
            if (!(f6 > f)) continue;
            f = f6;
        }
        return new Rectangle(Math.round(f3), Math.round(f4), Math.round(f2 - f3), Math.round(f - f4));
    }

    public Rectangle getScreenBoundingBox() {
        this.checkObject();
        return SVGObjectOutline.getShapeBoundingBox(this.m_coords);
    }

    public float[] getRotatePivotPoint() {
        return this.getCenter();
    }

    public float[] getScalePivotPoint() {
        return this.getCenter();
    }

    public float[] getCenter() {
        this.checkObject();
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.m_coords.length; ++i) {
            f += this.m_coords[i][0];
            f2 += this.m_coords[i][1];
        }
        return new float[]{f / 4.0f, f2 / 4.0f};
    }

    public boolean isAtRotateHandlePoint(float f, float f2) {
        this.checkObject();
        float[] fArray = this.m_coords[1];
        return GraphicUtils.areNear(f, f2, fArray[0], fArray[1], 30.0f);
    }

    public boolean isAtScaleHandlePoint(float f, float f2) {
        this.checkObject();
        for (int i = 0; i < 4; ++i) {
            if (i == 1 || i == 3 || !GraphicUtils.areNear(f, f2, this.m_coords[i][0], this.m_coords[i][1], 30.0f)) continue;
            return true;
        }
        return false;
    }

    public boolean isAtSkewHandlePoint(float f, float f2) {
        this.checkObject();
        float[] fArray = this.m_coords[3];
        return GraphicUtils.areNear(f, f2, fArray[0], fArray[1], 30.0f);
    }

    private static void drawRectSelectorCorner(Graphics graphics, int n, int n2) {
        graphics.setColor(SELECTOR_BODY);
        graphics.fillRect(n - 2, n2 - 2, 5, 5);
        graphics.setColor(SELECTOR_OUTLINE);
        graphics.drawRect(n - 3, n2 - 3, 6, 6);
    }

    private synchronized void checkObject() {
        assert (this.m_svgObject != null) : "SVGObject reference cannot be null";
        short s = this.m_svgObject.getScreenManager().getChangeTicker();
        if (s != this.m_tickerCopy) {
            SVGObjectOutline.transformRectangle(this.m_svgObject.getSafeBBox(), (Transform)this.m_svgObject.getSVGElement().getScreenCTM(), this.m_coords);
            this.m_tickerCopy = s;
        }
    }

    public static float[][] transformRectangle(SVGRect sVGRect, Transform transform, float[][] fArray) {
        float f = sVGRect.getX();
        float f2 = sVGRect.getY();
        float f3 = sVGRect.getWidth();
        float f4 = sVGRect.getHeight();
        float[][] fArrayArray = new float[][]{{f, f2}, {f + f3, f2}, {f + f3, f2 + f4}, {f, f2 + f4}};
        assert (fArray.length == 4);
        for (int i = 0; i < 4; ++i) {
            transform.transformPoint(fArrayArray[i], fArray[i]);
        }
        return fArray;
    }
}

