/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.DbActionLoaderSupport;
import org.netbeans.modules.db.explorer.DbNodeLoader;
import org.netbeans.modules.db.explorer.DbNodeLoaderSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.RegisteredNodeInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNodeInfo
extends DatabaseNodeInfo
implements ConnectionOwnerOperations,
ChangeListener {
    static final long serialVersionUID = -8079386805046070315L;
    static RootNodeInfo rootInfo = null;
    private static DatabaseOption option = null;
    private Collection<DbNodeLoader> nodeLoaders;
    private static Logger LOGGER = Logger.getLogger(RootNodeInfo.class.getName());

    public static RootNodeInfo getInstance() throws DatabaseException {
        if (rootInfo == null) {
            rootInfo = (RootNodeInfo)DatabaseNodeInfo.createNodeInfo(null, "root");
        }
        return rootInfo;
    }

    public RootNodeInfo() {
        try {
            SpecificationFactory specificationFactory = new SpecificationFactory();
            if (specificationFactory == null) {
                throw new Exception(RootNodeInfo.bundle().getString("EXC_NoSpecificationFactory"));
            }
            this.setSpecificationFactory(new SpecificationFactory());
            ConnectionList.getDefault().addConnectionListener(new ConnectionListener(){

                public void connectionsChanged() {
                    RootNodeInfo.this.stateChanged(new ChangeEvent(this));
                }
            });
            this.initDebugListening();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void initDebugListening() {
        final DatabaseSpecificationFactory databaseSpecificationFactory = this.getSpecificationFactory();
        if (option == null || databaseSpecificationFactory == null) {
            return;
        }
        option.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null) {
                    databaseSpecificationFactory.setDebugMode(option.getDebugMode());
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("debugMode")) {
                    databaseSpecificationFactory.setDebugMode((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        databaseSpecificationFactory.setDebugMode(option.getDebugMode());
    }

    public static synchronized DatabaseOption getOption() {
        if (option == null) {
            option = (DatabaseOption)SystemOption.findObject(DatabaseOption.class, (boolean)true);
        }
        return option;
    }

    @Override
    public void initChildren(Vector vector) throws DatabaseException {
        try {
            FileObject fileObject;
            DataFolder dataFolder;
            ConnectionNodeInfo connectionNodeInfo;
            DatabaseConnection databaseConnection;
            vector.addAll(this.getRegisteredNodeInfos());
            DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                databaseConnection = databaseConnectionArray[i];
                connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
                vector.add(connectionNodeInfo);
            }
            Repository repository = Repository.getDefault();
            databaseConnection = repository.getDefaultFileSystem();
            connectionNodeInfo = databaseConnection.getRoot();
            FileObject fileObject2 = connectionNodeInfo.getFileObject("Database");
            if (fileObject2 != null && (dataFolder = DataFolder.findFolder((FileObject)(fileObject = fileObject2.getFileObject("Adaptors")))) != null) {
                vector.add(dataFolder.getNodeDelegate());
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    private List<RegisteredNodeInfo> getRegisteredNodeInfos() {
        boolean bl = false;
        if (this.nodeLoaders == null) {
            this.nodeLoaders = DbNodeLoaderSupport.getLoaders();
            bl = true;
        }
        ArrayList<RegisteredNodeInfo> arrayList = new ArrayList<RegisteredNodeInfo>();
        for (DbNodeLoader dbNodeLoader : this.nodeLoaders) {
            if (bl) {
                dbNodeLoader.addChangeListener(this);
            }
            for (Node node : dbNodeLoader.getAllNodes()) {
                arrayList.add(new RegisteredNodeInfo((DatabaseNodeInfo)this, node));
            }
        }
        return arrayList;
    }

    @Override
    public Vector getActions() {
        Vector vector = super.getActions();
        List<Action> list = DbActionLoaderSupport.getAllActions();
        Vector<Action> vector2 = new Vector<Action>();
        for (Action action : vector) {
            if (action == null) {
                vector2.addAll(list);
            }
            vector2.add(action);
        }
        return vector2;
    }

    private ConnectionNodeInfo createConnectionNodeInfo(DatabaseConnection databaseConnection) throws DatabaseException {
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)RootNodeInfo.createNodeInfo(this, "connection");
        connectionNodeInfo.setUser(databaseConnection.getUser());
        connectionNodeInfo.setDatabase(databaseConnection.getDatabase());
        connectionNodeInfo.setSchema(databaseConnection.getSchema());
        connectionNodeInfo.setName(databaseConnection.getName());
        connectionNodeInfo.setDatabaseConnection(databaseConnection);
        return connectionNodeInfo;
    }

    public void addConnectionNoConnect(DatabaseConnection databaseConnection) throws DatabaseException {
        if (ConnectionList.getDefault().contains(databaseConnection)) {
            return;
        }
        ConnectionNodeInfo connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
        ConnectionList.getDefault().add(databaseConnection);
        this.notifyChange();
    }

    public void removeConnection(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        Vector vector = this.getChildren();
        ConnectionNodeInfo connectionNodeInfo = null;
        for (DatabaseNodeInfo databaseNodeInfo : vector) {
            if (!(databaseNodeInfo instanceof ConnectionNodeInfo)) continue;
            ConnectionNodeInfo connectionNodeInfo2 = (ConnectionNodeInfo)databaseNodeInfo;
            if (connectionNodeInfo2.getDatabaseConnection().equals(databaseConnection)) {
                connectionNodeInfo = connectionNodeInfo2;
            }
            databaseConnection.disconnect();
        }
        if (connectionNodeInfo != null) {
            this.removeChild(connectionNodeInfo, false);
        }
        ConnectionList.getDefault().remove(databaseConnection);
        this.notifyChange();
    }

    @Override
    public void addConnection(DBConnection dBConnection) throws DatabaseException {
        DatabaseConnection databaseConnection = (DatabaseConnection)dBConnection;
        this.getChildren();
        if (ConnectionList.getDefault().contains(databaseConnection)) {
            throw new DatabaseException(RootNodeInfo.bundle().getString("EXC_ConnectionAlreadyExists"));
        }
        ConnectionNodeInfo connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
        this.addChild(connectionNodeInfo);
        ConnectionList.getDefault().add(databaseConnection);
        if (databaseConnection.getConnection() == null) {
            connectionNodeInfo.connect();
        } else {
            connectionNodeInfo.connect(databaseConnection);
        }
        this.notifyChange();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.refreshChildren();
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
    }

    @Override
    public void refreshChildren() throws DatabaseException {
        super.refreshChildren();
        this.addChild(RootNodeInfo.createNodeInfo(this, "driverlist"));
    }

    @Override
    public String getDisplayName() {
        return RootNodeInfo.bundle().getString("NDN_Databases");
    }

    @Override
    public String getShortDescription() {
        return RootNodeInfo.bundle().getString("ND_Root");
    }
}

