/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;

public class DriverNodeInfo
extends DatabaseNodeInfo
implements PropertyChangeListener {
    static final long serialVersionUID = 6994829681095273161L;

    public DriverNodeInfo() {
        DatabaseDriver databaseDriver = (DatabaseDriver)this.get("dbdriver");
        if (databaseDriver != null) {
            this.setDatabaseDriver(databaseDriver);
        }
        this.addDriverListener(this);
    }

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get("dbdriver");
    }

    public void setDatabaseDriver(DatabaseDriver databaseDriver) {
        this.put("name", (Object)databaseDriver.getName());
        this.put("url", (Object)databaseDriver.getURL());
        this.put("prefix", (Object)databaseDriver.getDatabasePrefix());
        this.put("dbdriver", (Object)databaseDriver);
        this.notifyChange();
    }

    public void delete() throws IOException {
        try {
            JDBCDriver jDBCDriver = this.getJDBCDriver();
            if (jDBCDriver != null) {
                JDBCDriverManager.getDefault().removeDriver(jDBCDriver);
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(DriverNodeInfo.class.getName()).log(Level.INFO, null, databaseException);
        }
    }

    public String getIconBase() {
        return (String)(this.checkDriverFiles() ? this.get("iconbaseprefered") : this.get("iconbasepreferednotinstalled"));
    }

    public void setIconBase(String string) {
        if (this.checkDriverFiles()) {
            this.put("iconbaseprefered", (Object)string);
        } else {
            this.put("iconbasepreferednotinstalled", (Object)string);
        }
        this.notifyChange();
    }

    private boolean checkDriverFiles() {
        JDBCDriver jDBCDriver = this.getJDBCDriver();
        if (jDBCDriver != null) {
            return JDBCDriverSupport.isAvailable(jDBCDriver);
        }
        return false;
    }

    public JDBCDriver getJDBCDriver() {
        DatabaseDriver databaseDriver = this.getDatabaseDriver();
        if (databaseDriver == null) {
            return null;
        }
        return databaseDriver.getJDBCDriver();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        DatabaseDriver databaseDriver = this.getDatabaseDriver();
        if (databaseDriver != null) {
            if (string.equals("name")) {
                databaseDriver.setName((String)object);
            } else if (string.equals("url")) {
                databaseDriver.setURL((String)object);
            } else if (string.equals("prefix")) {
                databaseDriver.setDatabasePrefix((String)object);
            }
        }
        this.notifyChange();
    }

    public String getShortDescription() {
        return DriverNodeInfo.bundle().getString("ND_Driver");
    }

    public String getDisplayName() {
        return this.getJDBCDriver().getDisplayName();
    }
}

