/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.platform.JavaPlatformManager;
import org.netbeans.modules.gsfpath.api.queries.SourceLevelQuery;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ModificationResult;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.StringSourceFileReader;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.napi.gsfret.source.WorkingCopy;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source {
    private static final int INVALID = 1;
    private static final int CHANGE_EXPECTED = 2;
    private static final int RESCHEDULE_FINISHED_TASKS = 4;
    private static final int UPDATE_INDEX = 8;
    private static final boolean reportSlowTasks = Boolean.getBoolean("org.netbeans.napi.gsfret.source.Source.reportSlowTasks");
    private static final int SLOW_TASK_LIMIT = 250;
    private static final int SLOW_CANCEL_LIMIT = 50;
    static int REPARSE_DELAY = 500;
    private static Map<Phase, String> phase2Key = new HashMap<Phase, String>();
    private static Map<Phase, String> phase2Message = new HashMap<Phase, String>();
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<Source, Collection<Request>> finishedRequests;
    private static final Map<Source, Collection<Request>> waitingRequests;
    private static final Collection<CancellableTask> toRemove;
    private static final SingleThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final EditorRegistryListener editorRegistryListener;
    private static final ReentrantLock javacLock;
    private final Collection<FileObject> files;
    private final FileObject rootFo;
    private final FileChangeListener fileChangeListener;
    private DocListener listener;
    private DataObjectListener dataObjectListener;
    private String sourceLevel;
    private final ClasspathInfo classpathInfo;
    private CompilationInfo currentInfo;
    private Stack<CompilationInfo> infoStack = new Stack();
    private int flags = 0;
    private Object filterListener;
    private static Map<FileObject, Reference<Source>> file2JavaSource;
    private final RequestProcessor.Task resetTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            Source.this.resetStateImpl();
        }
    });
    private static final int MAX_DUMPS = 255;

    public static Source create(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IllegalArgumentException {
        if (collection == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new Source(classpathInfo, collection);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)dataObjectNotFoundException.getFileObject()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static Source create(ClasspathInfo classpathInfo, FileObject ... fileObjectArray) throws IllegalArgumentException {
        if (fileObjectArray == null || classpathInfo == null) {
            throw new IllegalArgumentException();
        }
        return Source.create(classpathInfo, Arrays.asList(fileObjectArray));
    }

    public static void clearSourceCache() {
        file2JavaSource.clear();
    }

    public static Source forFileObject(FileObject fileObject) throws IllegalArgumentException {
        Source source;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        if (!LanguageRegistry.getInstance().isSupported(fileObject.getMIMEType())) {
            return null;
        }
        Reference<Source> reference = file2JavaSource.get(fileObject);
        Source source2 = source = reference != null ? reference.get() : null;
        if (source == null) {
            source = Source.create(ClasspathInfo.create(fileObject), fileObject);
            file2JavaSource.put(fileObject, new WeakReference<Source>(source));
        }
        return source;
    }

    public static Source forDocument(Document document) throws IllegalArgumentException {
        DataObject dataObject;
        Source source;
        if (document == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference reference = (Reference)document.getProperty(Source.class);
        Source source2 = source = reference != null ? (Source)reference.get() : null;
        if (source == null && (dataObject = (DataObject)document.getProperty("stream")) != null) {
            source = Source.forFileObject(dataObject.getPrimaryFile());
        }
        return source;
    }

    private Source(ClasspathInfo classpathInfo, Collection<? extends FileObject> collection) throws IOException {
        this.files = Collections.unmodifiableList(new ArrayList<FileObject>(collection));
        this.fileChangeListener = new FileChangeListenerImpl();
        boolean bl = this.files.size() > 1;
        boolean bl2 = false;
        Iterator<FileObject> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = iterator.next();
            try {
                if (bl) continue;
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fileObject));
                this.assignDocumentListener(fileObject);
                this.dataObjectListener = new DataObjectListener(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if (bl) {
                    Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    iterator.remove();
                    continue;
                }
                throw dataObjectNotFoundException;
            }
        }
        this.classpathInfo = classpathInfo;
        this.rootFo = collection.size() == 1 ? this.classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(collection.iterator().next()) : null;
        this.classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.classpathInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUserActionTask(CancellableTask<CompilationController> cancellableTask, boolean bl) throws IOException {
        block47: {
            if (cancellableTask == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            assert (javacLock.isHeldByCurrentThread() || !Source.holdsDocumentWriteLock(this.files)) : "Source.runCompileControlTask called under Document write lock.";
            if (this.files.size() <= 1) {
                Request request = currentRequest.getTaskToCancel();
                try {
                    if (request != null) {
                        request.task.cancel();
                    }
                    javacLock.lock();
                    try {
                        CompilationInfo compilationInfo = null;
                        Source source = this;
                        synchronized (source) {
                            if (this.currentInfo != null && (this.flags & 1) == 0) {
                                compilationInfo = this.currentInfo;
                            }
                            if (!bl) {
                                this.flags |= 1;
                            }
                        }
                        if (compilationInfo == null) {
                            compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                            if (bl) {
                                source = this;
                                synchronized (source) {
                                    if (this.currentInfo == null || (this.flags & 1) != 0) {
                                        this.currentInfo = compilationInfo;
                                        this.flags &= 0xFFFFFFFE;
                                    } else {
                                        compilationInfo = this.currentInfo;
                                    }
                                }
                            }
                        }
                        assert (compilationInfo != null);
                        if (bl) {
                            if (!this.infoStack.isEmpty()) {
                                compilationInfo = this.infoStack.peek();
                            }
                        } else {
                            this.infoStack.push(compilationInfo);
                        }
                        try {
                            cancellableTask.run((Object)new CompilationController(compilationInfo));
                            break block47;
                        }
                        finally {
                            if (!bl) {
                                this.infoStack.pop();
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        iOException.initCause(exception);
                        throw iOException;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted(request);
                }
            }
            Request request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    ParserTaskImpl parserTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl2;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl2 = false;
                        } else {
                            bl2 = true;
                        }
                        CompilationInfo compilationInfo = Source.createCurrentInfo(this, fileObject, this.filterListener, parserTaskImpl);
                        cancellableTask.run((Object)new CompilationController(compilationInfo));
                        if (!compilationInfo.needsRestart) {
                            parserTaskImpl = compilationInfo.getParserTask();
                            fileObject = null;
                            continue;
                        }
                        parserTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl2) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ModificationResult runModificationTask(CancellableTask<WorkingCopy> cancellableTask) throws IOException {
        Object object;
        ModificationResult modificationResult;
        block40: {
            if (cancellableTask == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            assert (javacLock.isHeldByCurrentThread() || !Source.holdsDocumentWriteLock(this.files)) : "Source.runCompileControlTask called under Document write lock.";
            modificationResult = new ModificationResult(this);
            if (this.files.size() <= 1) {
                object = currentRequest.getTaskToCancel();
                try {
                    if (object != null) {
                        ((Request)object).task.cancel();
                    }
                    javacLock.lock();
                    try {
                        CompilationInfo compilationInfo = null;
                        Object object2 = this;
                        // MONITORENTER : object2
                        if (this.currentInfo != null && (this.flags & 1) == 0) {
                            compilationInfo = this.currentInfo;
                        }
                        // MONITOREXIT : object2
                        if (compilationInfo == null) {
                            compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                            object2 = this;
                            // MONITORENTER : object2
                            if (this.currentInfo == null || (this.flags & 1) != 0) {
                                this.currentInfo = compilationInfo;
                                this.flags &= 0xFFFFFFFE;
                            } else {
                                compilationInfo = this.currentInfo;
                            }
                            // MONITOREXIT : object2
                        }
                        assert (compilationInfo != null);
                        object2 = new WorkingCopy(compilationInfo);
                        cancellableTask.run(object2);
                        List<ModificationResult.Difference> list = ((WorkingCopy)((Object)object2)).getChanges();
                        if (list != null && list.size() > 0) {
                            modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                        }
                        break block40;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        IOException iOException = new IOException();
                        iOException.initCause(exception);
                        throw iOException;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted((Request)object);
                }
            }
            object = currentRequest.getTaskToCancel();
            try {
                if (object != null) {
                    ((Request)object).task.cancel();
                }
                javacLock.lock();
                try {
                    ParserTaskImpl parserTaskImpl = null;
                    FileObject fileObject = null;
                    Iterator<FileObject> iterator = this.files.iterator();
                    while (iterator.hasNext() || fileObject != null) {
                        boolean bl;
                        if (fileObject == null) {
                            fileObject = iterator.next();
                            bl = false;
                        } else {
                            bl = true;
                        }
                        CompilationInfo compilationInfo = Source.createCurrentInfo(this, fileObject, this.filterListener, parserTaskImpl);
                        WorkingCopy workingCopy = new WorkingCopy(compilationInfo);
                        cancellableTask.run((Object)workingCopy);
                        if (!compilationInfo.needsRestart) {
                            parserTaskImpl = compilationInfo.getParserTask();
                            List<ModificationResult.Difference> list = workingCopy.getChanges();
                            if (list != null && list.size() > 0) {
                                modificationResult.diffs.put(compilationInfo.getFileObject(), list);
                            }
                            fileObject = null;
                            continue;
                        }
                        parserTaskImpl = null;
                        compilationInfo = null;
                        System.gc();
                        if (!bl) continue;
                        throw new InsufficientMemoryException(fileObject);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted((Request)object);
            }
        }
        object = this;
        // MONITORENTER : object
        this.flags |= 1;
        // MONITOREXIT : object
        return modificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask, Phase phase, Priority priority) throws IOException {
        CompilationInfo compilationInfo;
        if (cancellableTask == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (phase == null || phase == Phase.MODIFIED) {
            throw new IllegalArgumentException(String.format("The %s is not a legal value of phase", new Object[]{phase}));
        }
        if (priority == null) {
            throw new IllegalArgumentException("The priority cannot be null");
        }
        Source source = this;
        synchronized (source) {
            compilationInfo = this.currentInfo;
        }
        if (compilationInfo == null) {
            compilationInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
        }
        source = this;
        synchronized (source) {
            if (this.currentInfo == null) {
                this.currentInfo = compilationInfo;
            }
        }
        Source.handleAddRequest(new Request(cancellableTask, this, phase, priority, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseCompletionTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            toRemove.add(cancellableTask);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleTask(CancellableTask<CompilationInfo> cancellableTask) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            block8: {
                Request request = currentRequest.getTaskToCancel(cancellableTask);
                if (request == null) {
                    Iterator<Collection<Request>> iterator = finishedRequests.values().iterator();
                    while (iterator.hasNext()) {
                        Collection<Request> collection = iterator.next();
                        Iterator<Request> iterator2 = collection.iterator();
                        while (iterator2.hasNext()) {
                            Request request2 = iterator2.next();
                            if (cancellableTask != request2.task) continue;
                            iterator2.remove();
                            requests.add(request2);
                            if (collection.size() == 0) {
                                iterator.remove();
                            }
                            break block8;
                        }
                    }
                } else {
                    currentRequest.cancelCompleted(request);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void revalidate() {
        this.resetState(true, false);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    ParserTaskImpl createParserTask(CompilationInfo compilationInfo) {
        Language language = compilationInfo.getLanguage();
        assert (language != null);
        ParserTaskImpl parserTaskImpl = Source.createParserTask(language, compilationInfo, this.getClasspathInfo(), this.sourceLevel, false);
        return parserTaskImpl;
    }

    private static ParserTaskImpl createParserTask(Language language, CompilationInfo compilationInfo, ClasspathInfo classpathInfo, String string, boolean bl) {
        ParserTaskImpl parserTaskImpl = new ParserTaskImpl(language);
        return parserTaskImpl;
    }

    static Phase moveToPhase(Phase phase, CompilationInfo compilationInfo, boolean bl) throws IOException {
        Phase phase2 = compilationInfo.getPhase();
        boolean bl2 = compilationInfo.getSource().files.size() > 1;
        LowMemoryNotifier lowMemoryNotifier = null;
        LMListener lMListener = null;
        if (bl2) {
            lowMemoryNotifier = LowMemoryNotifier.getDefault();
            assert (lowMemoryNotifier != null);
            lMListener = new LMListener();
            lowMemoryNotifier.addLowMemoryListener(lMListener);
        }
        try {
            long l;
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase3 = phase2;
                return phase3;
            }
            if (phase2.compareTo(Phase.PARSED) < 0 && phase.compareTo(Phase.PARSED) >= 0) {
                FileObject fileObject;
                if (bl && currentRequest.isCanceled()) {
                    Phase phase4 = Phase.MODIFIED;
                    return phase4;
                }
                l = System.currentTimeMillis();
                ArrayList<DefaultParserFile> arrayList = new ArrayList<DefaultParserFile>(1);
                arrayList.add(new DefaultParserFile(compilationInfo.getFileObject(), null, false));
                FileObject fileObject2 = compilationInfo.getFileObject();
                final ParserResult[] parserResultArray = new ParserResult[1];
                ParseListener parseListener = new ParseListener(){
                    final List<org.netbeans.modules.gsf.api.Error> errors = new ArrayList<org.netbeans.modules.gsf.api.Error>();

                    public void started(ParseEvent parseEvent) {
                        this.errors.clear();
                    }

                    public void error(org.netbeans.modules.gsf.api.Error error) {
                        this.errors.add(error);
                    }

                    public void exception(Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }

                    public void finished(ParseEvent parseEvent) {
                        if (parseEvent.getKind() == ParseEvent.Kind.PARSE) {
                            ParserResult parserResult = parseEvent.getResult();
                            for (org.netbeans.modules.gsf.api.Error error : this.errors) {
                                parserResult.addError(error);
                            }
                            parserResultArray[0] = parserResult;
                        }
                    }
                };
                LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
                String string = compilationInfo.getFileObject().getMIMEType();
                List<Language> list = languageRegistry.getApplicableLanguages(string);
                for (Language language : list) {
                    Phase phase5;
                    Object object;
                    Object object2;
                    Object object3;
                    fileObject = languageRegistry.getEmbedding(language.getMimeType(), string);
                    assert (language != null);
                    Parser parser = language.getParser();
                    if (bl && currentRequest.isCanceled()) {
                        object3 = Phase.MODIFIED;
                        return object3;
                    }
                    if (parser == null) continue;
                    if (fileObject != null) {
                        try {
                            object3 = compilationInfo.getDocument();
                            if (object3 == null) {
                                UiUtils.getDocument(compilationInfo.getFileObject(), true);
                                object3 = compilationInfo.getDocument();
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                            object2 = null;
                            if (bl2) {
                                assert (lowMemoryNotifier != null);
                                assert (lMListener != null);
                                lowMemoryNotifier.removeLowMemoryListener(lMListener);
                            }
                            compilationInfo.setPhase(phase2);
                            return object2;
                        }
                        if (object3 == null) continue;
                        if (bl && currentRequest.isCanceled()) {
                            object = Phase.MODIFIED;
                            return object;
                        }
                        object = fileObject.translate((Document)object3);
                        if (bl && currentRequest.isCanceled()) {
                            object2 = Phase.MODIFIED;
                            return object2;
                        }
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            Phase phase6;
                            phase5 = (TranslatedSource)object2.next();
                            String string2 = phase5.getSource();
                            StringSourceFileReader stringSourceFileReader = new StringSourceFileReader(string2, fileObject2);
                            Parser.Job job = new Parser.Job(arrayList, parseListener, (SourceFileReader)stringSourceFileReader, (TranslatedSource)phase5);
                            parser.parseFiles(job);
                            if (bl && currentRequest.isCanceled()) {
                                phase6 = Phase.MODIFIED;
                                return phase6;
                            }
                            phase6 = parserResultArray[0];
                            phase6.setTranslatedSource((TranslatedSource)phase5);
                            assert (phase6 != null);
                            compilationInfo.addEmbeddingResult(language.getMimeType(), (ParserResult)phase6);
                        }
                        continue;
                    }
                    object3 = compilationInfo.getText();
                    object = new StringSourceFileReader((String)object3, fileObject2);
                    object2 = new Parser.Job(arrayList, parseListener, (SourceFileReader)object, null);
                    parser.parseFiles((Parser.Job)object2);
                    if (bl && currentRequest.isCanceled()) {
                        phase5 = Phase.MODIFIED;
                        return phase5;
                    }
                    phase5 = parserResultArray[0];
                    assert (phase5 != null);
                    compilationInfo.addEmbeddingResult(language.getMimeType(), (ParserResult)phase5);
                }
                phase2 = Phase.PARSED;
                long l2 = System.currentTimeMillis();
                fileObject = compilationInfo.getFileObject();
                Source.logTime(fileObject, phase2, l2 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase7 = phase2;
                return phase7;
            }
            if (phase2 == Phase.PARSED && phase.compareTo(Phase.ELEMENTS_RESOLVED) >= 0) {
                if (bl && currentRequest.isCanceled()) {
                    Phase phase8 = Phase.MODIFIED;
                    return phase8;
                }
                l = System.currentTimeMillis();
                phase2 = Phase.ELEMENTS_RESOLVED;
                long l3 = System.currentTimeMillis();
                Source.logTime(compilationInfo.getFileObject(), phase2, l3 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase9 = phase2;
                return phase9;
            }
            if (phase2 == Phase.ELEMENTS_RESOLVED && phase.compareTo(Phase.RESOLVED) >= 0) {
                if (bl && currentRequest.isCanceled()) {
                    Phase phase10 = Phase.MODIFIED;
                    return phase10;
                }
                l = System.currentTimeMillis();
                phase2 = Phase.RESOLVED;
                long l4 = System.currentTimeMillis();
                Source.logTime(compilationInfo.getFileObject(), phase2, l4 - l);
            }
            if (lMListener != null && lMListener.lowMemory.getAndSet(false)) {
                compilationInfo.needsRestart = true;
                Phase phase11 = phase2;
                return phase11;
            }
            if (phase2 == Phase.RESOLVED && phase.compareTo(Phase.UP_TO_DATE) >= 0) {
                phase2 = Phase.UP_TO_DATE;
            }
        }
        catch (RuntimeException runtimeException) {
            Source.dumpSource(compilationInfo, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            Source.dumpSource(compilationInfo, error);
            throw error;
        }
        finally {
            if (bl2) {
                assert (lowMemoryNotifier != null);
                assert (lMListener != null);
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
            compilationInfo.setPhase(phase2);
        }
        return phase2;
    }

    static void logTime(FileObject fileObject, Phase phase, long l) {
        assert (fileObject != null && phase != null);
        String string = phase2Key.get((Object)phase);
        String string2 = phase2Message.get((Object)phase);
        assert (string != null && string2 != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState(boolean bl, boolean bl2) {
        boolean bl3;
        Object object = this;
        synchronized (object) {
            bl3 = (this.flags & 1) != 0;
            this.flags |= 2;
            if (bl) {
                this.flags |= 5;
            }
            if (bl2) {
                this.flags |= 8;
            }
        }
        if (bl2 && !bl3) {
            this.updateIndex();
        }
        object = currentRequest.getTaskToCancel(this);
        try {
            if (object != null) {
                ((Request)object).task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted((Request)object);
        }
        this.resetTask.schedule(REPARSE_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStateImpl() {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            boolean bl;
            boolean bl2;
            Collection<Request> collection = this;
            synchronized (collection) {
                bl2 = (this.flags & 4) != 0;
                bl = (this.flags & 8) != 0;
                this.flags &= 0xFFFFFFF1;
            }
            if (bl) {
                this.updateIndex();
            }
            if (bl2 && (collection = finishedRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            if ((collection = waitingRequests.remove(this)) != null && collection.size() > 0) {
                requests.addAll(collection);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateIndex() {
        if (this.rootFo != null) {
            try {
                for (Language language : LanguageRegistry.getInstance()) {
                    ClassIndexImpl classIndexImpl;
                    if (language.getIndexer() == null || (classIndexImpl = ClassIndexManager.get(language).getUsagesQuery(this.rootFo.getURL())) == null) continue;
                    classIndexImpl.setDirty(this);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void testUpdateIndex() {
        this.updateIndex();
    }

    private void assignDocumentListener(FileObject fileObject) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
        if (observable != null) {
            this.listener = new DocListener(observable);
        } else {
            Logger.getLogger("global").log(Level.WARNING, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
    }

    private static CompilationInfo createCurrentInfo(Source source, FileObject fileObject, Object object, ParserTaskImpl parserTaskImpl) throws IOException {
        if (source.sourceLevel == null && fileObject != null) {
            source.sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
        }
        if (source.sourceLevel == null) {
            source.sourceLevel = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
        }
        CompilationInfo compilationInfo = new CompilationInfo(source, fileObject, parserTaskImpl);
        return compilationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequest(Request request) {
        assert (request != null);
        requests.add(request);
        Request request2 = currentRequest.getTaskToCancel(request.priority);
        try {
            if (request2 != null) {
                request2.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(request2);
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<FileObject> iterable) {
        Class<AbstractDocument> clazz = AbstractDocument.class;
        try {
            Method method = clazz.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread thread = Thread.currentThread();
            for (FileObject fileObject : iterable) {
                try {
                    Object object;
                    StyledDocument styledDocument;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie == null || !((styledDocument = editorCookie.getDocument()) instanceof AbstractDocument) || (object = method.invoke((Object)styledDocument, new Object[0])) != thread) continue;
                    return true;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfo compilationInfo, Throwable throwable) {
        Object object;
        String string = System.getProperty("netbeans.user") + "/var/log/";
        String string2 = compilationInfo.getText();
        FileObject fileObject = compilationInfo.getFileObject();
        String string3 = FileUtil.getFileDisplayName((FileObject)compilationInfo.getFileObject());
        String string4 = fileObject.getName();
        File file = new File(string + string4 + ".dump");
        boolean bl = false;
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string + string4 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                object = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                try {
                    printWriter.println(string2);
                    printWriter.println("----- Classpath: ---------------------------------------------");
                    ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath classPath3 = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    printWriter.println("bootPath: " + (classPath != null ? classPath.toString() : "null"));
                    printWriter.println("classPath: " + (classPath2 != null ? classPath2.toString() : "null"));
                    printWriter.println("sourcePath: " + (classPath3 != null ? classPath3.toString() : "null"));
                    printWriter.println("----- Original exception ---------------------------------------------");
                    throwable.printStackTrace(printWriter);
                }
                finally {
                    printWriter.close();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, "Error when writing parser dump file!", iOException);
            }
        }
        if (bl) {
            object = Exceptions.attachMessage((Throwable)throwable, (String)("An error occurred during parsing of '" + string3 + "'. Please report a bug against ruby and attach dump file '" + file.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)object);
        } else {
            Logger.getLogger("global").log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static {
        SourceAccessor.setINSTANCE(new JavaSourceAccessorImpl());
        phase2Key.put(Phase.PARSED, "parsed");
        phase2Message.put(Phase.PARSED, "Parsed");
        phase2Key.put(Phase.ELEMENTS_RESOLVED, "sig-attributed");
        phase2Message.put(Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Key.put(Phase.RESOLVED, "attributed");
        phase2Message.put(Phase.RESOLVED, "Attributed");
        requests = new PriorityBlockingQueue<Request>(10, new RequestComparator());
        finishedRequests = new WeakHashMap<Source, Collection<Request>>();
        waitingRequests = new WeakHashMap<Source, Collection<Request>>();
        toRemove = new LinkedList<CancellableTask>();
        factory = new SingleThreadFactory();
        currentRequest = new CurrentRequestReference();
        editorRegistryListener = new EditorRegistryListener();
        javacLock = new ReentrantLock(true);
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        file2JavaSource = new WeakHashMap<FileObject, Reference<Source>>();
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    private static class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private long cancelTime;
        private boolean canceled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCurrentTask(Request request) throws InterruptedException {
            boolean bl = false;
            CurrentRequestReference currentRequestReference = this;
            synchronized (currentRequestReference) {
                while (this.canceledReference != null) {
                    this.wait();
                }
                bl = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.reference = request;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Priority priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && priority.compareTo(this.reference.priority) < 0) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Source source) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && source.equals(this.reference.javaSource)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(CancellableTask cancellableTask) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && cancellableTask == this.reference.task) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized long getCancelTime() {
            return this.cancelTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCompleted(Request request) {
            if (request != null) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    this.notify();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaSourceAccessorImpl
    extends SourceAccessor {
        private StackTraceElement[] javacLockedStackTrace;

        private JavaSourceAccessorImpl() {
        }

        @Override
        protected void runSpecialTaskImpl(CancellableTask<CompilationInfo> cancellableTask, Priority priority) {
            Source.handleAddRequest(new Request(cancellableTask, null, null, priority, false));
        }

        @Override
        public ParserTaskImpl createParserTask(Language language, ClasspathInfo classpathInfo, String string) {
            if (string == null) {
                string = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion().toString();
            }
            boolean bl = true;
            return Source.createParserTask(language, null, classpathInfo, string, bl);
        }

        @Override
        public ParserTaskImpl getParserTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.getParserTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationInfo getCurrentCompilationInfo(Source source, Phase phase) throws IOException {
            assert (source != null);
            assert (this.isDispatchThread());
            CompilationInfo compilationInfo = null;
            Object object = source;
            synchronized (object) {
                if ((source.flags & 1) == 0) {
                    compilationInfo = source.currentInfo;
                }
            }
            if (compilationInfo == null) {
                return null;
            }
            object = Source.moveToPhase(phase, compilationInfo, true);
            return ((Enum)object).compareTo(phase) < 0 ? null : compilationInfo;
        }

        @Override
        public void revalidate(Source source) {
            source.revalidate();
        }

        @Override
        public boolean isDispatchThread() {
            return factory.isDispatchThread(Thread.currentThread());
        }

        @Override
        public void lockParser() {
            javacLock.lock();
            try {
                this.javacLockedStackTrace = Thread.currentThread().getStackTrace();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlockParser() {
            try {
                this.javacLockedStackTrace = null;
            }
            finally {
                javacLock.unlock();
            }
        }

        @Override
        public boolean isParserLocked() {
            return javacLock.isLocked();
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private Thread t;

        private SingleThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            assert (this.t == null);
            this.t = new Thread(runnable, "GSF Source Worker Thread");
            return this.t;
        }

        public boolean isDispatchThread(Thread thread) {
            assert (thread != null);
            return this.t == thread;
        }
    }

    private final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;

        public DataObjectListener(FileObject fileObject) throws DataObjectNotFoundException {
            this.fobj = fileObject;
            this.dobj = DataObject.find((FileObject)fileObject);
            this.wlistener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.dobj);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
            if (dataObject != this.dobj) {
                return;
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                this.handleInvalidDataObject(dataObject);
            } else if (propertyChangeEvent.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(dataObject);
            }
        }

        private void handleInvalidDataObject(DataObject dataObject) {
            dataObject.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    this.dobj = DataObject.find((FileObject)this.fobj);
                    this.dobj.addPropertyChangeListener(this.wlistener);
                    Source.this.assignDocumentListener(this.fobj);
                    Source.this.resetState(true, true);
                }
                catch (IOException iOException) {
                    Logger.getLogger(Source.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fileEvent) {
            Source.this.resetState(true, false);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Source.this.resetState(true, false);
        }
    }

    private static class EditorRegistryListener
    implements CaretListener {
        private Request request;
        private JTextComponent lastEditor;

        public EditorRegistryListener() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EditorRegistryListener.this.editorRegistryChanged();
                }
            });
            this.editorRegistryChanged();
        }

        public void editorRegistryChanged() {
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (this.lastEditor != jTextComponent) {
                if (this.lastEditor != null) {
                    this.lastEditor.removeCaretListener(this);
                    Document document = this.lastEditor.getDocument();
                    Source source = null;
                    if (document != null) {
                        source = Source.forDocument(document);
                    }
                }
                this.lastEditor = jTextComponent;
                if (this.lastEditor != null) {
                    this.lastEditor.addCaretListener(this);
                }
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Source source;
            Document document;
            if (this.lastEditor != null && (document = this.lastEditor.getDocument()) != null && (source = Source.forDocument(document)) != null) {
                source.resetState(false, false);
            }
        }
    }

    private class DocListener
    implements DocumentListener,
    PropertyChangeListener,
    ChangeListener {
        private EditorCookie.Observable ec;
        private DocumentListener docListener;

        public DocListener(EditorCookie.Observable observable) {
            assert (observable != null);
            this.ec = observable;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument styledDocument = observable.getDocument();
            if (styledDocument != null) {
                this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                styledDocument.addDocumentListener(this.docListener);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Source.this.resetState(true, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Source.this.resetState(true, true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                StyledDocument styledDocument;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof Document && this.docListener != null) {
                    ((Document)object).removeDocumentListener(this.docListener);
                    this.docListener = null;
                }
                if ((styledDocument = this.ec.getDocument()) != null) {
                    this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)styledDocument);
                    styledDocument.addDocumentListener(this.docListener);
                    Source.this.resetState(true, false);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Source.this.resetState(true, false);
        }
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    try {}
                    catch (Throwable throwable) {
                        if (throwable instanceof InterruptedException) {
                            throw (InterruptedException)throwable;
                        }
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        Exceptions.printStackTrace((Throwable)throwable);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            while (true) {
                Collection<Object> collection;
                boolean bl;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                block61: {
                    object4 = Source.class;
                    // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                    if (!toRemove.isEmpty()) {
                        object3 = finishedRequests.values().iterator();
                        while (object3.hasNext()) {
                            Collection collection2 = (Collection)object3.next();
                            object2 = collection2.iterator();
                            while (object2.hasNext()) {
                                object = (Request)object2.next();
                                if (!toRemove.remove(((Request)object).task)) continue;
                                object2.remove();
                            }
                            if (collection2.size() != 0) continue;
                            object3.remove();
                        }
                    }
                    // MONITOREXIT : object4
                    object4 = (Request)requests.poll(2L, TimeUnit.SECONDS);
                    if (object4 == null) continue;
                    currentRequest.setCurrentTask((Request)object4);
                    object3 = ((Request)object4).javaSource;
                    if (object3 == null) {
                        assert (((Request)object4).phase == null);
                        assert (!((Request)object4).reschedule);
                        javacLock.lock();
                        try {
                            ((Request)object4).task.run(null);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            Exceptions.printStackTrace((Throwable)runtimeException);
                            continue;
                        }
                        finally {
                            javacLock.unlock();
                        }
                    }
                    assert (((Source)object3).files.size() <= 1);
                    object = Source.class;
                    // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                    if (!toRemove.remove(((Request)object4).task)) break block61;
                    // MONITOREXIT : object
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                Object object5 = object3;
                // MONITORENTER : object5
                boolean bl2 = bl = (((Source)object3).flags & 2) != 0;
                if (bl) {
                    collection = (LinkedList<Object>)waitingRequests.get(((Request)object4).javaSource);
                    if (collection == null) {
                        collection = new LinkedList<Object>();
                        waitingRequests.put(((Request)object4).javaSource, collection);
                    }
                    collection.add(object4);
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                try {
                    boolean bl3 = (((Source)object3).flags & 1) != 0;
                    object2 = ((Source)object3).currentInfo;
                    // MONITOREXIT : object5
                    // MONITOREXIT : object
                    try {
                        boolean bl4;
                        block62: {
                            if (bl3) {
                                object2 = Source.createCurrentInfo((Source)object3, ((Source)object3).files.isEmpty() ? null : (FileObject)((Source)object3).files.iterator().next(), ((Source)object3).filterListener, null);
                                object = object3;
                                // MONITORENTER : object
                                if ((((Source)object3).flags & 1) != 0) {
                                    ((Source)object3).currentInfo = object2;
                                    ((Source)object3).flags &= -2;
                                } else {
                                    object2 = ((Source)object3).currentInfo;
                                }
                                // MONITOREXIT : object
                            }
                            assert (object2 != null);
                            javacLock.lock();
                            try {
                                object = Source.moveToPhase(((Request)object4).phase, object2, true);
                                boolean bl5 = bl4 = ((Enum)object).compareTo(((Request)object4).phase) >= 0;
                                if (!bl4) break block62;
                                Object object6 = object3;
                                // MONITORENTER : object6
                                boolean bl6 = (((Source)object3).flags & 1) == 0;
                                // MONITOREXIT : object6
                                if (!(bl4 &= bl6)) break block62;
                                try {
                                    long l = System.currentTimeMillis();
                                    ((Request)object4).task.run(object2);
                                    long l2 = System.currentTimeMillis();
                                    if (reportSlowTasks) {
                                        long l3;
                                        if (l2 - l > 250L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("Source executed a slow task: %s in %d ms.", ((Request)object4).task.getClass().toString(), l2 - l));
                                        }
                                        if ((l3 = currentRequest.getCancelTime()) >= l && l2 - l3 > 50L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("Task: %s ignored cancel for %d ms.", ((Request)object4).task.getClass().toString(), l2 - l3));
                                        }
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    Exceptions.printStackTrace((Throwable)runtimeException);
                                }
                            }
                            finally {
                                javacLock.unlock();
                            }
                        }
                        if (!((Request)object4).reschedule) continue;
                        object = Source.class;
                        // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                        bl4 = currentRequest.setCurrentTask(null);
                        Object object7 = object3;
                        // MONITORENTER : object7
                        if ((((Source)object3).flags & 1) != 0 || bl4) {
                            requests.add(object4);
                        } else {
                            collection = (Collection)finishedRequests.get(((Request)object4).javaSource);
                            if (collection == null) {
                                collection = new LinkedList();
                                finishedRequests.put(((Request)object4).javaSource, collection);
                            }
                            collection.add(object4);
                        }
                        // MONITOREXIT : object7
                        // MONITOREXIT : object
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    continue;
                }
                finally {
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestComparator
    implements Comparator<Request> {
        private RequestComparator() {
        }

        @Override
        public int compare(Request request, Request request2) {
            assert (request != null && request2 != null);
            return request.priority.compareTo(request2.priority);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request {
        private final CancellableTask<? extends CompilationInfo> task;
        private final Source javaSource;
        private final Phase phase;
        private final Priority priority;
        private final boolean reschedule;

        public Request(CancellableTask<? extends CompilationInfo> cancellableTask, Source source, Phase phase, Priority priority, boolean bl) {
            assert (cancellableTask != null);
            this.task = cancellableTask;
            this.javaSource = source;
            this.phase = phase;
            this.priority = priority;
            this.reschedule = bl;
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase.name(), this.priority, this.task.toString()});
            }
            return String.format("One time request for phase: %s with priority: %d to perform: %s", new Object[]{this.phase != null ? this.phase.name() : "<null>", this.priority, this.task.toString()});
        }

        public int hashCode() {
            return this.priority.ordinal();
        }

        public boolean equals(Object object) {
            if (object instanceof Request) {
                Request request = (Request)object;
                return this.priority == request.priority && this.reschedule == request.reschedule && this.phase.equals((Object)request.phase) && this.task.equals(request.task);
            }
            return false;
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String string, FileObject fileObject) {
            super(string);
            this.fo = fileObject;
        }

        private InsufficientMemoryException(FileObject fileObject) {
            this(NbBundle.getMessage(Source.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)), fileObject);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }
}

