/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.DocumentUtil;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;
import org.netbeans.modules.gsfret.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneIndex
extends Index {
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    static final String REFERENCES = "gsf";
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private Set<String> rootPkgCache;
    private ClassIndexImpl classIndex;
    private File cacheRoot;
    private FieldSelector FILE_AND_TIMESTAMP = new FieldSelector(){

        public FieldSelectorResult accept(String string) {
            return "filename".equals(string) || "timeStamp".equals(string) ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    };

    public static Index create(Language language, File file, ClassIndexImpl classIndexImpl) throws IOException {
        assert (file != null && file.exists() && file.canRead() && file.canWrite());
        LuceneIndex luceneIndex = new LuceneIndex(language, LuceneIndex.getReferencesCacheFolder(file));
        luceneIndex.classIndex = classIndexImpl;
        luceneIndex.cacheRoot = file;
        return luceneIndex;
    }

    private LuceneIndex(Language language, File file) throws IOException {
        super(language);
        assert (file != null);
        this.directory = FSDirectory.getDirectory((File)file, (LockFactory)NoLockFactory.getNoLockFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regExpSearch(Pattern pattern, Term term, IndexReader indexReader, Set<Term> set, boolean bl) throws IOException {
        String string;
        CharSequence charSequence;
        String string2 = term.text();
        if (string2.length() > 0) {
            char c;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2.charAt(0));
            for (int i = 1; i < string2.length() && Character.isJavaIdentifierPart(c = string2.charAt(i)); ++i) {
                ((StringBuilder)charSequence).append(c);
            }
            string = ((StringBuilder)charSequence).toString();
        } else {
            string = string2;
        }
        charSequence = term.field();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && charSequence == term2.field() && term2.text().startsWith(string)) {
                Matcher matcher = pattern.matcher(term2.text());
                if (matcher.matches()) {
                    set.add(term2);
                }
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefixSearch(Term term, IndexReader indexReader, Set<Term> set) throws IOException {
        String string = term.field();
        String string2 = term.text();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && string == term2.field() && term2.text().startsWith(string2)) {
                set.add(term2);
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String string, long l) throws IOException {
        if (Index.isPreindexed(this.cacheRoot)) {
            return true;
        }
        if (!this.isValid(false)) {
            return false;
        }
        try {
            IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
            try {
                Hits hits;
                LuceneIndex luceneIndex;
                if (string == null) {
                    luceneIndex = this;
                    synchronized (luceneIndex) {
                        if (this.rootTimeStamp != null) {
                            boolean bl = this.rootTimeStamp >= l;
                            return bl;
                        }
                    }
                    hits = indexSearcher.search((Query)new TermQuery(DocumentUtil.rootDocumentTerm()));
                } else {
                    hits = indexSearcher.search(DocumentUtil.binaryNameQuery(string));
                }
                assert (hits.length() <= 1);
                if (hits.length() == 0) {
                    boolean bl = false;
                    return bl;
                }
                luceneIndex = (Hit)hits.iterator().next();
                long l2 = DocumentUtil.getTimeStamp(luceneIndex.getDocument());
                if (string == null) {
                    LuceneIndex luceneIndex2 = this;
                    synchronized (luceneIndex2) {
                        this.rootTimeStamp = new Long(l2);
                    }
                }
                boolean bl = l2 >= l;
                return bl;
            }
            finally {
                indexSearcher.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.clear();
            return false;
        }
    }

    @Override
    public Map<String, String> getTimeStamps() throws IOException {
        if (!this.isValid(false)) {
            return null;
        }
        IndexReader indexReader = this.getReader();
        HashMap<String, String> hashMap = new HashMap<String, String>(2 * indexReader.numDocs());
        int n = indexReader.numDocs();
        for (int i = 0; i < n; ++i) {
            if (indexReader.isDeleted(i)) continue;
            Document document = indexReader.document(i, this.FILE_AND_TIMESTAMP);
            String string = document.get("timeStamp");
            String string2 = document.get("filename");
            if (string == null || string2 == null) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    @Override
    public boolean isValid(boolean bl) throws IOException {
        boolean bl2 = IndexReader.indexExists((Directory)this.directory);
        if (bl2 && bl) {
            try {
                this.getReader();
            }
            catch (IOException iOException) {
                bl2 = false;
                this.clear();
            }
        }
        return bl2;
    }

    @Override
    public synchronized void clear() throws IOException {
        String[] stringArray;
        this.close();
        for (String string : stringArray = this.directory.list()) {
            this.directory.deleteFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        finally {
            this.directory.close();
        }
    }

    public String toString() {
        return this.directory.toString();
    }

    private synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = IndexReader.open((Directory)this.directory);
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean bl) throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        IndexWriter indexWriter = new IndexWriter(this.directory, (Analyzer)new KeywordAnalyzer(), bl);
        return indexWriter;
    }

    private static File getReferencesCacheFolder(File file) throws IOException {
        File file2 = new File(file, REFERENCES);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String string, List<IndexDocument> list) throws IOException {
        boolean bl;
        assert (ClassIndexManager.holdsWriteLock());
        this.rootPkgCache = null;
        boolean bl2 = bl = !this.isValid(false);
        if (!bl) {
            IndexReader indexReader = this.getReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            try {
                if (string != null) {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add((Query)new TermQuery(new Term("filename", string)), BooleanClause.Occur.MUST);
                    Hits hits = indexSearcher.search((Query)booleanQuery);
                    for (int i = 0; i < hits.length(); ++i) {
                        indexReader.deleteDocument(hits.id(i));
                    }
                }
                indexReader.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                indexSearcher.close();
            }
        }
        long l = System.currentTimeMillis();
        this.store(list, bl, l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(List<IndexDocument> list, boolean bl, long l, String string) throws IOException {
        List<IndexDocument> list2 = list;
        IndexWriter indexWriter = this.getWriter(bl);
        try {
            LuceneIndexMBeanImpl luceneIndexMBeanImpl;
            if (debugIndexMerging) {
                indexWriter.setInfoStream(System.err);
            }
            if ((luceneIndexMBeanImpl = LuceneIndexMBeanImpl.getDefault()) != null) {
                indexWriter.setMergeFactor(luceneIndexMBeanImpl.getMergeFactor());
                indexWriter.setMaxMergeDocs(luceneIndexMBeanImpl.getMaxMergeDocs());
                indexWriter.setMaxBufferedDocs(luceneIndexMBeanImpl.getMaxBufferedDocs());
            }
            LowMemoryNotifier lowMemoryNotifier = LowMemoryNotifier.getDefault();
            LMListener lMListener = new LMListener();
            lowMemoryNotifier.addLowMemoryListener(lMListener);
            RAMDirectory rAMDirectory = null;
            IndexWriter indexWriter2 = null;
            if (lMListener.lowMemory.getAndSet(false)) {
                indexWriter2 = indexWriter;
            } else {
                rAMDirectory = new RAMDirectory();
                indexWriter2 = new IndexWriter((Directory)rAMDirectory, (Analyzer)new KeywordAnalyzer(), true);
            }
            try {
                Object object;
                indexWriter2.addDocument(DocumentUtil.createRootTimeStampDocument(l));
                if (list2 != null && list2.size() > 0) {
                    for (IndexDocumentImpl indexDocumentImpl : list2) {
                        Field field;
                        String string2;
                        String string3;
                        int n;
                        Document document = new Document();
                        document.add((Fieldable)new Field("timeStamp", DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                        if (indexDocumentImpl.overrideUrl != null) {
                            document.add((Fieldable)new Field("filename", indexDocumentImpl.overrideUrl, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        } else if (string != null) {
                            document.add((Fieldable)new Field("filename", string, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        }
                        int n2 = indexDocumentImpl.indexedKeys.size();
                        for (n = 0; n < n2; ++n) {
                            string3 = indexDocumentImpl.indexedKeys.get(n);
                            string2 = indexDocumentImpl.indexedValues.get(n);
                            assert (string3 != null && string2 != null) : "key=" + string3 + ", value=" + string2;
                            field = new Field(string3, string2, Field.Store.YES, Field.Index.UN_TOKENIZED);
                            document.add((Fieldable)field);
                        }
                        n2 = indexDocumentImpl.unindexedKeys.size();
                        for (n = 0; n < n2; ++n) {
                            string3 = indexDocumentImpl.unindexedKeys.get(n);
                            string2 = indexDocumentImpl.unindexedValues.get(n);
                            assert (string3 != null && string2 != null) : "key=" + string3 + ", value=" + string2;
                            field = new Field(string3, string2, Field.Store.YES, Field.Index.NO);
                            document.add((Fieldable)field);
                        }
                        indexWriter2.addDocument(document);
                    }
                } else if (string != null) {
                    object = new Document();
                    object.add((Fieldable)new Field("timeStamp", DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                    object.add((Fieldable)new Field("filename", string, Field.Store.YES, Field.Index.UN_TOKENIZED));
                    indexWriter2.addDocument((Document)object);
                }
                if (rAMDirectory != null && lMListener.lowMemory.getAndSet(false)) {
                    indexWriter2.close();
                    indexWriter.addIndexes(new Directory[]{rAMDirectory});
                    rAMDirectory = new RAMDirectory();
                    indexWriter2 = new IndexWriter((Directory)rAMDirectory, (Analyzer)new KeywordAnalyzer(), true);
                }
                if (rAMDirectory != null) {
                    indexWriter2.close();
                    indexWriter.addIndexes(new Directory[]{rAMDirectory});
                    indexWriter2 = null;
                    rAMDirectory = null;
                }
                object = this;
                synchronized (object) {
                    this.rootTimeStamp = new Long(l);
                }
            }
            finally {
                lowMemoryNotifier.removeLowMemoryListener(lMListener);
            }
        }
        finally {
            indexWriter.close();
        }
    }

    public void search(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, Set<Index.SearchResult> set2, Set<String> set3) throws IOException {
        Object object;
        Integer n4;
        Object object2;
        Object object3;
        Serializable serializable;
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        assert (string2 != null);
        TreeSet<Term> treeSet = new TreeSet<Term>(new Comparator<Term>(){

            @Override
            public int compare(Term term, Term term2) {
                int n = term.field().compareTo(term2.field());
                if (n == 0) {
                    n = term.text().compareTo(term2.text());
                }
                return n;
            }
        });
        IndexReader indexReader = this.getReader();
        switch (nameKind) {
            case EXACT_NAME: {
                treeSet.add(new Term(string, string2));
                break;
            }
            case PREFIX: {
                if (string2.length() == 0) {
                    this.gsfEmptyPrefixSearch(indexReader, set2, string);
                    return;
                }
                serializable = new Term(string, string2);
                this.prefixSearch((Term)serializable, indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (string2.length() == 0) {
                    this.gsfEmptyPrefixSearch(indexReader, set2, string);
                    return;
                }
                serializable = new Term(string, string2.toLowerCase());
                this.prefixSearch((Term)serializable, indexReader, treeSet);
                break;
            }
            case CAMEL_CASE: {
                int n2;
                if (string2.length() == 0) {
                    this.search(string, string2, NameKind.CASE_INSENSITIVE_PREFIX, set, set2, set3);
                    return;
                }
                serializable = new StringBuilder();
                object3 = null;
                int n3 = 0;
                do {
                    object2 = string2.substring(n3, (n2 = LuceneIndex.findNextUpper(string2, n3 + 1)) == -1 ? string2.length() : n2);
                    if (n3 == 0) {
                        object3 = object2;
                    }
                    ((StringBuilder)serializable).append((String)object2);
                    ((StringBuilder)serializable).append(n2 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n3 = n2;
                } while (n2 != -1);
                object2 = Pattern.compile(((StringBuilder)serializable).toString());
                n4 = new Term(string, (String)object3);
                this.regExpSearch((Pattern)object2, (Term)n4, indexReader, treeSet, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (string2.length() == 0) {
                    this.search(string, string2, NameKind.CASE_INSENSITIVE_PREFIX, set, set2, set3);
                    return;
                }
                serializable = Pattern.compile(string2, 2);
                if (Character.isJavaIdentifierStart(string2.charAt(0))) {
                    this.regExpSearch((Pattern)serializable, new Term(string, string2.toLowerCase()), indexReader, treeSet, false);
                    break;
                }
                this.regExpSearch((Pattern)serializable, new Term(string, ""), indexReader, treeSet, false);
                break;
            }
            case REGEXP: {
                if (string2.length() == 0) {
                    this.search(string, string2, NameKind.PREFIX, set, set2, set3);
                    return;
                }
                serializable = Pattern.compile(string2);
                if (Character.isJavaIdentifierStart(string2.charAt(0))) {
                    this.regExpSearch((Pattern)serializable, new Term(string, string2), indexReader, treeSet, true);
                    break;
                }
                this.regExpSearch((Pattern)serializable, new Term(string, ""), indexReader, treeSet, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        serializable = indexReader.termDocs();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), treeSet.size()));
        }
        object3 = treeSet.iterator();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        HashMap<Integer, Document> hashMap = new HashMap<Integer, Document>();
        while (object3.hasNext()) {
            object2 = (Term)object3.next();
            serializable.seek((Term)object2);
            while (serializable.next()) {
                n4 = serializable.doc();
                object = (List)hashMap.get(n4);
                if (object == null) {
                    object = new ArrayList();
                    hashMap.put(n4, (Document)object);
                }
                object.add(object2.text());
                treeSet2.add(n4);
            }
        }
        for (Integer n4 : treeSet2) {
            object = indexReader.document(n4.intValue());
            List list = (List)hashMap.get(n4);
            FilteredDocumentSearchResult filteredDocumentSearchResult = new FilteredDocumentSearchResult((Document)object, string, list, n4);
            set2.add(filteredDocumentSearchResult);
        }
    }

    private static int findNextUpper(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private <T> void gsfEmptyPrefixSearch(IndexReader indexReader, Set<Index.SearchResult> set, String string) throws IOException {
        int n = indexReader.maxDoc();
        for (int i = 0; i < n; ++i) {
            Document document;
            if (indexReader.isDeleted(i) || (document = indexReader.document(i)) == null) continue;
            DocumentSearchResult documentSearchResult = new DocumentSearchResult(document, i);
            set.add(documentSearchResult);
        }
    }

    public IndexReader getDumpIndexReader() throws IOException {
        return this.getReader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredDocumentSearchResult
    implements Index.SearchResult {
        private Document doc;
        private int docId;
        private String primaryKey;
        private List<String> primaryValues;

        private FilteredDocumentSearchResult(Document document, String string, List<String> list, int n) {
            this.doc = document;
            this.primaryKey = string;
            this.primaryValues = list;
            this.docId = n;
        }

        public String getValue(String string) {
            if (string.equals(this.primaryKey)) {
                if (this.primaryValues.size() > 0) {
                    return this.primaryValues.get(0);
                }
                return null;
            }
            return this.doc.get(string);
        }

        public String[] getValues(String string) {
            if (string.equals(this.primaryKey)) {
                return this.primaryValues.toArray(new String[this.primaryValues.size()]);
            }
            return this.doc.getValues(string);
        }

        public String getPersistentUrl() {
            return this.getValue("filename");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration enumeration = this.doc.fields();
            while (enumeration.hasMoreElements()) {
                Field field = (Field)enumeration.nextElement();
                if (field.name().equals(this.primaryKey)) {
                    stringBuilder.append(this.primaryKey);
                    stringBuilder.append(":");
                    stringBuilder.append(this.primaryValues.toString());
                } else {
                    stringBuilder.append(field.name());
                    stringBuilder.append(":");
                    stringBuilder.append(field.stringValue());
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public int getDocumentNumber() {
            return this.docId;
        }

        public Object getDocument() {
            return this.doc;
        }

        public Object getIndexReader() {
            try {
                return LuceneIndex.this.getReader();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }

        public Object getIndex() {
            return LuceneIndex.this.classIndex;
        }

        public File getSegment() {
            return LuceneIndex.this.cacheRoot;
        }
    }

    private class DocumentSearchResult
    implements Index.SearchResult {
        private Document doc;
        private int docId;

        private DocumentSearchResult(Document document, int n) {
            this.doc = document;
            this.docId = n;
        }

        public String getValue(String string) {
            return this.doc.get(string);
        }

        public String[] getValues(String string) {
            return this.doc.getValues(string);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration enumeration = this.doc.fields();
            while (enumeration.hasMoreElements()) {
                Field field = (Field)enumeration.nextElement();
                stringBuilder.append(field.name());
                stringBuilder.append(":");
                stringBuilder.append(field.stringValue());
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public int getDocumentNumber() {
            return this.docId;
        }

        public Object getDocument() {
            return this.doc;
        }

        public Object getIndexReader() {
            try {
                return LuceneIndex.this.getReader();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }

        public Object getIndex() {
            return LuceneIndex.this.classIndex;
        }

        public File getSegment() {
            return LuceneIndex.this.cacheRoot;
        }

        public String getPersistentUrl() {
            return this.getValue("filename");
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomFieldSelector
    implements FieldSelector {
        private Set<String> includeFields;

        CustomFieldSelector(Set<String> set) {
            this.includeFields = set;
        }

        public FieldSelectorResult accept(String string) {
            boolean bl = this.includeFields.contains(string) || string.equals("filename");
            return bl ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    }
}

