/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.gsfret.editor.options.CodeFoldingEditor;
import org.openide.util.NbBundle;

public class CodeFoldingEditorPanel
extends JPanel {
    CodeFoldingEditor foldingEditor;
    private JCheckBox enableFoldingCB;
    private JCheckBox importCB;
    private JCheckBox initialCommentCB;
    private JCheckBox innerCB;
    private JLabel jLabel1;
    private JCheckBox javadocCB;
    private JCheckBox methodCB;

    public CodeFoldingEditorPanel(CodeFoldingEditor codeFoldingEditor) {
        this.foldingEditor = codeFoldingEditor;
        this.initComponents();
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.enableFoldingCB.setMnemonic(this.getBundleString("CFEP_UseCF_Mnemonic").charAt(0));
        this.methodCB.setMnemonic(this.getBundleString("CFEP_Method_Mnemonic").charAt(0));
        this.innerCB.setMnemonic(this.getBundleString("CFEP_InnerClass_Mnemonic").charAt(0));
        this.importCB.setMnemonic(this.getBundleString("CFEP_Import_Mnemonic").charAt(0));
        this.javadocCB.setMnemonic(this.getBundleString("CFEP_Javadoc_Mnemonic").charAt(0));
        this.initialCommentCB.setMnemonic(this.getBundleString("CFEP_InitialComment_Mnemonic").charAt(0));
    }

    private void initComponents() {
        this.enableFoldingCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.methodCB = new JCheckBox();
        this.innerCB = new JCheckBox();
        this.importCB = new JCheckBox();
        this.javadocCB = new JCheckBox();
        this.initialCommentCB = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.enableFoldingCB.setText(this.getBundleString("CFEP_UseCF"));
        this.enableFoldingCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.checkBoxChange(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.enableFoldingCB, gridBagConstraints);
        this.jLabel1.setText(this.getBundleString("CFEP_CollapsedByDefault"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 11);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.methodCB.setText(this.getBundleString("CFEP_Method"));
        this.methodCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.methodCBItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.methodCB, gridBagConstraints);
        this.innerCB.setText(this.getBundleString("CFEP_InnerClass"));
        this.innerCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.innerCBItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.innerCB, gridBagConstraints);
        this.importCB.setText(this.getBundleString("CFEP_Import"));
        this.importCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.importCBItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.importCB, gridBagConstraints);
        this.javadocCB.setText(this.getBundleString("CFEP_Javadoc"));
        this.javadocCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.javadocCBItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javadocCB, gridBagConstraints);
        this.initialCommentCB.setText(this.getBundleString("CFEP_InitialComment"));
        this.initialCommentCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CodeFoldingEditorPanel.this.initialCommentCBItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.initialCommentCB, gridBagConstraints);
    }

    private void initialCommentCBItemStateChanged(ItemEvent itemEvent) {
        this.notifyEditor();
    }

    private void javadocCBItemStateChanged(ItemEvent itemEvent) {
        this.notifyEditor();
    }

    private void importCBItemStateChanged(ItemEvent itemEvent) {
        this.notifyEditor();
    }

    private void innerCBItemStateChanged(ItemEvent itemEvent) {
        this.notifyEditor();
    }

    private void methodCBItemStateChanged(ItemEvent itemEvent) {
        this.notifyEditor();
    }

    private void checkBoxChange(ItemEvent itemEvent) {
        this.setCBoxesEnabled(itemEvent.getStateChange() == 1);
        this.notifyEditor();
    }

    private void notifyEditor() {
        if (this.foldingEditor != null) {
            this.foldingEditor.customEditorChange();
        }
    }

    private void setCBoxesEnabled(boolean bl) {
        this.methodCB.setEnabled(bl);
        this.innerCB.setEnabled(bl);
        this.importCB.setEnabled(bl);
        this.javadocCB.setEnabled(bl);
        this.initialCommentCB.setEnabled(bl);
    }

    public void setValue(Map map) {
        Boolean bl = (Boolean)map.get("code-folding-enable");
        if (!bl.booleanValue()) {
            this.setCBoxesEnabled(false);
        }
        this.enableFoldingCB.setSelected(bl);
        System.err.println("Not yet storing settings");
    }

    public Map getValue() {
        HashMap hashMap = new HashMap(10);
        System.err.println("Not yet storing settings");
        return hashMap;
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage(CodeFoldingEditorPanel.class, (String)string);
    }
}

