/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionDoc;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionItem;
import org.netbeans.modules.gsfret.editor.completion.MethodParamsTipPaintComponent;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GsfCompletionProvider
implements CompletionProvider {
    private static final String COMMENT_CATEGORY_NAME = "comment";
    private static boolean isAutoQuery;
    private static boolean expectingCreateTask;
    private static boolean caseSensitive;
    private static boolean inited;
    private static SettingsChangeListener settingsListener;

    public static Completable getCompletable(org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, int n) {
        try {
            return GsfCompletionProvider.getCompletable(compilationInfo.getDocument(), n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    static Completable getCompletable(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getCompletionProvider() == null) continue;
            return language.getCompletionProvider();
        }
        return null;
    }

    private static boolean isInCompletion(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("completion-active");
        return object == Boolean.TRUE;
    }

    public static int autoQueryTypes(JTextComponent jTextComponent, String string) {
        Completable completable;
        if (string.length() > 0 && (completable = GsfCompletionProvider.getCompletable(jTextComponent.getDocument(), jTextComponent.getCaretPosition())) != null) {
            Completable.QueryType queryType = completable.getAutoQuery(jTextComponent, string);
            switch (queryType) {
                case NONE: {
                    return 0;
                }
                case STOP: {
                    isAutoQuery = false;
                    Completion.get().hideAll();
                    return 0;
                }
                case COMPLETION: {
                    return 1;
                }
                case DOCUMENTATION: {
                    return 2;
                }
                case TOOLTIP: {
                    return 4;
                }
                case ALL_COMPLETION: {
                    return 9;
                }
            }
        }
        return 0;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        boolean bl = GsfCompletionProvider.isInCompletion(jTextComponent);
        int n = GsfCompletionProvider.autoQueryTypes(jTextComponent, string);
        if (!bl) {
            isAutoQuery = n != 0;
            expectingCreateTask = n != 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaContext(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        org.netbeans.api.lexer.Language language = (org.netbeans.api.lexer.Language)document.getProperty(org.netbeans.api.lexer.Language.class);
        if (language == null) {
            return true;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            TokenSequence tokenSequence = TokenHierarchy.get((Document)jTextComponent.getDocument()).tokenSequence();
            if (tokenSequence == null) {
                boolean bl = false;
                return bl;
            }
            if (!tokenSequence.moveNext() || tokenSequence.move(n) == 0) {
                boolean bl = true;
                return bl;
            }
            if (!tokenSequence.moveNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public static boolean startsWith(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        return GsfCompletionProvider.isCaseSensitive() ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (!expectingCreateTask) {
            isAutoQuery = false;
        }
        if ((n & 1) != 0 || n == 4 || n == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionQuery(n, jTextComponent.getSelectionStart()), jTextComponent);
        }
        return null;
    }

    static CompletionTask createDocTask(ElementHandle elementHandle, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
        JavaCompletionQuery javaCompletionQuery = new JavaCompletionQuery(2, -1);
        javaCompletionQuery.element = elementHandle;
        return new AsyncCompletionTask((AsyncCompletionQuery)javaCompletionQuery, Registry.getMostActiveComponent());
    }

    public static boolean isCaseSensitive() {
        GsfCompletionProvider.lazyInit();
        return caseSensitive;
    }

    public static void setCaseSensitive(boolean bl) {
        GsfCompletionProvider.lazyInit();
        caseSensitive = bl;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Settings.addSettingsChangeListener((SettingsChangeListener)settingsListener);
            GsfCompletionProvider.setCaseSensitive(SettingsUtil.getBoolean(GsfEditorKitFactory.GsfEditorKit.class, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive));
        }
    }

    static {
        caseSensitive = true;
        settingsListener = new SettingsListener();
    }

    private static class SettingsListener
    implements SettingsChangeListener {
        private SettingsListener() {
        }

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            GsfCompletionProvider.setCaseSensitive(SettingsUtil.getBoolean(GsfEditorKitFactory.GsfEditorKit.class, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive));
        }
    }

    private static class CompletionFormatter
    extends GsfHtmlFormatter {
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static final String END_COLOR = "</font>";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static final String VARIABLE_COLOR = "<font color=#00007c>";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static final String PARAMETERS_COLOR = "<font color=#808080>";
        private static final String ACTIVE_PARAMETER_COLOR = "<font color=#000000>";

        private CompletionFormatter() {
        }

        public void parameters(boolean bl) {
            assert (bl != this.isParameter);
            this.isParameter = bl;
            if (this.isParameter) {
                this.sb.append(PARAMETER_NAME_COLOR);
            } else {
                this.sb.append(END_COLOR);
            }
        }

        public void active(boolean bl) {
            if (bl) {
                this.sb.append("<font color=#000000>");
                this.sb.append("<b>");
            } else {
                this.sb.append("</b>");
                this.sb.append(END_COLOR);
            }
        }

        public void name(ElementKind elementKind, boolean bl) {
            assert (bl != this.isName);
            this.isName = bl;
            if (this.isName) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        this.sb.append(CONSTRUCTOR_COLOR);
                        break;
                    }
                    case CALL: {
                        this.sb.append("<font color=#808080>");
                        break;
                    }
                    case DB: 
                    case METHOD: {
                        this.sb.append("<font color=#000000>");
                        break;
                    }
                    case CLASS: {
                        this.sb.append(CLASS_COLOR);
                        break;
                    }
                    case FIELD: {
                        this.sb.append(FIELD_COLOR);
                        break;
                    }
                    case MODULE: {
                        this.sb.append("<font color=#808080>");
                        break;
                    }
                    case KEYWORD: {
                        this.sb.append(KEYWORD_COLOR);
                        this.sb.append("<b>");
                        break;
                    }
                    case VARIABLE: {
                        this.sb.append(VARIABLE_COLOR);
                        this.sb.append("<b>");
                        break;
                    }
                    default: {
                        this.sb.append("<font>");
                        break;
                    }
                }
            } else {
                switch (elementKind) {
                    case KEYWORD: 
                    case VARIABLE: {
                        this.sb.append("</b>");
                    }
                }
                this.sb.append(END_COLOR);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaCompletionQuery
    extends AsyncCompletionQuery
    implements CancellableTask<CompilationController> {
        private Collection<CompletionItem> results;
        private JToolTip toolTip;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;
        private Source source;

        private JavaCompletionQuery(int n, int n2) {
            this.queryType = n;
            this.caretOffset = n2;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getSelectionStart();
            if (n >= this.caretOffset) {
                try {
                    if (this.isJavaIdentifierPart(jTextComponent.getDocument().getText(this.caretOffset, n - this.caretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                this.caretOffset = n;
                if (this.queryType == 4 || this.queryType == 2 || GsfCompletionProvider.isJavaContext(this.component, n)) {
                    this.results = null;
                    this.documentation = null;
                    this.toolTip = null;
                    this.anchorOffset = -1;
                    Source source = Source.forDocument(document);
                    if (source == null) {
                        FileObject fileObject = null;
                        if (this.element != null && (fileObject = this.element.getFileObject()) != null) {
                            source = Source.forFileObject(fileObject);
                        }
                    }
                    if (source != null) {
                        if (SourceUtils.isScanInProgress()) {
                            completionResultSet.setWaitText(NbBundle.getMessage(GsfCompletionProvider.class, (String)"scanning-in-progress"));
                        }
                        source.runUserActionTask(this, true);
                        if ((this.queryType & 1) != 0) {
                            if (this.results != null) {
                                completionResultSet.addAllItems(this.results);
                            }
                        } else if (this.queryType == 4) {
                            if (this.toolTip != null) {
                                completionResultSet.setToolTip(this.toolTip);
                            }
                        } else if (this.queryType == 2 && this.documentation != null) {
                            completionResultSet.setDocumentation(this.documentation);
                        }
                        if (this.anchorOffset > -1) {
                            completionResultSet.setAnchorOffset(this.anchorOffset);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                completionResultSet.finish();
            }
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            this.filterPrefix = null;
            int n = jTextComponent.getSelectionStart();
            if ((this.queryType & 1) != 0) {
                if (n >= this.caretOffset && this.anchorOffset > -1) {
                    try {
                        String string = jTextComponent.getDocument().getText(this.anchorOffset, n - this.anchorOffset);
                        if (this.isJavaIdentifierPart(string)) {
                            this.filterPrefix = string;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                return this.filterPrefix != null;
            }
            if (this.queryType == 4) {
                try {
                    if (n == this.caretOffset) {
                        this.filterPrefix = "";
                    } else if (n - this.caretOffset > 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(this.caretOffset, n - this.caretOffset);
                    } else if (n - this.caretOffset < 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(n, this.caretOffset - n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return this.filterPrefix != null && this.filterPrefix.indexOf(44) == -1 && this.filterPrefix.indexOf(40) == -1 && this.filterPrefix.indexOf(41) == -1;
            }
            return false;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            try {
                if ((this.queryType & 1) != 0) {
                    if (this.results != null) {
                        if (this.filterPrefix != null) {
                            completionResultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        } else {
                            Completion.get().hideDocumentation();
                            Completion.get().hideCompletion();
                        }
                    }
                } else if (this.queryType == 4) {
                    completionResultSet.setToolTip(this.toolTip);
                }
                completionResultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            completionResultSet.finish();
        }

        public void run(CompilationController compilationController) throws Exception {
            if (compilationController.getDocument() == null) {
                return;
            }
            if ((this.queryType & 1) != 0) {
                this.resolveCompletion(compilationController);
            } else if (this.queryType == 4) {
                this.resolveToolTip(compilationController);
            } else if (this.queryType == 2) {
                this.resolveDocumentation(compilationController);
            }
            GsfCompletionItem.tipProposal = null;
        }

        public void cancel() {
        }

        private void resolveToolTip(CompilationController compilationController) throws IOException {
            int n;
            ParameterInfo parameterInfo;
            CompletionProposal completionProposal = GsfCompletionItem.tipProposal;
            Env env = this.getCompletionEnvironment(compilationController, false);
            Completable completable = env.getCompletable();
            if (completable != null && (parameterInfo = completable.parameters((CompilationInfo)compilationController, n = env.getOffset(), completionProposal)) != ParameterInfo.NONE) {
                List list = parameterInfo.getNames();
                int n2 = 50;
                int n3 = 0;
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    String string = (String)list.get(i);
                    if (i < n4 - 1) {
                        string = string + ", ";
                    }
                    arrayList2.add(string);
                    if ((n3 += string.length()) <= n2) continue;
                    n3 = 0;
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                }
                if (arrayList2.size() > 0) {
                    arrayList.add(arrayList2);
                }
                n4 = parameterInfo.getCurrentIndex();
                this.anchorOffset = parameterInfo.getAnchorOffset();
                this.toolTip = new MethodParamsTipPaintComponent(arrayList, n4, this.component);
                return;
            }
        }

        private void resolveDocumentation(CompilationController compilationController) throws IOException {
            compilationController.toPhase(Phase.RESOLVED);
            if (this.element != null) {
                this.documentation = GsfCompletionDoc.create(compilationController, this.element);
            } else {
                List list;
                Env env = this.getCompletionEnvironment(compilationController, false);
                int n = env.getOffset();
                String string = env.getPrefix();
                this.results = new ArrayList<CompletionItem>();
                this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
                Completable completable = env.getCompletable();
                if (completable != null && (list = completable.complete((CompilationInfo)compilationController, n, string, NameKind.EXACT_NAME, Completable.QueryType.DOCUMENTATION, GsfCompletionProvider.isCaseSensitive(), (HtmlFormatter)new CompletionFormatter())) != null) {
                    for (CompletionProposal completionProposal : list) {
                        ElementHandle elementHandle = completionProposal.getElement();
                        if (elementHandle == null) continue;
                        this.documentation = GsfCompletionDoc.create(compilationController, elementHandle);
                        if (this.documentation.getText() == null || this.documentation.getText().length() <= 0) continue;
                        break;
                    }
                }
            }
        }

        private void resolveCompletion(CompilationController compilationController) throws IOException {
            Env env = this.getCompletionEnvironment(compilationController, true);
            int n = env.getOffset();
            String string = env.getPrefix();
            this.results = new ArrayList<CompletionItem>();
            this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
            Completable completable = env.getCompletable();
            if (completable != null) {
                List list = completable.complete((CompilationInfo)compilationController, n, string, GsfCompletionProvider.isCaseSensitive() ? NameKind.PREFIX : NameKind.CASE_INSENSITIVE_PREFIX, Completable.QueryType.COMPLETION, GsfCompletionProvider.isCaseSensitive(), (HtmlFormatter)new CompletionFormatter());
                if (list != null) {
                    for (CompletionProposal completionProposal : list) {
                        GsfCompletionItem gsfCompletionItem = GsfCompletionItem.createItem(completionProposal, compilationController);
                        if (gsfCompletionItem == null) continue;
                        this.results.add(gsfCompletionItem);
                    }
                }
                if (isAutoQuery && (list == null || list.size() == 0)) {
                    Completion.get().hideCompletion();
                    expectingCreateTask = false;
                }
            }
        }

        private boolean isJavaIdentifierPart(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection<CompletionItem> collection, String string) {
            if (string.length() == 0) {
                return collection;
            }
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : collection) {
                if (!GsfCompletionProvider.startsWith(((Object)completionItem.getInsertPrefix()).toString(), string)) continue;
                arrayList.add(completionItem);
            }
            return arrayList;
        }

        private Env getCompletionEnvironment(CompilationController compilationController, boolean bl) throws IOException {
            int n;
            Document document = compilationController.getDocument();
            int n2 = n = document != null ? document.getLength() : (int)compilationController.getFileObject().getSize();
            if (this.caretOffset > n) {
                this.caretOffset = n;
            }
            int n3 = this.caretOffset;
            String string = null;
            Completable completable = GsfCompletionProvider.getCompletable(compilationController, n3);
            try {
                int n4;
                int[] nArray;
                if (completable != null) {
                    string = completable.getPrefix((CompilationInfo)compilationController, n3, bl);
                }
                if (string == null && (nArray = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)compilationController.getDocument()), (int)n3)) != null && (n4 = nArray[0]) < n3) {
                    string = bl ? compilationController.getDocument().getText(n4, n3 - n4) : compilationController.getDocument().getText(n4, nArray[1] - n4);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            compilationController.toPhase(Phase.PARSED);
            return new Env(n3, string, compilationController, completable);
        }

        private class Env {
            private int offset;
            private String prefix;
            private CompilationController controller;
            private Completable completable;
            private boolean autoCompleting;

            private Env(int n, String string, CompilationController compilationController, Completable completable) {
                this.offset = n;
                this.prefix = string;
                this.controller = compilationController;
                this.completable = completable;
            }

            public int getOffset() {
                return this.offset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public boolean isAutoCompleting() {
                return this.autoCompleting;
            }

            public void setAutoCompleting(boolean bl) {
                this.autoCompleting = bl;
            }

            public CompilationController getController() {
                return this.controller;
            }

            public Completable getCompletable() {
                return this.completable;
            }
        }
    }
}

