/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.DefaultLanguage;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageRegistry
implements Iterable<Language> {
    private static LanguageRegistry instance;
    private static final String ICON_BASE = "iconBase";
    private static final String LANGUAGE = "language.instance";
    private static final String PARSER = "parser.instance";
    private static final String COMPLETION = "completion.instance";
    private static final String RENAMER = "renamer.instance";
    private static final String FORMATTER = "formatter.instance";
    private static final String BRACKET_COMPLETION = "bracket.instance";
    private static final String DECLARATION_FINDER = "declarationfinder.instance";
    private static final String INDEXER = "indexer.instance";
    private static final String PALETTE = "palette.instance";
    private static final String STRUCTURE = "structure.instance";
    private static final String HINTS = "hints.instance";
    private static final String SEMANTIC = "semantic.instance";
    private static final String OCCURRENCES = "occurrences.instance";
    private static final String FOLDER = "GsfPlugins";
    private List<Language> languages;
    private boolean languagesInitialized;
    private Collection<? extends EmbeddingModel> embeddingModels;
    private Map<String, Map<String, Boolean>> relevantMimes = new HashMap<String, Map<String, Boolean>>();
    private ClassPath libraryPath;
    private List<URL> urls;

    public LanguageRegistry() {
        this.initialize();
    }

    public void addLanguages(List<Language> list) {
        if (this.languages != null && this.languages.size() > 0) {
            throw new RuntimeException("This is for testing purposes only!!!");
        }
        this.languages = list;
    }

    public static synchronized LanguageRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageRegistry();
        }
        return instance;
    }

    public Language getLanguageByMimeType(@NonNull String string) {
        if (this.languages == null) {
            return null;
        }
        assert (string.equals(string.toLowerCase())) : string;
        assert (this.languages instanceof RandomAccess);
        int n = this.languages.size();
        for (int i = 0; i < n; ++i) {
            Language language = this.languages.get(i);
            if (!language.getMimeType().equals(string)) continue;
            return language;
        }
        return null;
    }

    @CheckForNull
    public EmbeddingModel getEmbedding(@NonNull String string, @NonNull String string2) {
        Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
        for (EmbeddingModel embeddingModel : collection) {
            if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
            return embeddingModel;
        }
        return null;
    }

    private Collection<? extends EmbeddingModel> getEmbeddingModels() {
        if (this.embeddingModels == null) {
            this.embeddingModels = Lookup.getDefault().lookupAll(EmbeddingModel.class);
        }
        return this.embeddingModels;
    }

    public boolean isRelevantFor(FileObject fileObject, String string) {
        Boolean bl;
        String string2 = fileObject.getMIMEType();
        if (string.equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.relevantMimes.get(string);
        if (map == null) {
            map = new HashMap<String, Boolean>();
            this.relevantMimes.put(string, map);
        }
        if ((bl = map.get(string2)) == null) {
            bl = Boolean.FALSE;
            Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
            for (EmbeddingModel embeddingModel : collection) {
                if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
                bl = Boolean.TRUE;
                break;
            }
            map.put(string2, bl);
        }
        return bl;
    }

    @NonNull
    public List<Language> getApplicableLanguages(String string) {
        Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
        ArrayList<Language> arrayList = new ArrayList<Language>(5);
        Language language = this.getLanguageByMimeType(string);
        if (language != null) {
            arrayList.add(language);
        }
        for (EmbeddingModel embeddingModel : collection) {
            Language language2;
            if (!embeddingModel.getSourceMimeTypes().contains(string) || (language2 = this.getLanguageByMimeType(embeddingModel.getTargetMimeType())) == null || arrayList.contains(language2)) continue;
            arrayList.add(language2);
        }
        return arrayList;
    }

    public List<URL> getLibraryUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            for (Language language : this) {
                GsfLanguage gsfLanguage = language.getGsfLanguage();
                if (gsfLanguage == null) continue;
                for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                    try {
                        URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                        this.urls.add(uRL);
                        ClassIndexManager.get(language).addBootRoot(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
        }
        return this.urls;
    }

    public List<FileObject> getLibraryFos() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Language language : this) {
            GsfLanguage gsfLanguage = language.getGsfLanguage();
            if (gsfLanguage == null) continue;
            for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                arrayList.add(fileObject);
            }
        }
        return arrayList;
    }

    public ClassPath getLibraryPaths() {
        if (this.libraryPath == null) {
            List<URL> list = this.getLibraryUrls();
            final URL[] uRLArray = list.toArray(new URL[list.size()]);
            this.libraryPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ClassPathImplementation(){

                public List<? extends PathResourceImplementation> getResources() {
                    return Collections.singletonList(new PathResourceImplementation(){

                        public URL[] getRoots() {
                            return uRLArray;
                        }

                        public ClassPathImplementation getContent() {
                            return null;
                        }

                        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }

                        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }
                    });
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }
            });
        }
        return this.libraryPath;
    }

    private void addLanguages(List<Language> list, TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            String string;
            Language language;
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                this.addLanguages(list, tokenSequence2, n);
            }
            if ((language = this.getLanguageByMimeType(string = tokenSequence.language().mimeType())) != null) {
                list.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getEmbeddedLanguages(BaseDocument baseDocument, int n) {
        Language language;
        Object object;
        ArrayList<Language> arrayList = new ArrayList<Language>();
        baseDocument.readLock();
        try {
            object = TokenHierarchy.get((Document)baseDocument).tokenSequence();
            if (object != null) {
                this.addLanguages((List<Language>)arrayList, (TokenSequence)object, n);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        object = (String)baseDocument.getProperty((Object)"mimeType");
        if (object != null && (language = LanguageRegistry.getInstance().getLanguageByMimeType((String)object)) != null && (arrayList.size() == 0 || arrayList.get(arrayList.size() - 1) != language)) {
            arrayList.add(language);
        }
        return arrayList;
    }

    public boolean isSupported(@NonNull String string) {
        if (string == null) {
            return false;
        }
        for (Language language : this) {
            if (!string.equals(language.getMimeType())) continue;
            return true;
        }
        return false;
    }

    public String getLanguagesDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Language language : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(language.getDisplayName());
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Language> iterator() {
        if (this.languages == null) {
            return new Iterator<Language>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Language next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.languages.iterator();
    }

    private synchronized void initialize() {
        if (this.languages == null) {
            this.readSfs();
            this.initializeLanguages();
        }
    }

    synchronized void initializeLanguages() {
        if (this.languagesInitialized) {
            return;
        }
        this.languagesInitialized = true;
        if (this.languages == null) {
            return;
        }
        for (Language language : this.languages) {
            this.initializeLanguage(language);
        }
    }

    private void readSfs() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(FOLDER);
        if (fileObject == null) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        this.languages = new ArrayList<Language>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            FileObject[] fileObjectArray2 = fileObject2.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                FileObject fileObject3;
                FileObject fileObject4;
                FileObject fileObject5;
                FileObject fileObject6;
                FileObject fileObject7;
                FileObject fileObject8;
                FileObject fileObject9;
                FileObject fileObject10;
                FileObject fileObject11;
                FileObject fileObject12;
                FileObject fileObject13;
                String string;
                FileObject fileObject14;
                FileObject fileObject15 = fileObjectArray2[j];
                String string2 = fileObject2.getName() + "/" + fileObject15.getName();
                DefaultLanguage defaultLanguage = new DefaultLanguage(string2);
                this.languages.add(defaultLanguage);
                Boolean bl = (Boolean)fileObject15.getAttribute("useCustomEditorKit");
                if (bl != null && bl.booleanValue()) {
                    defaultLanguage.setUseCustomEditorKit(true);
                }
                if ((fileObject14 = fileSystem.findResource("Loaders/" + string2)) != null && (string = (String)fileObject14.getAttribute(ICON_BASE)) != null && string.length() > 0) {
                    defaultLanguage.setIconBase(string);
                }
                if ((string = fileObject15.getFileObject(LANGUAGE, null)) != null) {
                    defaultLanguage.setGsfLanguageFile((FileObject)string);
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No GSF language registered for mime type " + string2);
                }
                FileObject fileObject16 = fileObject15.getFileObject(PARSER, null);
                if (fileObject16 != null) {
                    defaultLanguage.setParserFile(fileObject16);
                }
                if ((fileObject13 = fileObject15.getFileObject(COMPLETION, null)) != null) {
                    defaultLanguage.setCompletionProviderFile(fileObject13);
                }
                if ((fileObject12 = fileObject15.getFileObject(RENAMER, null)) != null) {
                    defaultLanguage.setInstantRenamerFile(fileObject12);
                }
                if ((fileObject11 = fileObject15.getFileObject(FORMATTER, null)) != null) {
                    defaultLanguage.setFormatterFile(fileObject11);
                }
                if ((fileObject10 = fileObject15.getFileObject(DECLARATION_FINDER, null)) != null) {
                    defaultLanguage.setDeclarationFinderFile(fileObject10);
                }
                if ((fileObject9 = fileObject15.getFileObject(BRACKET_COMPLETION, null)) != null) {
                    defaultLanguage.setBracketCompletionFile(fileObject9);
                }
                if ((fileObject8 = fileObject15.getFileObject(INDEXER, null)) != null) {
                    defaultLanguage.setIndexerFile(fileObject8);
                }
                if ((fileObject7 = fileObject15.getFileObject(STRUCTURE, null)) != null) {
                    defaultLanguage.setStructureFile(fileObject7);
                }
                if ((fileObject6 = fileObject15.getFileObject(HINTS, null)) != null) {
                    defaultLanguage.setHintsProviderFile(fileObject6);
                }
                if ((fileObject5 = fileObject15.getFileObject(PALETTE, null)) != null) {
                    defaultLanguage.setPaletteFile(fileObject5);
                }
                if ((fileObject4 = fileObject15.getFileObject(SEMANTIC, null)) != null) {
                    defaultLanguage.setSemanticAnalyzer(fileObject4);
                }
                if ((fileObject3 = fileObject15.getFileObject(OCCURRENCES, null)) == null) continue;
                defaultLanguage.setOccurrencesFinderFile(fileObject3);
            }
        }
    }

    private void initializeLanguage(Language language) {
        FileObject fileObject;
        String string;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        if (((DefaultLanguage)language).hasStructureScanner()) {
            string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance";
            fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                try {
                    FileUtil.createData((FileObject)fileSystem.getRoot(), (String)string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else {
            string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance";
            fileObject = fileSystem.findResource(string);
            if (fileObject != null) {
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if ((fileObject = fileSystem.findResource(string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-retouche-navigation-ClassMemberPanel.instance")) != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    void initializeLanguageForEditor(Language language) {
        String string;
        FileObject fileObject;
        Object object;
        FileObject fileObject2;
        FileObject fileObject3;
        FileObject fileObject4;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        final FileObject fileObject5 = fileSystem.findResource("Editors/" + language.getMimeType());
        if (fileObject5.getFileObject("Settings.settings") == null) {
            try {
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/gsf/GsfOptions.settings");
                            try {
                                FileObject fileObject = fileObject5.createData("Settings.settings");
                                OutputStream outputStream = fileObject.getOutputStream();
                                try {
                                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject5.getFileObject("SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance") == null && language.getParser() != null) {
            try {
                FileUtil.createData((FileObject)fileObject5, (String)"FoldManager/org-netbeans-modules-gsfret-editor-fold-GsfFoldManagerFactory.instance");
                FileUtil.createData((FileObject)fileObject5, (String)"SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance").setAttribute("position", (Object)1200);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        boolean bl = false;
        FileObject fileObject6 = fileObject5.getFileObject("SideBar/org-netbeans-modules-editor-retouche-GsfCodeFoldingSideBarFactory.instance");
        if (fileObject6 != null) {
            bl = true;
            try {
                fileObject6.delete();
                fileObject6 = fileObject5.getFileObject("FoldManager/org-netbeans-modules-retouche-editor-fold-GsfFoldManagerFactory.instance");
                if (fileObject6 != null) {
                    fileObject6.delete();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((fileObject4 = fileObject5.getFileObject("HyperlinkProviders/GsfHyperlinkProvider.instance")) == null) {
            try {
                fileObject4 = FileUtil.createData((FileObject)fileObject5, (String)"HyperlinkProviders/GsfHyperlinkProvider.instance");
                fileObject4.setAttribute("instanceClass", (Object)"org.netbeans.modules.gsfret.editor.hyperlink.GsfHyperlinkProvider");
                fileObject4.setAttribute("instanceOf", (Object)"org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            if (bl && "org.netbeans.modules.retouche.editor.hyperlink.GsfHyperlinkProvider".equals(fileObject4.getAttribute("instanceClass"))) {
                try {
                    fileObject4.setAttribute("instanceClass", (Object)"org.netbeans.modules.gsfret.editor.hyperlink.GsfHyperlinkProvider");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if ("org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider".equals(fileObject4.getAttribute("instanceOf"))) {
                try {
                    fileObject4.setAttribute("instanceOf", (Object)"org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if ((fileObject3 = fileObject5.getFileObject("Popup")) == null) {
            try {
                fileObject3 = fileObject5.createFolder("Popup");
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if ((fileObject2 = fileObject3.getFileObject("in-place-refactoring")) == null) {
            try {
                fileObject3.createData("in-place-refactoring").setAttribute("position", (Object)680);
                object = fileObject3.getFileObject("goto");
                if (object == null) {
                    object = fileObject3.createFolder("goto");
                    object.setAttribute("position", (Object)500);
                }
                object.setAttribute("SystemFileSystem.localizingBundle", (Object)"org.netbeans.modules.gsf.Bundle");
                object.createData("goto-declaration").setAttribute("position", (Object)500);
                object.createData("goto").setAttribute("position", (Object)600);
                if (fileObject3.getFileObject("SeparatorBeforeCut.instance") == null) {
                    fileObject = fileObject3.createData("SeparatorBeforeCut.instance");
                    fileObject.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                    fileObject.setAttribute("position", (Object)1200);
                }
                if (fileObject3.getFileObject("format") == null) {
                    fileObject3.createData("format").setAttribute("position", (Object)750);
                }
                fileObject = fileObject3.createData("SeparatorAfterFormat.instance");
                fileObject.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                fileObject.setAttribute("position", (Object)780);
                if (bl && fileObject3.getFileObject("pretty-print") != null) {
                    fileObject3.getFileObject("pretty-print").delete();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            if (bl && fileObject3.getFileObject("generate-goto-popup") != null) {
                object = fileObject3.getFileObject("generate-goto-popup");
                try {
                    object.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && fileObject5.getFileObject("Popup/format") == null) {
                try {
                    fileObject3.createData("format");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && fileObject5.getFileObject("Popup/pretty-print") != null) {
                try {
                    object = fileObject5.getFileObject("Popup/pretty-print");
                    object.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (fileObject5.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance") == null) {
            try {
                FileUtil.createData((FileObject)fileObject5, (String)"UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (object = fileObject5.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
            try {
                object.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject5.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance") == null) {
            try {
                FileUtil.createData((FileObject)fileObject5, (String)"UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (object = fileObject5.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
            try {
                object.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((fileObject = fileObject5.getFileObject((String)(object = "CompletionProviders"))) == null) {
            try {
                fileObject = fileObject5.createFolder((String)object);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject != null) {
            FileObject fileObject7;
            string = "org-netbeans-lib-editor-codetemplates-CodeTemplateCompletionProvider.instance";
            FileObject fileObject8 = fileObject5.getFileObject((String)object + "/" + string);
            if (fileObject8 == null) {
                try {
                    fileObject.createData(string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            String string2 = "org-netbeans-modules-gsfret-editor-completion-GsfCompletionProvider.instance";
            FileObject fileObject9 = fileObject5.getFileObject((String)object + "/" + string2);
            if (fileObject9 == null) {
                try {
                    fileObject.createData(string2);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && (fileObject7 = fileObject.getFileObject("org-netbeans-modules-retouche-editor-completion-GsfCompletionProvider.instance")) != null) {
                try {
                    fileObject7.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (fileObject5.getFileObject("Toolbars/Default/comment") == null && language.getGsfLanguage() != null && language.getGsfLanguage().getLineCommentPrefix() != null) {
            try {
                string = FileUtil.createData((FileObject)fileObject5, (String)"Toolbars/Default/Separator-before-comment.instance");
                string.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                string.setAttribute("position", (Object)30000);
                FileUtil.createData((FileObject)fileObject5, (String)"Toolbars/Default/comment").setAttribute("position", (Object)30100);
                FileUtil.createData((FileObject)fileObject5, (String)"Toolbars/Default/uncomment").setAttribute("position", (Object)30200);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject5.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance") == null) {
            try {
                string = FileUtil.createData((FileObject)fileObject5, (String)"CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (string = fileObject5.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
            try {
                string.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject5.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance") == null) {
            try {
                string = FileUtil.createData((FileObject)fileObject5, (String)"CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (string = fileObject5.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
            try {
                string.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

