/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class GsfOptions
extends BaseOptions {
    public static String LANGUAGES = "ScriptLanguages";
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_CASE_SENSITIVE_PROP = "completionCaseSensitive";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    public static final String CODE_FOLDING_COLLAPSE_METHOD = "code-folding-collapse-method";
    public static final String CODE_FOLDING_COLLAPSE_INNERCLASS = "code-folding-collapse-innerclass";
    public static final String CODE_FOLDING_COLLAPSE_IMPORT = "code-folding-collapse-import";
    public static final String CODE_FOLDING_COLLAPSE_JAVADOC = "code-folding-collapse-javadoc";
    public static final String CODE_FOLDING_COLLAPSE_INITIAL_COMMENT = "code-folding-collapse-initial-comment";
    private static GsfOptions defaultInstance;
    private static final String HELP_ID = "editing.editor.gsf";
    private String mimeType;

    public static synchronized GsfOptions create(FileObject fileObject) {
        if (defaultInstance == null) {
            String string = fileObject.getParent().getPath().substring(8);
            defaultInstance = new GsfOptions(string);
        }
        return defaultInstance;
    }

    public GsfOptions(String string) {
        super(GsfEditorKitFactory.GsfEditorKit.class, LANGUAGES);
        this.mimeType = string;
    }

    protected String getContentType() {
        return this.mimeType;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String getString(String string) {
        try {
            return NbBundle.getMessage(GsfOptions.class, (String)string);
        }
        catch (MissingResourceException missingResourceException) {
            return super.getString(string);
        }
    }

    public MIMEOptionNode getMimeNode() {
        return null;
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean bl) {
        this.setSettingBoolean("completion-auto-popup", bl, COMPLETION_AUTO_POPUP_PROP);
    }

    public boolean getCompletionCaseSensitive() {
        return this.getSettingBoolean("completion-case-sensitive");
    }

    public void setCompletionCaseSensitive(boolean bl) {
        this.setSettingBoolean("completion-case-sensitive", bl, COMPLETION_CASE_SENSITIVE_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean bl) {
        this.setSettingBoolean("completion-instant-substitution", bl, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", n, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public Map getCodeFoldingProps() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(super.getCodeFoldingProps());
        Boolean bl = (Boolean)this.getSettingValue(CODE_FOLDING_COLLAPSE_METHOD);
        hashMap.put(CODE_FOLDING_COLLAPSE_METHOD, bl);
        bl = (Boolean)this.getSettingValue(CODE_FOLDING_COLLAPSE_INNERCLASS);
        hashMap.put(CODE_FOLDING_COLLAPSE_INNERCLASS, bl);
        bl = (Boolean)this.getSettingValue(CODE_FOLDING_COLLAPSE_IMPORT);
        hashMap.put(CODE_FOLDING_COLLAPSE_IMPORT, bl);
        bl = (Boolean)this.getSettingValue(CODE_FOLDING_COLLAPSE_JAVADOC);
        hashMap.put(CODE_FOLDING_COLLAPSE_JAVADOC, bl);
        bl = (Boolean)this.getSettingValue(CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
        hashMap.put(CODE_FOLDING_COLLAPSE_INITIAL_COMMENT, bl);
        return hashMap;
    }

    public void setCodeFoldingProps(Map map) {
        String string = "code-folding-enable";
        this.setSettingValue(string, map.get(string));
        string = CODE_FOLDING_COLLAPSE_METHOD;
        this.setSettingValue(string, map.get(string));
        string = CODE_FOLDING_COLLAPSE_INNERCLASS;
        this.setSettingValue(string, map.get(string));
        string = CODE_FOLDING_COLLAPSE_IMPORT;
        this.setSettingValue(string, map.get(string));
        string = CODE_FOLDING_COLLAPSE_JAVADOC;
        this.setSettingValue(string, map.get(string));
        string = CODE_FOLDING_COLLAPSE_INITIAL_COMMENT;
        this.setSettingValue(string, map.get(string));
    }
}

