/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.GsfLanguage;

public class GsfDocument
extends NbEditorDocument {
    private Language language;
    private org.netbeans.editor.Formatter formatter;

    public GsfDocument(Class clazz, Language language) {
        super(clazz);
        if (language.getGsfLanguage() != null) {
            this.putProperty(org.netbeans.api.lexer.Language.class, language.getGsfLanguage().getLexerLanguage());
        }
        this.language = language;
    }

    public boolean isIdentifierPart(char c) {
        GsfLanguage gsfLanguage = this.language.getGsfLanguage();
        if (gsfLanguage != null) {
            return gsfLanguage.isIdentifierChar(c);
        }
        return super.isIdentifierPart(c);
    }

    public boolean addLayer(DrawLayer drawLayer, int n) {
        if (DrawLayerFactory.SyntaxLayer.class.equals(drawLayer.getClass())) {
            return false;
        }
        return super.addLayer(drawLayer, n);
    }

    public org.netbeans.editor.Formatter getFormatter() {
        if (this.formatter == null) {
            Settings.setValue((Class)this.getKitClass(), (String)"formatter", (Object)new ExtFormatter(GsfEditorKitFactory.GsfEditorKit.class));
            this.formatter = super.getFormatter();
        }
        return this.formatter;
    }

    public int getShiftWidth() {
        int n;
        Formatter formatter = this.language.getFormatter();
        if (formatter != null && (n = formatter.indentSize()) > 0) {
            return n;
        }
        return super.getShiftWidth();
    }
}

