/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import org.netbeans.modules.gsf.GsfDataObject;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class GsfDataLoader
extends UniFileLoader {
    boolean initialized;

    public GsfDataLoader() {
        super("org.netbeans.modules.gsf.GsfDataObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensionList = this.getExtensions();
        for (Language language : LanguageRegistry.getInstance()) {
            if (language.useCustomEditorKit()) continue;
            extensionList.addMimeType(language.getMimeType());
        }
        this.initialized = true;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
        return new GsfDataObject(fileObject, (MultiFileLoader)this, language);
    }

    protected String defaultDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Language language : LanguageRegistry.getInstance()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(language.getDisplayName());
        }
        return NbBundle.getMessage(GsfDataLoader.class, (String)"GenericLoaderName", (Object)stringBuilder.toString());
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        FileEntry.Format format = new FileEntry.Format(multiDataObject, fileObject){

            protected Format createFormat(FileObject fileObject, String string, String string2) {
                String string3;
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                String string4 = "";
                if (classPath != null) {
                    string4 = classPath.getResourceName(fileObject);
                } else {
                    ErrorManager.getDefault().log(16, "No classpath was found for folder: " + fileObject);
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("NAME", string);
                String string5 = string.length() > 1 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : "" + Character.toUpperCase(string.charAt(0));
                hashMap.put("CAPITALIZEDNAME", string5);
                hashMap.put("LOWERNAME", string.toLowerCase());
                hashMap.put("UPPERNAME", string.toUpperCase());
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    stringBuilder.append(c);
                }
                String string6 = stringBuilder.toString();
                hashMap.put("IDENTIFIER", string6);
                stringBuilder.setCharAt(0, Character.toUpperCase(string6.charAt(0)));
                hashMap.put("CAPITALIZEDIDENTIFIER", stringBuilder.toString());
                hashMap.put("LOWERIDENTIFIER", string6.toLowerCase());
                String string7 = string4.replace('/', '.');
                hashMap.put("PACKAGE", string7);
                if (string7 == null || string7.length() == 0) {
                    string7 = "";
                    string3 = "";
                } else {
                    string3 = string7.length() > 1 ? Character.toUpperCase(string7.charAt(0)) + string7.substring(1) : "" + Character.toUpperCase(string7.charAt(0));
                }
                hashMap.put("CAPITALIZEDPACKAGE", string3);
                hashMap.put("PACKAGE_SLASHES", string4);
                if (fileObject.isRoot()) {
                    hashMap.put("PACKAGE_AND_NAME", string);
                    hashMap.put("PACKAGE_AND_NAME_SLASHES", string);
                } else {
                    hashMap.put("PACKAGE_AND_NAME", string4.replace('/', '.') + '.' + string);
                    hashMap.put("PACKAGE_AND_NAME_SLASHES", string4 + '/' + string);
                }
                hashMap.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
                hashMap.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
                MapFormat mapFormat = new MapFormat(hashMap);
                mapFormat.setLeftBrace("__");
                mapFormat.setRightBrace("__");
                return mapFormat;
            }
        };
        return format;
    }
}

