/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsfret.editor.semantic.ColoringManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLanguage
implements Language {
    private ColoringManager coloringManager;
    private String iconBase;
    private String mime;
    private boolean useCustomEditorKit;
    private List<Action> actions;
    private GsfLanguage language;
    private Parser parser;
    private Completable completionProvider;
    private InstantRenamer renamer;
    private DeclarationFinder declarationFinder;
    private Formatter formatter;
    private BracketCompletion bracketCompletion;
    private Indexer indexer;
    private StructureScanner structure;
    private HintsProvider hintsProvider;
    private OccurrencesFinder occurrences;
    private SemanticAnalyzer semantic;
    private FileObject parserFile;
    private FileObject languageFile;
    private FileObject completionProviderFile;
    private FileObject renamerFile;
    private FileObject declarationFinderFile;
    private FileObject formatterFile;
    private FileObject bracketCompletionFile;
    private FileObject indexerFile;
    private FileObject structureFile;
    private FileObject hintsProviderFile;
    private FileObject paletteFile;
    private FileObject semanticFile;
    private FileObject occurrencesFile;

    public DefaultLanguage(String string) {
        this.mime = string;
    }

    public DefaultLanguage(String string, String string2, List<Action> list, GsfLanguage gsfLanguage, Parser parser, Completable completable, InstantRenamer instantRenamer, DeclarationFinder declarationFinder, Formatter formatter, BracketCompletion bracketCompletion, Indexer indexer, StructureScanner structureScanner, Object object, boolean bl) {
        this.iconBase = string;
        this.mime = string2;
        this.actions = list;
        this.language = gsfLanguage;
        this.parser = parser;
        this.completionProvider = completable;
        this.renamer = instantRenamer;
        this.declarationFinder = declarationFinder;
        this.formatter = formatter;
        this.bracketCompletion = bracketCompletion;
        this.indexer = indexer;
        this.structure = structureScanner;
        this.useCustomEditorKit = bl;
    }

    @Override
    public boolean useCustomEditorKit() {
        return this.useCustomEditorKit;
    }

    public void setUseCustomEditorKit(boolean bl) {
        this.useCustomEditorKit = bl;
    }

    @Override
    public String getDisplayName() {
        return this.getGsfLanguage().getDisplayName();
    }

    @Override
    public String getIconBase() {
        return this.iconBase;
    }

    public void setIconBase(String string) {
        this.iconBase = string;
    }

    @Override
    public String getMimeType() {
        return this.mime;
    }

    public void setMimeType(String string) {
        this.mime = string;
    }

    @Override
    public Action[] getEditorActions() {
        if (this.actions != null) {
            return this.actions.toArray(new Action[this.actions.size()]);
        }
        return new Action[0];
    }

    @Override
    public GsfLanguage getGsfLanguage() {
        if (this.language == null && this.languageFile != null) {
            this.language = (GsfLanguage)this.createInstance(this.languageFile);
            if (this.language == null) {
                this.languageFile = null;
            }
        }
        return this.language;
    }

    public void setGsfLanguageFile(FileObject fileObject) {
        this.languageFile = fileObject;
    }

    @Override
    public Parser getParser() {
        if (this.parser == null && this.parserFile != null) {
            this.parser = (Parser)this.createInstance(this.parserFile);
            if (this.parser == null) {
                this.parserFile = null;
            }
        }
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setParserFile(FileObject fileObject) {
        this.parserFile = fileObject;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
    }

    private Object createInstance(FileObject fileObject) {
        assert (fileObject.getExt().equals("instance"));
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            return instanceCookie.instanceCreate();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return null;
    }

    public String toString() {
        return this.mime + ":" + this.getDisplayName();
    }

    @Override
    public Completable getCompletionProvider() {
        if (this.completionProvider == null && this.completionProviderFile != null) {
            this.completionProvider = (Completable)this.createInstance(this.completionProviderFile);
            if (this.completionProvider == null) {
                this.completionProviderFile = null;
            }
        }
        return this.completionProvider;
    }

    public void setCompletionProvider(Completable completable) {
        this.completionProvider = completable;
    }

    public void setCompletionProviderFile(FileObject fileObject) {
        this.completionProviderFile = fileObject;
    }

    @Override
    public InstantRenamer getInstantRenamer() {
        if (this.renamer == null && this.renamerFile != null) {
            this.renamer = (InstantRenamer)this.createInstance(this.renamerFile);
            if (this.renamer == null) {
                this.renamerFile = null;
            }
        }
        return this.renamer;
    }

    public void setInstantRenamerFile(FileObject fileObject) {
        this.renamerFile = fileObject;
    }

    @Override
    public DeclarationFinder getDeclarationFinder() {
        if (this.declarationFinder == null && this.declarationFinderFile != null) {
            this.declarationFinder = (DeclarationFinder)this.createInstance(this.declarationFinderFile);
            if (this.declarationFinder == null) {
                this.declarationFinderFile = null;
            }
        }
        return this.declarationFinder;
    }

    public void setDeclarationFinderFile(FileObject fileObject) {
        this.declarationFinderFile = fileObject;
    }

    @Override
    public Formatter getFormatter() {
        if (this.formatter == null && this.formatterFile != null) {
            this.formatter = (Formatter)this.createInstance(this.formatterFile);
            if (this.formatter == null) {
                this.formatterFile = null;
            }
        }
        return this.formatter;
    }

    public void setFormatterFile(FileObject fileObject) {
        this.formatterFile = fileObject;
    }

    @Override
    public BracketCompletion getBracketCompletion() {
        if (this.bracketCompletion == null && this.bracketCompletionFile != null) {
            this.bracketCompletion = (BracketCompletion)this.createInstance(this.bracketCompletionFile);
            if (this.bracketCompletion == null) {
                this.bracketCompletionFile = null;
            }
        }
        return this.bracketCompletion;
    }

    public void setBracketCompletionFile(FileObject fileObject) {
        this.bracketCompletionFile = fileObject;
    }

    @Override
    public Indexer getIndexer() {
        if (this.indexer == null && this.indexerFile != null) {
            this.indexer = (Indexer)this.createInstance(this.indexerFile);
            if (this.indexer == null) {
                this.indexerFile = null;
            }
        }
        return this.indexer;
    }

    public void setIndexerFile(FileObject fileObject) {
        this.indexerFile = fileObject;
    }

    @Override
    public StructureScanner getStructure() {
        if (this.structure == null && this.structureFile != null) {
            this.structure = (StructureScanner)this.createInstance(this.structureFile);
            if (this.structure == null) {
                this.structureFile = null;
            }
        }
        return this.structure;
    }

    public void setStructureFile(FileObject fileObject) {
        this.structureFile = fileObject;
    }

    @Override
    public HintsProvider getHintsProvider() {
        if (this.hintsProvider == null && this.hintsProviderFile != null) {
            this.hintsProvider = (HintsProvider)this.createInstance(this.hintsProviderFile);
            if (this.hintsProvider == null) {
                this.hintsProviderFile = null;
            }
        }
        return this.hintsProvider;
    }

    public void setHintsProviderFile(FileObject fileObject) {
        this.hintsProviderFile = fileObject;
    }

    public void setPaletteFile(FileObject fileObject) {
        this.paletteFile = fileObject;
    }

    @Override
    public ColoringManager getColoringManager() {
        if (this.coloringManager == null) {
            this.coloringManager = new ColoringManager(this.mime);
        }
        return this.coloringManager;
    }

    public boolean hasStructureScanner() {
        return this.structureFile != null;
    }

    public boolean hasFormatter() {
        return this.formatterFile != null;
    }

    @Override
    public OccurrencesFinder getOccurrencesFinder() {
        if (this.occurrences == null && this.occurrencesFile != null) {
            this.occurrences = (OccurrencesFinder)this.createInstance(this.occurrencesFile);
            if (this.occurrences == null) {
                this.occurrencesFile = null;
            }
        }
        return this.occurrences;
    }

    public void setOccurrencesFinderFile(FileObject fileObject) {
        this.occurrencesFile = fileObject;
    }

    @Override
    public SemanticAnalyzer getSemanticAnalyzer() {
        if (this.semantic == null && this.semanticFile != null) {
            this.semantic = (SemanticAnalyzer)this.createInstance(this.semanticFile);
            if (this.semantic == null) {
                this.semanticFile = null;
            }
        }
        return this.semantic;
    }

    public void setSemanticAnalyzer(FileObject fileObject) {
        this.semanticFile = fileObject;
    }
}

