/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenVisitor;
import org.netbeans.modules.java.editor.overridden.ReverseSourceRootsLookup;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsOverriddenAnnotationHandler
implements CancellableTask<CompilationInfo> {
    private static final boolean enableReverseLookups = Boolean.getBoolean("org.netbeans.java.editor.enableReverseLookups");
    static final Logger LOG = Logger.getLogger(IsOverriddenAnnotationHandler.class.getName());
    private FileObject file;
    private IsOverriddenVisitor visitor;
    private static final ClassPath EMPTY = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private boolean canceled;

    IsOverriddenAnnotationHandler(FileObject fileObject) {
        this.file = fileObject;
        Logger.getLogger("TIMER").log(Level.FINE, "IsOverriddenAnnotationHandler", new Object[]{fileObject, this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo compilationInfo) throws IOException {
        Object object;
        long l;
        block13: {
            IsOverriddenAnnotationHandler isOverriddenAnnotationHandler;
            this.resume();
            StyledDocument styledDocument = (StyledDocument)compilationInfo.getDocument();
            if (styledDocument == null) {
                LOG.log(Level.FINE, "Cannot get document!");
                return;
            }
            l = System.currentTimeMillis();
            try {
                object = this.process(compilationInfo, styledDocument);
                if (object != null) break block13;
                isOverriddenAnnotationHandler = this;
            }
            catch (Throwable throwable) {
                IsOverriddenAnnotationHandler isOverriddenAnnotationHandler2 = this;
                synchronized (isOverriddenAnnotationHandler2) {
                    this.visitor = null;
                }
                Logger.getLogger("TIMER").log(Level.FINE, "Overridden in", new Object[]{this.file, System.currentTimeMillis() - l});
                throw throwable;
            }
            synchronized (isOverriddenAnnotationHandler) {
                this.visitor = null;
            }
            Logger.getLogger("TIMER").log(Level.FINE, "Overridden in", new Object[]{this.file, System.currentTimeMillis() - l});
            return;
        }
        this.newAnnotations((List<IsOverriddenAnnotation>)object);
        object = this;
        synchronized (object) {
            this.visitor = null;
        }
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden in", new Object[]{this.file, System.currentTimeMillis() - l});
    }

    private FileObject findSourceRoot() {
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.file, (String)"classpath/source");
        if (classPath != null) {
            for (FileObject fileObject : classPath.getRoots()) {
                if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)this.file)) continue;
                return fileObject;
            }
        }
        return null;
    }

    private synchronized Set<FileObject> findReverseSourceRoots(final FileObject fileObject, final FileObject fileObject2) {
        final Object object = new Object();
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long l = System.currentTimeMillis();
                HashSet<FileObject> hashSet2 = new HashSet<FileObject>(ReverseSourceRootsLookup.reverseSourceRootsLookup(fileObject));
                long l2 = System.currentTimeMillis();
                Logger.getLogger("TIMER").log(Level.FINE, "Find Reverse Source Roots", new Object[]{fileObject2, l2 - l});
                Object object2 = object;
                synchronized (object2) {
                    hashSet.addAll(hashSet2);
                }
                IsOverriddenAnnotationHandler.this.wakeUp();
            }
        });
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
        }
        return hashSet;
    }

    public static AnnotationType detectOverrides(CompilationInfo compilationInfo, TypeElement typeElement, ExecutableElement executableElement, List<ElementDescription> list) {
        HashMap<Name, List<ExecutableElement>> hashMap = new HashMap<Name, List<ExecutableElement>>();
        IsOverriddenAnnotationHandler.sortOutMethods(compilationInfo, hashMap, typeElement, false);
        List list2 = (List)hashMap.get(executableElement.getSimpleName());
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        HashSet<ExecutableElement> hashSet = new HashSet<ExecutableElement>();
        for (ExecutableElement object : list2) {
            if (!compilationInfo.getElements().overrides(executableElement, object, SourceUtils.getEnclosingTypeElement((Element)executableElement)) || !hashSet.add(object)) continue;
            list.add(new ElementDescription(compilationInfo, object));
        }
        if (!list.isEmpty()) {
            for (ElementDescription elementDescription : list) {
                if (elementDescription.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                return AnnotationType.OVERRIDES;
            }
            return AnnotationType.IMPLEMENTS;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IsOverriddenAnnotation> process(CompilationInfo compilationInfo, StyledDocument styledDocument) {
        Set<FileObject> set;
        Object object;
        IsOverriddenVisitor isOverriddenVisitor;
        Object object2 = this;
        synchronized (object2) {
            if (this.isCanceled()) {
                return null;
            }
            isOverriddenVisitor = this.visitor = new IsOverriddenVisitor(styledDocument, compilationInfo);
        }
        object2 = compilationInfo.getCompilationUnit();
        long l = System.currentTimeMillis();
        isOverriddenVisitor.scan((Tree)object2, null);
        long l2 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden Scanner", new Object[]{this.file, l2 - l});
        if (enableReverseLookups) {
            object = this.findSourceRoot();
            if (object == null) {
                return null;
            }
            set = this.findReverseSourceRoots((FileObject)object, compilationInfo.getFileObject());
            set.add((FileObject)object);
        } else {
            set = null;
        }
        LOG.log(Level.FINE, "reverseSourceRoots: {0}", set);
        object = new ArrayList();
        for (ElementHandle<TypeElement> elementHandle : isOverriddenVisitor.type2Declaration.keySet()) {
            Object object4;
            Object object5;
            AbstractCollection abstractCollection;
            Object object6;
            Parameterizable parameterizable;
            Object object722;
            if (this.isCanceled()) {
                return null;
            }
            LOG.log(Level.FINE, "type: {0}", elementHandle.getQualifiedName());
            HashMap<Name, List<ExecutableElement>> hashMap = new HashMap<Name, List<ExecutableElement>>();
            TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationInfo);
            if (typeElement == null) continue;
            IsOverriddenAnnotationHandler.sortOutMethods(compilationInfo, hashMap, typeElement, false);
            for (Object object722 : isOverriddenVisitor.type2Declaration.get(elementHandle)) {
                int n;
                if (this.isCanceled()) {
                    return null;
                }
                parameterizable = (ExecutableElement)object722.resolve(compilationInfo);
                if (parameterizable == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "method: {0}", parameterizable.toString());
                }
                if ((object6 = (List)hashMap.get(parameterizable.getSimpleName())) == null || object6.isEmpty()) continue;
                abstractCollection = new HashSet();
                ArrayList<ElementDescription> arrayList = new ArrayList<ElementDescription>();
                Iterator iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object5 = (ExecutableElement)iterator.next();
                    if (!compilationInfo.getElements().overrides((ExecutableElement)parameterizable, (ExecutableElement)object5, SourceUtils.getEnclosingTypeElement((Element)parameterizable)) || !abstractCollection.add((long[])object5)) continue;
                    arrayList.add(new ElementDescription(compilationInfo, (Element)object5));
                }
                if (arrayList.isEmpty() || (object5 = (Object)IsOverriddenAnnotationHandler.getPosition(styledDocument, n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), isOverriddenVisitor.declaration2Tree.get(object722)))) == null) continue;
                object4 = new StringBuffer();
                boolean bl = false;
                boolean bl2 = false;
                for (ElementDescription elementDescription : arrayList) {
                    if (bl2) {
                        ((StringBuffer)object4).append("\n");
                    }
                    bl2 = true;
                    if (elementDescription.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        ((StringBuffer)object4).append(NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"TP_Implements", (Object)elementDescription.getDisplayName()));
                        continue;
                    }
                    ((StringBuffer)object4).append(NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"TP_Overrides", (Object)elementDescription.getDisplayName()));
                    bl = true;
                }
                object.add(new IsOverriddenAnnotation(styledDocument, (Position)object5, bl ? AnnotationType.OVERRIDES : AnnotationType.IMPLEMENTS, ((StringBuffer)object4).toString(), arrayList));
            }
            if (!enableReverseLookups) continue;
            Object object8 = null;
            object722 = null;
            parameterizable = (TypeElement)elementHandle.resolve(compilationInfo);
            if (parameterizable == null) {
                Logger.getLogger("global").log(Level.SEVERE, "IsOverriddenAnnotationHandler: resolved == null!");
                continue;
            }
            if (parameterizable.getKind().isInterface()) {
                object8 = NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"CAP_HasImplementations");
                object722 = AnnotationType.HAS_IMPLEMENTATION;
            }
            if (parameterizable.getKind().isClass()) {
                object8 = NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"CAP_IsOverridden");
                object722 = AnnotationType.IS_OVERRIDDEN;
            }
            object6 = new HashMap();
            abstractCollection = new ArrayList();
            long l3 = System.currentTimeMillis();
            object5 = new long[1];
            object4 = this.computeUsers(set, (ElementHandle<TypeElement>)ElementHandle.create((Element)parameterizable), (long[])object5);
            long l4 = System.currentTimeMillis();
            if (object4 == null) {
                return null;
            }
            Logger.getLogger("TIMER").log(Level.FINE, "Overridden Users Class Index", new Object[]{this.file, object5[0]});
            Logger.getLogger("TIMER").log(Level.FINE, "Overridden Users", new Object[]{this.file, l4 - l3});
            Object object9 = object4.entrySet().iterator();
            while (object9.hasNext()) {
                Map.Entry entry = (Map.Entry)object9.next();
                if (this.isCanceled()) {
                    return null;
                }
                this.findOverriddenAnnotations((FileObject)entry.getKey(), (Set)entry.getValue(), elementHandle, isOverriddenVisitor.type2Declaration.get(elementHandle), (Map<ElementHandle<ExecutableElement>, List<ElementDescription>>)object6, (List<ElementDescription>)((Object)abstractCollection));
            }
            if (!abstractCollection.isEmpty() && (object9 = (Tree)isOverriddenVisitor.declaration2Class.get(elementHandle)) != null) {
                Position position = IsOverriddenAnnotationHandler.getPosition(styledDocument, (int)compilationInfo.getTrees().getSourcePositions().getStartPosition((CompilationUnitTree)object2, (Tree)object9));
                if (position == null) continue;
                object.add(new IsOverriddenAnnotation(styledDocument, position, (AnnotationType)((Object)object722), ((String)object8).toString(), (List<ElementDescription>)((Object)abstractCollection)));
            }
            for (ElementHandle elementHandle2 : object6.keySet()) {
                if (this.isCanceled()) {
                    return null;
                }
                Position position = IsOverriddenAnnotationHandler.getPosition(styledDocument, (int)compilationInfo.getTrees().getSourcePositions().getStartPosition((CompilationUnitTree)object2, isOverriddenVisitor.declaration2Tree.get(elementHandle2)));
                if (position == null) continue;
                Set<Modifier> set2 = ((ExecutableElement)elementHandle2.resolve(compilationInfo)).getModifiers();
                String string = null;
                string = set2.contains((Object)Modifier.ABSTRACT) ? NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"TP_HasImplementations") : NbBundle.getMessage(IsOverriddenAnnotationHandler.class, (String)"TP_IsOverridden");
                IsOverriddenAnnotation isOverriddenAnnotation = new IsOverriddenAnnotation(styledDocument, position, set2.contains((Object)Modifier.ABSTRACT) ? AnnotationType.HAS_IMPLEMENTATION : AnnotationType.IS_OVERRIDDEN, string, (List)object6.get(elementHandle2));
                object.add(isOverriddenAnnotation);
            }
        }
        if (this.isCanceled()) {
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ElementHandle<TypeElement>> computeUsers(FileObject fileObject, Set<ElementHandle<TypeElement>> set, long[] lArray) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)EMPTY, (ClassPath)EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject}));
        long l = System.currentTimeMillis();
        try {
            ElementHandle elementHandle;
            LinkedList<ElementHandle<TypeElement>> linkedList = new LinkedList<ElementHandle<TypeElement>>(set);
            ElementHandle elementHandle2 = new HashSet();
            while (!linkedList.isEmpty()) {
                elementHandle = (ElementHandle)linkedList.remove(0);
                elementHandle2.add(elementHandle);
                Set set2 = classpathInfo.getClassIndex().getElements(elementHandle, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                if (set2 == null) continue;
                linkedList.addAll(set2);
            }
            elementHandle = elementHandle2;
            return elementHandle;
        }
        finally {
            lArray[0] = lArray[0] + (System.currentTimeMillis() - l);
        }
    }

    private Map<FileObject, Set<ElementHandle<TypeElement>>> computeUsers(Set<FileObject> set, ElementHandle<TypeElement> elementHandle, long[] lArray) {
        Object object;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (FileObject object22 : set) {
            hashMap.put(object22, new ArrayList());
        }
        for (FileObject fileObject : set) {
            object = new ArrayList();
            hashMap2.put(fileObject, object);
            for (Object object2 : ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile").entries()) {
                for (FileObject fileObject2 : SourceForBinaryQuery.findSourceRoots((URL)object2.getURL()).getRoots()) {
                    Collection collection = (Collection)hashMap.get(fileObject2);
                    if (collection != null) {
                        collection.add(fileObject);
                    }
                    object.add(fileObject2);
                }
            }
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(set);
        try {
            Utilities.topologicalSort((Collection)arrayList, hashMap);
        }
        catch (TopologicalSortException topologicalSortException) {
            LOG.log(Level.WARNING, "internal error", topologicalSortException);
            return null;
        }
        HashMap<FileObject, Set<ElementHandle<TypeElement>>> hashMap3 = new HashMap<FileObject, Set<ElementHandle<TypeElement>>>();
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object object2;
            FileObject fileObject = (FileObject)object.next();
            object2 = new HashSet();
            object2.add(elementHandle);
            for (FileObject fileObject3 : (Collection)hashMap2.get(fileObject)) {
                Set set2 = (Set)hashMap3.get(fileObject3);
                if (set2 == null) continue;
                object2.addAll(set2);
            }
            Set<ElementHandle<TypeElement>> set3 = this.computeUsers(fileObject, (Set<ElementHandle<TypeElement>>)object2, lArray);
            set3.removeAll((Collection<?>)object2);
            hashMap3.put(fileObject, set3);
        }
        return hashMap3;
    }

    private void findOverriddenAnnotations(FileObject fileObject, final Set<ElementHandle<TypeElement>> set, final ElementHandle<TypeElement> elementHandle, final List<ElementHandle<ExecutableElement>> list, final Map<ElementHandle<ExecutableElement>, List<ElementDescription>> map, final List<ElementDescription> list2) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
        if (!set.isEmpty()) {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        HashSet<Element> hashSet = new HashSet<Element>();
                        for (ElementHandle elementHandle3 : set) {
                            if (IsOverriddenAnnotationHandler.this.isCanceled()) {
                                return;
                            }
                            TypeElement typeElement = (TypeElement)elementHandle3.resolve((CompilationInfo)compilationController);
                            Element element = elementHandle.resolve((CompilationInfo)compilationController);
                            if (!hashSet.add(element) || !compilationController.getTypes().isSubtype(typeElement.asType(), element.asType())) continue;
                            list2.add(new ElementDescription((CompilationInfo)compilationController, typeElement));
                            for (ElementHandle elementHandle2 : list) {
                                ExecutableElement executableElement = (ExecutableElement)elementHandle2.resolve((CompilationInfo)compilationController);
                                if (executableElement != null) {
                                    ExecutableElement executableElement2 = IsOverriddenAnnotationHandler.this.getImplementationOf((CompilationInfo)compilationController, executableElement, typeElement);
                                    if (executableElement2 == null) continue;
                                    ArrayList<ElementDescription> arrayList = (ArrayList<ElementDescription>)map.get(elementHandle2);
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<ElementDescription>();
                                        map.put(elementHandle2, arrayList);
                                    }
                                    arrayList.add(new ElementDescription((CompilationInfo)compilationController, executableElement2));
                                    continue;
                                }
                                Logger.getLogger("global").log(Level.SEVERE, "IsOverriddenAnnotationHandler: originalMethod == null!");
                            }
                        }
                    }
                }, true);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private ExecutableElement getImplementationOf(CompilationInfo compilationInfo, ExecutableElement executableElement, TypeElement typeElement) {
        for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) continue;
            return executableElement2;
        }
        return null;
    }

    public synchronized void cancel() {
        this.canceled = true;
        if (this.visitor != null) {
            this.visitor.cancel();
        }
        this.wakeUp();
    }

    private synchronized void resume() {
        this.canceled = false;
    }

    private synchronized void wakeUp() {
        this.notifyAll();
    }

    private synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void newAnnotations(List<IsOverriddenAnnotation> list) {
        AnnotationsHolder annotationsHolder = AnnotationsHolder.get(this.file);
        if (annotationsHolder != null) {
            annotationsHolder.setNewAnnotations(list);
        }
    }

    private static void sortOutMethods(CompilationInfo compilationInfo, Map<Name, List<ExecutableElement>> map, Element element, boolean bl) {
        if (bl) {
            List<ExecutableElement> list;
            HashMap hashMap = new HashMap();
            block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                ArrayList<ExecutableElement> arrayList;
                list = executableElement.getSimpleName();
                List<ExecutableElement> list2 = map.get(list);
                if (list2 != null) {
                    arrayList = list2.iterator();
                    while (arrayList.hasNext()) {
                        ExecutableElement executableElement2 = (ExecutableElement)arrayList.next();
                        if (!compilationInfo.getElements().overrides(executableElement2, executableElement, (TypeElement)executableElement2.getEnclosingElement())) continue;
                        continue block0;
                    }
                }
                if ((arrayList = (List)hashMap.get(list)) == null) {
                    arrayList = new ArrayList<ExecutableElement>();
                    hashMap.put(list, arrayList);
                }
                arrayList.add(executableElement);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                list = map.get(entry.getKey());
                if (list == null) {
                    map.put((Name)entry.getKey(), (List<ExecutableElement>)entry.getValue());
                    continue;
                }
                list.addAll((Collection)entry.getValue());
            }
        }
        for (TypeMirror typeMirror : compilationInfo.getTypes().directSupertypes(element.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            IsOverriddenAnnotationHandler.sortOutMethods(compilationInfo, map, ((DeclaredType)typeMirror).asElement(), true);
        }
    }

    private static Position getPosition(final StyledDocument styledDocument, final int n) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Impl
        implements Runnable {
            private Position pos;

            Impl() {
            }

            @Override
            public void run() {
                if (n < 0 || n >= styledDocument.getLength()) {
                    return;
                }
                try {
                    this.pos = styledDocument.createPosition(n - NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n));
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.FINE, null, badLocationException);
                }
            }
        }
        Impl impl = new Impl();
        styledDocument.render(impl);
        return impl.pos;
    }
}

