/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningManager
implements PropertyChangeListener,
LookupListener,
PreferenceChangeListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    private static VersioningManager instance;
    private final FilesystemInterceptor filesystemInterceptor;
    private final Lookup.Result<VersioningSystem> systemsLookupResult;
    private final Collection<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(2);
    private final Map<File, VersioningSystem> folderOwners = new HashMap<File, VersioningSystem>(200);
    private VersioningSystem localHistory;
    private Map<File, Boolean> localHistoryFolders = new HashMap<File, Boolean>(200);
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){};

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    private VersioningManager() {
        this.systemsLookupResult = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.filesystemInterceptor = new FilesystemInterceptor();
    }

    private void init() {
        this.systemsLookupResult.addLookupListener((LookupListener)this);
        this.refreshVersioningSystems();
        this.filesystemInterceptor.init(this);
        VersioningSupport.getPreferences().addPreferenceChangeListener(this);
    }

    private synchronized void refreshVersioningSystems() {
        for (VersioningSystem object : this.versioningSystems) {
            object.removePropertyChangeListener(this);
        }
        this.versioningSystems.clear();
        assert (this.versioningSystems.size() == 0);
        this.localHistory = null;
        Collection collection = this.systemsLookupResult.allInstances();
        assert (this.versioningSystems.size() == 0);
        assert (this.localHistory == null);
        this.versioningSystems.addAll(collection);
        for (VersioningSystem versioningSystem : this.versioningSystems) {
            if (this.localHistory == null && Utils.isLocalHistory(versioningSystem)) {
                this.localHistory = versioningSystem;
            }
            versioningSystem.addPropertyChangeListener(this);
        }
        this.flushFileOwnerCache();
        this.refreshDiffSidebars(null);
        VersioningAnnotationProvider.refreshAllAnnotations();
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars(Set<File> set) {
        DiffSidebarManager.getInstance().refreshSidebars(set);
    }

    private synchronized void flushFileOwnerCache() {
        this.folderOwners.clear();
        this.localHistoryFolders.clear();
    }

    synchronized VersioningSystem[] getVersioningSystems() {
        return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
    }

    VersioningSystem[] getOwners(VCSContext vCSContext) {
        Set<File> set = vCSContext.getRootFiles();
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>();
        for (File file : set) {
            VersioningSystem versioningSystem = this.getOwner(file);
            if (versioningSystem == null) continue;
            hashSet.add(versioningSystem);
        }
        return hashSet.toArray(new VersioningSystem[hashSet.size()]);
    }

    public synchronized VersioningSystem getOwner(File file) {
        File file2 = file;
        if (file.isFile() && (file2 = file.getParentFile()) == null) {
            return null;
        }
        VersioningSystem versioningSystem = this.folderOwners.get(file2);
        if (versioningSystem == this.NULL_OWNER) {
            return null;
        }
        if (versioningSystem != null) {
            return versioningSystem;
        }
        File file3 = null;
        for (VersioningSystem versioningSystem2 : this.versioningSystems) {
            File file4;
            if (versioningSystem2 == this.localHistory || (file4 = versioningSystem2.getTopmostManagedAncestor(file2)) == null || file3 != null && !Utils.isAncestorOrEqual(file3, file4)) continue;
            versioningSystem = versioningSystem2;
            file3 = file4;
        }
        if (versioningSystem != null) {
            this.folderOwners.put(file2, versioningSystem);
        } else {
            this.folderOwners.put(file2, this.NULL_OWNER);
        }
        return versioningSystem;
    }

    synchronized VersioningSystem getLocalHistory(File file) {
        boolean bl;
        if (this.localHistory == null) {
            return null;
        }
        File file2 = file;
        if (file.isFile() && (file2 = file.getParentFile()) == null) {
            return null;
        }
        Boolean bl2 = this.localHistoryFolders.get(file2);
        if (bl2 != null) {
            return bl2 != false ? this.localHistory : null;
        }
        boolean bl3 = bl = this.localHistory.getTopmostManagedAncestor(file2) != null;
        if (bl) {
            this.localHistoryFolders.put(file2, Boolean.TRUE);
            return this.localHistory;
        }
        this.localHistoryFolders.put(file2, Boolean.FALSE);
        return null;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshVersioningSystems();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (EVENT_STATUS_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
            this.refreshDiffSidebars(set);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
        } else if (EVENT_VERSIONED_ROOTS.equals(propertyChangeEvent.getPropertyName())) {
            this.flushFileOwnerCache();
            this.refreshDiffSidebars(null);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        VersioningAnnotationProvider.instance.refreshAnnotations(null);
    }
}

