/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.analyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.analyzer.AnalyzerPanel;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerEditorView
implements DataEditorView,
DesignDocumentAwareness {
    private static final Color BACKGROUND_COLOR = new Color(16513523);
    private static final long serialVersionUID = -1L;
    static final String ANALYZER_ID = "analyzer";
    private DataObjectContext context;
    private transient HashMap<Analyzer, JComponent> components;
    private transient DesignDocument document;
    private transient JScrollPane scroll;
    private transient JToolBar toolbar;

    public AnalyzerEditorView(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        this.init();
    }

    private void init() {
        Object object;
        Object object22;
        this.components = new HashMap();
        Collection collection = Lookup.getDefault().lookupResult(Analyzer.class).allInstances();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scroll = new JScrollPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 18;
        for (Object object22 : collection) {
            object = this.context.getProjectType();
            if (object == null || !((String)object).equals(object22.getProjectType())) continue;
            JComponent jComponent = object22.createVisualRepresentation();
            this.components.put((Analyzer)object22, jComponent);
            if (jComponent == null) continue;
            jPanel.add((Component)new AnalyzerPanel((Analyzer)object22, jComponent), gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setPreferredSize(new Dimension(14, 14));
        this.toolbar.setSize(new Dimension(14, 14));
        object22 = new JToolBar.Separator();
        ((JSeparator)object22).setOrientation(1);
        this.toolbar.add((Component)object22);
        object = new JButton();
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setToolTipText(NbBundle.getMessage(AnalyzerEditorView.class, (String)"TTIP_Refresh"));
        ((AbstractButton)object).setBorderPainted(false);
        ((AbstractButton)object).setRolloverEnabled(true);
        ((Component)object).setSize(14, 14);
        ((AbstractButton)object).setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/vmd/analyzer/resources/refresh.png")));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerEditorView.this.updateAnalyzers();
            }
        });
        this.toolbar.add((Component)object);
        jPanel.putClientProperty(Printable.class, "");
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return ANALYZER_ID;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AnalyzerEditorView.class, (String)"DISP_AnalyzerView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AnalyzerEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.scroll;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        this.updateAnalyzers();
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return 0;
    }

    public int getEditPriority() {
        return 0;
    }

    public int getOrder() {
        return 3000;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.context);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }

    public void setDesignDocument(DesignDocument designDocument) {
        this.document = designDocument;
        this.componentActivated();
    }

    private void updateAnalyzers() {
        DesignDocument designDocument = this.document;
        for (Map.Entry<Analyzer, JComponent> entry : this.components.entrySet()) {
            entry.getKey().update(entry.getValue(), designDocument);
        }
    }
}

