/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.actions.SyncDocumentRegion;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private final PositionsBag bag;
    private boolean inSync;
    private static final AttributeSet COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(138, 191, 236)});

    InstantRenamePerformer(JTextComponent jTextComponent, Collection<CsmReference> collection, int n) throws BadLocationException {
        this.target = jTextComponent;
        this.doc = jTextComponent.getDocument();
        MutablePositionRegion mutablePositionRegion = null;
        ArrayList<MutablePositionRegion> arrayList = new ArrayList<MutablePositionRegion>();
        this.bag = new PositionsBag(this.doc);
        for (CsmReference csmReference : collection) {
            Position position;
            Position position2 = NbDocument.createPosition((Document)this.doc, (int)csmReference.getStartOffset(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion mutablePositionRegion2 = new MutablePositionRegion(position2, position = NbDocument.createPosition((Document)this.doc, (int)csmReference.getEndOffset(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(mutablePositionRegion2, n)) {
                mutablePositionRegion = mutablePositionRegion2;
            } else {
                arrayList.add(mutablePositionRegion2);
            }
            this.bag.addHighlight(position2, position, COLORING);
        }
        if (mutablePositionRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        arrayList.add(0, mutablePositionRegion);
        this.region = new SyncDocumentRegion(this.doc, arrayList);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
        }
        jTextComponent.addKeyListener(this);
        jTextComponent.putClientProperty(InstantRenamePerformer.class, this);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        jTextComponent.select(mutablePositionRegion.getStartOffset(), mutablePositionRegion.getEndOffset());
    }

    private static String getString(String string) {
        return NbBundle.getMessage(InstantRenamePerformer.class, (String)string);
    }

    public static void invokeInstantRename(JTextComponent jTextComponent) {
        try {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
            CsmFile csmFile = CsmUtilities.getCsmFile((DataObject)dataObject, (boolean)false);
            if (csmFile == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(csmFile, n);
            if (csmReference == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            if (InstantRenamePerformer.allowInstantRename(csmReference)) {
                Collection<CsmReference> collection = InstantRenamePerformer.computeChangePoints(csmReference);
                InstantRenamePerformer.doInstantRename(collection, jTextComponent, n);
            } else {
                InstantRenamePerformer.doFullRename(dataObject, jTextComponent);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    static boolean allowInstantRename(CsmReference csmReference) {
        CsmReferenceResolver.Scope scope = CsmReferenceResolver.getDefault().fastCheckScope(csmReference);
        if (scope == CsmReferenceResolver.Scope.LOCAL) {
            return true;
        }
        if (scope == CsmReferenceResolver.Scope.FILE_LOCAL) {
            return CsmIncludeHierarchyResolver.getDefault().getFiles(csmReference.getContainingFile()).isEmpty();
        }
        return false;
    }

    private static void doFullRename(DataObject dataObject, JTextComponent jTextComponent) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        Node node = dataObject.getNodeDelegate();
        if (node == null) {
            Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)InstantRenamePerformer.getString("no-instant-rename"));
            return;
        }
        InstanceContent instanceContent = new InstanceContent();
        if (editorCookie != null) {
            instanceContent.add((Object)editorCookie);
        }
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    private static void doInstantRename(Collection<CsmReference> collection, JTextComponent jTextComponent, int n) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(jTextComponent, collection, n);
    }

    static Collection<CsmReference> computeChangePoints(CsmReference csmReference) {
        CsmObject csmObject = csmReference.getReferencedObject();
        if (csmObject == null) {
            return Collections.emptyList();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        Collection collection = CsmReferenceRepository.getDefault().getReferences(csmObject, csmFile, CsmReferenceKind.ALL);
        return collection;
    }

    public static void performInstantRename(JTextComponent jTextComponent, Collection<CsmReference> collection, int n) throws BadLocationException {
        new InstantRenamePerformer(jTextComponent, collection, n);
    }

    private boolean isIn(MutablePositionRegion mutablePositionRegion, int n) {
        return mutablePositionRegion.getStartOffset() <= n && n <= mutablePositionRegion.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && keyEvent.getModifiers() == 0 || keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0) {
            this.release();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void release() {
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
        }
        this.target.removeKeyListener(this);
        InstantRenamePerformer.getHighlightsBag(this.doc).clear();
        this.region = null;
        this.doc = null;
        this.target = null;
    }

    public static PositionsBag getHighlightsBag(Document document) {
        PositionsBag positionsBag = (PositionsBag)document.getProperty(InstantRenamePerformer.class);
        if (positionsBag == null) {
            positionsBag = new PositionsBag(document);
            document.putProperty(InstantRenamePerformer.class, positionsBag);
        }
        return positionsBag;
    }
}

