/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.modules.web.project.classpath.ClassPathSupportCallbackImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String TAG_MINIMUM_ANT_VERSION = "minimum-ant-version";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private ProjectUpdateListener projectUpdateListener = null;
    private UpdateHelper updateHelper;
    private EditableProperties cachedProperties;

    UpdateProjectImpl(Project project, AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration) {
        assert (project != null && antProjectHelper != null && auxiliaryConfiguration != null);
        this.project = project;
        this.helper = antProjectHelper;
        this.cfg = auxiliaryConfiguration;
    }

    public void setUpdateHelper(UpdateHelper updateHelper) {
        this.updateHelper = updateHelper;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        if (UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) != null || UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true) != null) {
                            UpdateProjectImpl.this.isCurrent = Boolean.FALSE;
                        } else {
                            UpdateProjectImpl.this.isCurrent = Boolean.TRUE;
                        }
                    }
                    return UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean bl = this.showUpdateDialog();
        if (!bl) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties editableProperties) throws IOException {
        ClassPathSupport classPathSupport;
        UpdateProjectImpl updateProjectImpl;
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        if (this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true) != null) {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
        } else {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
        }
        boolean bl = false;
        if (editableProperties == null) {
            assert (this.updateHelper != null);
            editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
            bl = true;
        }
        if (editableProperties != null) {
            editableProperties.put("test.src.dir", "test");
            editableProperties.put("build.test.classes.dir", "${build.dir}/test/classes");
            editableProperties.put("build.test.results.dir", "${build.dir}/test/results");
            editableProperties.put("conf.dir", "${source.root}/conf");
            editableProperties.put("jspcompilation.classpath", "${jspc.classpath}:${javac.classpath}");
            editableProperties.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}:", "${libs.junit_4.classpath}"});
            editableProperties.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
            editableProperties.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
            editableProperties.put("war.ear.name", editableProperties.getProperty("war.name"));
            editableProperties.put("dist.ear.war", "${dist.dir}/${war.ear.name}");
            if (editableProperties.getProperty("lib.dir") == null) {
                editableProperties.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
            }
        }
        if (editableProperties != null) {
            String[] stringArray;
            updateProjectImpl = new ReferenceHelper(this.helper, this.cfg, this.helper.getStandardPropertyEvaluator());
            classPathSupport = new ClassPathSupport(this.helper.getStandardPropertyEvaluator(), (ReferenceHelper)updateProjectImpl, this.helper, this.updateHelper, (ClassPathSupport.Callback)new ClassPathSupportCallbackImpl(this.helper));
            Iterator iterator = classPathSupport.itemsIterator((String)editableProperties.get((Object)"javac.classpath"), "web-module-libraries");
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                String string = stringArray.getReference();
                if (string == null) continue;
                String string2 = string.substring("${libs.".length());
                if (string2.indexOf(".classpath}") != -1) {
                    string2 = string2.substring(0, string2.indexOf(".classpath}"));
                }
                if ("servlet24".equals(string2) || "jsp20".equals(string2)) continue;
                arrayList.add(stringArray);
            }
            stringArray = classPathSupport.encodeToStrings(arrayList, "web-module-libraries");
            editableProperties.setProperty("javac.classpath", stringArray);
        }
        if (bl) {
            this.helper.putProperties("nbproject/project.properties", editableProperties);
        }
        ProjectManager.getDefault().saveProject(this.project);
        updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
        if (this.projectUpdateListener != null) {
            this.projectUpdateListener.projectUpdated();
        }
        try {
            updateProjectImpl = this.project.getProjectDirectory();
            classPathSupport = updateProjectImpl.createFolder("conf");
            FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/MANIFEST.MF"), (FileObject)classPathSupport, (String)"MANIFEST");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String string;
            int n = 1;
            Element element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/1", true);
            if (element == null) {
                n = 2;
                element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/2", true);
            }
            String string2 = string = n == 1 ? "http://www.netbeans.org/ns/web-project/1" : "http://www.netbeans.org/ns/web-project/2";
            if (element != null) {
                Element element2;
                Object object;
                Document document = element.getOwnerDocument();
                Element element3 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "data");
                UpdateProjectImpl.copyDocument(document, element, element3);
                if (n == 1) {
                    object = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    Element element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    element4.setAttribute("id", "src.dir");
                    object.appendChild(element4);
                    element3.appendChild((Node)object);
                    element2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    element4 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                    element4.setAttribute("id", "test.src.dir");
                    element2.appendChild(element4);
                    element3.appendChild(element2);
                }
                if (n == 1 || n == 2) {
                    object = element3.getElementsByTagNameNS(string, TAG_LIBRARY);
                    for (int i = 0; i < object.getLength(); ++i) {
                        if (object.item(i).getNodeType() != 1) continue;
                        element2 = (Element)object.item(i);
                        Node node = element2.getElementsByTagNameNS(string, TAG_FILE).item(0);
                        String string3 = UpdateProjectImpl.findText(node);
                        if (!(string3 = string3.substring(2, string3.length() - 1)).startsWith("lib.")) continue;
                        String string4 = string3.substring(6, string3.indexOf(".classpath"));
                        List list = LibraryManager.getDefault().getLibrary(string4).getContent("classpath");
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
                        for (URL uRL : list) {
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if ("jar".equals(uRL.getProtocol())) {
                                fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
                            }
                            if (fileObject == null) continue;
                            if (fileObject.isData()) {
                                arrayList.add(fileObject);
                                continue;
                            }
                            arrayList2.add(fileObject);
                        }
                        if (arrayList.size() > 0) {
                            element2.setAttribute(ATTR_FILES, "" + arrayList.size());
                        }
                        if (arrayList2.size() <= 0) continue;
                        element2.setAttribute(ATTR_DIRS, "" + arrayList2.size());
                    }
                }
                this.cachedElement = UpdateProjectImpl.updateMinAntVersion(element3, document);
            }
        }
        return this.cachedElement;
    }

    public synchronized EditableProperties getUpdatedProjectProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = this.helper.getProperties("nbproject/project.properties");
            if (this.cachedProperties.get((Object)"javadoc.additionalparam") == null) {
                this.cachedProperties.put("javadoc.additionalparam", "");
            }
        }
        return this.cachedProperties;
    }

    private static String findText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    private static void copyDocument(Document document, Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            switch (node.getNodeType()) {
                case 1: {
                    Node node3;
                    Element element3 = (Element)node;
                    node2 = document.createElementNS("http://www.netbeans.org/ns/web-project/3", element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    Element element4 = (Element)node2;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        node3 = namedNodeMap.item(j);
                        element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    UpdateProjectImpl.copyDocument(document, element3, (Element)node2);
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    node2 = document.createTextNode(text.getData());
                    break;
                }
                case 8: {
                    Node node3 = (Comment)node;
                    node2 = document.createComment(node3.getData());
                }
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    private static Element updateMinAntVersion(Element element, Document document) {
        Element element2;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", TAG_MINIMUM_ANT_VERSION);
        if (nodeList.getLength() == 1 && (nodeList = (element2 = (Element)nodeList.item(0)).getChildNodes()).getLength() == 1) {
            element2.replaceChild(document.createTextNode("1.6"), nodeList.item(0));
            return element;
        }
        assert (false) : "Invalid project file";
        return element;
    }

    private boolean showUpdateDialog() {
        JButton jButton = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateProjectImpl.class, (String)"AD_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
    }

    public void setProjectUpdateListener(ProjectUpdateListener projectUpdateListener) {
        this.projectUpdateListener = projectUpdateListener;
    }

    public static interface ProjectUpdateListener {
        public void projectUpdated();
    }
}

