/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.xhtml;

import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.insync.InSyncService;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.xhtml.FormNamePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class FragmentPanel
extends JPanel
implements ActionListener,
ItemListener {
    private DesignProperty prop;
    private JComboBox comboBox;
    private JButton createButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public FragmentPanel(DesignProperty designProperty) {
        this.prop = designProperty;
        this.initComponents();
        this.createButton.addActionListener(this);
        this.comboBox.addItemListener(this);
        this.addComboFragments();
    }

    private void update() {
    }

    private Project getProject() {
        DesignContext designContext = this.prop.getDesignBean().getDesignContext();
        DesignProject designProject = designContext.getProject();
        return InSyncService.getProvider().getProjectForDesignProject(designProject);
    }

    private void addComboFragments() {
        Project project;
        this.comboBox.setEditable(false);
        DesignContext designContext = this.prop.getDesignBean().getDesignContext();
        DataObject dataObject = null;
        if (designContext != null) {
            project = InSyncService.getProvider().getMarkupFileObjectForDesignContext(designContext);
            try {
                dataObject = DataObject.find((FileObject)project);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        if ((project = this.getProject()) == null) {
            return;
        }
        FileObject fileObject = JsfProjectUtils.getDocumentRoot((Project)project);
        if (fileObject == null) {
            return;
        }
        DataObject dataObject2 = null;
        try {
            dataObject2 = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        if (dataObject2 instanceof DataFolder) {
            this.addSubFolderFragments((DataFolder)dataObject2, arrayList, dataObject);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.comboBox.setEditable(true);
        if (this.prop.getValue() != null) {
            this.comboBox.setSelectedItem(this.prop.getValue().toString());
        } else if (stringArray.length > 0) {
            this.prop.setValue((Object)stringArray[0]);
        }
    }

    private void addSubFolderFragments(DataFolder dataFolder, List list, DataObject dataObject) {
        DataObject[] dataObjectArray = dataFolder.getChildren();
        if (dataObjectArray == null) {
            return;
        }
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (dataObjectArray[i] instanceof DataFolder) {
                this.addSubFolderFragments((DataFolder)dataObjectArray[i], list, dataObject);
                continue;
            }
            DataObject dataObject2 = dataObjectArray[i];
            if (dataObject2 == dataObject || !dataObject2.getPrimaryFile().getNameExt().endsWith(".jspf")) continue;
            String string = FragmentPanel.computePathFromTo(dataObject, dataObject2);
            list.add(string);
        }
    }

    public static String computePathFromTo(DataObject dataObject, DataObject dataObject2) {
        int n;
        FileObject fileObject = dataObject.getPrimaryFile();
        FileObject fileObject2 = dataObject2.getPrimaryFile();
        ArrayList arrayList = FragmentPanel.getPathList(fileObject);
        ArrayList arrayList2 = FragmentPanel.getPathList(fileObject2);
        for (int i = 0; i < arrayList.size() && i < arrayList2.size() && arrayList.get(i).equals(arrayList2.get(i)); ++i) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = i; n < arrayList.size(); ++n) {
            stringBuffer.append("../");
        }
        for (n = i; n < arrayList2.size(); ++n) {
            stringBuffer.append(arrayList2.get(n));
            stringBuffer.append("/");
        }
        if (fileObject2.isData()) {
            stringBuffer.append(fileObject2.getNameExt());
        }
        return stringBuffer.toString();
    }

    public static ArrayList getPathList(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (fileObject != null) {
            arrayList.add(fileObject.getName());
            fileObject = fileObject.getParent();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboBox = new JComboBox();
        this.createButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage((Class)FragmentPanel.class, (String)"JspPageDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.jLabel1, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/xhtml/Bundle");
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("PF_LBL_ACCESS_DESC"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/xhtml/Bundle").getString("JspPageMnemonic").charAt(0));
        this.jLabel2.setLabelFor(this.comboBox);
        this.jLabel2.setText(NbBundle.getMessage((Class)FragmentPanel.class, (String)"JspPage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 11, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.comboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.comboBox, gridBagConstraints);
        this.comboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FragmentPanel.class, (String)"PF_COMBOBOX_ACCESS_NAME"));
        this.comboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FragmentPanel.class, (String)"PF_COMBOBOX_ACCESS_DESC"));
        this.createButton.setMnemonic(NbBundle.getMessage((Class)FragmentPanel.class, (String)"CREATE_NEW_PF_BUTTON_MNEMONIC").charAt(0));
        this.createButton.setText(NbBundle.getMessage((Class)FragmentPanel.class, (String)"CreateNew"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 6, 11);
        this.add((Component)this.createButton, gridBagConstraints);
        this.createButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FragmentPanel.class, (String)"CREATE_NEW_PF_BUTTON_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.createButton && (string = this.createPageFragment()) != null) {
            this.comboBox.setSelectedItem(string);
            this.prop.setValue((Object)string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.prop.setValue((Object)this.comboBox.getSelectedItem().toString());
    }

    private String createPageFragment() {
        FormNamePanel formNamePanel;
        Object object;
        FileObject fileObject;
        Object object2 = null;
        Project project = this.getProject();
        if (project != null) {
            fileObject = JsfProjectUtils.getDocumentRoot((Project)project);
            try {
                object2 = (DataFolder)DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        if (this.prop != null && (fileObject = InSyncService.getProvider().getMarkupFileObjectForDesignContext(this.prop.getDesignBean().getDesignContext())) != null) {
            try {
                object = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                object = null;
            }
            if (object != null && (formNamePanel = object.getFolder()) != null) {
                object2 = formNamePanel;
            }
        }
        fileObject = null;
        object = null;
        formNamePanel = new FormNamePanel(project, "Fragment");
        String string = NbBundle.getMessage((Class)FragmentPanel.class, (String)"CreateFragment");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)formNamePanel, string, true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        JDialog jDialog = (JDialog)DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FragmentPanel.class, (String)"CreateFragmentAccessibleDesc"));
        formNamePanel.setDescriptor(dialogDescriptor);
        jDialog.show();
        String string2 = dialogDescriptor.getValue().toString();
        if (!dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            return null;
        }
        object = formNamePanel.getFragmentName();
        boolean bl = JsfProjectUtils.isValidJavaFileName((String)object);
        if (!bl) {
            return null;
        }
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            String string3 = "Templates/JSF/PageFragment.jspf";
            FileObject fileObject2 = fileSystem.findResource(string3);
            if (fileObject2 == null) {
                throw new IOException("Can't find template FileObject for " + string3);
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            DataObject dataObject2 = dataObject.createFromTemplate(object2, (String)object);
            if (dataObject2 != null) {
                InSyncService.getProvider().initModelsForWebformFile(project, dataObject2.getPrimaryFile());
            }
            return dataObject2.getPrimaryFile().getNameExt();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
    }
}

