/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.editor.indent.IndentSpiPackageAccessor;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskHandler {
    private static final Logger LOG = Logger.getLogger(TaskHandler.class.getName());
    private final boolean indent;
    private final Document doc;
    private List<MimeItem> items;
    private Position startPos;
    private Position endPos;
    private Position caretPos;
    private final Set<Object> existingFactories = new HashSet<Object>();

    TaskHandler(boolean bl, Document document) {
        this.indent = bl;
        this.doc = document;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public Document document() {
        return this.doc;
    }

    public int caretOffset() {
        return this.caretPos.getOffset();
    }

    public void setCaretOffset(int n) throws BadLocationException {
        this.caretPos = this.doc.createPosition(n);
    }

    public Position startPos() {
        return this.startPos;
    }

    public Position endPos() {
        return this.endPos;
    }

    void setGlobalBounds(Position position, Position position2) {
        assert (position.getOffset() <= position2.getOffset()) : "startPos=" + position.getOffset() + " < endPos=" + position2.getOffset();
        this.startPos = position;
        this.endPos = position2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    boolean collectTasks() {
        Object object3;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document());
        Set set = Collections.emptySet();
        if (this.doc instanceof AbstractDocument) {
            object3 = (AbstractDocument)this.doc;
            ((AbstractDocument)object3).readLock();
            try {
                set = tokenHierarchy.languagePaths();
                ArrayList object22 = new ArrayList(set);
                Collections.sort(object22, LanguagePathSizeComparator.ASCENDING);
                for (LanguagePath languagePath : object22) {
                    this.addItem(MimePath.parse((String)languagePath.mimePath()), languagePath);
                }
            }
            finally {
                ((AbstractDocument)object3).readUnlock();
            }
        }
        if (set.isEmpty()) {
            this.addItem(MimePath.parse((String)this.docMimeType()), null);
        }
        if (this.items != null && "application/x-httpd-eruby".equals(this.docMimeType())) {
            void var4_6;
            object3 = new ArrayList(this.items.size());
            Object var4_5 = null;
            for (MimeItem mimeItem : this.items) {
                if (mimeItem.mimePath().getPath().endsWith("text/x-ruby")) {
                    MimeItem mimeItem2 = mimeItem;
                    continue;
                }
                object3.add(mimeItem);
            }
            if (var4_6 != null) {
                object3.add(var4_6);
            }
            this.items = object3;
        }
        if (this.items != null && "text/x-jsp".equals(this.docMimeType()) || "text/x-tag".equals(this.docMimeType())) {
            void var4_10;
            object3 = new ArrayList(this.items.size());
            Object var4_9 = null;
            Object object = null;
            for (MimeItem mimeItem : this.items) {
                if (mimeItem.mimePath().getPath().endsWith("text/html")) {
                    MimeItem mimeItem3 = mimeItem;
                    continue;
                }
                if (mimeItem.mimePath().getPath().endsWith("text/x-jsp") || mimeItem.mimePath().getPath().endsWith("text/x-tag")) {
                    object = mimeItem;
                    continue;
                }
                object3.add(mimeItem);
            }
            if (var4_10 != null) {
                object3.add(0, var4_10);
            }
            if (object != null) {
                object3.add(0, object);
            }
            this.items = object3;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Collected items: ");
            for (MimeItem mimeItem : this.items) {
                LOG.fine("  Item: " + mimeItem);
            }
            LOG.fine("-----------------");
        }
        return this.items != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        if (this.items != null) {
            MimeItem mimeItem;
            int n;
            try {
                for (n = 0; n < this.items.size(); ++n) {
                    mimeItem = this.items.get(n);
                    mimeItem.lock();
                }
            }
            finally {
                if (n < this.items.size()) {
                    while (--n >= 0) {
                        mimeItem = this.items.get(n);
                        mimeItem.unlock();
                    }
                }
            }
        }
    }

    void unlock() {
        if (this.items != null) {
            for (MimeItem mimeItem : this.items) {
                mimeItem.unlock();
            }
        }
    }

    boolean hasFactories() {
        String string = this.docMimeType();
        return string != null && new MimeItem(this, MimePath.get((String)string), null).hasFactories();
    }

    boolean hasItems() {
        return this.items != null;
    }

    void runTasks() throws BadLocationException {
        if (this.items == null) {
            return;
        }
        for (MimeItem mimeItem : this.items) {
            mimeItem.runTask();
        }
    }

    private boolean addItem(MimePath mimePath, LanguagePath languagePath) {
        MimeItem mimeItem = new MimeItem(this, mimePath, languagePath);
        if (mimeItem.createTask(this.existingFactories)) {
            if (this.items == null) {
                this.items = new ArrayList<MimeItem>();
            }
            this.items.add(mimeItem);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Adding MimeItem: " + mimeItem);
            }
            return true;
        }
        return false;
    }

    private Collection<LanguagePath> getActiveEmbeddedPaths(TokenSequence tokenSequence) {
        HashSet<LanguagePath> hashSet = new HashSet<LanguagePath>();
        hashSet.add(tokenSequence.languagePath());
        List list = null;
        while (true) {
            if (tokenSequence.moveNext()) {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 == null) continue;
                list.add(tokenSequence);
                tokenSequence = tokenSequence2;
                hashSet.add(tokenSequence.languagePath());
                continue;
            }
            if (list == null || list.size() <= 0) break;
            tokenSequence = (TokenSequence)list.get(list.size() - 1);
            list.remove(list.size() - 1);
        }
        return hashSet;
    }

    private String docMimeType() {
        return (String)this.document().getProperty("mimeType");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguagePathSizeComparator
    implements Comparator<LanguagePath> {
        static final LanguagePathSizeComparator ASCENDING = new LanguagePathSizeComparator(false);
        private final boolean reverse;

        public LanguagePathSizeComparator(boolean bl) {
            this.reverse = bl;
        }

        @Override
        public int compare(LanguagePath languagePath, LanguagePath languagePath2) {
            return this.reverse ? languagePath2.size() - languagePath.size() : languagePath.size() - languagePath2.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MimeItem {
        private final TaskHandler handler;
        private final MimePath mimePath;
        private final LanguagePath languagePath;
        private IndentTask indentTask;
        private ReformatTask reformatTask;
        private ExtraLock extraLock;
        private Context context;

        MimeItem(TaskHandler taskHandler, MimePath mimePath, LanguagePath languagePath) {
            this.handler = taskHandler;
            this.mimePath = mimePath;
            this.languagePath = languagePath;
        }

        public MimePath mimePath() {
            return this.mimePath;
        }

        public LanguagePath languagePath() {
            return this.languagePath;
        }

        public Context context() {
            if (this.context == null) {
                this.context = IndentSpiPackageAccessor.get().createContext(this);
            }
            return this.context;
        }

        public TaskHandler handler() {
            return this.handler;
        }

        boolean hasFactories() {
            Lookup lookup = MimeLookup.getLookup((MimePath)this.mimePath);
            return this.handler().isIndent() ? lookup.lookup(IndentTask.Factory.class) != null : lookup.lookup(ReformatTask.Factory.class) != null;
        }

        public List<Context.Region> indentRegions() {
            Document document = this.handler.document();
            ArrayList<Context.Region> arrayList = new ArrayList();
            try {
                List list;
                int n;
                if (this.languagePath != null) {
                    int n2 = this.handler.endPos().getOffset();
                    if (n2 >= document.getLength()) {
                        n2 = Integer.MAX_VALUE;
                    }
                    n = this.handler.startPos().getOffset();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("indentRegions: startOffset=" + n + ", endOffset=" + n2 + '\n');
                    }
                    list = TokenHierarchy.get((Document)document).tokenSequenceList(this.languagePath, n, n2);
                    for (TokenSequence tokenSequence : list) {
                        tokenSequence.moveStart();
                        if (!tokenSequence.moveNext()) continue;
                        int n3 = tokenSequence.offset();
                        tokenSequence.moveEnd();
                        tokenSequence.movePrevious();
                        int n4 = tokenSequence.offset() + tokenSequence.token().length();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("  Region[" + arrayList.size() + "]: startOffset=" + n3 + ", endOffset=" + n4 + '\n');
                        }
                        if (n3 > n2 || n4 < n) continue;
                        n3 = Math.max(n3, n);
                        n4 = Math.min(n4, n2);
                        MutablePositionRegion mutablePositionRegion = new MutablePositionRegion(document.createPosition(n3), document.createPosition(n4));
                        arrayList.add(IndentSpiPackageAccessor.get().createContextRegion(mutablePositionRegion));
                    }
                } else {
                    MutablePositionRegion mutablePositionRegion = new MutablePositionRegion(document.getStartPosition(), document.createPosition(document.getLength()));
                    arrayList.add(IndentSpiPackageAccessor.get().createContextRegion(mutablePositionRegion));
                }
                if (arrayList.size() > 0 && document instanceof GuardedDocument) {
                    MutablePositionRegion mutablePositionRegion = IndentSpiPackageAccessor.get().positionRegion((Context.Region)arrayList.get(0));
                    n = mutablePositionRegion.getStartOffset();
                    list = (GuardedDocument)document;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                arrayList = Collections.emptyList();
            }
            return arrayList;
        }

        boolean createTask(Set<Object> set) {
            Object object;
            Lookup lookup = MimeLookup.getLookup((MimePath)this.mimePath);
            if (!this.handler.isIndent()) {
                object = (ReformatTask.Factory)lookup.lookup(ReformatTask.Factory.class);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("'" + this.mimePath.getPath() + "' supplied ReformatTask.Factory: " + object);
                }
                if (object != null && (this.reformatTask = object.createTask(this.context())) != null && !set.contains(object)) {
                    this.extraLock = this.reformatTask.reformatLock();
                    set.add(object);
                    return true;
                }
            }
            if (this.handler.isIndent() || this.reformatTask == null) {
                object = (IndentTask.Factory)lookup.lookup(IndentTask.Factory.class);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("'" + this.mimePath.getPath() + "' supplied IndentTask.Factory: " + object);
                }
                if (object != null && (this.indentTask = object.createTask(this.context())) != null && !set.contains(object)) {
                    this.extraLock = this.indentTask.indentLock();
                    set.add(object);
                    return true;
                }
            }
            return false;
        }

        void lock() {
            if (this.extraLock != null) {
                this.extraLock.lock();
            }
        }

        void runTask() throws BadLocationException {
            if (this.indentTask != null) {
                this.indentTask.reindent();
            } else {
                this.reformatTask.reformat();
            }
        }

        void unlock() {
            if (this.extraLock != null) {
                this.extraLock.unlock();
            }
        }

        public String toString() {
            return this.mimePath + ": " + (this.indentTask != null ? "IT: " + this.indentTask : "RT: " + this.reformatTask);
        }
    }
}

