/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.ExtTreeWillExpandListener;
import org.netbeans.swing.outline.OutlineModel;

public final class TreePathSupport {
    private OutlineModel mdl;
    private Map expandedPaths = new HashMap();
    private List eListeners = new ArrayList();
    private List weListeners = new ArrayList();
    private AbstractLayoutCache layout;

    public TreePathSupport(OutlineModel outlineModel, AbstractLayoutCache abstractLayoutCache) {
        this.mdl = outlineModel;
        this.layout = abstractLayoutCache;
    }

    public void clear() {
        this.expandedPaths.clear();
    }

    public void expandPath(TreePath treePath) {
        if (Boolean.TRUE.equals(this.expandedPaths.get(treePath))) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, true);
            this.expandedPaths.put(treePath, Boolean.TRUE);
            this.layout.setExpandedState(treePath, true);
            this.fireTreeExpansion(treeExpansionEvent, true);
        }
        catch (ExpandVetoException expandVetoException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, expandVetoException.getLocalizedMessage(), expandVetoException);
            this.fireTreeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public void collapsePath(TreePath treePath) {
        if (Boolean.FALSE.equals(this.expandedPaths.get(treePath))) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        try {
            this.fireTreeWillExpand(treeExpansionEvent, false);
            this.expandedPaths.put(treePath, Boolean.FALSE);
            this.layout.setExpandedState(treePath, false);
            this.fireTreeExpansion(treeExpansionEvent, false);
        }
        catch (ExpandVetoException expandVetoException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, expandVetoException.getLocalizedMessage(), expandVetoException);
            this.fireTreeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public void removePath(TreePath treePath) {
        this.expandedPaths.remove(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansion(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        int n = this.eListeners.size();
        TreeExpansionListener[] treeExpansionListenerArray = new TreeExpansionListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeExpansionListenerArray = this.eListeners.toArray(treeExpansionListenerArray);
        }
        for (int i = 0; i < treeExpansionListenerArray.length; ++i) {
            if (bl) {
                treeExpansionListenerArray[i].treeExpanded(treeExpansionEvent);
                continue;
            }
            treeExpansionListenerArray[i].treeCollapsed(treeExpansionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeWillExpand(TreeExpansionEvent treeExpansionEvent, boolean bl) throws ExpandVetoException {
        int n = this.eListeners.size();
        TreeWillExpandListener[] treeWillExpandListenerArray = new TreeWillExpandListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeWillExpandListenerArray = this.weListeners.toArray(treeWillExpandListenerArray);
        }
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            if (bl) {
                treeWillExpandListenerArray[i].treeWillExpand(treeExpansionEvent);
                continue;
            }
            treeWillExpandListenerArray[i].treeWillCollapse(treeExpansionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeExpansionVetoed(TreeExpansionEvent treeExpansionEvent, ExpandVetoException expandVetoException) {
        int n = this.eListeners.size();
        TreeWillExpandListener[] treeWillExpandListenerArray = new TreeWillExpandListener[n];
        TreePathSupport treePathSupport = this;
        synchronized (treePathSupport) {
            treeWillExpandListenerArray = this.weListeners.toArray(treeWillExpandListenerArray);
        }
        for (int i = 0; i < treeWillExpandListenerArray.length; ++i) {
            if (!(treeWillExpandListenerArray[i] instanceof ExtTreeWillExpandListener)) continue;
            ((ExtTreeWillExpandListener)treeWillExpandListenerArray[i]).treeExpansionVetoed(treeExpansionEvent, expandVetoException);
        }
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedPaths.get(treePath) != null;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object v = this.expandedPaths.get(treePath);
        if (v == null || !((Boolean)v).booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    protected void removeDescendantToggledPaths(Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath[] treePathArray = this.getDescendantToggledPaths((TreePath)enumeration.nextElement());
                for (int i = 0; i < treePathArray.length; ++i) {
                    this.expandedPaths.remove(treePathArray[i]);
                }
            }
        }
    }

    protected TreePath[] getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (TreePath treePath2 : this.expandedPaths.keySet()) {
            if (!treePath.isDescendant(treePath2)) continue;
            arrayList.add(treePath2);
        }
        TreePath[] treePathArray = new TreePath[arrayList.size()];
        return arrayList.toArray(treePathArray);
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null) {
                return this.isExpanded(treePath2);
            }
            return true;
        }
        return false;
    }

    public TreePath[] getExpandedDescendants(TreePath treePath) {
        TreePath[] treePathArray = new TreePath[]{};
        if (this.isExpanded(treePath)) {
            ArrayList<TreePath> arrayList = null;
            if (!this.expandedPaths.isEmpty()) {
                for (TreePath treePath2 : this.expandedPaths.keySet()) {
                    Object v = this.expandedPaths.get(treePath2);
                    if (treePath2 == treePath || v == null || !((Boolean)v).booleanValue() || !treePath.isDescendant(treePath2) || !this.isVisible(treePath2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<TreePath>();
                    }
                    arrayList.add(treePath2);
                }
                if (arrayList != null) {
                    treePathArray = arrayList.toArray(treePathArray);
                }
            }
        }
        return treePathArray;
    }

    public synchronized void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.eListeners.add(treeExpansionListener);
    }

    public synchronized void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.eListeners.remove(treeExpansionListener);
    }

    public synchronized void addTreeWillExpandListener(TreeExpansionListener treeExpansionListener) {
        this.weListeners.add(treeExpansionListener);
    }

    public synchronized void removeTreeWillExpandListener(TreeExpansionListener treeExpansionListener) {
        this.weListeners.remove(treeExpansionListener);
    }
}

