/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.sort;

import prefuse.Visualization;
import prefuse.visual.DecoratorItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class TreeDepthItemSorter
extends ItemSorter {
    private int m_childrenAbove;
    private int m_hover;
    private int m_highlight;
    private int m_depth;

    public TreeDepthItemSorter() {
        this(false);
    }

    public TreeDepthItemSorter(boolean childrenAbove) {
        if (childrenAbove) {
            this.m_childrenAbove = 1;
            this.m_hover = 13;
            this.m_highlight = 12;
            this.m_depth = 14;
        } else {
            this.m_childrenAbove = -1;
            this.m_hover = 29;
            this.m_highlight = 28;
            this.m_depth = 12;
        }
    }

    public int score(VisualItem item) {
        int score = 0;
        if (item.isHover()) {
            score += 1 << this.m_hover;
        }
        if (item.isHighlighted()) {
            score += 1 << this.m_highlight;
        }
        if (item instanceof NodeItem) {
            score += 0x8000000;
            score += this.m_childrenAbove * (((NodeItem)item).getDepth() << this.m_depth);
        }
        if (item.isInGroup(Visualization.FOCUS_ITEMS)) {
            score += 2048;
        }
        if (item.isInGroup(Visualization.SEARCH_ITEMS)) {
            score += 1024;
        }
        if (item instanceof DecoratorItem) {
            score += 512;
        }
        return score;
    }
}

