/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import prefuse.data.io.AbstractTextTableReader;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.ParserFactory;

public class CSVTableReader
extends AbstractTextTableReader {
    public CSVTableReader() {
    }

    public CSVTableReader(ParserFactory parserFactory) {
        super(parserFactory);
    }

    public void read(InputStream is, TableReadListener trl) throws IOException, DataParseException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        boolean inRecord = false;
        int inQuote = 0;
        int lineno = 0;
        int col = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            ++lineno;
            char[] c = line.toCharArray();
            int last = c.length - 1;
            for (int i = 0; i <= last; ++i) {
                String s;
                if (!inRecord) {
                    if (Character.isWhitespace(c[i])) continue;
                    if (c[i] == '\"') {
                        inRecord = true;
                        inQuote = 1;
                        continue;
                    }
                    if (c[i] == ',') {
                        s = sbuf.toString().trim();
                        trl.readValue(lineno, col++, s);
                        sbuf.delete(0, sbuf.length());
                        continue;
                    }
                    inRecord = true;
                    sbuf.append(c[i]);
                    continue;
                }
                if (inQuote == 1) {
                    if (c[i] == '\"' && (i == last || c[i + 1] != '\"')) {
                        inQuote = 2;
                        continue;
                    }
                    if (c[i] == '\"') {
                        sbuf.append(c[i++]);
                        continue;
                    }
                    sbuf.append(c[i]);
                    continue;
                }
                if (Character.isWhitespace(c[i])) {
                    sbuf.append(c[i]);
                    continue;
                }
                if (c[i] != ',' && inQuote == 2) {
                    throw new IllegalStateException("Invalid data format. Error at line " + lineno + ", col " + i);
                }
                if (c[i] != ',') {
                    sbuf.append(c[i]);
                    continue;
                }
                s = sbuf.toString().trim();
                trl.readValue(lineno, ++col, s);
                sbuf.delete(0, sbuf.length());
                inQuote = 0;
                inRecord = false;
            }
            if (inQuote != 1) {
                String s = sbuf.toString().trim();
                trl.readValue(lineno, ++col, s);
                sbuf.delete(0, sbuf.length());
                inQuote = 0;
                inRecord = false;
            }
            if (inRecord || col <= 0) continue;
            col = 0;
        }
    }
}

