/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.projects.jbi.CasaConstants;
import org.netbeans.modules.compapp.projects.jbi.anttasks.CasaBuilder;
import org.netbeans.modules.compapp.projects.jbi.anttasks.wsdlRepository;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Connection;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.PtConnection;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionResolver
implements CasaConstants {
    private boolean saInternalRouting;
    private boolean showLog;
    private Task task;
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private List<Connection> connectionList = new ArrayList<Connection>();
    Map<String, List<Connection>[]> bcConnections = new HashMap<String, List<Connection>[]>();

    public ConnectionResolver(Task task, boolean showLog, boolean saInternalRouting) {
        this.task = task;
        this.showLog = showLog;
        this.saInternalRouting = saInternalRouting;
    }

    public List<Connection> getConnectionList() {
        return this.connectionList;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public Set<String> getBCNames() {
        return this.bcConnections.keySet();
    }

    public Map<String, List<Connection>[]> getBCConnections() {
        return this.bcConnections;
    }

    public boolean isConnected(Endpoint p) {
        if (this.connectionList == null) {
            return false;
        }
        for (Connection con : this.connectionList) {
            if (!con.getConsume().equals((Object)p) && !con.getProvide().equals((Object)p)) continue;
            return true;
        }
        return false;
    }

    public void resolveConnections(wsdlRepository repo, Document oldCasaDocument) {
        Map<String, PtConnection> ptConnectionMap = repo.getConnections();
        for (String pt : ptConnectionMap.keySet()) {
            List consumers;
            Connection con;
            int numProviders;
            List providers;
            List ports;
            int numPorts;
            PtConnection ptConnection = ptConnectionMap.get(pt);
            if (this.showLog) {
                this.log(ptConnection.dump());
            }
            if ((numPorts = (ports = ptConnection.getPorts()).size()) == 1) {
                Port p = (Port)ports.get(0);
                providers = ptConnection.getProvides();
                numProviders = providers.size();
                if (numProviders > 1) {
                    this.log("WARNING: 1 port with " + numProviders + " providers [" + pt + "]", 1);
                }
                String bcName = repo.getBindingComponentName(p);
                QName ptQName = ((Binding)p.getBinding().get()).getType().getQName();
                if (bcName == null) {
                    this.log("WARNING: PORT w/o address: " + ptQName, 1);
                    continue;
                }
                Service sv = (Service)p.getParent();
                String tns = p.getModel().getDefinitions().getTargetNamespace();
                Endpoint port = new Endpoint(p.getName(), new QName(tns, sv.getName()), ptQName);
                Endpoint provide = null;
                if (numProviders > 0) {
                    provide = (Endpoint)providers.get(0);
                    Connection con2 = new Connection(port, provide);
                    this.addConnection(con2, true, bcName);
                    if (numProviders > 1) {
                        this.dumpEndpoints(providers, "Provider");
                    }
                }
                List consumers2 = ptConnection.getConsumes();
                for (Endpoint consume : consumers2) {
                    if (provide != null && this.saInternalRouting) {
                        con = new Connection(consume, provide);
                        this.addConnection(con);
                        continue;
                    }
                    con = new Connection(consume, port);
                    this.addConnection(con, false, bcName);
                }
                continue;
            }
            if (numPorts == 0) {
                if (!pt.endsWith("}dummyCasaPortType")) {
                    this.log("WARNING: there is no WSDL Port implementing PortType [" + pt + "]", 1);
                }
                consumers = ptConnection.getConsumes();
                providers = ptConnection.getProvides();
                numProviders = providers.size();
                int numConsumers = consumers.size();
                if (numConsumers < 1 || numProviders < 1) continue;
                if (numProviders == 1) {
                    Endpoint provider = (Endpoint)providers.get(0);
                    for (Endpoint consumer : consumers) {
                        Connection c = new Connection(consumer, provider);
                        this.addConnection(c);
                    }
                    continue;
                }
                if (numProviders <= 1) continue;
                this.log("WARNING: 0 port, " + numConsumers + " consumers, " + numProviders + " providers. [" + pt + "]", 1);
                this.dumpPorts(ports);
                this.dumpEndpoints(consumers, "Consumer");
                this.dumpEndpoints(providers, "Provider");
                continue;
            }
            consumers = ptConnection.getConsumes();
            providers = ptConnection.getProvides();
            numProviders = providers.size();
            int numConsumers = consumers.size();
            if (numProviders > 1) {
                this.log("WARNING: " + numPorts + " ports and " + numProviders + " providers [" + pt + "]", 1);
                this.dumpPorts(ports);
                this.dumpEndpoints(providers, "Provider");
                continue;
            }
            if (numConsumers > 0) {
                this.log("WARNING: 1 or more consumers with " + numPorts + " ports [" + pt + "]", 1);
                this.dumpPorts(ports);
                this.dumpEndpoints(consumers, "Consumer");
                continue;
            }
            if (numProviders != 1) continue;
            Endpoint provide = (Endpoint)providers.get(0);
            for (Port p : ports) {
                String bcName = repo.getBindingComponentName(p);
                QName ptQName = ((Binding)p.getBinding().get()).getType().getQName();
                if (bcName == null) {
                    this.log("Warning: PORT w/o address: " + ptQName, 1);
                    continue;
                }
                Service sv = (Service)p.getParent();
                String tns = ((Definitions)sv.getParent()).getTargetNamespace();
                Endpoint port = new Endpoint(p.getName(), new QName(tns, sv.getName()), ptQName);
                con = new Connection(port, provide);
                this.addConnection(con, true, bcName);
            }
        }
        if (this.showLog) {
            this.log("\n-----------------------------------\n");
        }
        this.mergeCasaConnections(oldCasaDocument);
    }

    private boolean isInConnectionList(List<Connection> connectionList, Connection connection) {
        for (Connection con : connectionList) {
            if (!con.equals((Object)connection)) continue;
            return true;
        }
        return false;
    }

    private void removeConnectionFromList(List<Connection> connectionList, Connection connection) {
        for (Connection con : connectionList) {
            if (!con.equals((Object)connection)) continue;
            connectionList.remove(con);
            break;
        }
    }

    private void removeConnection(Connection connection) {
        this.removeConnectionFromList(this.connectionList, connection);
    }

    private void removeConnection(Connection connection, boolean isConsumeAPort, String bcName) {
        this.removeConnection(connection);
        List<Connection>[] clist = this.bcConnections.get(bcName);
        assert (clist != null && clist[0] != null && clist[1] != null);
        if (isConsumeAPort) {
            clist[0].remove(connection);
        } else {
            clist[1].remove(connection);
        }
        if (clist[0].size() == 0 && clist[1].size() == 0) {
            this.bcConnections.remove(bcName);
        }
    }

    private void addConnection(Connection connection) {
        if (!this.isInConnectionList(this.connectionList, connection)) {
            this.connectionList.add(connection);
        }
    }

    private void addConnection(Connection connection, boolean isConsumeAPort, String bcName) {
        List<Connection>[] clist;
        this.addConnection(connection);
        List<Connection>[] cmap = this.bcConnections.get(bcName);
        if (cmap != null) {
            clist = cmap;
        } else {
            clist = new ArrayList[]{new ArrayList<Connection>(), new ArrayList<Connection>()};
            this.bcConnections.put(bcName, clist);
        }
        if (isConsumeAPort) {
            if (!this.isInConnectionList(clist[0], connection)) {
                Endpoint consume = connection.getConsume();
                for (Connection con : clist[0]) {
                    if (!con.getConsume().equals((Object)consume)) continue;
                    this.log("INFO: A new connection (" + con + ") is suppressed by an existing connection (" + connection + ").", 2);
                    clist[0].remove(con);
                    this.removeConnectionFromList(this.connectionList, con);
                    break;
                }
                clist[0].add(connection);
            }
        } else if (!this.isInConnectionList(clist[1], connection)) {
            clist[1].add(connection);
        }
    }

    private void mergeCasaConnections(Document oldCasaDocument) {
        if (oldCasaDocument == null) {
            return;
        }
        try {
            NodeList oldConnectionList = oldCasaDocument.getElementsByTagName("connection");
            Element sus = (Element)oldCasaDocument.getElementsByTagName("service-units").item(0);
            if (sus == null) {
                this.log("WARNING: Old version of casa format is not supported.", 1);
                return;
            }
            NodeList bcsuNodeList = sus.getElementsByTagName("binding-component-service-unit");
            Map<String, String> endpointID2BCName = ConnectionResolver.hashBcNames(bcsuNodeList);
            for (int i = oldConnectionList.getLength() - 1; i >= 0; --i) {
                String pBcName;
                String cBcName;
                Connection con;
                Element oldConnection = (Element)oldConnectionList.item(i);
                String oldConnectionState = oldConnection.getAttribute("state");
                String cID = oldConnection.getAttribute("consumer");
                String pID = oldConnection.getAttribute("provider");
                Endpoint c = CasaBuilder.getEndpoint(oldCasaDocument, cID);
                Endpoint p = CasaBuilder.getEndpoint(oldCasaDocument, pID);
                if (oldConnectionState.equals("deleted")) {
                    con = new Connection(c, p);
                    cBcName = endpointID2BCName.get(cID);
                    if (cBcName != null) {
                        this.removeConnection(con, true, cBcName);
                    }
                    if ((pBcName = endpointID2BCName.get(pID)) != null) {
                        this.removeConnection(con, false, pBcName);
                    }
                    if (cBcName != null || pBcName != null) continue;
                    this.removeConnection(con);
                    continue;
                }
                con = new Connection(c, p);
                if (this.isInConnectionList(this.connectionList, con)) continue;
                cBcName = endpointID2BCName.get(cID);
                if (cBcName != null) {
                    this.addConnection(con, true, cBcName);
                }
                if ((pBcName = endpointID2BCName.get(pID)) != null) {
                    this.addConnection(con, false, pBcName);
                }
                if (cBcName != null || pBcName != null) continue;
                this.addConnection(con);
            }
            NodeList endpointList = oldCasaDocument.getElementsByTagName("endpoint");
            NodeList portNodeList = oldCasaDocument.getElementsByTagName("port");
            List<String> deletedEndpoints = this.getDeletedEndpoints(portNodeList);
            for (int i = 0; i < endpointList.getLength(); ++i) {
                QName interfaceQName;
                QName serviceQName;
                String endpointName;
                Endpoint pt;
                Element endpoint = (Element)endpointList.item(i);
                String name = endpoint.getAttribute("name");
                String bcName = endpointID2BCName.get(name);
                if (bcName == null || this.isConnected(pt = new Endpoint(endpointName = endpoint.getAttribute("endpoint-name"), serviceQName = XmlUtil.getAttributeNSName((Element)endpoint, (String)"service-name"), interfaceQName = XmlUtil.getAttributeNSName((Element)endpoint, (String)"interface-name"))) || deletedEndpoints.contains(name)) continue;
                Connection con = new Connection(pt, pt);
                this.addConnection(con, true, bcName);
                this.addConnection(con, false, bcName);
            }
        }
        catch (Exception e) {
            this.log("ERROR: Problem merging new/deleted connections from old casa: " + e);
        }
    }

    private List<String> getDeletedEndpoints(NodeList portNodeList) {
        ArrayList<String> deleted = new ArrayList<String>();
        if (portNodeList != null) {
            for (int i = 0; i < portNodeList.getLength(); ++i) {
                NodeList consumesNodeList;
                Element port = (Element)portNodeList.item(i);
                String state = port.getAttribute("state");
                if (!"deleted".equals(state) || (consumesNodeList = port.getElementsByTagName("consumes")) == null || consumesNodeList.getLength() != 1) continue;
                Element consumes = (Element)consumesNodeList.item(0);
                String endpointID = consumes.getAttribute("endpoint");
                deleted.add(endpointID);
            }
        }
        return deleted;
    }

    private static Map<String, String> hashBcNames(NodeList bcsuList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < bcsuList.getLength(); ++i) {
            Element bcSU = (Element)bcsuList.item(i);
            String bcName = bcSU.getAttribute("unit-name");
            NodeList cNodeList = bcSU.getElementsByTagName("consumes");
            for (int j = 0; j < cNodeList.getLength(); ++j) {
                Element c = (Element)cNodeList.item(j);
                String endpointID = c.getAttribute("endpoint");
                map.put(endpointID, bcName);
            }
            NodeList pNodeList = bcSU.getElementsByTagName("provides");
            for (int j = 0; j < pNodeList.getLength(); ++j) {
                Element p = (Element)pNodeList.item(j);
                String endpointID = p.getAttribute("endpoint");
                map.put(endpointID, bcName);
            }
        }
        return map;
    }

    private void dumpEndpoints(List<Endpoint> endpoints, String type) {
        for (int k = 0; k < endpoints.size(); ++k) {
            Endpoint e = endpoints.get(k);
            this.log("\t" + type + "[" + k + "]: " + e.getFullyQualifiedName());
        }
    }

    private void dumpPorts(List<Port> ports) {
        for (int k = 0; k < ports.size(); ++k) {
            Port p = ports.get(k);
            this.log("\tPort[" + k + "]: " + p.getName() + ", " + p.getBinding().getQName());
        }
    }

    public void dumpConnections() {
        this.log("Connection List : " + this.connectionList.size() + " connections");
        for (Connection con : this.connectionList) {
            Endpoint c = con.getConsume();
            Endpoint p = con.getProvide();
            this.log("\t" + c.getFullyQualifiedName() + " -> " + p.getFullyQualifiedName());
        }
    }

    private void log(String msg) {
        this.task.log(msg);
    }

    private void log(String msg, int level) {
        this.task.log(msg, level);
    }
}

