/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.projects.jbi.anttasks.AntProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.anttasks.EndpointWithExtension;
import org.netbeans.modules.compapp.projects.jbi.anttasks.wsdlRepository;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.netbeans.modules.compapp.projects.jbi.util.MyFileUtil;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaBuilder {
    public static final String WSDL_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_PORT_ELEM_NAME = "port";
    public static final String WSDL_SERVICE_ELEM_NAME = "service";
    public static final String WSDL_NAME_ATTR_NAME = "name";
    public static final String XLINK_NAMESPACE_URI = "http://www.w3.org/2000/xlink";
    public static final String XLINK_NAMESPACE_PREFIX = "xlink";
    public static final String XLINK_HREF_ATTR_NAME = "href";
    public static final String XLINK_TYPE_ATTR_NAME = "type";
    public static final String WSDL_ENDPOINTS_REGION_NAME = "WSDL Endpoints";
    public static final String JBI_MODULES_REGION_NAME = "JBI Modules";
    public static final String EXTERNAL_MODULES_REGION_NAME = "External Modules";
    public static final String DEFAULT_WSDL_ENDPOINTS_REGION_WIDTH = "150";
    public static final String DEFAULT_JBI_MODULES_REGION_WIDTH = "500";
    public static final String DEFAULT_EXTERNAL_MODULES_REGION_WIDTH = "200";
    public static final String CASA_NAMESPACE_URI = "http://java.sun.com/xml/ns/casa";
    public static final String WSIT_CALLBACK_ELEMENT = "WsitCallback";
    public static final String WSIT_CALLBACK_PROJECT = "CallbackProject";
    private Map<String, String> bcNamespace2NameMap;
    private Map<String, List<Endpoint>> su2Endpoints = new HashMap<String, List<Endpoint>>();
    private Map<String, String> newEndpointMap = new HashMap<String, String>();
    private int endpointIndex = 1;
    private List<Endpoint> externalEndpoints;
    private List<Endpoint> newWsdlEndpoints;
    private Map<String, List<Endpoint>> deletedBCEndpointsMap;
    private Map<String, List<Endpoint>> oldUnconnectedBCEndpointsMap;
    private String serviceUnitsDirLoc;
    private String confDirLoc;
    private String casaFileLoc;
    private Project project;
    private wsdlRepository wsdlRepository;
    private Task task;
    private Document oldCasaDocument;
    private Document newCasaDocument;
    private Map<String, String> nsMap = new HashMap<String, String>();
    private int prefixID = 1;

    public CasaBuilder(Project project, wsdlRepository wsdlRepository2, Task task) {
        this.project = project;
        this.wsdlRepository = wsdlRepository2;
        this.task = task;
        String projName = AntProjectHelper.getServiceAssemblyID(project);
        String projPath = project.getProperty("basedir") + File.separator;
        String srcDirLoc = projPath + "src" + File.separator;
        this.confDirLoc = srcDirLoc + "conf" + File.separator;
        this.serviceUnitsDirLoc = srcDirLoc + "jbiServiceUnits" + File.separator;
        this.casaFileLoc = this.confDirLoc + projName + ".casa";
        File casaFile = new File(this.casaFileLoc);
        if (casaFile.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                this.oldCasaDocument = documentBuilder.parse(casaFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    final Document getOldCasaDocument() {
        return this.oldCasaDocument;
    }

    public Document createCasaDocument(Document jbiDocument) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.newCasaDocument = builder.newDocument();
            Element casaRoot = this.newCasaDocument.createElement("casa");
            this.newCasaDocument.appendChild(casaRoot);
            casaRoot.setAttribute("xmlns", CASA_NAMESPACE_URI);
            casaRoot.setAttribute("xmlns:xlink", XLINK_NAMESPACE_URI);
            this.bcNamespace2NameMap = org.netbeans.modules.compapp.projects.jbi.anttasks.wsdlRepository.buildBindingComponentMap(this.project);
            this.deletedBCEndpointsMap = this.getDeletedBCEndpointsMap();
            this.oldUnconnectedBCEndpointsMap = this.getUnconnectedBCEndpointsMap();
            Element casaEndpoints = this.createEndpoints(jbiDocument);
            casaRoot.appendChild(casaEndpoints);
            Element casaServiceUnits = this.createSUs(jbiDocument);
            casaRoot.appendChild(casaServiceUnits);
            Element casaConnections = this.createConnections(jbiDocument);
            casaRoot.appendChild(casaConnections);
            List<Element> casaWSDLReferences = this.createWSDLReferenceElements();
            for (Element casaElement : casaWSDLReferences) {
                casaRoot.appendChild(casaElement);
            }
            Element casaRegions = this.createRegions();
            casaRoot.appendChild(casaRegions);
            this.mergeLocations();
            this.mergeBCEndpointExtensions(true);
            this.mergeBCEndpointExtensions(false);
            this.mergeConnectionExtensions();
            XmlUtil.writeToFile((String)this.casaFileLoc, (Document)this.newCasaDocument);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e.getMessage());
        }
        return this.newCasaDocument;
    }

    private static Endpoint getEndpointInCASA(Element casaEndpointElement) {
        String endpointName = casaEndpointElement.getAttribute("endpoint-name");
        QName serviceQName = XmlUtil.getAttributeNSName((Element)casaEndpointElement, (String)"service-name");
        QName interfaceQName = XmlUtil.getAttributeNSName((Element)casaEndpointElement, (String)"interface-name");
        return new Endpoint(endpointName, serviceQName, interfaceQName);
    }

    private static String getEndpointID(Document casaDocument, Endpoint endpoint) {
        NodeList endpointNodeList = casaDocument.getElementsByTagName("endpoint");
        for (int i = 0; i < endpointNodeList.getLength(); ++i) {
            Element endpointElement = (Element)endpointNodeList.item(i);
            Endpoint casaEndpoint = CasaBuilder.getEndpointInCASA(endpointElement);
            if (!endpoint.equals((Object)casaEndpoint)) continue;
            return endpointElement.getAttribute(WSDL_NAME_ATTR_NAME);
        }
        return null;
    }

    private Element createSUs(Document jbiDocument) throws SAXException, IOException, ParserConfigurationException {
        Element casaSUs = this.newCasaDocument.createElement("service-units");
        ArrayList<String> componentIDs = new ArrayList<String>();
        if (jbiDocument == null) {
            return casaSUs;
        }
        NodeList jbiSUs = jbiDocument.getElementsByTagName("service-unit");
        for (int i = 0; i < jbiSUs.getLength(); ++i) {
            Element casaSU;
            Element jbiSU = (Element)jbiSUs.item(i);
            String componentID = this.getJBIServiceUnitComponentName(jbiSU);
            componentIDs.add(componentID);
            Element element = casaSU = this.bcNamespace2NameMap.values().contains(componentID) ? this.createBCSUFromJbiElement(jbiSU) : this.createSESUFromJbiElement(jbiSU);
            if (casaSU == null) continue;
            casaSUs.appendChild(casaSU);
        }
        if (this.oldCasaDocument != null) {
            NodeList bcSUs = this.oldCasaDocument.getElementsByTagName("binding-component-service-unit");
            for (int i = 0; i < bcSUs.getLength(); ++i) {
                Element casaSU;
                Element ports;
                Element bcSU = (Element)bcSUs.item(i);
                String bcName = bcSU.getAttribute("component-name");
                if (componentIDs.contains(bcName) || (ports = (Element)(casaSU = this.createBCSUFromCasaElement(bcSU)).getElementsByTagName("ports").item(0)).getChildNodes().getLength() <= 0) continue;
                casaSUs.appendChild(casaSU);
            }
            try {
                List<Element> externalSESUs = this.getExternalSESUs();
                for (Element oldSESU : externalSESUs) {
                    Element newSESU = this.deepCloneCasaNodeWithEndpointConversion(oldSESU);
                    casaSUs.appendChild(newSESU);
                }
            }
            catch (Exception e) {
                this.log("ERROR: Problem merging external service units from old casa: " + e + ". This does not affect regular compapp build.");
            }
        }
        return casaSUs;
    }

    private void mergeConnectionExtensions() {
        if (this.oldCasaDocument == null) {
            return;
        }
        NodeList oldConnections = this.oldCasaDocument.getElementsByTagName("connection");
        for (int i = 0; i < oldConnections.getLength(); ++i) {
            Element oldConnection = (Element)oldConnections.item(i);
            Element newConnection = CasaBuilder.findConnection(this.oldCasaDocument, oldConnection, this.newCasaDocument);
            if (newConnection == null) continue;
            CasaBuilder.deepCloneChildren(oldConnection, newConnection);
        }
    }

    private static Element findConnection(Document oldCasaDocument, Element oldConnection, Document newCasaDocument) {
        Element ret = null;
        String oldConsumerEndpointID = oldConnection.getAttribute("consumer");
        Endpoint consumerEndpoint = CasaBuilder.getEndpoint(oldCasaDocument, oldConsumerEndpointID);
        String newConsumerEndpointID = CasaBuilder.getEndpointID(newCasaDocument, consumerEndpoint);
        String oldProviderEndpointID = oldConnection.getAttribute("provider");
        Endpoint providerEndpoint = CasaBuilder.getEndpoint(oldCasaDocument, oldProviderEndpointID);
        String newProviderEndpointID = CasaBuilder.getEndpointID(newCasaDocument, providerEndpoint);
        NodeList newConnections = newCasaDocument.getElementsByTagName("connection");
        for (int i = 0; i < newConnections.getLength(); ++i) {
            Element newConnection = (Element)newConnections.item(i);
            if (!newConnection.getAttribute("consumer").equals(newConsumerEndpointID) || !newConnection.getAttribute("provider").equals(newProviderEndpointID)) continue;
            ret = newConnection;
            break;
        }
        return ret;
    }

    private void mergeBCEndpointExtensions(boolean isConsumes) {
        if (this.oldCasaDocument == null) {
            return;
        }
        NodeList oldBCSUs = this.oldCasaDocument.getElementsByTagName("binding-component-service-unit");
        for (int i = 0; i < oldBCSUs.getLength(); ++i) {
            Element oldBCSU = (Element)oldBCSUs.item(i);
            NodeList oldEndpointRefs = oldBCSU.getElementsByTagName(isConsumes ? "consumes" : "provides");
            for (int j = 0; j < oldEndpointRefs.getLength(); ++j) {
                Element oldEndpointRef = (Element)oldEndpointRefs.item(j);
                Element newEndpointRef = CasaBuilder.findEndpointRef(this.oldCasaDocument, oldEndpointRef, this.newCasaDocument, isConsumes);
                if (newEndpointRef == null) continue;
                CasaBuilder.deepCloneChildren(oldEndpointRef, newEndpointRef);
            }
        }
    }

    private static Element findEndpointRef(Document oldCasaDocument, Element oldEndpointRef, Document newCasaDocument, boolean isConsumes) {
        Element newEndpointRef = null;
        String oldEndpointID = oldEndpointRef.getAttribute("endpoint");
        Endpoint endpoint = CasaBuilder.getEndpoint(oldCasaDocument, oldEndpointID);
        String newEndpointID = CasaBuilder.getEndpointID(newCasaDocument, endpoint);
        if (newEndpointID != null) {
            newEndpointRef = CasaBuilder.getEndpointRefElement(newCasaDocument, newEndpointID, false, isConsumes);
        }
        return newEndpointRef;
    }

    public static void deepCloneChildren(Element src, Element dest) {
        assert (src != null && dest != null);
        Document destDocument = dest.getOwnerDocument();
        NodeList oldChildren = src.getChildNodes();
        for (int k = 0; k < oldChildren.getLength(); ++k) {
            Node oldChild = oldChildren.item(k);
            if (!(oldChild instanceof Element)) continue;
            Node clonedNode = CasaBuilder.deepCloneCasaNode(oldChild, destDocument);
            dest.appendChild(clonedNode);
        }
    }

    static Element getEndpointRefElement(Document casaDocument, Endpoint endpoint, boolean isSESU, boolean isConsumes) {
        String endpointID = CasaBuilder.getEndpointID(casaDocument, endpoint);
        return CasaBuilder.getEndpointRefElement(casaDocument, endpointID, isSESU, isConsumes);
    }

    private static Element getEndpointRefElement(Document casaDocument, String endpointID, boolean isSESU, boolean isConsumes) {
        NodeList sus = casaDocument.getElementsByTagName(isSESU ? "service-engine-service-unit" : "binding-component-service-unit");
        for (int i = 0; i < sus.getLength(); ++i) {
            Element su = (Element)sus.item(i);
            NodeList endpointRefs = su.getElementsByTagName(isConsumes ? "consumes" : "provides");
            for (int j = 0; j < endpointRefs.getLength(); ++j) {
                Element endpointRef = (Element)endpointRefs.item(j);
                if (!endpointRef.getAttribute("endpoint").equals(endpointID)) continue;
                return endpointRef;
            }
        }
        return null;
    }

    private Element deepCloneCasaNodeWithEndpointConversion(Element oldElement) {
        Element newElement = (Element)CasaBuilder.deepCloneCasaNode(oldElement, this.newCasaDocument);
        NodeList oldConsumesNodeList = oldElement.getElementsByTagName("consumes");
        NodeList newConsumesNodeList = newElement.getElementsByTagName("consumes");
        for (int i = 0; i < oldConsumesNodeList.getLength(); ++i) {
            Element oldConsumes = (Element)oldConsumesNodeList.item(i);
            Element newConsumes = (Element)newConsumesNodeList.item(i);
            this.fixEndpointRefElementID(oldConsumes, newConsumes);
        }
        NodeList oldProvidesNodeList = oldElement.getElementsByTagName("provides");
        NodeList newProvidesNodeList = newElement.getElementsByTagName("provides");
        for (int i = 0; i < oldProvidesNodeList.getLength(); ++i) {
            Element oldProvides = (Element)oldProvidesNodeList.item(i);
            Element newProvides = (Element)newProvidesNodeList.item(i);
            this.fixEndpointRefElementID(oldProvides, newProvides);
        }
        return newElement;
    }

    private void fixEndpointRefElementID(Element oldEndpointRef, Element newEndpointRef) {
        String oldEndpointID = oldEndpointRef.getAttribute("endpoint");
        Endpoint endpoint = CasaBuilder.getEndpoint(this.oldCasaDocument, oldEndpointID);
        String newEndpointID = this.addEndpoint(endpoint);
        newEndpointRef.setAttribute("endpoint", newEndpointID);
    }

    private Element createBCSUFromJbiElement(Element jbiSU) throws SAXException, IOException, ParserConfigurationException {
        Element bcSU = this.newCasaDocument.createElement("binding-component-service-unit");
        String suName = this.getJBIServiceUnitName(jbiSU);
        Element identification = (Element)jbiSU.getElementsByTagName("identification").item(0);
        String name = ((Element)identification.getElementsByTagName(WSDL_NAME_ATTR_NAME).item(0)).getFirstChild().getNodeValue();
        String description = ((Element)identification.getElementsByTagName("description").item(0)).getFirstChild().getNodeValue();
        Element target = (Element)jbiSU.getElementsByTagName("target").item(0);
        String componentName = ((Element)target.getElementsByTagName("component-name").item(0)).getFirstChild().getNodeValue();
        String artifactsZip = ((Element)target.getElementsByTagName("artifacts-zip").item(0)).getFirstChild().getNodeValue();
        bcSU.setAttribute(WSDL_NAME_ATTR_NAME, name);
        bcSU.setAttribute("unit-name", suName);
        bcSU.setAttribute("component-name", componentName);
        bcSU.setAttribute("description", description);
        bcSU.setAttribute("artifacts-zip", artifactsZip);
        Element casaPorts = this.createPorts(suName);
        bcSU.appendChild(casaPorts);
        return bcSU;
    }

    private Element createBCSUFromCasaElement(Element casaBCSU) throws SAXException, IOException, ParserConfigurationException {
        Element ret = this.newCasaDocument.createElement("binding-component-service-unit");
        NamedNodeMap attrs = casaBCSU.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attrNode = attrs.item(i);
            String name = attrNode.getNodeName();
            String value = attrNode.getNodeValue();
            ret.setAttribute(name, value);
        }
        String suName = ret.getAttribute("component-name");
        Element casaPorts = this.createPorts(suName);
        ret.appendChild(casaPorts);
        return ret;
    }

    private Element createSESUFromJbiElement(Element jbiSU) throws SAXException, IOException, ParserConfigurationException {
        Element seSU = this.newCasaDocument.createElement("service-engine-service-unit");
        String suName = this.getJBIServiceUnitName(jbiSU);
        List<Endpoint> suEndpointList = this.su2Endpoints.get(suName);
        Element identification = (Element)jbiSU.getElementsByTagName("identification").item(0);
        String name = ((Element)identification.getElementsByTagName(WSDL_NAME_ATTR_NAME).item(0)).getFirstChild().getNodeValue();
        Node descriptionChildNode = ((Element)identification.getElementsByTagName("description").item(0)).getFirstChild();
        String description = descriptionChildNode == null ? "" : descriptionChildNode.getNodeValue();
        Element target = (Element)jbiSU.getElementsByTagName("target").item(0);
        String componentName = ((Element)target.getElementsByTagName("component-name").item(0)).getFirstChild().getNodeValue();
        String artifactsZip = ((Element)target.getElementsByTagName("artifacts-zip").item(0)).getFirstChild().getNodeValue();
        seSU.setAttribute("x", "-1");
        seSU.setAttribute("y", "-1");
        seSU.setAttribute("internal", "true");
        seSU.setAttribute("defined", "true");
        seSU.setAttribute("unknown", "false");
        seSU.setAttribute(WSDL_NAME_ATTR_NAME, name);
        seSU.setAttribute("unit-name", suName);
        seSU.setAttribute("component-name", componentName);
        seSU.setAttribute("description", description);
        seSU.setAttribute("artifacts-zip", artifactsZip);
        if (suEndpointList != null) {
            for (Endpoint endpoint : suEndpointList) {
                Element endpointRef = endpoint.isConsumes() ? this.newCasaDocument.createElement("consumes") : this.newCasaDocument.createElement("provides");
                String endpointID = this.getNewEndpointID(endpoint);
                endpointRef.setAttribute("endpoint", endpointID);
                seSU.appendChild(endpointRef);
            }
        }
        return seSU;
    }

    private Element createConnections(Document jbiDocument) {
        Element casaConnections = this.newCasaDocument.createElement("connections");
        if (jbiDocument == null) {
            return casaConnections;
        }
        NodeList jbiConnections = jbiDocument.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi", "connection");
        for (int i = 0; i < jbiConnections.getLength(); ++i) {
            Element jbiConnection = (Element)jbiConnections.item(i);
            Element consumer = (Element)jbiConnection.getElementsByTagName("consumer").item(0);
            String consumerEndpointName = consumer.getAttribute("endpoint-name");
            QName consumerServiceQName = XmlUtil.getAttributeNSName((Element)consumer, (String)"service-name");
            String consumerID = this.getNewEndpointID(consumerServiceQName, consumerEndpointName);
            if (consumerID == null || consumerID.trim().length() == 0) continue;
            Element provider = (Element)jbiConnection.getElementsByTagName("provider").item(0);
            String providerEndpointName = provider.getAttribute("endpoint-name");
            QName providerServiceQName = XmlUtil.getAttributeNSName((Element)provider, (String)"service-name");
            String providerID = this.getNewEndpointID(providerServiceQName, providerEndpointName);
            if (providerID == null || providerID.trim().length() == 0) continue;
            Element casaConnection = this.newCasaDocument.createElement("connection");
            casaConnection.setAttribute("state", "unchanged");
            casaConnection.setAttribute("consumer", consumerID);
            casaConnection.setAttribute("provider", providerID);
            casaConnections.appendChild(casaConnection);
        }
        if (this.oldCasaDocument != null) {
            try {
                NodeList oldConnectionList = this.oldCasaDocument.getElementsByTagName("connection");
                for (int i = oldConnectionList.getLength() - 1; i >= 0; --i) {
                    String newProviderID;
                    String newConsumerID;
                    Element oldConnection = (Element)oldConnectionList.item(i);
                    String oldConnectionState = oldConnection.getAttribute("state");
                    if (!oldConnectionState.equals("deleted") && !oldConnectionState.equals("new") || (newConsumerID = this.findNewEndpointID(this.oldCasaDocument, this.newCasaDocument, oldConnection, true)) == null || newConsumerID.trim().length() == 0 || (newProviderID = this.findNewEndpointID(this.oldCasaDocument, this.newCasaDocument, oldConnection, false)) == null || newProviderID.trim().length() == 0) continue;
                    Element newConnection = this.findConnection(casaConnections, newConsumerID, newProviderID);
                    if (oldConnectionState.equals("deleted")) {
                        assert (newConnection == null);
                        newConnection = this.newCasaDocument.createElement("connection");
                        newConnection.setAttribute("consumer", newConsumerID);
                        newConnection.setAttribute("provider", newProviderID);
                        newConnection.setAttribute("state", "deleted");
                        casaConnections.appendChild(newConnection);
                        continue;
                    }
                    newConnection.setAttribute("state", "new");
                }
            }
            catch (Exception e) {
                this.log("ERROR: Problem merging deleted/new connections from old casa: " + e + ". This does not affect regular compapp build.");
            }
        }
        return casaConnections;
    }

    private List<Element> createWSDLReferenceElements() {
        ArrayList<Element> ret = new ArrayList<Element>();
        Element casaPortTypes = this.newCasaDocument.createElement("porttypes");
        Element casaBindings = this.newCasaDocument.createElement("bindings");
        Element casaServices = this.newCasaDocument.createElement("services");
        for (WSDLModel model : this.wsdlRepository.getWsdlCollection()) {
            Element linkElement;
            String relativePath = MyFileUtil.getRelativePath((File)new File(this.confDirLoc), (File)CasaBuilder.getFile(model));
            Definitions defs = model.getDefinitions();
            for (PortType pt : defs.getPortTypes()) {
                String ptName = pt.getName();
                linkElement = this.createLink(relativePath, "/definitions/portType[@name='" + ptName + "']");
                casaPortTypes.appendChild(linkElement);
            }
            for (Binding b : defs.getBindings()) {
                String bName = b.getName();
                linkElement = this.createLink(relativePath, "/definitions/binding[@name='" + bName + "']");
                casaBindings.appendChild(linkElement);
            }
            for (Service s : defs.getServices()) {
                String sName = s.getName();
                linkElement = this.createLink(relativePath, "/definitions/service[@name='" + sName + "']");
                casaServices.appendChild(linkElement);
            }
        }
        ret.add(casaPortTypes);
        ret.add(casaBindings);
        ret.add(casaServices);
        return ret;
    }

    private Element createRegions() {
        if (this.oldCasaDocument != null) {
            try {
                Element oldRegions = (Element)this.oldCasaDocument.getElementsByTagName("regions").item(0);
                return (Element)CasaBuilder.deepCloneCasaNode(oldRegions, this.newCasaDocument);
            }
            catch (Exception e) {
                this.log("ERROR: Problem merging regsions from old casa: " + e + ". This does not affect regular compapp build.");
            }
        }
        Element regions = this.newCasaDocument.createElement("regions");
        Element region = this.newCasaDocument.createElement("region");
        region.setAttribute(WSDL_NAME_ATTR_NAME, WSDL_ENDPOINTS_REGION_NAME);
        region.setAttribute("width", DEFAULT_WSDL_ENDPOINTS_REGION_WIDTH);
        regions.appendChild(region);
        region = this.newCasaDocument.createElement("region");
        region.setAttribute(WSDL_NAME_ATTR_NAME, JBI_MODULES_REGION_NAME);
        region.setAttribute("width", DEFAULT_JBI_MODULES_REGION_WIDTH);
        regions.appendChild(region);
        region = this.newCasaDocument.createElement("region");
        region.setAttribute(WSDL_NAME_ATTR_NAME, EXTERNAL_MODULES_REGION_NAME);
        region.setAttribute("width", DEFAULT_EXTERNAL_MODULES_REGION_WIDTH);
        regions.appendChild(region);
        return regions;
    }

    private String getJBIServiceUnitComponentName(Element jbiSU) {
        Element target = (Element)jbiSU.getElementsByTagName("target").item(0);
        Element compName = (Element)target.getElementsByTagName("component-name").item(0);
        return compName.getTextContent();
    }

    private String getJBIServiceUnitName(Element jbiSU) {
        Element suID = (Element)jbiSU.getElementsByTagName("identification").item(0);
        Element suName = (Element)suID.getElementsByTagName(WSDL_NAME_ATTR_NAME).item(0);
        String compApp_SuName = suName.getTextContent();
        Element jbiSA = (Element)jbiSU.getParentNode();
        Element saID = (Element)jbiSA.getElementsByTagName("identification").item(0);
        Element saName = (Element)saID.getElementsByTagName(WSDL_NAME_ATTR_NAME).item(0);
        String compAppName = saName.getTextContent();
        return compApp_SuName.substring(compAppName.length() + 1);
    }

    private static File getFile(WSDLModel model) {
        Lookup lookup = model.getModelSource().getLookup();
        File f = (File)lookup.lookup(File.class);
        if (f == null) {
            FileObject fo = (FileObject)lookup.lookup(FileObject.class);
            f = FileUtil.toFile((FileObject)fo);
        }
        return f;
    }

    private Map<String, List<Endpoint>> getDeletedBCEndpointsMap() {
        if (this.deletedBCEndpointsMap == null) {
            this.deletedBCEndpointsMap = new HashMap<String, List<Endpoint>>();
            if (this.oldCasaDocument != null) {
                NodeList portNodeList = this.oldCasaDocument.getElementsByTagName(WSDL_PORT_ELEM_NAME);
                for (int i = 0; i < portNodeList.getLength(); ++i) {
                    NodeList consumesNodeList;
                    Element port = (Element)portNodeList.item(i);
                    String state = port.getAttribute("state");
                    if (!"deleted".equals(state) || (consumesNodeList = port.getElementsByTagName("consumes")) == null || consumesNodeList.getLength() != 1) continue;
                    Element consumes = (Element)consumesNodeList.item(0);
                    String endpointID = consumes.getAttribute("endpoint");
                    Endpoint endpoint = CasaBuilder.getEndpoint(this.oldCasaDocument, endpointID);
                    Element bcsuElement = (Element)port.getParentNode().getParentNode();
                    String bcName = bcsuElement.getAttribute("component-name");
                    List<Endpoint> deletedBCEndpoints = this.deletedBCEndpointsMap.get(bcName);
                    if (deletedBCEndpoints == null) {
                        deletedBCEndpoints = new ArrayList<Endpoint>();
                        this.deletedBCEndpointsMap.put(bcName, deletedBCEndpoints);
                    }
                    deletedBCEndpoints.add(endpoint);
                }
            }
        }
        return this.deletedBCEndpointsMap;
    }

    private Map<String, List<Endpoint>> getUnconnectedBCEndpointsMap() {
        HashMap<String, List<Endpoint>> endpointMap = new HashMap<String, List<Endpoint>>();
        if (this.oldCasaDocument != null) {
            ArrayList<String> connectedEndpointIDs = new ArrayList<String>();
            NodeList connectionNodeList = this.oldCasaDocument.getElementsByTagName("connection");
            for (int i = 0; i < connectionNodeList.getLength(); ++i) {
                Element connection = (Element)connectionNodeList.item(i);
                String state = connection.getAttribute("state");
                if (state.equals("deleted")) continue;
                connectedEndpointIDs.add(connection.getAttribute("consumer"));
                connectedEndpointIDs.add(connection.getAttribute("provider"));
            }
            NodeList portNodeList = this.oldCasaDocument.getElementsByTagName(WSDL_PORT_ELEM_NAME);
            ArrayList endpointList = new ArrayList();
            NodeList endpointNodeList = this.oldCasaDocument.getElementsByTagName("endpoint");
            block1: for (int i = 0; i < endpointNodeList.getLength(); ++i) {
                Element endpointElement = (Element)endpointNodeList.item(i);
                String endpointID = endpointElement.getAttribute(WSDL_NAME_ATTR_NAME);
                if (connectedEndpointIDs.contains(endpointID)) continue;
                for (int j = 0; j < portNodeList.getLength(); ++j) {
                    Element portElement = (Element)portNodeList.item(j);
                    String id = this.getCasaPortEndpointID(portElement);
                    if (!id.equals(endpointID)) continue;
                    Element bcsuElement = (Element)portElement.getParentNode().getParentNode();
                    String componentName = bcsuElement.getAttribute("component-name");
                    ArrayList<Endpoint> list = (ArrayList<Endpoint>)endpointMap.get(componentName);
                    if (list == null) {
                        list = new ArrayList<Endpoint>();
                        endpointMap.put(componentName, list);
                    }
                    Endpoint endpoint = CasaBuilder.getEndpointInCASA(endpointElement);
                    list.add(endpoint);
                    continue block1;
                }
            }
        }
        return endpointMap;
    }

    private String getCasaPortEndpointID(Element portElement) {
        NodeList consumesNodeList = portElement.getElementsByTagName("consumes");
        if (consumesNodeList != null && consumesNodeList.getLength() == 1) {
            Element consumes = (Element)consumesNodeList.item(0);
            return consumes.getAttribute("endpoint");
        }
        return null;
    }

    private List<Element> getExternalSESUs() {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (this.oldCasaDocument != null) {
            NodeList oldCasaSUs = this.oldCasaDocument.getElementsByTagName("service-engine-service-unit");
            for (int i = 0; i < oldCasaSUs.getLength(); ++i) {
                Element oldCasaSU = (Element)oldCasaSUs.item(i);
                String type = oldCasaSU.getAttribute("internal");
                if (type == null || !type.equals("false")) continue;
                ret.add(oldCasaSU);
            }
        }
        return ret;
    }

    private List<Endpoint> getExternalEndpoints() {
        if (this.externalEndpoints == null) {
            this.externalEndpoints = new ArrayList<Endpoint>();
            for (Element sesu : this.getExternalSESUs()) {
                NodeList consumesNodeList = sesu.getElementsByTagName("consumes");
                for (int j = 0; j < consumesNodeList.getLength(); ++j) {
                    Element consumes = (Element)consumesNodeList.item(j);
                    String endpointID = consumes.getAttribute("endpoint");
                    Endpoint endpoint = CasaBuilder.getEndpoint(this.oldCasaDocument, endpointID);
                    this.externalEndpoints.add(endpoint);
                }
                NodeList providesNodeList = sesu.getElementsByTagName("provides");
                for (int j = 0; j < providesNodeList.getLength(); ++j) {
                    Element provides = (Element)providesNodeList.item(j);
                    String endpointID = provides.getAttribute("endpoint");
                    Endpoint endpoint = CasaBuilder.getEndpoint(this.oldCasaDocument, endpointID);
                    this.externalEndpoints.add(endpoint);
                }
            }
        }
        return this.externalEndpoints;
    }

    private void mergeLocations() {
        if (this.oldCasaDocument == null) {
            return;
        }
        NodeList oldSESUs = this.oldCasaDocument.getElementsByTagName("service-engine-service-unit");
        NodeList newSESUs = this.newCasaDocument.getElementsByTagName("service-engine-service-unit");
        block0: for (int i = 0; i < oldSESUs.getLength(); ++i) {
            Element oldSESU = (Element)oldSESUs.item(i);
            String oldSESUName = oldSESU.getAttribute("unit-name");
            for (int j = 0; j < newSESUs.getLength(); ++j) {
                Element newSESU = (Element)newSESUs.item(j);
                String newSESUName = newSESU.getAttribute("unit-name");
                if (!newSESUName.equals(oldSESUName)) continue;
                newSESU.setAttribute("x", oldSESU.getAttribute("x"));
                newSESU.setAttribute("y", oldSESU.getAttribute("y"));
                continue block0;
            }
        }
        NodeList oldPorts = this.oldCasaDocument.getElementsByTagName(WSDL_PORT_ELEM_NAME);
        NodeList newPorts = this.newCasaDocument.getElementsByTagName(WSDL_PORT_ELEM_NAME);
        for (int i = 0; i < oldPorts.getLength(); ++i) {
            Element oldPort = (Element)oldPorts.item(i);
            Element newPort = this.findLinkContainerElement(newPorts, oldPort);
            if (newPort == null) continue;
            newPort.setAttribute("x", oldPort.getAttribute("x"));
            newPort.setAttribute("y", oldPort.getAttribute("y"));
            String bindingType = oldPort.getAttribute("bindingType");
            if (bindingType != null && bindingType.trim().length() > 0) {
                newPort.setAttribute("bindingType", bindingType);
            }
            NodeList pNodes = oldPort.getChildNodes();
            for (int k = 0; k < pNodes.getLength(); ++k) {
                Element pNode;
                String ns;
                if (!(pNodes.item(k) instanceof Element) || CASA_NAMESPACE_URI.equals(ns = (pNode = (Element)pNodes.item(k)).getNamespaceURI())) continue;
                Node clonedNode = CasaBuilder.deepCloneCasaNode(pNode, this.newCasaDocument);
                newPort.appendChild(clonedNode);
            }
        }
    }

    private static Element getCasaEndpointElement(Document casaDocument, String endpointID) {
        NodeList endpoints = casaDocument.getElementsByTagName("endpoint");
        for (int i = 0; i < endpoints.getLength(); ++i) {
            Element endpoint = (Element)endpoints.item(i);
            if (!endpoint.getAttribute(WSDL_NAME_ATTR_NAME).equals(endpointID)) continue;
            return endpoint;
        }
        return null;
    }

    private String findNewEndpointID(Document oldCasaDocument, Document newCasaDocument, Element oldConnection, boolean isConsumes) {
        String oldEndpointID = isConsumes ? oldConnection.getAttribute("consumer") : oldConnection.getAttribute("provider");
        Element oldEndpoint = CasaBuilder.getCasaEndpointElement(oldCasaDocument, oldEndpointID);
        if (oldEndpoint != null) {
            String oldEndpointName = oldEndpoint.getAttribute("endpoint-name");
            QName oldServiceQName = XmlUtil.getAttributeNSName((Element)oldEndpoint, (String)"service-name");
            return this.getNewEndpointID(oldServiceQName, oldEndpointName);
        }
        return null;
    }

    private Element findConnection(Element connections, String consumerID, String providerID) {
        NodeList connectionsNodeList = connections.getElementsByTagName("connection");
        for (int i = 0; i < connectionsNodeList.getLength(); ++i) {
            Element connection = (Element)connectionsNodeList.item(i);
            if (!connection.getAttribute("consumer").equals(consumerID) || !connection.getAttribute("provider").equals(providerID)) continue;
            return connection;
        }
        return null;
    }

    static Node deepCloneCasaNode(Node node, Document targetDocument) throws DOMException {
        String nodeName = node.getNodeName();
        Node clonedNode = null;
        if (node instanceof Element) {
            clonedNode = targetDocument.createElement(nodeName);
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String oldValuePrefix;
                String oldNamespaceURI;
                Node attrNode = attrs.item(i);
                String attrName = attrNode.getNodeName();
                String attrValue = attrNode.getNodeValue();
                if (!attrName.equals("xmlns") && attrValue.indexOf(":") != -1 && !(oldNamespaceURI = XmlUtil.getNamespaceURI((Element)((Element)node), (String)(oldValuePrefix = attrValue.substring(0, attrValue.indexOf(":"))))).equals("")) {
                    ((Element)clonedNode).setAttribute("xmlns:" + oldValuePrefix, oldNamespaceURI);
                }
                clonedNode.setAttribute(attrName, attrValue);
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                Node clonedChild = CasaBuilder.deepCloneCasaNode(child, targetDocument);
                clonedNode.appendChild(clonedChild);
            }
        } else if (node instanceof Text) {
            clonedNode = targetDocument.createTextNode(((Text)node).getWholeText());
        } else assert (false) : "deep clone node of type " + node.getClass().getName() + " is not implemented yet.";
        return clonedNode;
    }

    private Element findLinkContainerElement(NodeList newPortNodeList, Element oldPort) {
        NodeList oldLinkNodeList = oldPort.getElementsByTagName("link");
        for (int i = 0; i < oldLinkNodeList.getLength(); ++i) {
            Element oldLink = (Element)oldLinkNodeList.item(i);
            String oldLinkHref = oldLink.getAttributeNS(XLINK_NAMESPACE_URI, XLINK_HREF_ATTR_NAME);
            for (int j = 0; j < newPortNodeList.getLength(); ++j) {
                Element newPort = (Element)newPortNodeList.item(j);
                NodeList newLinkNodeList = newPort.getElementsByTagName("link");
                for (int k = 0; k < newLinkNodeList.getLength(); ++k) {
                    Element newLink = (Element)newLinkNodeList.item(k);
                    String newLinkHref = newLink.getAttribute("xlink:href");
                    if (!newLinkHref.equals(oldLinkHref)) continue;
                    return newPort;
                }
            }
        }
        return null;
    }

    static Endpoint getEndpoint(Document casaDocument, String endpointID) {
        NodeList endpointList = casaDocument.getElementsByTagName("endpoint");
        for (int i = 0; i < endpointList.getLength(); ++i) {
            Element endpoint = (Element)endpointList.item(i);
            if (!endpoint.getAttribute(WSDL_NAME_ATTR_NAME).equals(endpointID)) continue;
            return CasaBuilder.getEndpointInCASA(endpoint);
        }
        return null;
    }

    private static List<Endpoint> getEndpoints(Document casaDocument) {
        ArrayList<Endpoint> ret = new ArrayList<Endpoint>();
        if (casaDocument != null) {
            NodeList endpointList = casaDocument.getElementsByTagName("endpoint");
            for (int i = 0; i < endpointList.getLength(); ++i) {
                Element endpointElement = (Element)endpointList.item(i);
                Endpoint endpoint = CasaBuilder.getEndpointInCASA(endpointElement);
                ret.add(endpoint);
            }
        }
        return ret;
    }

    private List<Endpoint> getNewWsdlEndpoints() {
        if (this.newWsdlEndpoints == null) {
            this.newWsdlEndpoints = new ArrayList<Endpoint>();
            for (WSDLModel model : this.wsdlRepository.getWsdlCollection()) {
                String tns = model.getDefinitions().getTargetNamespace();
                for (Service service : model.getDefinitions().getServices()) {
                    QName serviceQName = new QName(tns, service.getName());
                    for (Port port : service.getPorts()) {
                        QName interfaceQName;
                        Endpoint endpoint;
                        String portName = port.getName();
                        Binding binding = (Binding)port.getBinding().get();
                        if (binding == null || this.newWsdlEndpoints.contains(endpoint = new Endpoint(portName, serviceQName, interfaceQName = binding.getType().getQName()))) continue;
                        this.newWsdlEndpoints.add(endpoint);
                    }
                }
            }
        }
        return this.newWsdlEndpoints;
    }

    private List<Endpoint> getNewCasaEndpoints(Document jbiDocument) {
        List<Endpoint> oldCasaEndpoints = CasaBuilder.getEndpoints(this.oldCasaDocument);
        ArrayList<Endpoint> newSUEndpoints = new ArrayList<Endpoint>();
        if (jbiDocument == null) {
            return new ArrayList<Endpoint>();
        }
        NodeList jbiSUs = jbiDocument.getElementsByTagName("service-unit");
        for (int i = 0; i < jbiSUs.getLength(); ++i) {
            Element jbiSU = (Element)jbiSUs.item(i);
            String suName = this.getJBIServiceUnitName(jbiSU);
            List<Endpoint> suEndpoints = this.loadSUEndpoints(suName);
            this.su2Endpoints.put(suName, suEndpoints);
            if (suEndpoints == null) continue;
            for (Endpoint suEndpoint : suEndpoints) {
                if (newSUEndpoints.contains(suEndpoint)) continue;
                newSUEndpoints.add(suEndpoint);
            }
        }
        ArrayList<Endpoint> externalAndWsdlEndpoints = new ArrayList<Endpoint>();
        externalAndWsdlEndpoints.addAll(this.getExternalEndpoints());
        externalAndWsdlEndpoints.addAll(this.getNewWsdlEndpoints());
        ArrayList<Endpoint> newCasaEndpoints = new ArrayList<Endpoint>();
        block2: for (Endpoint oldCasaEndpoint : oldCasaEndpoints) {
            for (Endpoint endpoint : externalAndWsdlEndpoints) {
                if (!oldCasaEndpoint.equals((Object)endpoint)) continue;
                newCasaEndpoints.add(oldCasaEndpoint);
                continue block2;
            }
        }
        for (Endpoint suEndpoint : newSUEndpoints) {
            if (newCasaEndpoints.contains(suEndpoint)) continue;
            newCasaEndpoints.add(suEndpoint);
        }
        this.debugLog("old CASA Endpoints:");
        for (Endpoint endpoint : oldCasaEndpoints) {
            this.debugLog("    " + endpoint.getFullyQualifiedName());
        }
        this.debugLog("new WSDL Endpoints:");
        for (Endpoint endpoint : this.newWsdlEndpoints) {
            this.debugLog("    " + endpoint.getFullyQualifiedName());
        }
        this.debugLog("external Endpoints:");
        for (Endpoint endpoint : this.externalEndpoints) {
            this.debugLog("    " + endpoint.getFullyQualifiedName());
        }
        this.debugLog("new SU Endpoints:");
        for (Endpoint endpoint : newSUEndpoints) {
            this.debugLog("    " + endpoint.getFullyQualifiedName());
        }
        this.debugLog("new CASA Endpoints:");
        for (Endpoint endpoint : newCasaEndpoints) {
            this.debugLog("    " + endpoint.getFullyQualifiedName());
        }
        return newCasaEndpoints;
    }

    private Element createEndpoints(Document jbiDocument) {
        Element endpoints = this.newCasaDocument.createElement("endpoints");
        Element casaRoot = (Element)this.newCasaDocument.getElementsByTagName("casa").item(0);
        casaRoot.appendChild(endpoints);
        List<Endpoint> newCasaEndpoints = this.getNewCasaEndpoints(jbiDocument);
        for (Endpoint endpoint : newCasaEndpoints) {
            this.addEndpoint(endpoint);
        }
        return endpoints;
    }

    private String addEndpoint(Endpoint endpoint) {
        String key = endpoint.getFullyQualifiedName();
        String endpointID = this.newEndpointMap.get(key);
        if (endpointID == null) {
            endpointID = "endpoint" + this.endpointIndex;
            ++this.endpointIndex;
            this.newEndpointMap.put(key, endpointID);
            Element endpoints = (Element)this.newCasaDocument.getElementsByTagName("endpoints").item(0);
            Element casaEndpoint = this.newCasaDocument.createElement("endpoint");
            casaEndpoint.setAttribute(WSDL_NAME_ATTR_NAME, endpointID);
            casaEndpoint.setAttribute("endpoint-name", endpoint.getEndpointName());
            this.setAttributeQName(casaEndpoint, "service-name", endpoint.getServiceQName());
            this.setAttributeQName(casaEndpoint, "interface-name", endpoint.getInterfaceQName());
            if (endpoint instanceof EndpointWithExtension) {
                EndpointWithExtension endpointWithExtension = (EndpointWithExtension)endpoint;
                String displayName = endpointWithExtension.getDisplayName();
                String processName = endpointWithExtension.getProcessName();
                String filePath = endpointWithExtension.getFilePath();
                if (displayName != null && displayName.length() > 0) {
                    casaEndpoint.setAttribute("display-name", displayName);
                }
                if (processName != null && processName.length() > 0) {
                    casaEndpoint.setAttribute("process-name", processName);
                }
                if (filePath != null && filePath.length() > 0) {
                    casaEndpoint.setAttribute("file-path", filePath);
                }
            }
            endpoints.appendChild(casaEndpoint);
        }
        return endpointID;
    }

    private String getNewEndpointID(QName serviceQName, String endpointName) {
        String key = serviceQName.toString() + "." + endpointName;
        return this.newEndpointMap.get(key);
    }

    private String getNewEndpointID(Endpoint endpoint) {
        String key = endpoint.getFullyQualifiedName();
        return this.newEndpointMap.get(key);
    }

    private void setAttributeQName(Element element, String attrName, QName attrValueQName) {
        String attrQValue;
        String attrValueNamespace = attrValueQName.getNamespaceURI();
        String attrValue = attrValueQName.getLocalPart();
        if (attrValueNamespace.equals("") && attrValue.equals("")) {
            attrQValue = "";
        } else {
            String prefix = this.nsMap.get(attrValueNamespace);
            if (prefix == null) {
                prefix = "ns" + this.prefixID;
                ++this.prefixID;
                element.getOwnerDocument().getDocumentElement().setAttribute("xmlns:" + prefix, attrValueNamespace);
                this.nsMap.put(attrValueNamespace, prefix);
            }
            attrQValue = prefix + ":" + attrValue;
        }
        element.setAttribute(attrName, attrQValue);
    }

    private List<Endpoint> loadSUEndpoints(String suName) {
        ArrayList<Endpoint> suEndpointList = new ArrayList<Endpoint>();
        File suJbiFile = new File(this.serviceUnitsDirLoc + suName + File.separator + "jbi.xml");
        if (suJbiFile.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            try {
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                Document suJbiDocument = documentBuilder.parse(suJbiFile);
                NodeList servicesElements = suJbiDocument.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi", "services");
                for (int i = 0; i < servicesElements.getLength(); ++i) {
                    Element servicesElement = (Element)servicesElements.item(i);
                    NodeList children = servicesElement.getChildNodes();
                    for (int k = 0; k < children.getLength(); ++k) {
                        NodeList filePathElements;
                        NodeList processNameElements;
                        Node child = children.item(k);
                        if (!(child instanceof Element)) continue;
                        Element e = (Element)child;
                        String endpointName = e.getAttribute("endpoint-name");
                        String serviceName = e.getAttribute("service-name");
                        String serviceNS = null;
                        int idx = serviceName.indexOf(58);
                        if (idx > 0) {
                            String prefix = serviceName.substring(0, idx);
                            serviceNS = suJbiDocument.getDocumentElement().getAttribute("xmlns:" + prefix);
                            serviceName = serviceName.substring(idx + 1);
                        }
                        String interfaceName = e.getAttribute("interface-name");
                        String interfaceNS = "";
                        idx = interfaceName.indexOf(58);
                        if (idx > 0) {
                            String prefix = interfaceName.substring(0, idx);
                            interfaceNS = suJbiDocument.getDocumentElement().getAttribute("xmlns:" + prefix);
                            interfaceName = interfaceName.substring(idx + 1);
                        }
                        if (interfaceName == null || interfaceName.length() <= 0) continue;
                        EndpointWithExtension endpoint = new EndpointWithExtension(endpointName, new QName(serviceNS, serviceName), new QName(interfaceNS, interfaceName), e.getLocalName().equals("consumes"));
                        NodeList displayNameElements = e.getElementsByTagNameNS("http://www.sun.com/jbi/descriptor/service-unit", "display-name");
                        if (displayNameElements.getLength() == 1) {
                            String displayName = displayNameElements.item(0).getTextContent();
                            endpoint.setDisplayName(displayName);
                        }
                        if ((processNameElements = e.getElementsByTagNameNS("http://www.sun.com/jbi/descriptor/service-unit", "process-name")).getLength() == 1) {
                            String processName = processNameElements.item(0).getTextContent();
                            endpoint.setProcessName(processName);
                        }
                        if ((filePathElements = e.getElementsByTagNameNS("http://www.sun.com/jbi/descriptor/service-unit", "file-path")).getLength() == 1) {
                            String filePath = filePathElements.item(0).getTextContent();
                            endpoint.setFilePath(filePath);
                        }
                        suEndpointList.add(endpoint);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return suEndpointList;
        }
        return null;
    }

    private boolean isInEndpointList(List<Endpoint> endpointList, QName serviceQName, String portName) {
        if (endpointList != null) {
            for (Endpoint endpoint : endpointList) {
                if (!endpoint.getEndpointName().equals(portName) || !endpoint.getServiceQName().equals(serviceQName)) continue;
                return true;
            }
        }
        return false;
    }

    private Element createPorts(String bcName) {
        this.debugLog("create Ports for binding component " + bcName);
        Element ports = this.newCasaDocument.createElement("ports");
        HashMap<String, Element> casaPortMap = new HashMap<String, Element>();
        List<Endpoint> suEndpoints = this.su2Endpoints.get(bcName);
        HashMap<String, Port> portMap = new HashMap<String, Port>();
        for (WSDLModel model : this.wsdlRepository.getWsdlCollection()) {
            String relativePath = MyFileUtil.getRelativePath((File)new File(this.confDirLoc), (File)CasaBuilder.getFile(model));
            this.debugLog("    WSDL: " + relativePath);
            String tns = ((WSDLComponent)model.getRootComponent()).getPeer().getAttribute("targetNamespace");
            for (Service s : model.getDefinitions().getServices()) {
                String serviceName = s.getName();
                QName serviceQName = new QName(tns, serviceName);
                for (Port p : s.getPorts()) {
                    String portName = p.getName();
                    this.debugLog("          Endpoint: " + serviceQName + ":" + portName);
                    String key = tns + ":" + serviceName + ":" + portName;
                    if (portMap.get(key) != null) continue;
                    portMap.put(key, p);
                    boolean isSUEndpoint = this.isInEndpointList(suEndpoints, serviceQName, portName);
                    boolean isLiveDeletedBCEndpoint = false;
                    boolean isLiveUnconnectedEndpoint = false;
                    if (isSUEndpoint) {
                        this.debugLog("              is a SU endpoint.");
                    } else {
                        List<Endpoint> unconnectedBCEndpoints;
                        List<Endpoint> deletedBCEndpoints = this.deletedBCEndpointsMap.get(bcName);
                        if (this.isInEndpointList(deletedBCEndpoints, serviceQName, portName) && this.isInEndpointList(this.newWsdlEndpoints, serviceQName, portName)) {
                            isLiveDeletedBCEndpoint = true;
                            this.debugLog("              is a live deleted endpoint.");
                        }
                        if (!isLiveDeletedBCEndpoint && this.isInEndpointList(unconnectedBCEndpoints = this.oldUnconnectedBCEndpointsMap.get(bcName), serviceQName, portName) && this.isInEndpointList(this.newWsdlEndpoints, serviceQName, portName)) {
                            isLiveUnconnectedEndpoint = true;
                            this.debugLog("              is a live unconnected endpoint.");
                        }
                    }
                    if (!isSUEndpoint && !isLiveDeletedBCEndpoint && !isLiveUnconnectedEndpoint) continue;
                    String fullyQualifiedPortName = serviceQName.toString() + "." + portName;
                    Element port = (Element)casaPortMap.get(fullyQualifiedPortName);
                    if (port == null) {
                        port = this.createPort(relativePath, serviceQName, portName);
                        ports.appendChild(port);
                        casaPortMap.put(fullyQualifiedPortName, port);
                        if (!isLiveDeletedBCEndpoint) continue;
                        port.setAttribute("state", "deleted");
                        continue;
                    }
                    Element casaLinkElement = this.createLinkForWsdlPort(relativePath, serviceName, portName);
                    port.appendChild(casaLinkElement);
                }
            }
        }
        return ports;
    }

    private Element createPort(String relativePath, QName serviceQName, String portName) {
        Element ret = this.newCasaDocument.createElement(WSDL_PORT_ELEM_NAME);
        ret.setAttribute("x", "0");
        ret.setAttribute("y", "-1");
        Element linkElement = this.createLinkForWsdlPort(relativePath, serviceQName.getLocalPart(), portName);
        ret.appendChild(linkElement);
        String endpointID = this.getNewEndpointID(serviceQName, portName);
        Element cEndpointRef = this.newCasaDocument.createElement("consumes");
        cEndpointRef.setAttribute("endpoint", endpointID);
        ret.appendChild(cEndpointRef);
        Element pEndpointRef = this.newCasaDocument.createElement("provides");
        pEndpointRef.setAttribute("endpoint", endpointID);
        ret.appendChild(pEndpointRef);
        return ret;
    }

    private Element createLinkForWsdlPort(String relativePath, String serviceName, String portName) {
        String uri = "/definitions/service[@name='" + serviceName + "']/port[@name='" + portName + "']";
        return this.createLink(relativePath, uri);
    }

    private Element createLink(String relativePath, String uri) {
        Element ret = this.newCasaDocument.createElement("link");
        ret.setAttribute("xlink:type", "simple");
        ret.setAttribute("xlink:href", relativePath + "#xpointer(" + uri + ")");
        return ret;
    }

    private void log(String msg) {
        this.task.log(msg);
    }

    private void debugLog(String msg) {
        this.task.log(msg, 4);
    }
}

