/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.projects.jbi.anttasks.AntProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.anttasks.BCSUDescriptorBuilder;
import org.netbeans.modules.compapp.projects.jbi.anttasks.CasaBuilder;
import org.netbeans.modules.compapp.projects.jbi.anttasks.ConnectionResolver;
import org.netbeans.modules.compapp.projects.jbi.anttasks.ModelUtil;
import org.netbeans.modules.compapp.projects.jbi.anttasks.MyValidation;
import org.netbeans.modules.compapp.projects.jbi.anttasks.SAConnectionsBuilder;
import org.netbeans.modules.compapp.projects.jbi.anttasks.wsdlRepository;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.Endpoint;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.PtConnection;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildServiceAssembly
extends Task {
    private String showLogOption = "false";
    private boolean showLog = false;
    private wsdlRepository mRepo;
    private Document jbiDocument;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private File mergedCatalogFile;
    private String projDirLoc;
    private String serviceUnitsDirLoc;
    private String jbiasaDirLoc;
    private String wsitCallbackProjects;
    private static final String SOAP_BC = "sun-http-binding";
    private boolean saInternalRouting = true;
    private boolean ignoreJ2EEPorts = true;
    private List<String> bcNames;
    private List<String> suJarNames;
    public static final String BC_JARNAME = "BCDeployment.jar";
    public static final String ENDPOINT_XML = "endpoints.xml";
    public static final String SU_JBIXML_PATH = "META-INF/jbi.xml";
    public static final String SU_CATALOGXML_PATH = "META-INF/catalog.xml";

    public String getShowLogOption() {
        return this.showLogOption;
    }

    public void setShowLogOption(String showLogOption) {
        this.showLogOption = showLogOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.showLog = this.showLogOption.equalsIgnoreCase("true");
        ZipFile genericBCJar = null;
        Project p = this.getProject();
        String confDir = p.getProperty("meta.inf");
        if (confDir == null || confDir.length() < 1) {
            return;
        }
        this.wsitCallbackProjects = p.getProperty("WsitCallbackProjects");
        String javaeeJars = p.getProperty("jbi.content.javaee.jars");
        String jars = p.getProperty("jbi.content.additional");
        this.projDirLoc = p.getProperty("basedir") + File.separator;
        String srcDirLoc = this.projDirLoc + "src" + File.separator;
        String confDirLoc = srcDirLoc + "conf" + File.separator;
        this.serviceUnitsDirLoc = srcDirLoc + "jbiServiceUnits";
        this.jbiasaDirLoc = srcDirLoc + "jbiasa";
        String catalogDirLoc = this.serviceUnitsDirLoc + File.separator + "META-INF";
        String connectionsFileLoc = confDirLoc + "connections.xml";
        String buildDir = this.projDirLoc + p.getProperty("build.dir");
        File buildMetaInfDir = new File(buildDir + "/META-INF");
        if (!buildMetaInfDir.exists()) {
            buildMetaInfDir.mkdirs();
        }
        this.saInternalRouting = this.getBooleanProperty(p.getProperty("com.sun.jbi.sa.internal.routing"), true);
        try {
            FileObject baseDirFO = FileUtil.toFileObject((File)p.getBaseDir());
            if (baseDirFO != null) {
                FileSystem fs = baseDirFO.getFileSystem();
                fs.refresh(true);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.mRepo = new wsdlRepository(p, this);
        this.log("Validating CompApp project...");
        this.validateCompAppProject();
        try {
            String jbiFileLoc = buildDir + "/META-INF/jbi.xml";
            String genericBCJarFileLoc = buildDir + "/BCDeployment.jar";
            File bDir = new File(buildDir);
            if (!bDir.exists()) {
                bDir.mkdirs();
            }
            String ciFileLoc = confDirLoc + "ComponentInformation.xml";
            this.bcNames = this.loadBindingComponentNames(ciFileLoc);
            String asiFileLoc = confDirLoc + "AssemblyInformation.xml";
            this.loadAssemblyInfo(asiFileLoc);
            List<String> srcJarPaths = this.getJarList(jars);
            List<String> javaEEJarPaths = this.getJarList(javaeeJars);
            ArrayList<String> saEEJarPaths = new ArrayList<String>();
            for (String srcJarPath : srcJarPaths) {
                if (javaEEJarPaths != null && javaEEJarPaths.contains(srcJarPath)) {
                    srcJarPath = this.getLocalJavaEEJarPath(buildDir, srcJarPath);
                    saEEJarPaths.add(srcJarPath);
                    this.createEndpointsFrom(srcJarPath);
                    continue;
                }
                if (srcJarPath.indexOf(58) < 0 && !srcJarPath.startsWith("/")) {
                    srcJarPath = this.projDirLoc + srcJarPath;
                }
                File srcJarFile = new File(srcJarPath);
                String jarName = this.getShortName(srcJarPath);
                if (!srcJarFile.exists()) {
                    this.log(" Error: Missing project Sub-Assembly: " + srcJarPath);
                    continue;
                }
                if (!this.suJarNames.contains(jarName)) {
                    this.log(" Error: Cannot locate service unit for " + jarName);
                    continue;
                }
                String destJarPath = buildDir + File.separator + jarName;
                this.copyJarFile(srcJarPath, destJarPath);
            }
            CasaBuilder casaBuilder = new CasaBuilder(this.project, this.mRepo, this);
            Document oldCasaDocument = casaBuilder.getOldCasaDocument();
            this.log("Resolving connections...");
            ConnectionResolver connectionResolver = new ConnectionResolver(this, this.showLog, this.saInternalRouting);
            connectionResolver.resolveConnections(this.mRepo, oldCasaDocument);
            this.log("Writing connections out to connections.xml...");
            SAConnectionsBuilder dd = new SAConnectionsBuilder();
            String saName = AntProjectHelper.getServiceAssemblyID(p);
            String saDescription = AntProjectHelper.getServiceAssemblyDescription(p);
            dd.buildDOMTree(connectionResolver, saName, saDescription, oldCasaDocument);
            dd.writeToFile(connectionsFileLoc);
            this.log("Generating Service Assembly jbi.xml...");
            this.generateServiceAssemblyDescriptor(connectionResolver, connectionsFileLoc, jbiFileLoc, oldCasaDocument);
            this.log("Merging component projects' catalogs...");
            this.MergeSeJarCatalogs(catalogDirLoc);
            this.log("Generating Binding Component Service Units...");
            genericBCJar = new JarFile(genericBCJarFileLoc);
            HashMap<String, BCSUDescriptorBuilder> bcsuDescriptorBuilderMap = new HashMap<String, BCSUDescriptorBuilder>();
            HashMap<String, String> bcJarMap = new HashMap<String, String>();
            for (String bcName : connectionResolver.getBCNames()) {
                String bcJarName = null;
                for (int k = 0; k < this.suJarNames.size(); ++k) {
                    String name = this.suJarNames.get(k);
                    if (name.indexOf(bcName) == -1) continue;
                    bcJarName = buildDir + File.separator + name;
                    this.log("  creating " + name);
                    break;
                }
                if (bcJarName != null) {
                    BCSUDescriptorBuilder bcsuDescriptorBuilder = this.createBCSUDescriptor(bcName, connectionResolver);
                    bcsuDescriptorBuilderMap.put(bcName, bcsuDescriptorBuilder);
                    bcJarMap.put(bcName, bcJarName);
                    continue;
                }
                this.log("ERROR: Cannot create binding component jar file for " + bcName);
            }
            this.log("Creating/Updating CASA...");
            Document newCasaDocument = casaBuilder.createCasaDocument(this.jbiDocument);
            for (String bcName : bcsuDescriptorBuilderMap.keySet()) {
                BCSUDescriptorBuilder bcsuDescriptorBuilder = (BCSUDescriptorBuilder)bcsuDescriptorBuilderMap.get(bcName);
                bcsuDescriptorBuilder.decorateEndpoints(newCasaDocument);
                this.createBCJar((String)bcJarMap.get(bcName), (JarFile)genericBCJar, bcsuDescriptorBuilder, bcName);
            }
            this.log("Filtering Java EE Endpoints...");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Build SA Failed: " + e.toString());
        }
        finally {
            try {
                if (genericBCJar != null) {
                    genericBCJar.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    private List<String> getJarList(String commaSeparatedList) {
        ArrayList<String> ret = new ArrayList<String>();
        if (commaSeparatedList != null) {
            StringTokenizer st = new StringTokenizer(commaSeparatedList, ";");
            String tkn = null;
            while (st.hasMoreTokens()) {
                tkn = st.nextToken();
                ret.add(tkn);
            }
        }
        return ret;
    }

    private boolean getBooleanProperty(String str, boolean def) {
        boolean bFlag = def;
        bFlag = str == null ? def : str.equalsIgnoreCase("true");
        return bFlag;
    }

    private void MergeSeJarCatalogs(String catalogDirLoc) {
        File catalogFile;
        File catalogDir = new File(catalogDirLoc);
        if (!catalogDir.exists()) {
            return;
        }
        ArrayList<File> catalogFiles = new ArrayList<File>();
        File[] children = catalogDir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            catalogFile = new File(child, "catalog.xml");
            if (!catalogFile.exists()) continue;
            catalogFiles.add(catalogFile);
        }
        if (catalogFiles.size() < 1) {
            return;
        }
        Document mergedCatalogDoc = null;
        this.mergedCatalogFile = new File(catalogDir.getParentFile(), "catalog.xml");
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            for (int i = 0; i < catalogFiles.size(); ++i) {
                catalogFile = (File)catalogFiles.get(i);
                if (i == 0) {
                    mergedCatalogDoc = this.getUpdatedCatalogDocument(catalogFile, builder);
                    continue;
                }
                Document catalogDoc = this.getUpdatedCatalogDocument(catalogFile, builder);
                this.importCatalog(mergedCatalogDoc, catalogDoc);
            }
            this.mergedCatalogFile.createNewFile();
            DOMSource src = new DOMSource(mergedCatalogDoc);
            FileOutputStream fos = new FileOutputStream(this.mergedCatalogFile);
            StreamResult rest = new StreamResult(fos);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer transformer = transFact.newTransformer();
            transformer.transform(src, rest);
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            this.log("Exception: A processing error occurred; " + ex);
        }
    }

    private Document getUpdatedCatalogDocument(File catalogFile, DocumentBuilder builder) throws Exception {
        File sesuDir = catalogFile.getParentFile();
        String sesuName = sesuDir.getName();
        Document doc = builder.parse(catalogFile);
        NodeList systemNodes = doc.getElementsByTagName("system");
        for (int i = 0; i < systemNodes.getLength(); ++i) {
            URI realUri;
            Element systemNode = (Element)systemNodes.item(i);
            String uri = systemNode.getAttribute("uri");
            if (uri == null || (realUri = new URI(uri)).getScheme() != null) continue;
            uri = "../" + sesuName + "/META-INF/" + uri;
            uri = uri.replace("/META-INF/..", "");
            systemNode.setAttribute("uri", uri);
        }
        return doc;
    }

    private void importCatalog(Document mergedDoc, Document doc) {
        try {
            Element mergedRoot = mergedDoc.getDocumentElement();
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                childNode = mergedDoc.importNode(childNode, true);
                mergedRoot.appendChild(childNode);
            }
        }
        catch (Exception ex) {
            this.log("Exception: A processing error occurred; " + ex);
        }
    }

    private void generateServiceAssemblyDescriptor(ConnectionResolver connectionResolver, String conFileLoc, String jbiFileLoc, Document casaDocument) {
        Set<String> outputBCNames = connectionResolver.getBCNames();
        try {
            NodeList rs;
            SAConnectionsBuilder dd = new SAConnectionsBuilder();
            Project p = this.getProject();
            String saName = AntProjectHelper.getServiceAssemblyID(p);
            String saDescription = AntProjectHelper.getServiceAssemblyDescription(p);
            dd.buildDOMTree(connectionResolver, saName, saDescription, casaDocument);
            dd.writeToFile(conFileLoc);
            if (this.jbiDocument == null) {
                return;
            }
            NodeList sas = this.jbiDocument.getElementsByTagName("service-assembly");
            if (sas != null && sas.getLength() > 0) {
                Element sa = (Element)sas.item(0);
                NodeList suList = this.jbiDocument.getElementsByTagName("service-unit");
                for (int i = suList.getLength() - 1; i >= 0; --i) {
                    Element cn;
                    String compName;
                    Element su = (Element)suList.item(i);
                    NodeList cns = su.getElementsByTagName("component-name");
                    if (cns == null || cns.getLength() <= 0 || !this.bcNames.contains(compName = (cn = (Element)cns.item(0)).getFirstChild().getNodeValue()) || outputBCNames.contains(compName)) continue;
                    sa.removeChild(su);
                }
                List<Element> connectionsElements = dd.createConnections(connectionResolver, this.jbiDocument, casaDocument);
                for (Element connections : connectionsElements) {
                    sa.appendChild(connections);
                }
                sa.normalize();
                NodeList children = sa.getChildNodes();
                for (int i = children.getLength() - 1; i >= 0; --i) {
                    Node child = children.item(i);
                    String nodeValue = child.getNodeValue();
                    if (nodeValue == null || nodeValue.trim().length() != 0) continue;
                    sa.removeChild(child);
                }
            }
            if ((rs = this.jbiDocument.getElementsByTagName("jbi")) != null && rs.getLength() > 0) {
                Element root = (Element)rs.item(0);
                Map<String, String> map = connectionResolver.getNamespaceMap();
                for (String key : map.keySet()) {
                    if (key == null) continue;
                    String value = map.get(key);
                    root.setAttribute("xmlns:" + key, value);
                }
            }
            XmlUtil.writeToFile((String)jbiFileLoc, (Document)this.jbiDocument);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(" Build SA Descriptor Failed: " + e.toString());
        }
    }

    private List<String> loadBindingComponentNames(String ciFileLoc) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(new File(ciFileLoc));
            NodeList compInfoNodeList = document.getElementsByTagName("component-info");
            int isize = compInfoNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                Element compInfo = (Element)compInfoNodeList.item(i);
                Element typeElement = (Element)compInfo.getElementsByTagName("type").item(0);
                String compType = typeElement.getFirstChild().getNodeValue();
                if (!compType.equalsIgnoreCase("binding")) continue;
                Element nameElement = (Element)compInfo.getElementsByTagName("name").item(0);
                String compName = nameElement.getFirstChild().getNodeValue();
                ret.add(compName);
            }
        }
        catch (Exception e) {
            this.log(e.getMessage() + " : " + ciFileLoc);
        }
        return ret;
    }

    private void loadAssemblyInfo(String asiFileLoc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            this.jbiDocument = factory.newDocumentBuilder().parse(new File(asiFileLoc));
            this.suJarNames = new ArrayList<String>();
            NodeList jarNodeList = this.jbiDocument.getElementsByTagName("artifacts-zip");
            int isize = jarNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                Node jarNode = jarNodeList.item(i);
                String jarName = jarNode.getFirstChild().getNodeValue();
                this.suJarNames.add(jarName);
            }
        }
        catch (Exception e) {
            this.log(e.getMessage() + " : " + asiFileLoc);
        }
    }

    private String getShortName_Fallback(String source) {
        String name = new String(source);
        int idx1 = source.indexOf("/build/SEDeployment.jar");
        if (idx1 > 0) {
            int idx2 = source.lastIndexOf(47, idx1 - 1);
            if (idx2 < 0) {
                idx2 = source.lastIndexOf(92, idx1 - 1);
            }
            if (idx1 > 0 && idx2 > 0) {
                return source.substring(idx2 + 1, idx1) + ".jar";
            }
        } else {
            int idx3 = source.lastIndexOf(47);
            return source.substring(idx3 + 1);
        }
        return name;
    }

    private String getShortName(String source) {
        File file = new File(source);
        File projDir = file.getParentFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals("nbproject");
            }
        };
        try {
            while (true) {
                File[] files;
                if ((files = projDir.listFiles(filter)) != null && files.length > 0) {
                    File projectXmlFile = new File(files[0], "project.xml");
                    DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = fact.newDocumentBuilder();
                    Document document = builder.parse(projectXmlFile);
                    Element nameElement = (Element)document.getElementsByTagName("name").item(0);
                    String projDisplayName = nameElement.getTextContent();
                    return projDisplayName + source.substring(source.lastIndexOf("."));
                }
                projDir = projDir.getParentFile();
            }
        }
        catch (Exception e) {
            this.log(e.getMessage());
            return this.getShortName_Fallback(source);
        }
    }

    private String getLocalJavaEEJarPath(String dir, String subProjectJar) {
        File sJar = null;
        String ret = null;
        if (subProjectJar != null) {
            sJar = new File(subProjectJar);
            ret = dir + "/" + sJar.getName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEndpointsFrom(String jarFile) throws Exception {
        JarFile jar = new JarFile(jarFile);
        byte[] buffer = new byte[1024];
        try {
            Enumeration<JarEntry> entries = jar.entries();
            StringBuffer jbiXml = new StringBuffer();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName().toLowerCase();
                if (!fileName.equalsIgnoreCase(SU_JBIXML_PATH)) continue;
                InputStream is = jar.getInputStream(entry);
                while ((bytesRead = is.read(buffer)) != -1) {
                    jbiXml.append(new String(buffer, 0, bytesRead, "UTF-8"));
                }
                is.close();
                is = null;
                Document jbiDoc = XmlUtil.createDocumentFromXML((boolean)true, (String)jbiXml.toString());
                this.createEndpoints(jbiDoc.getElementsByTagName("provides"), true);
                this.createEndpoints(jbiDoc.getElementsByTagName("consumes"), false);
                break;
            }
        }
        catch (IOException ex) {
            this.log("Operation aborted due to : " + ex);
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJarFile(String inFile, String outFile) throws Exception {
        byte[] buffer = new byte[1024];
        JarFile jar = new JarFile(inFile);
        JarOutputStream newJar = new JarOutputStream(new FileOutputStream(outFile));
        try {
            Enumeration<JarEntry> entries = jar.entries();
            boolean hasJbiXml = false;
            boolean copyJbiXml = false;
            String jbiXml = "";
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName().toLowerCase();
                InputStream is = jar.getInputStream(entry);
                copyJbiXml = false;
                newJar.putNextEntry(entry);
                if (fileName.equalsIgnoreCase(SU_JBIXML_PATH)) {
                    hasJbiXml = true;
                    copyJbiXml = true;
                }
                while ((bytesRead = is.read(buffer)) != -1) {
                    newJar.write(buffer, 0, bytesRead);
                    if (!copyJbiXml) continue;
                    jbiXml = jbiXml + new String(buffer, 0, bytesRead, "UTF-8");
                }
                is.close();
                is = null;
            }
            if (hasJbiXml) {
                Document jbiDoc = XmlUtil.createDocumentFromXML((boolean)true, (String)jbiXml);
                this.createEndpoints(jbiDoc.getElementsByTagName("provides"), true);
                this.createEndpoints(jbiDoc.getElementsByTagName("consumes"), false);
            }
        }
        catch (IOException ex) {
            this.log("Operation aborted due to : " + ex);
        }
        finally {
            try {
                newJar.close();
                jar.close();
            }
            catch (IOException ignored) {}
        }
    }

    private void createEndpoints(NodeList nodeList, boolean isProvide) {
        if (nodeList != null) {
            int node = nodeList.getLength();
            for (int i = 0; i < node; ++i) {
                String PT;
                PtConnection con;
                QName interfaceQName;
                QName serviceQName;
                Element pe = (Element)nodeList.item(i);
                String endpointName = pe.getAttribute("endpoint-name");
                Endpoint p = new Endpoint(endpointName, serviceQName = BuildServiceAssembly.getNSName(pe, pe.getAttribute("service-name")), interfaceQName = BuildServiceAssembly.getNSName(pe, pe.getAttribute("interface-name")));
                if (p == null || (con = this.mRepo.getPtConnection(PT = p.getInterfaceQName().toString())) == null) continue;
                if (isProvide) {
                    con.addProvide(p);
                    continue;
                }
                con.addConsume(p);
            }
        }
    }

    private static QName getNSName(Element e, String qname) {
        if (qname == null) {
            return null;
        }
        int i = qname.indexOf(58);
        if (i > 0) {
            String name = qname.substring(i + 1);
            String prefix = qname.substring(0, i);
            return new QName(BuildServiceAssembly.getNamespace(e, prefix), name);
        }
        return new QName(qname);
    }

    public static String getNamespace(Element el, String prefix) {
        if (prefix == null || prefix.length() < 1) {
            return "";
        }
        try {
            NamedNodeMap map = el.getOwnerDocument().getDocumentElement().getAttributes();
            for (int j = 0; j < map.getLength(); ++j) {
                Node n = map.item(j);
                String localName = n.getLocalName();
                if (localName == null || !n.getLocalName().trim().equals(prefix.trim())) continue;
                return n.getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private BCSUDescriptorBuilder createBCSUDescriptor(String bcName, ConnectionResolver connectionResolver) {
        String bcSUDirLoc = this.serviceUnitsDirLoc + File.separator + bcName;
        File bcSUDir = new File(bcSUDirLoc);
        if (!bcSUDir.exists()) {
            bcSUDir.mkdir();
        }
        if (!bcSUDir.isDirectory()) {
            throw new RuntimeException(bcSUDirLoc + " is not a directory");
        }
        BCSUDescriptorBuilder dd = new BCSUDescriptorBuilder();
        try {
            dd.buildDOMTree(connectionResolver, bcName);
            dd.writeToFile(bcSUDirLoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dd;
    }

    private String getProjectName() {
        Project proj = this.getProject();
        return AntProjectHelper.getServiceAssemblyID(proj);
    }

    private String getCompAppWSDLFileName() {
        return this.getProjectName() + ".wsdl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBCJar(String outFile, JarFile genericBCJar, BCSUDescriptorBuilder bcsuDescriptorBuilder, String bcName) throws Exception {
        byte[] buffer = new byte[1024];
        String compAppWSDLFileName = this.getCompAppWSDLFileName();
        JarOutputStream newJar = new JarOutputStream(new FileOutputStream(outFile));
        try {
            Enumeration<JarEntry> jarEntries = genericBCJar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                InputStream is = genericBCJar.getInputStream(jarEntry);
                String jarEntryName = jarEntry.getName();
                if (jarEntryName.equals(compAppWSDLFileName)) {
                    String line;
                    newJar.putNextEntry(new JarEntry(compAppWSDLFileName));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if (line.indexOf("import") != -1) {
                            if (line.indexOf("location=\"../jbiServiceUnits/") != -1) {
                                line = line.replace("../jbiServiceUnits/", "");
                            }
                            if (line.indexOf("location=\"../jbiasa/") != -1) {
                                line = line.replace("../jbiasa/", "");
                            }
                        }
                        newJar.write(line.getBytes("UTF-8"));
                        newJar.write(System.getProperty("line.separator").getBytes("UTF-8"));
                    }
                    reader.close();
                } else if (!this.bcNames.contains(jarEntryName.substring(0, jarEntryName.length() - 1)) && !jarEntryName.equals(".ignore")) {
                    int bytesRead;
                    newJar.putNextEntry(jarEntry);
                    while ((bytesRead = is.read(buffer)) != -1) {
                        newJar.write(buffer, 0, bytesRead);
                    }
                }
                is.close();
                is = null;
            }
            JarEntry jbientry = new JarEntry(SU_JBIXML_PATH);
            newJar.putNextEntry(jbientry);
            newJar.write(bcsuDescriptorBuilder.writeToBytes());
            if (this.mergedCatalogFile != null) {
                int len;
                JarEntry catalogentry = new JarEntry(SU_CATALOGXML_PATH);
                newJar.putNextEntry(catalogentry);
                FileInputStream in = new FileInputStream(this.mergedCatalogFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    newJar.write(buf, 0, len);
                }
                ((InputStream)in).close();
            }
            if (SOAP_BC.equals(bcName) && this.wsitCallbackProjects != null) {
                StringTokenizer st = new StringTokenizer(this.wsitCallbackProjects, ";");
                while (st.hasMoreTokens()) {
                    String projLoc = st.nextToken();
                    File buildDir = new File(projLoc + "/build/classes/");
                    if (!buildDir.exists()) continue;
                    String path = "";
                    this.copyWsitCallbackClass(buildDir, newJar, path);
                }
            }
        }
        catch (IOException ex) {
            this.log("Operation aborted due to : " + ex);
        }
        finally {
            try {
                newJar.close();
            }
            catch (IOException ignored) {}
        }
    }

    private void copyWsitCallbackClass(File file, JarOutputStream newJar, String path) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            String fname = file.getName();
            String pname = fname.equals("classes") ? "" : path + fname + "/";
            for (int i = 0; i < children.length; ++i) {
                this.copyWsitCallbackClass(children[i], newJar, pname);
            }
        } else {
            String fname = path + file.getName();
            try {
                int len;
                JarEntry classEntry = new JarEntry(fname);
                newJar.putNextEntry(classEntry);
                FileInputStream in = new FileInputStream(file);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    newJar.write(buf, 0, len);
                }
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                this.log("Copying " + fname + " failed due to :\n" + ex);
            }
        }
    }

    public void validateCompAppProject() throws BuildException {
        boolean isError = false;
        MyValidation validation = new MyValidation();
        for (WSDLModel wsdlModel : this.mRepo.getWsdlCollection()) {
            String wsdlPath = wsdlRepository.getWsdlFilePath(wsdlModel);
            if (wsdlPath.startsWith(this.serviceUnitsDirLoc)) continue;
            this.log("  validating " + wsdlPath);
            validation.validate((Model)wsdlModel, Validation.ValidationType.COMPLETE);
            for (Validator.ResultItem resultItem : validation.getValidationResult()) {
                this.logValidationErrors(new File(wsdlPath), resultItem);
                if (resultItem.getType() != Validator.ResultType.ERROR) continue;
                isError = true;
            }
        }
        if (isError) {
            throw new BuildException("Found validation error(s).");
        }
    }

    private void logValidationErrors(File file, Validator.ResultItem resultItem) {
        int lineNumber = 0;
        int columnNumber = 0;
        String errorDescription = resultItem.getDescription();
        if (errorDescription == null) {
            return;
        }
        String msgType = resultItem.getType().name();
        Component component = resultItem.getComponents();
        if (component != null) {
            lineNumber = ModelUtil.getLineNumber(component);
            columnNumber = ModelUtil.getColumnNumber(component);
            this.showError(file, columnNumber, lineNumber, errorDescription, msgType);
        } else {
            columnNumber = resultItem.getColumnNumber();
            lineNumber = resultItem.getLineNumber();
            this.showError(file, columnNumber, lineNumber, errorDescription, msgType);
        }
    }

    private void showError(File file, int columnNumber, int lineNumber, String errorDescription, String msgType) {
        StringBuffer lineNumStr = new StringBuffer(5);
        StringBuffer columnNumStr = new StringBuffer(5);
        if (lineNumber != -1) {
            lineNumStr.append(":");
            lineNumStr.append(lineNumber);
            lineNumStr.append(",");
        }
        if (columnNumber != -1) {
            columnNumStr.append(" column:");
            columnNumStr.append(columnNumber);
            columnNumStr.append(" ");
        }
        msgType = msgType + ": ";
        StringBuffer msg = new StringBuffer(100);
        msg.append(msgType);
        if (file != null) {
            msg.append(file.getPath());
        }
        msg.append(lineNumStr);
        msg.append(columnNumStr);
        msg.append(System.getProperty("line.separator"));
        msg.append(errorDescription);
        msg.append(System.getProperty("line.separator"));
        this.log(msg.toString());
    }

    private void filterJavaEEEndpoints(ConnectionResolver cR, List<String> saEEJarPaths, String serviceUnitsDirLoc) {
        String NS = "http://javaee.serviceengine.sun.com/endpoint/naming/extension";
        for (String path : saEEJarPaths) {
            File jbixml = new File(serviceUnitsDirLoc + "/" + this.getJavaEEProjName(path) + "/jbi.xml");
            try {
                String eptName;
                Document jbiDoc = XmlUtil.createDocument((boolean)true, (File)jbixml);
                NodeList nodeList = jbiDoc.getElementsByTagName("provides");
                ArrayList<Element> uList = new ArrayList<Element>();
                this.getUnconnectedNodes(uList, nodeList, cR);
                nodeList = jbiDoc.getElementsByTagName("consumes");
                this.getUnconnectedNodes(uList, nodeList, cR);
                if (uList.size() <= 0) continue;
                Node srvNode = jbiDoc.getElementsByTagName("services").item(0);
                Node mapNode = jbiDoc.getElementsByTagNameNS(NS, "ept-mappings").item(0);
                NodeList mapList = jbiDoc.getElementsByTagNameNS(NS, "java-ept");
                Hashtable<String, Node> eptMap = new Hashtable<String, Node>();
                for (int i = 0; i < mapList.getLength(); ++i) {
                    Element map = (Element)mapList.item(i);
                    eptName = map.getAttribute("endpoint-name");
                    eptMap.put(eptName, map.getParentNode());
                }
                for (Element elm : uList) {
                    eptName = elm.getAttribute("endpoint-name");
                    srvNode.removeChild(elm);
                    if (mapNode == null) continue;
                    mapNode.removeChild((Node)eptMap.get(eptName));
                }
                byte[] jbiNew = XmlUtil.writeToBytes((Document)jbiDoc);
                this.copyJavaEEJarFile(path, jbiNew);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJavaEEJarFile(String inFile, byte[] jbixml) {
        byte[] buffer = new byte[1024];
        File jarFile = null;
        File tempJarFile = null;
        ZipFile jar = null;
        ZipOutputStream newJar = null;
        boolean jarUpdated = false;
        try {
            jarFile = new File(inFile);
            tempJarFile = new File(inFile + ".new");
            jar = new JarFile(jarFile);
            newJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName().toLowerCase();
                if (fileName.equalsIgnoreCase(SU_JBIXML_PATH)) {
                    JarEntry jbiEntry = new JarEntry(SU_JBIXML_PATH);
                    ((JarOutputStream)newJar).putNextEntry(jbiEntry);
                    newJar.write(jbixml);
                    continue;
                }
                ((JarOutputStream)newJar).putNextEntry(entry);
                InputStream is = ((JarFile)jar).getInputStream(entry);
                while ((bytesRead = is.read(buffer)) != -1) {
                    newJar.write(buffer, 0, bytesRead);
                }
                is.close();
                is = null;
            }
            jarUpdated = true;
        }
        catch (Exception ex) {
            this.log("Copying EE jar aborted due to : " + ex);
            ex.printStackTrace();
        }
        finally {
            try {
                if (newJar != null) {
                    newJar.close();
                }
                if (jar != null) {
                    jar.close();
                }
                if (jarUpdated) {
                    jarFile.delete();
                    tempJarFile.renameTo(jarFile);
                } else if (tempJarFile != null) {
                    tempJarFile.delete();
                }
            }
            catch (IOException ignored) {
                this.log("Copying EE jar aborted finally due to : " + ignored);
            }
        }
    }

    private String getJavaEEProjName(String subProjectJar) {
        File sJar = null;
        String ret = null;
        if (subProjectJar != null) {
            sJar = new File(subProjectJar);
            String sJarName = sJar.getName();
            int ext = sJarName.indexOf(46);
            if (ext > 0) {
                sJarName = sJarName.substring(0, ext);
            }
            ret = sJarName;
        }
        return ret;
    }

    private void getUnconnectedNodes(List<Element> uList, NodeList nodeList, ConnectionResolver cR) {
        int node = nodeList.getLength();
        for (int i = 0; i < node; ++i) {
            QName interfaceQName;
            QName serviceQName;
            Element pe = (Element)nodeList.item(i);
            String endpointName = pe.getAttribute("endpoint-name");
            Endpoint p = new Endpoint(endpointName, serviceQName = BuildServiceAssembly.getNSName(pe, pe.getAttribute("service-name")), interfaceQName = BuildServiceAssembly.getNSName(pe, pe.getAttribute("interface-name")));
            boolean connected = cR.isConnected(p);
            if (connected) continue;
            uList.add(pe);
        }
    }
}

