/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.project.ProjectCellRenderer;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.reporting.wizard.ReportWizardSettings;
import org.netbeans.modules.uml.reporting.wizard.WizardPanelBase;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ReportLocationPanel
extends WizardPanelBase
implements WizardDescriptor.FinishablePanel {
    private Project selected;
    private File folder;
    private WizardDescriptor wizardDescriptor;
    private JLabel ProjectLbl;
    private JButton browseBtn;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel locationLbl;
    private JTextField locationTextField;
    private JPanel msgPanel;
    private JComboBox projectComboBox;

    public ReportLocationPanel() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ReportLocationPanel.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ReportLocationPanel.this.checkValidity();
            }
        };
        this.locationTextField.getDocument().addDocumentListener(documentListener);
        this.initValue();
    }

    public boolean isFinishPanel() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(ReportLocationPanel.class, (String)"TITLE_ReportLocationPanel_WizardTitle");
    }

    public void initValue() {
        Project[] projectArray = ProjectUtil.getOpenUMLProjects();
        Project[] projectArray2 = ProjectUtil.getSelectedProjects(UMLProject.class);
        if (projectArray2.length > 0) {
            this.selected = projectArray2[0];
        } else if (projectArray.length > 0) {
            this.selected = projectArray[0];
        }
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(projectArray);
        this.projectComboBox.setModel(defaultComboBoxModel);
        this.projectComboBox.setRenderer(new ProjectCellRenderer());
        this.projectComboBox.setSelectedItem(this.selected);
    }

    public Project getSelectedProject() {
        return (Project)this.projectComboBox.getSelectedItem();
    }

    private void setReportFolder(File file) {
        this.folder = file;
        this.locationTextField.setText(file.getAbsolutePath());
        this.setValid(true);
    }

    public File getReportFolder() {
        return new File(this.locationTextField.getText());
    }

    private void checkValidity() {
        String string = this.locationTextField.getText().trim();
        File file = new File(string);
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        if (file.exists() && !file.isDirectory()) {
            this.setValid(false);
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ReportLocationPanel.class, (String)"MSG_ReportLocationPanel_InvalidFolder"));
        } else if (file.exists() && file.listFiles() != null && file.listFiles().length > 0) {
            this.setValid(true);
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ReportLocationPanel.class, (String)"MSG_ReportLocationPanel_FolderExists"));
        }
    }

    public void readSettings(Object object) {
        ReportWizardSettings reportWizardSettings = (ReportWizardSettings)object;
        this.wizardDescriptor = reportWizardSettings.getWizardDescriptor();
        Project project = reportWizardSettings.getProject();
        this.folder = reportWizardSettings.getReportFolder();
        if (project != null) {
            this.projectComboBox.setSelectedItem(project);
        }
        if (this.folder != null) {
            this.locationTextField.setText(this.folder.getAbsolutePath());
        } else {
            FileObject fileObject = ((Project)this.projectComboBox.getSelectedItem()).getProjectDirectory();
            String string = FileUtil.toFile((FileObject)fileObject.getParent()).getAbsolutePath();
            this.locationTextField.setText(string);
        }
    }

    public void storeSettings(Object object) {
        ReportWizardSettings reportWizardSettings = (ReportWizardSettings)object;
        reportWizardSettings.setProject(this.getSelectedProject());
        reportWizardSettings.setReportFolder(this.getReportFolder());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ProjectLbl = new JLabel();
        this.projectComboBox = new JComboBox();
        this.locationLbl = new JLabel();
        this.locationTextField = new JTextField();
        this.browseBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.msgPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(180, 175));
        this.setPreferredSize(new Dimension(180, 175));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.ProjectLbl.setText(ResourceBundle.getBundle("org/netbeans/modules/uml/reporting/wizard/Bundle").getString("LBL_ReportLocationPanel_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.ProjectLbl, gridBagConstraints);
        this.projectComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.projectComboBox, gridBagConstraints);
        this.locationLbl.setText(ResourceBundle.getBundle("org/netbeans/modules/uml/reporting/wizard/Bundle").getString("LBL_ReportLocationPanel_ReportLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.locationLbl, gridBagConstraints);
        this.locationTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.locationTextField, gridBagConstraints);
        this.browseBtn.setText(ResourceBundle.getBundle("org/netbeans/modules/uml/reporting/wizard/Bundle").getString("CTL_ReportLocationPanel"));
        this.browseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportLocationPanel.this.browseBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.browseBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.msgPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.msgPanel, gridBagConstraints);
    }

    private void browseBtnActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(jFileChooser) == 0) {
            this.setReportFolder(jFileChooser.getSelectedFile());
        }
    }
}

