/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.common.commonstatemachines.IState;
import org.netbeans.modules.uml.core.metamodel.common.commonstatemachines.IStateMachine;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.ReportTask;
import org.netbeans.modules.uml.reporting.dataobjects.ClassData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.openide.util.NbBundle;

public class StateMachineData
extends ClassData {
    private IStateMachine element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IStateMachine) {
            this.element = (IStateMachine)iElement;
        }
    }

    public IStateMachine getElement() {
        return this.element;
    }

    private String getSummaryTable(ETList eTList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < eTList.size(); ++i) {
            INamedElement iNamedElement = (INamedElement)eTList.get(i);
            stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
            String string = this.getBriefDocumentation(iNamedElement.getDocumentation());
            if (string == null || string.trim().equals("")) {
                string = "&nbsp;";
            }
            stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
            stringBuilder.append("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)iNamedElement) + "\" title=\"" + iNamedElement.getElementType() + " in " + iNamedElement.getName() + "\">" + iNamedElement.getName() + "</A></B></TD>\r\n");
            stringBuilder.append("<TD>" + string + "</TD>\r\n");
            stringBuilder.append("</TR>\r\n");
        }
        stringBuilder.append("</TABLE>\r\n&nbsp;\r\n");
        return stringBuilder.toString();
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Final, Property_Transient, Property_Abstract, Property_Leaf, Property_Reentrant};
    }

    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsFinal());
        Boolean bl2 = new Boolean(this.getElement().getIsTransient());
        Boolean bl3 = new Boolean(this.getElement().getIsAbstract());
        Boolean bl4 = new Boolean(this.getElement().getIsLeaf());
        Boolean bl5 = new Boolean(this.getElement().getIsReentrant());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), bl, bl2, bl3, bl4, bl5};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        ETList eTList = this.getElement().getSubmachinesStates();
        ETList eTList2 = this.getElement().getContainedElements();
        String string = "";
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getDiagramSummary());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== SUBMACHINE STATE SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("sub_machine_state_summary", NbBundle.getMessage(StateMachineData.class, (String)"Sub_Machine_State_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    IState iState = (IState)eTList.get(i);
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    string = this.getBriefDocumentation(iState.getDocumentation());
                    if (string == null || string.trim().equals("")) {
                        string = "&nbsp;";
                    }
                    String string2 = iState.getElementType().replaceAll(" ", "");
                    String string3 = iState.getName();
                    if (string3 == null || string3.equals("")) {
                        string3 = iState.getElementType();
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    String string4 = CommonResourceManager.instance().getIconDetailsForElementType(iState.getElementType());
                    if (string4.lastIndexOf("/") > -1) {
                        string4 = string4.substring(string4.lastIndexOf("/") + 1);
                    }
                    ReportTask.addToImageList(string4);
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><img src=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/" + string4 + "\" border=n>&nbsp<B><A HREF=\"" + this.getLinkTo((IElement)iState) + "\" title=\"" + iState.getElementType() + " in " + string3 + "\">" + string3 + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if (eTList2 != null && eTList2.size() > 0) {
                outputStreamWriter.write("<!-- =========== CONTAINED ELEMENTS SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("contained_element_summary", NbBundle.getMessage(StateMachineData.class, (String)"Contained_Element_Summary")));
                outputStreamWriter.write(this.getSummaryTable(eTList2));
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

