/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.common.commonstatemachines.IState;
import org.netbeans.modules.uml.core.metamodel.common.commonstatemachines.ITransition;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class StateData
extends ElementDataObject {
    private IState element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IState) {
            this.element = (IState)iElement;
        }
    }

    public IState getElement() {
        return this.element;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Container, Property_SubmachineState, Property_Simple, Property_Orthogonal, Property_Composite};
    }

    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsSubmachineState());
        Boolean bl2 = new Boolean(this.getElement().getIsSimple());
        Boolean bl3 = new Boolean(this.getElement().getIsOrthogonal());
        Boolean bl4 = new Boolean(this.getElement().getIsComposite());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), this.getElement().getContainer(), bl, bl2, bl3, bl4};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        ETList eTList = this.getElement().getIncomingTransitions();
        ETList eTList2 = this.getElement().getOutgoingTransitions();
        try {
            ITransition iTransition;
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElement().getExpandedElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            if (eTList != null && eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== INCOMING TRANSITION SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("incoming_transition_summary", NbBundle.getMessage(StateData.class, (String)"Incoming_Transition_Summary")));
                for (n = 0; n < eTList.size(); ++n) {
                    iTransition = (ITransition)eTList.get(n);
                    if (iTransition.getSource() == null) continue;
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)iTransition.getSource()) + "\" title=\"" + iTransition.getSource().getExpandedElementType() + " in " + iTransition.getSource().getName() + "\">" + iTransition.getSource().getName() + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + this.getBriefDocumentation(iTransition.getSource().getDocumentation()) + "</TD>\r\n");
                    outputStreamWriter.write("</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if (eTList2 != null && eTList2.size() > 0) {
                outputStreamWriter.write("<!-- =========== INCOMING TRANSITION SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("outgoing_transition_summary", NbBundle.getMessage(StateData.class, (String)"Outgoing_Transition_Summary")));
                for (n = 0; n < eTList2.size(); ++n) {
                    iTransition = (ITransition)eTList2.get(n);
                    if (iTransition.getTarget() == null) continue;
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)iTransition.getTarget()) + "\" title=\"" + iTransition.getTarget().getExpandedElementType() + " in " + iTransition.getTarget().getName() + "\">" + iTransition.getTarget().getName() + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + this.getBriefDocumentation(iTransition.getTarget().getDocumentation()) + "</TD>\r\n");
                    outputStreamWriter.write("</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

