/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.Lifeline;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.openide.util.NbBundle;

public class LifelineData
extends ElementDataObject {
    Lifeline lifeline;

    public void setElement(IElement iElement) {
        if (iElement instanceof Lifeline) {
            this.lifeline = (Lifeline)iElement;
        }
    }

    public Lifeline getElement() {
        return this.lifeline;
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        IClassifier iClassifier = this.getElement().getRepresentingClassifier();
        ETList eTList = this.getElement().getEvents();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<DL>\r\n");
            outputStreamWriter.write("<DT>" + this.getVisibility((INamedElement)this.getElement()) + " " + this.getElementType().toLowerCase() + " <B>" + this.getElement().getName() + "</B></DT>");
            if (iClassifier != null) {
                outputStreamWriter.write("<DT>" + NbBundle.getMessage(LifelineData.class, (String)"represents") + ": ");
                if (iClassifier.getOwningPackage() != null) {
                    outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iClassifier) + "\" title=\"interface in " + iClassifier.getOwningPackage().getFullyQualifiedName(false) + "\">" + iClassifier.getName() + "</A>");
                } else {
                    outputStreamWriter.write(iClassifier.getName());
                    Logger.getLogger(LifelineData.class.getName()).log(Level.WARNING, NbBundle.getMessage(LifelineData.class, (String)"MSG_InvalidPackage", (Object)iClassifier.getElementType(), (Object)iClassifier.getName()));
                }
                outputStreamWriter.write("</DL>\r\n\r\n");
            }
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

