/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IEdgeMapLocation;
import org.netbeans.modules.uml.core.metamodel.diagrams.IGraphicExportDetails;
import org.netbeans.modules.uml.core.metamodel.diagrams.IGraphicMapLocation;
import org.netbeans.modules.uml.core.metamodel.diagrams.ILabelMapLocation;
import org.netbeans.modules.uml.core.metamodel.diagrams.INodeMapLocation;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.ReportTask;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.ui.controls.drawingarea.UIDiagram;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeDiagram;
import org.openide.util.NbBundle;

public class DiagramData
extends ElementDataObject {
    private IProxyDiagram pProxyDiagram;
    private String dir;
    private static int VIEWPORT_WIDTH = 1000;
    private static int VIEWPORT_HEIGHT = 700;
    private static int ZOOM_WIDTH = 120;
    private static String FIT_TO_WINDOW_DIAGRAM_FILE_SUFFIX = "_fit.html";
    private int fitToScaleIndex = 0;
    private int full_size_index = 0;

    public DiagramData() {
    }

    public DiagramData(ITreeDiagram iTreeDiagram) {
        this.pProxyDiagram = iTreeDiagram.getDiagram();
        this.setElement((IElement)iTreeDiagram.getData().getDiagram().getDiagram());
    }

    public IDiagram getDiagram() {
        return this.pProxyDiagram.getDiagram();
    }

    private double getFitToWindowScale(IDiagram iDiagram) {
        if (iDiagram instanceof UIDiagram) {
            double d;
            double d2;
            double d3 = ((UIDiagram)iDiagram).getFrameWidth();
            double d4 = (double)VIEWPORT_WIDTH / d3;
            return d4 > (d2 = (double)VIEWPORT_HEIGHT / (d = ((UIDiagram)iDiagram).getFrameHeight())) ? d2 : d4;
        }
        return 1.0;
    }

    private void createFullDiagramFile(IDiagram iDiagram, IGraphicExportDetails iGraphicExportDetails) {
        if (iDiagram != null && iGraphicExportDetails != null) {
            IETRect iETRect;
            String string;
            String string2 = iDiagram.getFilename();
            String string3 = string = StringUtilities.getFileName((String)string2);
            string3 = string3 + "_" + this.full_size_index + ReportTask.IMAGE_EXT;
            String string4 = iDiagram.getName();
            String string5 = iDiagram.getDocumentation();
            String string6 = this.getDirectoryPath() + File.separator + string + ReportTask.HTML_EXT;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHTMLHeader());
            stringBuilder.append(this.getNavBar());
            if (string4 != null && string4.length() > 0) {
                stringBuilder.append("<HR><H2>" + iDiagram.getDiagramKind2() + " " + string4 + "</H2>");
                stringBuilder.append("<P>" + string5 + "</P>\r\n");
                stringBuilder.append("<P ALIGN=\"CENTER\"><A HREF=\"" + string + FIT_TO_WINDOW_DIAGRAM_FILE_SUFFIX + "\"><IMG SRC=\"" + ReportTask.getPathToReportRoot((IElement)iDiagram) + "images/fit-to-window.png\" BORDER=n></A>&nbsp;</P>");
                stringBuilder.append("<HR>\r\n");
            }
            if ((iETRect = iGraphicExportDetails.getGraphicBoundingRect()) != null) {
                ETList eTList;
                int n = iETRect.getLeft();
                int n2 = iETRect.getTop();
                int n3 = iETRect.getBottom();
                int n4 = iETRect.getRight();
                String string7 = "<IMG SRC=\"" + string3 + "\" USEMAP=\"#MAP0-0\" BORDER=0 COORDS=\"" + n + n3 + n4 + n2 + "\">";
                stringBuilder.append(string7);
                stringBuilder.append("<MAP NAME=\"MAP0-0\">");
                if (iGraphicExportDetails != null && (eTList = iGraphicExportDetails.getMapLocations()) != null) {
                    String string8;
                    INodeMapLocation iNodeMapLocation;
                    IGraphicMapLocation iGraphicMapLocation;
                    int n5;
                    int n6 = eTList.size();
                    for (n5 = 0; n5 < n6; ++n5) {
                        iGraphicMapLocation = (IGraphicMapLocation)eTList.get(n5);
                        if (iGraphicMapLocation == null) continue;
                        if (iGraphicMapLocation instanceof INodeMapLocation) {
                            iNodeMapLocation = (INodeMapLocation)iGraphicMapLocation;
                            string8 = this.createLineForNode(iDiagram, n2, iNodeMapLocation);
                            stringBuilder.append(string8);
                            continue;
                        }
                        if (!(iGraphicMapLocation instanceof ILabelMapLocation)) continue;
                        iNodeMapLocation = (ILabelMapLocation)iGraphicMapLocation;
                        string8 = this.createLineForLabel(n2, (ILabelMapLocation)iNodeMapLocation);
                        stringBuilder.append(string8);
                    }
                    for (n5 = 0; n5 < n6; ++n5) {
                        iGraphicMapLocation = (IGraphicMapLocation)eTList.get(n5);
                        if (iGraphicMapLocation == null || !(iGraphicMapLocation instanceof IEdgeMapLocation)) continue;
                        iNodeMapLocation = (IEdgeMapLocation)iGraphicMapLocation;
                        string8 = this.createLineForLink(n2, (IEdgeMapLocation)iNodeMapLocation);
                        stringBuilder.append(string8);
                    }
                }
            }
            stringBuilder.append("<HR>\r\n");
            stringBuilder.append(this.getNavBar());
            stringBuilder.append("</BODY>\r\n");
            stringBuilder.append("</HTML>");
            this.makePage(string6, stringBuilder.toString());
        }
    }

    private String createLineForNode(IDiagram iDiagram, int n, INodeMapLocation iNodeMapLocation) {
        String string = "";
        if (n > 0 && iNodeMapLocation != null) {
            String string2 = iNodeMapLocation.getName();
            IETRect iETRect = iNodeMapLocation.getLocation();
            if (iETRect != null) {
                int n2 = iETRect.getLeft();
                int n3 = iETRect.getTop();
                int n4 = iETRect.getBottom();
                int n5 = iETRect.getRight();
                long l = n2;
                long l2 = n3;
                long l3 = n5;
                long l4 = n4;
                if (this.displayLink(iNodeMapLocation.getElement())) {
                    string = "<AREA SHAPE=\"RECT\" COORDS=\"" + l + ", " + l2 + ", " + l3 + ", " + l4 + "\" HREF=\"" + ReportTask.getPathToReportRoot((IElement)iDiagram) + ReportTask.getLinkTo(iNodeMapLocation.getElement()) + "\" ALT=\"" + string2 + "\">";
                }
            }
        }
        return string;
    }

    private String createLineForLabel(int n, ILabelMapLocation iLabelMapLocation) {
        String string = "";
        if (n > 0 && iLabelMapLocation != null) {
            String string2 = iLabelMapLocation.getName();
            IETRect iETRect = iLabelMapLocation.getLocation();
            if (iETRect != null) {
                int n2 = iETRect.getLeft();
                int n3 = iETRect.getTop();
                int n4 = iETRect.getBottom();
                int n5 = iETRect.getRight();
                long l = n2;
                long l2 = n3;
                long l3 = n5;
                long l4 = n4;
                if (this.displayLink(iLabelMapLocation.getElement())) {
                    string = "<AREA SHAPE=\"RECT\" COORDS=\"" + l + ", " + l2 + ", " + l3 + ", " + l4 + "\" HREF=\"" + ReportTask.getPathToReportRoot((IElement)this.getDiagram()) + ReportTask.getLinkTo(iLabelMapLocation.getElement()) + "\" ALT=\"" + string2 + "\">";
                }
            }
        }
        return string;
    }

    private String createLineForLink(int n, IEdgeMapLocation iEdgeMapLocation) {
        String string = "";
        if (n > 0 && iEdgeMapLocation != null) {
            ETList eTList;
            String string2 = iEdgeMapLocation.getName();
            if (this.displayLink(iEdgeMapLocation.getElement()) && (eTList = iEdgeMapLocation.getPoints()) != null && eTList.size() > 0) {
                string = "<AREA SHAPE=\"POLY\" COORDS=\"";
                int n2 = eTList.size();
                for (int i = 0; i < n2; ++i) {
                    IETPoint iETPoint = (IETPoint)eTList.item(i);
                    Integer n3 = new Integer(iETPoint.getX());
                    Integer n4 = new Integer(iETPoint.getY());
                    string = string + n3.toString() + ",";
                    string = string + n4.toString();
                    if (i + 1 == n2) continue;
                    string = string + ",";
                }
                string = string + "\" HREF=\"" + ReportTask.getPathToReportRoot((IElement)this.getDiagram()) + ReportTask.getLinkTo(iEdgeMapLocation.getElement()) + "\" ALT=\"" + string2 + "\">";
            }
        }
        return string;
    }

    private boolean makePage(String string, String string2) {
        boolean bl = false;
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
            bl = true;
        }
        catch (IOException iOException) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getDiagram().getDiagramKind2() + " - " + this.getDiagram().getName(), iOException);
        }
        return bl;
    }

    private String getDirectoryPath() {
        return this.dir;
    }

    private boolean createFilesForDiagram(IDiagram iDiagram, IGraphicExportDetails iGraphicExportDetails, String string) {
        if (iDiagram == null || iGraphicExportDetails == null) {
            return false;
        }
        this.createFullDiagramFile(iDiagram, iGraphicExportDetails);
        String string2 = iDiagram.getFilename();
        String string3 = StringUtilities.getFileName((String)string2);
        String string4 = iDiagram.getName();
        String string5 = this.getDirectoryPath();
        string5 = string5 + File.separator + string3 + FIT_TO_WINDOW_DIAGRAM_FILE_SUFFIX;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML>\n");
        stringBuilder.append("\t<HEAD>\n");
        stringBuilder.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + ENCODING + "\">\n");
        String string6 = "<TITLE>" + string4 + "</TITLE>\n";
        stringBuilder.append(string6 + "\n");
        String string7 = this.getJavaScriptPath(iDiagram);
        String string8 = this.getScript(string7, string3, string);
        stringBuilder.append(string8 + "\n");
        stringBuilder.append("\t</HEAD>\n");
        String string9 = this.getBody(string7, string4, string3 + ReportTask.HTML_EXT);
        stringBuilder.append(string9 + "\n");
        stringBuilder.append("</HTML>");
        return this.makePage(string5, stringBuilder.toString());
    }

    private String getJavaScriptPath(IDiagram iDiagram) {
        String string = "..";
        IPackage iPackage = iDiagram.getOwningPackage();
        assert (iPackage != null) : "invalid package for diagram " + iDiagram.getName();
        while (!iPackage.equals(iPackage.getProject())) {
            string = string + "/..";
            iPackage = iPackage.getOwningPackage();
        }
        return string;
    }

    private String getScript(String string, String string2, String string3) {
        String string4 = "";
        StringBuilder stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/script_template.html");
        string4 = stringBuilder.toString();
        string4 = string4.replace("VIEWPORT_WIDTH", String.valueOf(VIEWPORT_WIDTH));
        string4 = string4.replace("VIEWPORT_HEIGHT", String.valueOf(VIEWPORT_HEIGHT));
        string4 = string4.replace("ZOOM_WIDTH", String.valueOf(ZOOM_WIDTH));
        string4 = string4.replace("LEFT_POSITION", String.valueOf((VIEWPORT_WIDTH - ZOOM_WIDTH) / 2));
        string4 = string4.replaceAll("DIAGRAM_IMAGE", string2);
        string4 = string4.replaceAll("SCRIPT_PATH", string);
        string4 = string4.replaceAll("IMAGESTRING", string3);
        string4 = string4.replaceAll("FIT_SCALE_INDEX", String.valueOf(this.fitToScaleIndex));
        return string4;
    }

    private String getBody(String string, String string2, String string3) {
        String string4 = "";
        StringBuilder stringBuilder = ReportTask.readTemplate("org/netbeans/modules/uml/reporting/templates/body_template.html");
        string4 = stringBuilder.toString();
        string4 = string4.replaceAll("SCRIPT_PATH", string);
        string4 = string4.replaceAll("%DIAGRAM_NAME%", this.getDiagram().getDiagramKind2() + " " + string2);
        string4 = string4.replaceAll("%DIAGRAM_DOC%", this.getDiagram().getDocumentation());
        string4 = string4.replaceAll("FULL_DIAGRAM_HTML", string3);
        string4 = string4.replace("%BRAND%", NbBundle.getMessage(DiagramData.class, (String)"brand"));
        string4 = string4.replaceAll("%OVERVIEW%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Overview"));
        string4 = string4.replaceAll("%PACKAGE%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Package"));
        string4 = string4.replaceAll("%ELEMENT%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Element"));
        string4 = string4.replaceAll("%DIAGRAM%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Diagram"));
        string4 = string4.replaceAll("%HELP%", NbBundle.getMessage(ElementDataObject.class, (String)"Header_Help"));
        return string4;
    }

    public boolean toReport(File file) {
        this.dir = file.getAbsolutePath();
        if (this.pProxyDiagram != null) {
            IDiagram iDiagram = this.pProxyDiagram.getDiagram();
            if (iDiagram == null) {
                iDiagram = ReportTask.loadDiagram(this.pProxyDiagram.getFilename());
            }
            if (iDiagram != null) {
                String string = iDiagram.getFilename();
                String string2 = StringUtilities.getFileName((String)string);
                double d = this.getFitToWindowScale(iDiagram);
                double d2 = iDiagram.getCurrentZoom();
                d2 = d2 > 1.0 ? 1.0 : d2;
                double[] dArray = new double[]{0.5 * d2, d2, d};
                Arrays.sort(dArray);
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] == d) {
                        this.fitToScaleIndex = i;
                        continue;
                    }
                    if (dArray[i] != d2) continue;
                    this.full_size_index = i;
                }
                StringBuilder stringBuilder = new StringBuilder();
                IGraphicExportDetails iGraphicExportDetails = null;
                for (int i = 0; i < dArray.length; ++i) {
                    String string3 = this.getDirectoryPath() + File.separator + string2 + "_" + i + ReportTask.IMAGE_EXT;
                    IGraphicExportDetails iGraphicExportDetails2 = iDiagram.saveAsGraphic2(string3, 1, dArray[i]);
                    if (iGraphicExportDetails2 == null) continue;
                    int n = (int)(iGraphicExportDetails2.getFrameBoundingRect().getWidth() * dArray[i]);
                    int n2 = (int)(iGraphicExportDetails2.getFrameBoundingRect().getHeight() * dArray[i]);
                    stringBuilder.append("               { 'path' : '" + string2 + "_" + i + ReportTask.IMAGE_EXT + "' , 'width' : " + n + " , 'height' : " + n2 + " }, ");
                    stringBuilder.append("\n");
                    if (i != this.full_size_index) continue;
                    iGraphicExportDetails = iGraphicExportDetails2;
                }
                return this.createFilesForDiagram(iDiagram, iGraphicExportDetails, stringBuilder.toString());
            }
        }
        return false;
    }
}

